/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.loader;

import edu.uoregon.tau.perfdmf.Database;
import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.database.ConnectionManager;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.database.ParseConfig;
import edu.uoregon.tau.perfdmf.loader.DatabaseConfigurationException;
import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;

public class ConfigureTest {
    private static String Usage = "Usage: configure [{-h,--help}] [{-g,--configfile} filename] [{-t,--tauroot} path]";
    private static String Greeting = "\nNow testing your database connection.\n";
    private String jdbc_db_jarfile = "postgresql.jar";
    private String jdbc_db_driver = "org.postgresql.Driver";
    private String jdbc_db_type = "postgresql";
    private String db_hostname = "localhost";
    private String db_portnum = "5432";
    private String db_dbname = "perfdmf";
    private String db_username = "";
    private String db_password = "";
    private String db_schemafile = "dbschema.txt";
    private String xml_parser = "xerces.jar";
    private ParseConfig parser;
    private String configFileName;

    public void errorPrint(String string) {
        System.err.println(string);
    }

    public void initialize(String string) {
        System.out.println(Greeting);
        try {
            this.configFileName = string;
            File file = new File(this.configFileName);
            if (file.exists()) {
                this.parseConfigFile();
            } else {
                System.out.println("Configuration file NOT found... (looking for " + file + ")");
                System.out.println("a new configuration file will be created.");
            }
        }
        catch (IOException iOException) {
            System.out.println("I/O Error occurred.");
        }
    }

    public void parseConfigFile() throws IOException, FileNotFoundException {
        this.parser = new ParseConfig(this.configFileName);
        this.jdbc_db_jarfile = this.parser.getJDBCJarFile();
        this.jdbc_db_driver = this.parser.getJDBCDriver();
        this.jdbc_db_type = this.parser.getDBType();
        this.db_hostname = this.parser.getDBHost();
        this.db_portnum = this.parser.getDBPort();
        this.db_dbname = this.parser.getDBName();
        this.db_username = this.parser.getDBUserName();
        this.db_password = this.parser.getDBPasswd();
        this.db_schemafile = this.parser.getDBSchema();
        this.xml_parser = this.parser.getXMLSAXParser();
    }

    public void setJDBCJarfile(String string) {
        this.jdbc_db_jarfile = string;
    }

    public String getJDBCJarfile() {
        return this.jdbc_db_jarfile;
    }

    public void setJDBCDriver(String string) {
        this.jdbc_db_driver = string;
    }

    public String getJDBCDriver() {
        return this.jdbc_db_driver;
    }

    public void setJDBCType(String string) {
        this.jdbc_db_type = string;
    }

    public String getJDBCType() {
        return this.jdbc_db_type;
    }

    public void setDBHostname(String string) {
        this.db_hostname = string;
    }

    public String getDBHostname() {
        return this.db_hostname;
    }

    public void setDBPortNum(String string) {
        this.db_portnum = string;
    }

    public String getDBPortNum() {
        return this.db_portnum;
    }

    public void setDBName(String string) {
        this.db_dbname = string;
    }

    public String getDBName() {
        return this.db_dbname;
    }

    public void setDBUsername(String string) {
        this.db_username = string;
    }

    public String getDBUsername() {
        return this.db_username;
    }

    public void setDBPassword(String string) {
        this.db_password = string;
    }

    public String getDBPassword() {
        return this.db_password;
    }

    public void setDBSchemaFile(String string) {
        this.db_schemafile = string;
    }

    public String getDBSchemaFile() {
        return this.db_schemafile;
    }

    public void setXMLPaser(String string) {
        this.xml_parser = string;
    }

    public String getXMLPaser() {
        return this.xml_parser;
    }

    public void setConfigFileName(String string) {
        this.configFileName = string;
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public boolean checkSchema() {
        Object object;
        ConnectionManager connectionManager = null;
        DB dB = null;
        try {
            object = new Database(this.configFileName);
            if ((this.jdbc_db_type.equals("derby") || this.jdbc_db_type.equals("h2")) && !new File(this.db_dbname).exists()) {
                connectionManager = this.db_password != null ? new ConnectionManager((Database)object, this.db_password) : new ConnectionManager((Database)object);
                connectionManager.connectAndCreate();
                connectionManager.dbclose();
                connectionManager = null;
            }
            connectionManager = this.db_password != null ? new ConnectionManager((Database)object, this.db_password) : new ConnectionManager((Database)object);
            connectionManager.connect();
            dB = connectionManager.getDB();
        }
        catch (Exception exception) {
            System.out.println("\nPlease make sure that your DBMS is configured correctly, and");
            System.out.println("the database " + this.db_dbname + " has been created.");
            exception.printStackTrace();
            throw new DatabaseConfigurationException("Error Connecting to Database.");
        }
        try {
            object = new String("SELECT * FROM " + dB.getSchemaPrefix() + "trial");
            dB.executeQuery((String)object);
        }
        catch (SQLException sQLException) {
            return false;
        }
        connectionManager.dbclose();
        return true;
    }

    public void createDB(boolean bl) {
        DB dB;
        ConnectionManager connectionManager;
        block15: {
            Object object;
            connectionManager = null;
            dB = null;
            try {
                object = new Database(this.configFileName);
                if ((this.jdbc_db_type.equals("derby") || this.jdbc_db_type.equals("h2")) && !new File(this.db_dbname).exists()) {
                    connectionManager = this.db_password != null ? new ConnectionManager((Database)object, this.db_password) : new ConnectionManager((Database)object, bl);
                    connectionManager.connectAndCreate();
                    connectionManager.dbclose();
                    connectionManager = null;
                }
                connectionManager = this.db_password != null ? new ConnectionManager((Database)object, this.db_password) : new ConnectionManager((Database)object, bl);
                connectionManager.connect();
                System.out.println();
                dB = connectionManager.getDB();
            }
            catch (SQLException sQLException) {
                System.out.println("\nPlease make sure that your DBMS is configured correctly, and");
                System.out.println("the database " + this.db_dbname + " has been created.");
                throw new DatabaseException("Error Connecting to Database.", sQLException);
            }
            try {
                object = new String("SELECT * FROM " + dB.getSchemaPrefix() + "trial");
                dB.executeQuery((String)object);
            }
            catch (SQLException sQLException) {
                String string = "";
                boolean bl2 = false;
                if (bl) {
                    System.out.print("This database has not been initalized with perfdmf.\n\nWould you like to upload the schema? [y/n]: ");
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                    try {
                        string = bufferedReader.readLine();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        System.exit(-1);
                    }
                    if (string.equals("y") || string.equals("Y")) {
                        bl2 = true;
                    } else {
                        System.exit(0);
                    }
                } else {
                    bl2 = true;
                }
                if (!bl2) break block15;
                System.out.println("Uploading Schema: " + this.db_schemafile);
                if (connectionManager.genParentSchema(this.db_schemafile) == 0) {
                    System.out.println("Successfully uploaded schema\n");
                }
                System.out.println("Error uploading schema\n");
                throw new DatabaseConfigurationException("Error uploading schema.");
            }
        }
        try {
            if (dB.checkSchema() != 0) {
                System.out.println("\nIncompatible schema found.  Please contact us at tau-team@cs.uoregon.edu\nfor a conversion script.");
                throw new DatabaseConfigurationException("Incompatible schema found.");
            }
        }
        catch (SQLException sQLException) {
            System.out.println("\nError trying to confirm schema:");
            sQLException.printStackTrace();
            throw new DatabaseConfigurationException("Error trying to confirm schema.");
        }
        connectionManager.dbclose();
        System.out.println("Database connection successful.");
        System.out.println("Configuration complete.");
    }

    public static void main(String[] stringArray) {
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addStringOption('g', "configfile");
        CmdLineParser.Option option2 = cmdLineParser.addStringOption('t', "tauroot");
        CmdLineParser.Option option3 = cmdLineParser.addStringOption('a', "arch");
        CmdLineParser.Option option4 = cmdLineParser.addBooleanOption('h', "help");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println(optionException.getMessage());
            System.err.println(Usage);
            System.exit(-1);
        }
        String string = (String)cmdLineParser.getOptionValue(option);
        String string2 = (String)cmdLineParser.getOptionValue(option2);
        String string3 = (String)cmdLineParser.getOptionValue(option3);
        Boolean bl = (Boolean)cmdLineParser.getOptionValue(option4);
        if (bl != null && bl.booleanValue()) {
            System.err.println(Usage);
            System.exit(-1);
        }
        if (string == null) {
            string = System.getProperty("user.home") + "/.ParaProf/perfdmf.cfg";
        }
        if (string2 == null) {
            string2 = new String("");
        }
        if (string3 == null) {
            string3 = new String("");
        }
        ConfigureTest configureTest = new ConfigureTest();
        configureTest.initialize(string);
        try {
            configureTest.createDB(true);
        }
        catch (DatabaseConfigurationException databaseConfigurationException) {
            databaseConfigurationException.printStackTrace();
            System.exit(0);
        }
    }
}

