/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.loader;

import edu.uoregon.tau.common.MetaDataMap;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.SnapshotDataSource;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.UtilFncs;
import edu.uoregon.tau.perfdmf.View;
import edu.uoregon.tau.perfdmf.taudb.TAUdbDatabaseAPI;
import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class LoadTrial {
    private String[] sourceFiles;
    private String metadataFile;
    private String metadataString;
    private Experiment exp;
    private boolean fixNames;
    private boolean summaryOnly;
    private boolean useNulls;
    private int expID;
    public int trialID;
    private DataSource dataSource;
    public String trialName;
    public String appName;
    public String expName;
    public String problemFile;
    public String configuration;
    public boolean terminate = true;
    private DatabaseAPI databaseAPI;
    private Trial trial;
    private Double reducePercentage;

    public static void usage() {
        System.err.println("Usage: taudb_loadtrial -n <name> [options] <file>\n\ntry `taudb_loadtrial --help' for more information");
    }

    public static void outputHelp() {
        System.err.println("Usage: taudb_loadtrial -n <name> [options] <file>\n\nRequired Arguments:\n\n  -n, --name <text>               Specify the name of the trial\n  -c, --config <name>             Specify the name of the configuration to use\n\nOptional Arguments:\n\n  -g, --configFile <file>         Specify the configuration file to use\n                                    (overrides -c)\n  -f, --filetype <filetype>       Specify type of performance data, options are:\n                                    profiles (default), pprof, dynaprof, mpip,\n                                    gprof, psrun, hpm, packed, cube, hpc, ompp,\n                                    snap, perixml, gptl, paraver, ipm, google\n  -i, --fixnames                  Use the fixnames option for gprof\n  -z, --usenull                   Include NULL values as 0 for mean calculation\n  -r, --reduce <percentage>       Aggregate all timers less than percentage as \"other\"\n  -d, --metadata-file <filename>  XML metadata for the trial\n  -m, --metadata                  Colon seperated metadata name/value pairs \n                                  <foo1=bar1:foo2=bar2>\n\nNotes:\n  -a, --applicationname <string>  Specify associated application name\n                                    for this trial. Creates a view.\n  -x, --experimentname <string>   Specify associated experiment name\n                                    for this trial. Creates a view.\n  For the TAU profiles type, you can specify either a specific set of profile\nfiles on the commandline, or you can specify a directory (by default the current\ndirectory).  The specified directory will be searched for profile.*.*.* files,\nor, in the case of multiple counters, directories named MULTI_* containing\nprofile data.\n\nExamples:\n\n  taudb_loadtrial -c mydb -n \"Batch 001\"\n    This will load profile.* (or multiple counters directories MULTI_*) into\n    database config mydb and give the trial the name \"Batch 001\"\n\n  taudb_loadtrial -c mydb -n \"HPM data 01\" -f hpm perfhpm*\n    This will load perfhpm* files of type HPMToolkit into datatabase mydb and give\n    the trial the name \"HPM data 01\"\n\n");
    }

    public LoadTrial(String string, String[] stringArray) {
        this.sourceFiles = stringArray;
        this.databaseAPI = new DatabaseAPI();
        try {
            this.databaseAPI.initialize(string, true);
            if (this.databaseAPI.db().getSchemaVersion() > 0) {
                this.databaseAPI = new TAUdbDatabaseAPI(this.databaseAPI);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public boolean checkForExp(String string, String string2, String string3) {
        if (this.databaseAPI.db().getSchemaVersion() > 0) {
            System.err.println("Ignore Exp in load trial");
            return true;
        }
        if (string != null) {
            this.expID = Integer.parseInt(string);
            try {
                this.exp = this.databaseAPI.setExperiment(this.expID);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.exp == null) {
                System.err.println("Experiment id " + string + " not found,  please enter a valid experiment ID.");
                System.exit(-1);
                return false;
            }
            return true;
        }
        Experiment experiment = this.databaseAPI.getExperiment(string2, string3, true);
        this.expID = experiment.getID();
        return true;
    }

    public boolean checkForTrialName(String string) {
        Trial trial = this.databaseAPI.setTrial(string, false);
        return trial != null;
    }

    public boolean checkForTrial(String string) {
        Trial trial = this.databaseAPI.setTrial(Integer.parseInt(string), false);
        return trial != null;
    }

    public void loadTrial(int n) {
        File[] fileArray = new File[this.sourceFiles.length];
        for (int i = 0; i < this.sourceFiles.length; ++i) {
            fileArray[i] = new File(this.sourceFiles[i]);
        }
        try {
            this.dataSource = UtilFncs.initializeDataSource(fileArray, n, this.fixNames);
            DataSource.setMeanIncludeNulls(this.useNulls);
        }
        catch (DataSourceException dataSourceException) {
            dataSourceException.printStackTrace();
            System.err.println("Error: Unable to initialize datasource!");
            return;
        }
        this.trial = new Trial();
        this.trial.setDataSource(this.dataSource);
        if (this.metadataString != null && this.metadataString.length() > 0) {
            MetaDataMap metaDataMap = new MetaDataMap();
            String[] stringArray = this.metadataString.split(":");
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("=");
                if (stringArray2.length != 2) continue;
                metaDataMap.put(stringArray2[0], stringArray2[1]);
            }
            this.dataSource.setMetaData(metaDataMap);
        }
        try {
            if (this.metadataFile != null) {
                this.dataSource.setMetadataFile(this.metadataFile);
            }
        }
        catch (Exception exception) {
            System.err.println("Error Loading metadata:");
            exception.printStackTrace();
            System.exit(1);
        }
        try {
            if (this.databaseAPI.db().getSchemaVersion() >= 0 && !(this.dataSource instanceof SnapshotDataSource)) {
                this.dataSource.setGenerateTAUdbStatistics(true);
            }
            this.dataSource.load();
            if (this.reducePercentage != null && this.reducePercentage > 0.0) {
                this.dataSource.reduceTrial(this.reducePercentage);
            }
        }
        catch (Exception exception) {
            System.err.println("Error Loading Trial:");
            exception.printStackTrace();
        }
        this.trial.setMetaData(this.dataSource.getMetaData());
        this.trial.setUncommonMetaData(this.dataSource.getUncommonMetaData());
        if (this.trialID == 0) {
            this.saveTrial();
        } else {
            this.appendToTrial();
        }
        if (this.terminate) {
            this.databaseAPI.terminate();
        }
    }

    public void saveTrial() {
        List<View> list;
        this.trial.setName(this.trialName);
        int n = -2;
        String string = "NAME";
        String string2 = "ID";
        String string3 = "Application-" + this.appName;
        ArrayList<View.ViewRule> arrayList = new ArrayList<View.ViewRule>(2);
        boolean bl = true;
        if (this.appName != null) {
            list = View.getViews(0, this.databaseAPI.db());
            if (list != null) {
                for (View list2 : list) {
                    String sQLException = list2.getField(string);
                    if (!sQLException.equals(string3)) continue;
                    bl = false;
                    n = Integer.parseInt(list2.getField(string2));
                    break;
                }
            }
            if (bl) {
                arrayList.add(View.ViewRule.createStringViewRule("Application", this.appName, View.ViewRule.StringViewComparator.EXACTLY));
                try {
                    n = View.createView(this.databaseAPI.db(), string3, true, -1, arrayList);
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            this.trial.getMetaData().put("Application", this.appName);
        }
        if (this.expName != null) {
            if (n >= 0) {
                list = "Experiment-" + this.expName;
                boolean bl2 = true;
                List<View> list2 = View.getViews(n, this.databaseAPI.db());
                if (list2 != null) {
                    for (View view : list2) {
                        String string4 = view.getField(string);
                        if (!string4.equals(list)) continue;
                        bl2 = false;
                        break;
                    }
                }
                if (bl2) {
                    arrayList.add(View.ViewRule.createStringViewRule("Experiment", this.expName, View.ViewRule.StringViewComparator.EXACTLY));
                    try {
                        View.createView(this.databaseAPI.db(), (String)((Object)list), true, n, arrayList);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
            }
            this.trial.getMetaData().put("Experiment", this.expName);
        }
        System.err.println("TrialName: " + this.trialName);
        this.trial.setExperimentID(this.expID);
        try {
            this.trialID = this.databaseAPI.uploadTrial(this.trial, this.summaryOnly);
        }
        catch (DatabaseException databaseException) {
            databaseException.printStackTrace();
            Exception exception = databaseException.getException();
            System.err.println("from: ");
            exception.printStackTrace();
            System.exit(-1);
        }
        System.err.println("Done saving trial!");
    }

    public void appendToTrial() {
        this.trial.setID(this.trialID);
        try {
            this.databaseAPI.saveTrial(this.trial, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        System.err.println("Done adding metric to trial!");
    }

    public String getProblemString() {
        if (this.problemFile == null) {
            return new String("");
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.problemFile));
        }
        catch (Exception exception) {
            System.err.println("Problem file not found!  Exiting...");
            System.exit(0);
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            String string;
            try {
                string = bufferedReader.readLine();
            }
            catch (Exception exception) {
                string = null;
            }
            if (string == null) break;
            stringBuffer.append(string.replaceAll("'", "'"));
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Object object;
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addBooleanOption('h', "help");
        CmdLineParser.Option option2 = cmdLineParser.addStringOption('e', "experimentid");
        CmdLineParser.Option option3 = cmdLineParser.addStringOption('n', "name");
        CmdLineParser.Option option4 = cmdLineParser.addStringOption('c', "config");
        CmdLineParser.Option option5 = cmdLineParser.addStringOption('g', "configFile");
        CmdLineParser.Option option6 = cmdLineParser.addStringOption('t', "trialid");
        CmdLineParser.Option option7 = cmdLineParser.addStringOption('f', "filetype");
        CmdLineParser.Option option8 = cmdLineParser.addBooleanOption('i', "fixnames");
        CmdLineParser.Option option9 = cmdLineParser.addStringOption('l', "metadataFile");
        CmdLineParser.Option option10 = cmdLineParser.addStringOption('m', "metadata");
        CmdLineParser.Option option11 = cmdLineParser.addStringOption('a', "applicationname");
        CmdLineParser.Option option12 = cmdLineParser.addStringOption('x', "experimentname");
        CmdLineParser.Option option13 = cmdLineParser.addBooleanOption('s', "summaryonly");
        CmdLineParser.Option option14 = cmdLineParser.addDoubleOption('r', "reduce");
        CmdLineParser.Option option15 = cmdLineParser.addBooleanOption('z', "usenull");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println(optionException.getMessage());
            LoadTrial.usage();
            System.exit(-1);
        }
        Boolean bl = (Boolean)cmdLineParser.getOptionValue(option);
        String string = (String)cmdLineParser.getOptionValue(option4);
        String string2 = (String)cmdLineParser.getOptionValue(option5);
        String string3 = (String)cmdLineParser.getOptionValue(option2);
        String string4 = (String)cmdLineParser.getOptionValue(option3);
        String string5 = (String)cmdLineParser.getOptionValue(option11);
        String string6 = (String)cmdLineParser.getOptionValue(option12);
        Double d = (Double)cmdLineParser.getOptionValue(option14);
        String string7 = (String)cmdLineParser.getOptionValue(option6);
        String string8 = (String)cmdLineParser.getOptionValue(option7);
        Boolean bl2 = (Boolean)cmdLineParser.getOptionValue(option8);
        String string9 = (String)cmdLineParser.getOptionValue(option9);
        String string10 = (String)cmdLineParser.getOptionValue(option10);
        Boolean bl3 = (Boolean)cmdLineParser.getOptionValue(option13);
        Boolean bl4 = (Boolean)cmdLineParser.getOptionValue(option15);
        if (bl != null && bl.booleanValue()) {
            LoadTrial.outputHelp();
            System.exit(-1);
        }
        if (string2 == null) {
            string2 = string == null ? System.getProperty("user.home") + "/.ParaProf/perfdmf.cfg" : System.getProperty("user.home") + "/.ParaProf/perfdmf.cfg." + string;
        }
        String[] stringArray2 = cmdLineParser.getRemainingArgs();
        boolean bl5 = false;
        LoadTrial loadTrial = new LoadTrial(string2, stringArray2);
        if (string4 == null) {
            if (stringArray2 != null && stringArray2.length > 0) {
                String string11 = stringArray2[0];
                object = new File(string11);
                int n = UtilFncs.identifyData((File)object);
                if (string8 != null && string8.equals("packed") || n == 0) {
                    bl5 = true;
                }
            }
            if (!bl5) {
                System.err.println("Error: Missing trial name\n");
                LoadTrial.usage();
                System.exit(-1);
            }
        }
        int n = 1;
        if (string8 != null) {
            if (string8.equals("profiles")) {
                n = 1;
            } else if (string8.equals("pprof")) {
                n = 8;
            } else if (string8.equals("dynaprof")) {
                n = 3;
            } else if (string8.equals("mpip")) {
                n = 4;
            } else if (string8.equals("hpm")) {
                n = 5;
            } else if (string8.equals("gprof")) {
                n = 6;
            } else if (string8.equals("psrun")) {
                n = 7;
            } else if (string8.equals("packed")) {
                n = 0;
            } else if (string8.equals("cube")) {
                n = 9;
            } else if (string8.equals("hpc")) {
                n = 10;
            } else if (string8.equals("gyro")) {
                n = 100;
            } else if (string8.equals("gamess")) {
                n = 101;
            } else if (string8.equals("gptl")) {
                n = 13;
            } else if (string8.equals("ipm")) {
                n = 15;
            } else if (string8.equals("ompp")) {
                n = 11;
            } else if (string8.equals("snap")) {
                n = 2;
            } else if (string8.equals("paraver")) {
                n = 14;
            } else if (string8.equals("perixml")) {
                n = 12;
            } else if (string8.equals("google")) {
                n = 16;
            } else {
                System.err.println("Please enter a valid file type.");
                LoadTrial.usage();
                System.exit(-1);
            }
        } else if (stringArray2.length >= 1) {
            n = UtilFncs.identifyData(new File(stringArray2[0]));
        }
        if (string4 == null) {
            string4 = "";
        }
        if (bl2 == null) {
            bl2 = new Boolean(false);
        }
        if (bl3 == null) {
            bl3 = new Boolean(false);
        }
        if (bl4 == null) {
            bl4 = new Boolean(false);
        }
        if (d == null) {
            d = new Double(0.0);
        }
        if (bl5) {
            for (int i = 0; i < stringArray2.length; ++i) {
                string4 = stringArray2[i].substring(0, stringArray2[i].lastIndexOf(46));
                LoadTrial loadTrial2 = new LoadTrial(string2, new String[]{stringArray2[i]});
                loadTrial2.checkForExp(string3, string5, string6);
                if (string7 != null) {
                    loadTrial2.checkForTrial(string7);
                    loadTrial2.trialID = Integer.parseInt(string7);
                }
                loadTrial2.trialName = string4;
                loadTrial2.fixNames = bl2;
                loadTrial2.metadataFile = string9;
                loadTrial2.metadataString = string10;
                loadTrial2.summaryOnly = bl3;
                loadTrial2.reducePercentage = d;
                loadTrial2.loadTrial(n);
            }
        } else {
            object = new LoadTrial(string2, stringArray2);
            if (((LoadTrial)object).databaseAPI.db().getSchemaVersion() == 0) {
                ((LoadTrial)object).checkForExp(string3, string5, string6);
            }
            if (string7 != null) {
                ((LoadTrial)object).checkForTrial(string7);
                ((LoadTrial)object).trialID = Integer.parseInt(string7);
            }
            ((LoadTrial)object).trialName = string4;
            ((LoadTrial)object).fixNames = bl2;
            ((LoadTrial)object).metadataFile = string9;
            ((LoadTrial)object).metadataString = string10;
            ((LoadTrial)object).summaryOnly = bl3;
            if (string5 != null) {
                ((LoadTrial)object).appName = string5;
            }
            if (string6 != null) {
                ((LoadTrial)object).expName = string6;
            }
            ((LoadTrial)object).useNulls = bl4;
            ((LoadTrial)object).reducePercentage = d;
            ((LoadTrial)object).loadTrial(n);
        }
    }

    public void setMetadataFile(String string) {
        this.metadataFile = string;
    }

    public void setMetadataString(String string) {
        this.metadataString = string;
    }

    public void setFixNames(boolean bl) {
        this.fixNames = bl;
    }

    public void setSummaryOnly(boolean bl) {
        this.summaryOnly = bl;
    }

    public DatabaseAPI getDatabaseAPI() {
        return this.databaseAPI;
    }
}

