/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.loader;

import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceExport;
import edu.uoregon.tau.perfdmf.PhaseConvertedDataSource;
import edu.uoregon.tau.perfdmf.UtilFncs;
import edu.uoregon.tau.perfdmf.loader.LoadTrial;
import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class PhaseConverter {
    public static void usage() {
        System.err.println("Usage: phaseconvert [options] <phase list file> <files>\n\ntry `phaseconvert --help' for more information");
    }

    public static void outputHelp() {
        System.err.println("Usage: phaseconvert [-i] [-f <filetype>] <phase list file> [profile files]\n\nConverts a callpath profile into a phase profile\n\nThe resulting profiles are written to a directory called \"converted\"\nOptions:\n\n  -f, --filetype <filetype>      Specify type of performance data, options are:\n                                   profiles (default), pprof, dynaprof, mpip,\n                                   gprof, psrun, hpm, packed, cube, hpc\n  -i, --fixnames                 Use the fixnames option for gprof\n\nNotes:\n  For the TAU profiles type, you can specify either a specific set of profile\nfiles on the commandline, or you can specify a directory (by default the current\ndirectory).  The specified directory will be searched for profile.*.*.* files,\nor, in the case of multiple counters, directories named MULTI_* containing\nprofile data.\n\nExamples:\n\n  phaseconvert phases.txt\n    This will load profile.* (or multiple counters directories MULTI_*) and\n    create a phase profile with the phases given in phases.txt\n  phaseconvert phases.txt profile.ppk\n    This will convert the profile in profile.ppk to a phase profile\n");
    }

    public static void main(String[] stringArray) {
        DataSource dataSource;
        File[] fileArray;
        FileInputStream fileInputStream;
        String[] stringArray2;
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addBooleanOption('h', "help");
        CmdLineParser.Option option2 = cmdLineParser.addStringOption('f', "filetype");
        CmdLineParser.Option option3 = cmdLineParser.addBooleanOption('i', "fixnames");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println(optionException.getMessage());
            PhaseConverter.usage();
            System.exit(-1);
        }
        Boolean bl = (Boolean)cmdLineParser.getOptionValue(option);
        String string = (String)cmdLineParser.getOptionValue(option2);
        Boolean bl2 = (Boolean)cmdLineParser.getOptionValue(option3);
        if (bl != null && bl.booleanValue()) {
            PhaseConverter.outputHelp();
            System.exit(-1);
        }
        if ((stringArray2 = cmdLineParser.getRemainingArgs()).length < 1) {
            PhaseConverter.usage();
            System.exit(-1);
        }
        File file = new File(stringArray2[0]);
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File not found: " + file);
            System.exit(-1);
            return;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                arrayList.add(string2.trim());
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(-1);
            return;
        }
        int n = 0;
        if (string != null) {
            if (string.equals("profiles")) {
                n = 0;
            } else if (string.equals("pprof")) {
                n = 1;
            } else if (string.equals("dynaprof")) {
                n = 2;
            } else if (string.equals("mpip")) {
                n = 3;
            } else if (string.equals("hpm")) {
                n = 4;
            } else if (string.equals("gprof")) {
                n = 5;
            } else if (string.equals("psrun")) {
                n = 6;
            } else if (string.equals("packed")) {
                n = 7;
            } else if (string.equals("cube")) {
                n = 8;
            } else if (string.equals("hpc")) {
                n = 9;
            } else if (string.equals("gyro")) {
                n = 100;
            } else {
                System.err.println("Please enter a valid file type.");
                LoadTrial.usage();
                System.exit(-1);
            }
        } else if (stringArray2.length == 2) {
            fileArray = stringArray2[1];
            if (fileArray.endsWith(".ppk")) {
                n = 7;
            }
            if (fileArray.endsWith(".cube")) {
                n = 8;
            }
        }
        fileArray = new File[stringArray2.length - 1];
        for (int i = 1; i < stringArray2.length; ++i) {
            fileArray[i - 1] = new File(stringArray2[i]);
        }
        try {
            System.out.println("Loading Profile...");
            dataSource = UtilFncs.initializeDataSource(fileArray, n, bl2 != null && bl2 != false);
            dataSource.load();
        }
        catch (Exception exception) {
            if (fileArray == null || fileArray.length != 0) {
                exception.printStackTrace();
            }
            System.exit(-1);
            return;
        }
        System.out.println("Converting...");
        PhaseConvertedDataSource phaseConvertedDataSource = new PhaseConvertedDataSource(dataSource, arrayList);
        String string3 = "converted";
        File file2 = new File(string3);
        try {
            boolean bl3;
            if (!file2.exists() && !(bl3 = new File(string3).mkdir())) {
                System.err.println("Failed to create directory: " + string3);
                System.exit(-1);
            }
            System.out.println("Writing profiles to 'converted'");
            DataSourceExport.writeProfiles(phaseConvertedDataSource, new File(string3));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(-1);
        }
    }
}

