/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.taudb;

import edu.uoregon.tau.perfdmf.taudb.TAUdbCounter;
import edu.uoregon.tau.perfdmf.taudb.TAUdbSession;
import edu.uoregon.tau.perfdmf.taudb.TAUdbThread;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTimerCallpath;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTrial;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class TAUdbCounterValue {
    private TAUdbSession session = null;
    private TAUdbTrial trial = null;
    private TAUdbCounter counter = null;
    private TAUdbTimerCallpath timerCallpath = null;
    private TAUdbThread thread = null;
    private double sampleCount = 0.0;
    private double maximumValue = 0.0;
    private double minimumValue = 0.0;
    private double meanValue = 0.0;
    private double standardDeviation = 0.0;

    public TAUdbCounterValue(TAUdbSession tAUdbSession, TAUdbTrial tAUdbTrial, TAUdbCounter tAUdbCounter, TAUdbTimerCallpath tAUdbTimerCallpath, TAUdbThread tAUdbThread, double d, double d2, double d3, double d4, double d5) {
        this.session = tAUdbSession;
        this.trial = tAUdbTrial;
        this.counter = tAUdbCounter;
        this.timerCallpath = tAUdbTimerCallpath;
        this.thread = tAUdbThread;
        this.sampleCount = d;
        this.maximumValue = d2;
        this.minimumValue = d3;
        this.meanValue = d4;
        this.standardDeviation = d5;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Counter: " + this.counter);
        stringBuilder.append(" Thread: " + this.thread.getThreadRank());
        stringBuilder.append(" samples: " + this.sampleCount);
        stringBuilder.append(" mean: " + this.meanValue);
        return stringBuilder.toString();
    }

    public static List<TAUdbCounterValue> getCounterValues(TAUdbSession tAUdbSession, TAUdbTrial tAUdbTrial) {
        if (tAUdbTrial.getCounterValues() != null && tAUdbTrial.getCounterValues().size() > 0) {
            return tAUdbTrial.getCounterValues();
        }
        ArrayList<TAUdbCounterValue> arrayList = new ArrayList<TAUdbCounterValue>();
        String string = "select v.counter, v.timer_callpath, v.thread, v.sample_count, v.maximum_value, v.minimum_value, v.mean_value, v.standard_deviation from counter_value v join counter c on v.counter = c.id where c.trial = ?";
        try {
            PreparedStatement preparedStatement = tAUdbSession.getDB().prepareStatement(string);
            preparedStatement.setInt(1, tAUdbTrial.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n = resultSet.getInt(1);
                Integer n2 = resultSet.getInt(2);
                Integer n3 = resultSet.getInt(3);
                double d = resultSet.getDouble(4);
                double d2 = resultSet.getDouble(5);
                double d3 = resultSet.getDouble(6);
                double d4 = resultSet.getDouble(7);
                double d5 = resultSet.getDouble(8);
                TAUdbCounter tAUdbCounter = tAUdbTrial.getCounters().get(n);
                TAUdbTimerCallpath tAUdbTimerCallpath = tAUdbTrial.getTimerCallpaths().get(n2);
                TAUdbThread tAUdbThread = tAUdbTrial.getThreads().get(n3);
                if (tAUdbThread == null) {
                    tAUdbThread = tAUdbTrial.getDerivedThreads().get(n3);
                }
                TAUdbCounterValue tAUdbCounterValue = new TAUdbCounterValue(tAUdbSession, tAUdbTrial, tAUdbCounter, tAUdbTimerCallpath, tAUdbThread, d, d2, d3, d4, d5);
                arrayList.add(tAUdbCounterValue);
            }
            resultSet.close();
            preparedStatement.close();
            tAUdbTrial.setCounterValues(arrayList);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return arrayList;
    }

    public TAUdbSession getSession() {
        return this.session;
    }

    public void setSession(TAUdbSession tAUdbSession) {
        this.session = tAUdbSession;
    }

    public TAUdbTrial getTrial() {
        return this.trial;
    }

    public void setTrial(TAUdbTrial tAUdbTrial) {
        this.trial = tAUdbTrial;
    }

    public TAUdbCounter getCounter() {
        return this.counter;
    }

    public void setCounter(TAUdbCounter tAUdbCounter) {
        this.counter = tAUdbCounter;
    }

    public TAUdbTimerCallpath getTimerCallpath() {
        return this.timerCallpath;
    }

    public void setTimerCallpath(TAUdbTimerCallpath tAUdbTimerCallpath) {
        this.timerCallpath = tAUdbTimerCallpath;
    }

    public TAUdbThread getThread() {
        return this.thread;
    }

    public void setThread(TAUdbThread tAUdbThread) {
        this.thread = tAUdbThread;
    }

    public double getSampleCount() {
        return this.sampleCount;
    }

    public void setSampleCount(double d) {
        this.sampleCount = d;
    }

    public double getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(double d) {
        this.maximumValue = d;
    }

    public double getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(double d) {
        this.minimumValue = d;
    }

    public double getMeanValue() {
        return this.meanValue;
    }

    public void setMeanValue(double d) {
        this.meanValue = d;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public void setStandardDeviation(double d) {
        this.standardDeviation = d;
    }

    public static void main(String[] stringArray) {
        TAUdbSession tAUdbSession = new TAUdbSession("callpath", false);
        TAUdbTrial tAUdbTrial = TAUdbTrial.getTrial(tAUdbSession, 1, true);
        List<TAUdbCounterValue> list = TAUdbCounterValue.getCounterValues(tAUdbSession, tAUdbTrial);
        for (TAUdbCounterValue tAUdbCounterValue : list) {
            System.out.println(tAUdbCounterValue.toString());
        }
        tAUdbSession.close();
    }
}

