/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.taudb;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import edu.uoregon.tau.common.MetaDataMap;
import edu.uoregon.tau.perfdmf.CallPathUtilFuncs;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.IntervalLocationProfile;
import edu.uoregon.tau.perfdmf.MetaDataParserJSON;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Parameter;
import edu.uoregon.tau.perfdmf.SourceRegion;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.perfdmf.View;
import edu.uoregon.tau.perfdmf.database.DB;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import org.postgresql.PGConnection;
import org.postgresql.copy.CopyManager;

public class TAUdbDatabaseAPI
extends DatabaseAPI {
    static final int MEAN_WITHOUT_NULL = -1;
    static final int TOTAL = -2;
    static final int STDDEV_WITHOUT_NULL = -3;
    static final int MIN = -4;
    static final int MAX = -5;
    static final int MEAN_WITH_NULL = -6;
    static final int STDDEV_WITH_NULL = -7;
    private Map<Integer, Experiment> experiments = null;
    private Map<Integer, View> views = null;
    private View view = null;

    public TAUdbDatabaseAPI(DatabaseAPI databaseAPI) {
        databaseAPI.copy(this);
    }

    public TAUdbDatabaseAPI() {
    }

    public static int uploadTrial(DB dB, Trial trial, boolean bl) {
        DataSource dataSource = trial.getDataSource();
        try {
            dB.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Saving Trial Failed: couldn't set AutoCommit to false", sQLException);
        }
        int n = -1;
        Map<Function, Integer> map = null;
        Map<Thread, Integer> map2 = null;
        try {
            long l;
            n = trial.saveTrial(dB);
            trial.setID(n);
            long l2 = l = System.currentTimeMillis();
            System.out.print("Inserting metrics...");
            TAUdbDatabaseAPI.uploadMetrics(n, dataSource.getMetrics(), dB);
            Map<Metric, Integer> map3 = TAUdbDatabaseAPI.getMetricIDMap(n, dataSource, dB);
            long l3 = System.currentTimeMillis();
            System.out.println(" done. (" + (double)(l3 - l) / 1000.0 + " seconds)");
            l = l3;
            System.out.print("Inserting timers...");
            TAUdbDatabaseAPI.uploadFunctions(n, dataSource, dB);
            Map<Function, Integer> map4 = TAUdbDatabaseAPI.getFunctionsIDMap(n, dataSource, dB);
            l3 = System.currentTimeMillis();
            System.out.println(" done. (" + (double)(l3 - l) / 1000.0 + " seconds)");
            l = l3;
            if (!bl) {
                System.out.print("Inserting threads...");
                TAUdbDatabaseAPI.uploadThreads(n, dataSource, dB);
                map2 = TAUdbDatabaseAPI.getThreadsMap(n, dataSource, dB, false);
                l3 = System.currentTimeMillis();
                System.out.println(" done. (" + (double)(l3 - l) / 1000.0 + " seconds)");
                l = l3;
            }
            System.out.print("Inserting timer groups and parameters...");
            TAUdbDatabaseAPI.uploadTimerGroups(map4, dB);
            TAUdbDatabaseAPI.uploadTimerParameter(map4, dB);
            l3 = System.currentTimeMillis();
            System.out.println(" done. (" + (double)(l3 - l) / 1000.0 + " seconds)");
            l = l3;
            System.out.print("Inserting call graph...");
            map = TAUdbDatabaseAPI.uploadCallpathInfo(dataSource, map4, dB);
            l3 = System.currentTimeMillis();
            System.out.println(" done. (" + (double)(l3 - l) / 1000.0 + " seconds)");
            l = l3;
            if (bl) {
                System.out.println("Only doing summary!");
            }
            if (!bl) {
                System.out.print("Inserting per-thread call data...");
                TAUdbDatabaseAPI.uploadCallDataInfo(dataSource, map, map3, map2, dB, false);
                l3 = System.currentTimeMillis();
                System.out.println(" done. (" + (double)(l3 - l) / 1000.0 + " seconds)");
                l = l3;
            }
            System.out.print("Inserting derived threads...");
            Map<Thread, Integer> map5 = TAUdbDatabaseAPI.uploadDerivedThreads(n, dataSource, dB);
            l3 = System.currentTimeMillis();
            System.out.println(" done. (" + (double)(l3 - l) / 1000.0 + " seconds)");
            l = l3;
            System.out.print("Inserting derived threads call data...");
            TAUdbDatabaseAPI.uploadCallDataInfo(dataSource, map, map3, map5, dB, true);
            l3 = System.currentTimeMillis();
            System.out.println(" done. (" + (double)(l3 - l) / 1000.0 + " seconds)");
            l = l3;
            System.out.print("Querying new call data for IDs...");
            Map<TimerCallData, Integer> map6 = TAUdbDatabaseAPI.getCallDataMap(n, dataSource, map, dB);
            l3 = System.currentTimeMillis();
            System.out.println(" done. (" + (double)(l3 - l) / 1000.0 + " seconds)");
            l = l3;
            System.out.print("Inserting timer measurements...");
            if (!bl) {
                if (dB.getDBType().equals("postgresql")) {
                    TAUdbDatabaseAPI.uploadFunctionProfilesPSQL(dataSource, map6, map3, dB);
                } else {
                    TAUdbDatabaseAPI.uploadFunctionProfiles(dataSource, map6, map3, dB);
                    TAUdbDatabaseAPI.uploadStatistics(dataSource, map6, map3, dB);
                }
            } else {
                TAUdbDatabaseAPI.uploadStatistics(dataSource, map6, map3, dB);
            }
            l3 = System.currentTimeMillis();
            System.out.println(" done. (" + (double)(l3 - l) / 1000.0 + " seconds)");
            l = l3;
            if (!bl) {
                System.out.print("Inserting counters...");
                TAUdbDatabaseAPI.uploadUserEvents(n, map4, dataSource, dB);
                Map<UserEvent, Integer> map7 = TAUdbDatabaseAPI.getUserEventsMap(n, dataSource, dB);
                TAUdbDatabaseAPI.uploadUserEventProfiles(dataSource, map7, dB, map2);
                l3 = System.currentTimeMillis();
                System.out.println(" done. (" + (double)(l3 - l) / 1000.0 + " seconds)");
                l = l3;
            }
            System.out.print("Inserting metadata...");
            TAUdbDatabaseAPI.uploadMetadata(dataSource, trial, map, map2, dB, bl);
            l3 = System.currentTimeMillis();
            System.out.println(" done. (" + (double)(l3 - l) / 1000.0 + " seconds)");
            System.out.println("Total time to load : " + (double)(l3 - l2) / 1000.0 + " seconds");
        }
        catch (SQLException sQLException) {
            try {
                dB.rollback();
                sQLException.printStackTrace();
                throw new DatabaseException("Saving Trial Failed, rollbacks successful", sQLException);
            }
            catch (SQLException sQLException2) {
                throw new DatabaseException("Saving Trial Failed, rollbacks failed!", sQLException2);
            }
        }
        try {
            dB.commit();
            dB.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Saving Trial Failed: commit failed!", sQLException);
        }
        return n;
    }

    private static Map<Thread, Integer> uploadDerivedThreads(int n, DataSource dataSource, DB dB) throws SQLException {
        PreparedStatement preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "thread (trial, node_rank, context_rank, thread_rank,  " + " thread_index) VALUES (?, ?, ?, ?, ?)");
        List<Thread> list = dataSource.getAggThreads();
        for (Thread thread : list) {
            int n2 = thread.getNodeID();
            int n3 = thread.getContextID();
            int n4 = thread.getThreadID();
            int n5 = n2;
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            preparedStatement.setInt(3, n3);
            preparedStatement.setInt(4, n4);
            preparedStatement.setInt(5, n5);
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        preparedStatement.close();
        return TAUdbDatabaseAPI.getDerivedThreadsMap(n, dataSource, dB);
    }

    private static void uploadStatistics(DataSource dataSource, Map<TimerCallData, Integer> map, Map<Metric, Integer> map2, DB dB) throws SQLException {
        Group group = dataSource.getGroup("TAU_CALLPATH_DERIVED");
        PreparedStatement preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "timer_value (timer_call_data, metric, inclusive_percent, inclusive_value, exclusive_percent, " + " exclusive_value) VALUES (?, ?, ?, ?, ?, ?)");
        for (Metric metric : dataSource.getMetrics()) {
            Integer n = map2.get(metric);
            if (n == null) continue;
            Iterator<Function> iterator = dataSource.getFunctionIterator();
            while (iterator.hasNext()) {
                Function function = iterator.next();
                if (function.isGroupMember(group)) continue;
                for (Thread thread : dataSource.getAggThreads()) {
                    TimerCallData timerCallData = new TimerCallData(function, thread, 0.0);
                    Integer n2 = map.get(timerCallData);
                    if (n2 == null) continue;
                    int n3 = n2;
                    TAUdbDatabaseAPI.insertDerivedThreadValue(preparedStatement, metric, n, n3, thread, function);
                }
            }
        }
        preparedStatement.executeBatch();
        preparedStatement.close();
    }

    private static void insertDerivedThreadValue(PreparedStatement preparedStatement, Metric metric, Integer n, Integer n2, Thread thread, Function function) throws SQLException {
        FunctionProfile functionProfile = thread.getFunctionProfile(function);
        if (functionProfile != null) {
            preparedStatement.setInt(1, n2);
            preparedStatement.setInt(2, n);
            preparedStatement.setDouble(3, functionProfile.getInclusivePercent(metric.getID()));
            preparedStatement.setDouble(4, functionProfile.getInclusive(metric.getID()));
            preparedStatement.setDouble(5, functionProfile.getExclusivePercent(metric.getID()));
            preparedStatement.setDouble(6, functionProfile.getExclusive(metric.getID()));
            if (functionProfile.getExclusive(metric.getID()) == 3.142998606E-313) {
                System.out.println("Found it");
            }
            preparedStatement.addBatch();
        }
    }

    private static Integer getIDForCallpath(DataSource dataSource, DB dB, Function function, Map<Function, Integer> map, Map<Function, Integer> map2) throws SQLException {
        Integer n = map.get(function);
        if (n == null) {
            Function function2;
            Integer n2;
            Object object;
            Integer n3 = null;
            String string = CallPathUtilFuncs.getParentName(function.getName());
            if (!string.equals("")) {
                object = dataSource.getFunction(string);
                if (object == null) {
                    object = dataSource.addFunction(string, dataSource.getNumberOfMetrics());
                }
                n3 = TAUdbDatabaseAPI.getIDForCallpath(dataSource, dB, (Function)object, map, map2);
            }
            if ((n2 = map2.get(function2 = dataSource.getFunction((String)(object = function.getCallpathNodeName())))) == null) {
                return null;
            }
            PreparedStatement preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "timer_callpath (timer, parent) " + "VALUES (?, ?)");
            preparedStatement.setInt(1, n2);
            if (n3 == null) {
                preparedStatement.setNull(2, 4);
            } else {
                preparedStatement.setInt(2, n3);
            }
            preparedStatement.execute();
            preparedStatement.close();
            String string2 = new String();
            string2 = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM timer_callpath" : (dB.getDBType().compareTo("sqlite") == 0 ? "select seq from sqlite_sequence where name = 'timer_callpath'" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM timer_callpath" : (dB.getDBType().compareTo("h2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM timer_callpath" : (dB.getDBType().compareTo("oracle") == 0 ? "select " + dB.getSchemaPrefix() + "timer_callpath_id_seq.currval FROM dual" : "select currval('timer_callpath_id_seq');")))));
            n = Integer.parseInt(dB.getDataItem(string2));
            map.put(function, n);
        }
        return (int)n;
    }

    private static Map<Function, Integer> uploadCallpathInfo(DataSource dataSource, Map<Function, Integer> map, DB dB) throws SQLException {
        Group group = dataSource.getGroup("TAU_CALLPATH_DERIVED");
        HashMap<Function, Integer> hashMap = new HashMap<Function, Integer>();
        Iterator<Function> iterator = dataSource.getFunctionIteratorCopy();
        while (iterator.hasNext()) {
            Function function = iterator.next();
            if (function.isGroupMember(group)) continue;
            TAUdbDatabaseAPI.getIDForCallpath(dataSource, dB, function, hashMap, map);
        }
        return hashMap;
    }

    private static Map<Function, Integer> getTimerCallPathMap(int n, DataSource dataSource, DB dB) throws SQLException {
        HashMap<Function, Integer> hashMap = new HashMap<Function, Integer>();
        PreparedStatement preparedStatement = dB.prepareStatement("with recursive cp (id, parent, timer, name) as ( SELECT tc.id, tc.parent, tc.timer, t.name FROM " + dB.getSchemaPrefix() + "timer_callpath tc inner join " + dB.getSchemaPrefix() + "timer t on tc.timer = t.id where " + "t.trial = " + n + " and tc.parent is null" + "UNION ALL" + "SELECT d.id, d.parent, d.timer, " + "concat (cp.name, ' => ', dt.name) FROM " + dB.getSchemaPrefix() + "timer_callpath AS d JOIN cp ON (d.parent = cp.id) join " + dB.getSchemaPrefix() + "timer dt on d.timer = dt.id where dt.trial = " + n + " ) " + "SELECT distinct * FROM cp order by parent;");
        preparedStatement.execute();
        ResultSet resultSet = preparedStatement.getResultSet();
        while (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            String string = resultSet.getString(2);
            Function function = dataSource.getFunction(string);
            hashMap.put(function, n2);
        }
        preparedStatement.close();
        return hashMap;
    }

    private static void uploadCallDataInfo(DataSource dataSource, Map<Function, Integer> map, Map<Metric, Integer> map2, Map<Thread, Integer> map3, DB dB, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "timer_call_data (timer_callpath, thread, calls, subroutines) " + "VALUES (?, ?, ?, ?)");
        Group group = dataSource.getGroup("TAU_CALLPATH_DERIVED");
        for (Function function : map.keySet()) {
            if (function.isGroupMember(group)) continue;
            Integer n = map.get(function);
            List<Thread> list = null;
            list = bl ? dataSource.getAggThreads() : dataSource.getAllThreads();
            for (Thread thread : list) {
                Integer n2 = map3.get(thread);
                if (n2 == null) {
                    System.out.println("Function: " + function + " Can't find Thread ID for thread: " + thread);
                    continue;
                }
                FunctionProfile functionProfile = thread.getFunctionProfile(function);
                if (functionProfile == null || !(functionProfile.getNumCalls() > 0.0)) continue;
                preparedStatement.setInt(1, n);
                preparedStatement.setInt(2, n2);
                preparedStatement.setInt(3, (int)functionProfile.getNumCalls());
                preparedStatement.setInt(4, (int)functionProfile.getNumSubr());
                preparedStatement.addBatch();
            }
        }
        preparedStatement.executeBatch();
        preparedStatement.close();
    }

    private static void uploadThreads(int n, DataSource dataSource, DB dB) throws SQLException {
        int n2 = dataSource.getMaxNCTNumbers()[1] + 1;
        int n3 = dataSource.getMaxNCTNumbers()[2] + 1;
        PreparedStatement preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "thread (trial, node_rank, context_rank, thread_rank,  " + " thread_index) VALUES (?, ?, ?, ?, ?)");
        List<Thread> list = dataSource.getAllThreads();
        for (Thread thread : list) {
            int n4 = thread.getNodeID();
            int n5 = thread.getContextID();
            int n6 = thread.getThreadID();
            int n7 = n4 * n2 * n3 + n5 * n3 + n6;
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n4);
            preparedStatement.setInt(3, n5);
            preparedStatement.setInt(4, n6);
            preparedStatement.setInt(5, n7);
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        preparedStatement.close();
    }

    public static Map<String, Integer> getCallDataMap(int n, DB dB) throws SQLException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("with recursive cp (id, parent, timer, name) as ( SELECT tc.id, tc.parent, tc.timer, t.name FROM " + dB.getSchemaPrefix() + "timer_callpath tc inner join " + dB.getSchemaPrefix() + "timer t on tc.timer = t.id where ");
        stringBuilder.append("t.trial = " + n + " and tc.parent is null ");
        stringBuilder.append("UNION ALL SELECT d.id, d.parent, d.timer, ");
        if (dB.getDBType().compareTo("h2") == 0) {
            stringBuilder.append("concat (cp.name, ' => ', dt.name) FROM ");
        } else {
            stringBuilder.append("cp.name || ' => ' || dt.name FROM ");
        }
        stringBuilder.append(dB.getSchemaPrefix() + "timer_callpath AS d JOIN cp ON (d.parent = cp.id) join " + dB.getSchemaPrefix());
        stringBuilder.append("timer dt on d.timer = dt.id where dt.trial = " + n + ") ");
        stringBuilder.append("SELECT distinct tcd.id, tcd.time_range, cp.name, h.node_rank, h.context_rank, h.thread_rank, cp.id FROM cp join ");
        stringBuilder.append(dB.getSchemaPrefix());
        stringBuilder.append("timer_call_data tcd on tcd.timer_callpath = cp.id join ");
        stringBuilder.append(dB.getSchemaPrefix());
        stringBuilder.append("thread h on tcd.thread = h.id where h.trial = " + n);
        PreparedStatement preparedStatement = dB.prepareStatement(stringBuilder.toString());
        preparedStatement.execute();
        ResultSet resultSet = preparedStatement.getResultSet();
        while (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            Double d = resultSet.getDouble(2);
            String string = resultSet.getString(3);
            int n3 = resultSet.getInt(4);
            int n4 = resultSet.getInt(5);
            int n5 = resultSet.getInt(6);
            int n6 = resultSet.getInt(7);
            hashMap.put(string, n6);
        }
        preparedStatement.close();
        return hashMap;
    }

    public static Map<String, ArrayList<Integer>> getCallDataMap(List<Integer> list, DB dB) throws SQLException {
        int n;
        HashMap<String, ArrayList<Integer>> hashMap = new HashMap<String, ArrayList<Integer>>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("with recursive cp (id, parent, timer, name) as ( SELECT tc.id, tc.parent, tc.timer, t.name FROM " + dB.getSchemaPrefix() + "timer_callpath tc inner join " + dB.getSchemaPrefix() + "timer t on tc.timer = t.id ");
        for (n = 0; n < list.size(); ++n) {
            if (n != 0) {
                stringBuilder.append(" or ");
            } else {
                stringBuilder.append(" where ( ");
            }
            stringBuilder.append("t.trial = " + list.get(n) + " ");
        }
        if (list.size() > 0) {
            stringBuilder.append(")");
        }
        stringBuilder.append(" and tc.parent is null ");
        stringBuilder.append("UNION ALL SELECT d.id, d.parent, d.timer, ");
        if (dB.getDBType().compareTo("h2") == 0) {
            stringBuilder.append("concat (cp.name, ' => ', dt.name) FROM ");
        } else {
            stringBuilder.append("cp.name || ' => ' || dt.name FROM ");
        }
        stringBuilder.append(dB.getSchemaPrefix() + "timer_callpath AS d JOIN cp ON (d.parent = cp.id) join " + dB.getSchemaPrefix());
        stringBuilder.append("timer dt on d.timer = dt.id ");
        for (n = 0; n < list.size(); ++n) {
            if (n != 0) {
                stringBuilder.append(" or ");
            } else {
                stringBuilder.append(" where ( ");
            }
            stringBuilder.append("dt.trial = " + list.get(n) + " ");
        }
        if (list.size() > 0) {
            stringBuilder.append(")");
        }
        stringBuilder.append(")");
        stringBuilder.append("SELECT distinct tcd.id, tcd.time_range, cp.name, h.node_rank, h.context_rank, h.thread_rank, cp.id FROM cp join ");
        stringBuilder.append(dB.getSchemaPrefix());
        stringBuilder.append("timer_call_data tcd on tcd.timer_callpath = cp.id join ");
        stringBuilder.append(dB.getSchemaPrefix());
        stringBuilder.append("thread h on tcd.thread = h.id");
        for (n = 0; n < list.size(); ++n) {
            if (n != 0) {
                stringBuilder.append(" or ");
            } else {
                stringBuilder.append(" where ( ");
            }
            stringBuilder.append("h.trial = " + list.get(n) + " ");
        }
        if (list.size() > 0) {
            stringBuilder.append(")");
        }
        PreparedStatement preparedStatement = dB.prepareStatement(stringBuilder.toString());
        try {
            preparedStatement.execute();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ResultSet resultSet = preparedStatement.getResultSet();
        while (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            Double d = resultSet.getDouble(2);
            String string = resultSet.getString(3);
            int n3 = resultSet.getInt(4);
            int n4 = resultSet.getInt(5);
            int n5 = resultSet.getInt(6);
            int n6 = resultSet.getInt(7);
            ArrayList<Integer> arrayList = (ArrayList<Integer>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(n6);
        }
        preparedStatement.close();
        return hashMap;
    }

    private static Map<TimerCallData, Integer> getCallDataMap(int n, DataSource dataSource, Map<Function, Integer> map, DB dB) throws SQLException {
        Object object;
        HashMap<TimerCallData, Integer> hashMap = new HashMap<TimerCallData, Integer>();
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<Integer, Function> hashMap2 = new HashMap<Integer, Function>();
        if (map != null) {
            for (Function object22 : map.keySet()) {
                hashMap2.put(map.get(object22), object22);
            }
        } else {
            object = dataSource.getFunctionIterator();
            while (object.hasNext()) {
                Function function = object.next();
                hashMap2.put(function.getID(), function);
            }
        }
        stringBuilder.append("select distinct tcd.id, tcd.time_range, cp.id, h.node_rank, h.context_rank, h.thread_rank ");
        stringBuilder.append("from timer_callpath cp ");
        stringBuilder.append("join timer_call_data tcd on tcd.timer_callpath = cp.id ");
        stringBuilder.append("join thread h on tcd.thread = h.id where h.trial = " + n);
        object = dB.prepareStatement(stringBuilder.toString());
        object.execute();
        ResultSet resultSet = object.getResultSet();
        while (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            Double d = resultSet.getDouble(2);
            Function function = (Function)hashMap2.get(resultSet.getInt(3));
            int n3 = resultSet.getInt(4);
            int n4 = resultSet.getInt(5);
            int n5 = resultSet.getInt(6);
            Thread thread = null;
            if (n3 < 0) {
                switch (n3) {
                    case -1: {
                        thread = dataSource.getMeanData();
                        break;
                    }
                    case -2: {
                        thread = dataSource.getTotalData();
                        break;
                    }
                    case -3: {
                        thread = dataSource.getStdDevData();
                        break;
                    }
                    case -4: {
                        thread = dataSource.getMinData();
                        break;
                    }
                    case -5: {
                        thread = dataSource.getMaxData();
                        break;
                    }
                    case -6: {
                        thread = dataSource.getMeanDataAll();
                        break;
                    }
                    case -7: {
                        thread = dataSource.getStdDevDataAll();
                        break;
                    }
                }
            } else {
                thread = dataSource.getThread(n3, n4, n5);
            }
            TimerCallData timerCallData = new TimerCallData(function, thread, d);
            hashMap.put(timerCallData, n2);
        }
        object.close();
        return hashMap;
    }

    public static Map<Thread, Integer> getThreadsMap(int n, DataSource dataSource, DB dB, boolean bl) throws SQLException {
        HashMap<Thread, Integer> hashMap = new HashMap<Thread, Integer>();
        PreparedStatement preparedStatement = dB.prepareStatement("SELECT node_rank, context_rank, thread_rank, id FROM " + dB.getSchemaPrefix() + "thread WHERE trial=?");
        preparedStatement.setInt(1, n);
        preparedStatement.execute();
        ResultSet resultSet = preparedStatement.getResultSet();
        while (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            int n3 = resultSet.getInt(2);
            int n4 = resultSet.getInt(3);
            int n5 = resultSet.getInt(4);
            Thread thread = dataSource.getThread(n2, n3, n4);
            if (thread == null && bl && n2 >= 0) {
                dataSource.addThread(n2, n3, n4);
            }
            hashMap.put(thread, n5);
        }
        preparedStatement.close();
        return hashMap;
    }

    private static Map<Thread, Integer> getDerivedThreadsMap(int n, DataSource dataSource, DB dB) throws SQLException {
        HashMap<Thread, Integer> hashMap = new HashMap<Thread, Integer>();
        PreparedStatement preparedStatement = dB.prepareStatement("SELECT thread_index, id FROM " + dB.getSchemaPrefix() + "thread WHERE trial=? and thread_index < 0 order by thread_index desc");
        preparedStatement.setInt(1, n);
        preparedStatement.execute();
        ResultSet resultSet = preparedStatement.getResultSet();
        while (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            int n3 = resultSet.getInt(2);
            switch (n2) {
                case -1: {
                    hashMap.put(dataSource.getMeanDataNoNull(), n3);
                    break;
                }
                case -2: {
                    hashMap.put(dataSource.getTotalData(), n3);
                    break;
                }
                case -3: {
                    hashMap.put(dataSource.getStdDevDataNoNull(), n3);
                    break;
                }
                case -4: {
                    hashMap.put(dataSource.getMinData(), n3);
                    break;
                }
                case -5: {
                    hashMap.put(dataSource.getMaxData(), n3);
                    break;
                }
                case -6: {
                    hashMap.put(dataSource.getMeanDataAll(), n3);
                    break;
                }
                case -7: {
                    hashMap.put(dataSource.getStdDevDataAll(), n3);
                    break;
                }
            }
        }
        preparedStatement.close();
        return hashMap;
    }

    private static void uploadTimerParameter(Map<Function, Integer> map, DB dB) throws SQLException {
        Set<Function> set = map.keySet();
        PreparedStatement preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "timer_parameter (timer, parameter_name, parameter_value) VALUES (?, ?, ?)");
        for (Function function : set) {
            int n = map.get(function);
            List<Parameter> list = function.getSourceLink().getParameters();
            if (list == null) continue;
            for (Parameter parameter : list) {
                preparedStatement.setInt(1, n);
                preparedStatement.setString(2, parameter.getName());
                preparedStatement.setString(3, parameter.getValue());
                preparedStatement.addBatch();
            }
        }
        preparedStatement.executeBatch();
        preparedStatement.close();
    }

    private static void uploadTimerGroups(Map<Function, Integer> map, DB dB) throws SQLException {
        Set<Function> set = map.keySet();
        PreparedStatement preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "timer_group (timer, group_name) VALUES (?, ?)");
        for (Function function : set) {
            int n = map.get(function);
            List<Group> list = function.getGroups();
            if (list == null) continue;
            for (Group group : list) {
                preparedStatement.setInt(1, n);
                preparedStatement.setString(2, group.getName());
                preparedStatement.addBatch();
            }
        }
        preparedStatement.executeBatch();
        preparedStatement.close();
    }

    private static void uploadMetrics(int n, List<Metric> list, DB dB) throws SQLException {
        PreparedStatement preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "metric (name, trial, derived) VALUES (?, ?, ?)");
        for (Metric metric : list) {
            preparedStatement.setString(1, metric.getName());
            preparedStatement.setInt(2, n);
            preparedStatement.setBoolean(3, metric.getDerivedMetric());
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        preparedStatement.close();
    }

    private static Map<Metric, Integer> getMetricIDMap(int n, DataSource dataSource, DB dB) throws SQLException {
        HashMap<Metric, Integer> hashMap = new HashMap<Metric, Integer>();
        PreparedStatement preparedStatement = dB.prepareStatement("SELECT id, name FROM " + dB.getSchemaPrefix() + "metric WHERE trial=?");
        preparedStatement.setInt(1, n);
        preparedStatement.execute();
        ResultSet resultSet = preparedStatement.getResultSet();
        while (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            String string = resultSet.getString(2);
            Metric metric = dataSource.getMetric(string);
            metric.setDbMetricID(n2);
            hashMap.put(metric, n2);
        }
        preparedStatement.close();
        return hashMap;
    }

    private static void uploadFunctions(int n, DataSource dataSource, DB dB) throws SQLException {
        Group group = dataSource.getGroup("TAU_CALLPATH_DERIVED");
        Group group2 = dataSource.getGroup("TAU_CALLPATH");
        PreparedStatement preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "timer (trial, name, source_file, line_number, line_number_end, column_number, column_number_end, short_name) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        Iterator<Function> iterator = dataSource.getFunctionIterator();
        while (iterator.hasNext()) {
            Function function = iterator.next();
            if (function.isGroupMember(group) || function.isCallPathFunction()) continue;
            SourceRegion sourceRegion = function.getSourceLink();
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, function.getName());
            preparedStatement.setString(3, sourceRegion.getFilename());
            preparedStatement.setInt(4, sourceRegion.getStartLine());
            preparedStatement.setInt(5, sourceRegion.getEndLine());
            preparedStatement.setInt(6, sourceRegion.getStartColumn());
            preparedStatement.setInt(7, sourceRegion.getEndColumn());
            preparedStatement.setString(8, sourceRegion.getShortName());
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        preparedStatement.close();
    }

    private static Map<Function, Integer> getFunctionsIDMap(int n, DataSource dataSource, DB dB) throws SQLException {
        HashMap<Function, Integer> hashMap = new HashMap<Function, Integer>();
        PreparedStatement preparedStatement = dB.prepareStatement("SELECT id, name FROM " + dB.getSchemaPrefix() + "timer WHERE trial=?");
        preparedStatement.setInt(1, n);
        preparedStatement.execute();
        ResultSet resultSet = preparedStatement.getResultSet();
        while (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            String string = resultSet.getString(2);
            Function function = dataSource.getFunction(string);
            hashMap.put(function, n2);
        }
        preparedStatement.close();
        return hashMap;
    }

    private static void uploadFunctionProfilesPSQL(DataSource dataSource, Map<TimerCallData, Integer> map, Map<Metric, Integer> map2, DB dB) throws SQLException {
        if (!(dB.getConnection() instanceof PGConnection)) {
            System.err.println("Upload using copy was called on a non postgresql database.");
            return;
        }
        PGConnection pGConnection = (PGConnection)dB.getConnection();
        CopyManager copyManager = pGConnection.getCopyAPI();
        StringBuffer stringBuffer = new StringBuffer();
        Group group = dataSource.getGroup("TAU_CALLPATH_DERIVED");
        for (Metric metric : dataSource.getMetrics()) {
            Integer n = map2.get(metric);
            Iterator<Function> iterator = dataSource.getFunctionIterator();
            while (iterator.hasNext()) {
                FunctionProfile functionProfile;
                Integer n2;
                TimerCallData timerCallData;
                Function function = iterator.next();
                if (function.isGroupMember(group)) continue;
                for (Thread thread : dataSource.getAllThreads()) {
                    timerCallData = new TimerCallData(function, thread, 0.0);
                    n2 = map.get(timerCallData);
                    functionProfile = thread.getFunctionProfile(function);
                    if (functionProfile == null || n2 == null) continue;
                    stringBuffer.append(n2 + "\t");
                    stringBuffer.append(n + "\t");
                    stringBuffer.append(TAUdbDatabaseAPI.checkDoubleValue(functionProfile.getInclusivePercent(metric.getID())) + "\t");
                    stringBuffer.append(TAUdbDatabaseAPI.checkDoubleValue(functionProfile.getInclusive(metric.getID())) + "\t");
                    stringBuffer.append(TAUdbDatabaseAPI.checkDoubleValue(functionProfile.getExclusivePercent(metric.getID())) + "\t");
                    stringBuffer.append(TAUdbDatabaseAPI.checkDoubleValue(functionProfile.getExclusive(metric.getID())) + "\n");
                }
                for (Thread thread : dataSource.getAggThreads()) {
                    timerCallData = new TimerCallData(function, thread, 0.0);
                    n2 = map.get(timerCallData);
                    functionProfile = thread.getFunctionProfile(function);
                    if (functionProfile == null || n2 == null) continue;
                    stringBuffer.append(n2 + "\t");
                    stringBuffer.append(n + "\t");
                    stringBuffer.append(TAUdbDatabaseAPI.checkDoubleValue(functionProfile.getInclusivePercent(metric.getID())) + "\t");
                    stringBuffer.append(TAUdbDatabaseAPI.checkDoubleValue(functionProfile.getInclusive(metric.getID())) + "\t");
                    stringBuffer.append(TAUdbDatabaseAPI.checkDoubleValue(functionProfile.getExclusivePercent(metric.getID())) + "\t");
                    stringBuffer.append(TAUdbDatabaseAPI.checkDoubleValue(functionProfile.getExclusive(metric.getID())) + "\n");
                }
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes());
        try {
            copyManager.copyIn("COPY timer_value (timer_call_data, metric, inclusive_percent, inclusive_value, exclusive_percent,  exclusive_value) FROM STDIN", (InputStream)byteArrayInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static double checkDoubleValue(double d) {
        if (d < 1.0E-307) {
            return 0.0;
        }
        if (d > 1.0E308) {
            return 9.0E307;
        }
        return d;
    }

    private static void uploadFunctionProfiles(DataSource dataSource, Map<TimerCallData, Integer> map, Map<Metric, Integer> map2, DB dB) throws SQLException {
        PreparedStatement preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "timer_value (timer_call_data, metric, inclusive_percent, inclusive_value, exclusive_percent, " + " exclusive_value) VALUES (?, ?, ?, ?, ?, ?)");
        Group group = dataSource.getGroup("TAU_CALLPATH_DERIVED");
        for (Metric metric : dataSource.getMetrics()) {
            Integer n = map2.get(metric);
            if (n == null) continue;
            Iterator<Function> iterator = dataSource.getFunctionIterator();
            while (iterator.hasNext()) {
                Function function = iterator.next();
                if (function.isGroupMember(group)) continue;
                for (Thread thread : dataSource.getAllThreads()) {
                    TimerCallData timerCallData = new TimerCallData(function, thread, 0.0);
                    Integer n2 = map.get(timerCallData);
                    if (n2 == null) continue;
                    int n3 = n2;
                    TAUdbDatabaseAPI.insertDerivedThreadValue(preparedStatement, metric, n, n3, thread, function);
                }
            }
        }
        preparedStatement.executeBatch();
        preparedStatement.close();
    }

    private static void uploadUserEvents(int n, Map<Function, Integer> map, DataSource dataSource, DB dB) throws SQLException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Function object2 : map.keySet()) {
            hashMap.put(object2.getName(), map.get(object2));
        }
        PreparedStatement preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "counter (trial, name) VALUES (?, ?)");
        Iterator<UserEvent> iterator = dataSource.getUserEventIterator();
        while (iterator.hasNext()) {
            UserEvent userEvent = iterator.next();
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, userEvent.getName());
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        preparedStatement.close();
    }

    private static Map<UserEvent, Integer> getUserEventsMap(int n, DataSource dataSource, DB dB) throws SQLException {
        HashMap<UserEvent, Integer> hashMap = new HashMap<UserEvent, Integer>();
        PreparedStatement preparedStatement = dB.prepareStatement("SELECT id, name FROM " + dB.getSchemaPrefix() + "counter WHERE trial=?");
        preparedStatement.setInt(1, n);
        preparedStatement.execute();
        ResultSet resultSet = preparedStatement.getResultSet();
        while (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            String string = resultSet.getString(2);
            UserEvent userEvent = dataSource.getUserEvent(string);
            if (userEvent == null) {
                System.out.println("Warning: Event " + string + " not found in data-source.");
            }
            hashMap.put(userEvent, n2);
        }
        preparedStatement.close();
        return hashMap;
    }

    private static void uploadUserEventProfiles(DataSource dataSource, Map<UserEvent, Integer> map, DB dB, Map<Thread, Integer> map2) throws SQLException {
        List<Thread> list = dataSource.getThreads();
        PreparedStatement preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "counter_value (counter, thread, sample_count, maximum_value, minimum_value, mean_value, standard_deviation)" + "VALUES (?, ?, ?, ?, ?, ?, ?)");
        for (Thread thread : list) {
            Iterator<UserEventProfile> iterator = thread.getUserEventProfiles();
            while (iterator.hasNext()) {
                UserEventProfile userEventProfile = iterator.next();
                if (userEventProfile == null) continue;
                UserEvent userEvent = userEventProfile.getUserEvent();
                Integer n = map.get(userEvent);
                if (n == null) {
                    System.out.println("Error: No id mapped for " + userEvent.getName());
                }
                int n2 = n;
                preparedStatement.setInt(1, n2);
                preparedStatement.setInt(2, map2.get(thread));
                preparedStatement.setInt(3, (int)userEventProfile.getNumSamples());
                preparedStatement.setDouble(4, userEventProfile.getMaxValue());
                preparedStatement.setDouble(5, userEventProfile.getMinValue());
                preparedStatement.setDouble(6, userEventProfile.getMeanValue());
                preparedStatement.setDouble(7, userEventProfile.getSumSquared());
                preparedStatement.addBatch();
            }
        }
        preparedStatement.executeBatch();
        preparedStatement.close();
    }

    private static void uploadMetadata(DataSource dataSource, Trial trial, Map<Function, Integer> map, Map<Thread, Integer> map2, DB dB, boolean bl) throws SQLException {
        Object object;
        Object object2;
        int n = trial.getID();
        PreparedStatement preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "primary_metadata (trial, name, value) VALUES (?, ?, ?)");
        for (Object object4 : trial.getMetaData().entrySet()) {
            String object32 = ((MetaDataMap.MetaDataKey)object4.getKey()).name;
            object2 = ((MetaDataMap.MetaDataValue)object4.getValue()).value.toString();
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, object32);
            preparedStatement.setString(3, (String)object2);
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        preparedStatement.close();
        if (!bl) {
            object = new HashMap();
            preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "secondary_metadata (id, trial, thread, timer_callpath, time_range, parent, name, value, is_array) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            for (Thread thread : trial.getDataSource().getThreads()) {
                for (MetaDataMap.MetaDataKey metaDataKey : trial.getUncommonMetaData().keySet()) {
                    MetaDataMap.MetaDataValue metaDataValue = thread.getMetaData().get(metaDataKey);
                    if (metaDataValue == null) continue;
                    int entry = 0;
                    int n2 = 0;
                    if (metaDataKey.timer_context != null) {
                        entry = map.get(dataSource.getFunction(metaDataKey.timer_context));
                        n2 = TAUdbDatabaseAPI.getTimestampID(dB, metaDataKey, (Map<List<Integer>, Integer>)object, preparedStatement);
                    }
                    preparedStatement.setString(1, UUID.randomUUID().toString());
                    preparedStatement.setInt(2, n);
                    preparedStatement.setInt(3, map2.get(thread));
                    if (metaDataKey.timer_context != null) {
                        preparedStatement.setInt(4, entry);
                        preparedStatement.setInt(5, n2);
                        preparedStatement.setNull(6, 4);
                    } else {
                        preparedStatement.setNull(4, 4);
                        preparedStatement.setNull(5, 4);
                        preparedStatement.setNull(6, 4);
                    }
                    preparedStatement.setString(7, metaDataKey.name);
                    preparedStatement.setString(8, metaDataValue.value.toString());
                    preparedStatement.setBoolean(9, false);
                    preparedStatement.addBatch();
                }
            }
            preparedStatement.executeBatch();
            preparedStatement.close();
        }
        if (trial.getDataSource().getMetadataFile() != null) {
            try {
                System.out.print("Parsing metadata file: " + trial.getDataSource().getMetadataFile() + "...");
                object = DataSource.readFileAsString(trial.getDataSource().getMetadataFile());
                if (MetaDataParserJSON.isJSON((String)object)) {
                    Object object4;
                    object4 = new Gson();
                    Object object3 = object4.fromJson((String)object, Object.class);
                    System.out.print("done.\nUploading to database...");
                    if (object3.getClass() == LinkedHashMap.class) {
                        object2 = (LinkedHashMap)object3;
                        preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "primary_metadata (trial, name, value) VALUES (?, ?, ?)");
                        int n3 = 0;
                        for (Map.Entry entry : object2.entrySet()) {
                            n3 = TAUdbDatabaseAPI.processPrimaryElement(preparedStatement, entry, null, n);
                        }
                        System.out.print("Primary Metadata Fields Processed: " + n3);
                        System.out.print(", executing batch... ");
                        preparedStatement.executeBatch();
                        System.out.println("done.");
                        preparedStatement.close();
                        preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "secondary_metadata (id, trial, name, value, parent, is_array) VALUES (?, ?, ?, ?, ?, ?)");
                        for (Map.Entry entry : object2.entrySet()) {
                            n3 = TAUdbDatabaseAPI.processElement(preparedStatement, entry, null, n);
                        }
                        System.out.print("Secondary Metadata Fields Processed: " + n3);
                        if (n3 > 1) {
                            System.out.print(", executing batch... ");
                            preparedStatement.executeBatch();
                            System.out.println("done.");
                        }
                        preparedStatement.close();
                    }
                }
            }
            catch (IOException iOException) {
                System.err.println("Error parsing metadata file.");
                System.err.println(iOException.getMessage());
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                System.err.println("Error parsing JSON metadata file.");
                System.err.println(jsonSyntaxException.getMessage());
            }
        }
    }

    private static int getTimestampID(DB dB, MetaDataMap.MetaDataKey metaDataKey, Map<List<Integer>, Integer> map, PreparedStatement preparedStatement) throws SQLException {
        ArrayList<Long> arrayList = new ArrayList<Long>(2);
        arrayList.set(0, new Long(metaDataKey.call_number));
        arrayList.set(1, new Long(metaDataKey.timestamp));
        Integer n = map.get(arrayList);
        if (n != null) {
            return n;
        }
        try {
            preparedStatement.executeBatch();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        PreparedStatement preparedStatement2 = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "time_range (iteration_start, iteration_end, time_start, time_end) VALUES (?, ?, ?, ?)");
        preparedStatement2.setInt(1, metaDataKey.call_number);
        preparedStatement2.setInt(2, metaDataKey.call_number);
        preparedStatement2.setLong(3, metaDataKey.timestamp);
        preparedStatement2.setLong(4, metaDataKey.timestamp);
        preparedStatement2.execute();
        preparedStatement2.close();
        String string = new String();
        string = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM time_range" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM time_range" : (dB.getDBType().compareTo("sqlite") == 0 ? "select seq from sqlite_sequence where name = 'time_range'" : (dB.getDBType().compareTo("h2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM time_range" : (dB.getDBType().compareTo("oracle") == 0 ? "select " + dB.getSchemaPrefix() + "time_range_id_seq.currval FROM dual" : "select currval('time_range_id_seq');")))));
        n = Integer.parseInt(dB.getDataItem(string));
        return n;
    }

    private static int processElement(PreparedStatement preparedStatement, Map.Entry<String, Object> entry, String string, int n) throws SQLException {
        int n2 = 0;
        String string2 = entry.getKey();
        Object object = entry.getValue();
        String string3 = UUID.randomUUID().toString();
        if (object == null && string == null) {
            preparedStatement.setString(1, string3);
            preparedStatement.setInt(2, n);
            preparedStatement.setString(3, string2);
            preparedStatement.setNull(4, 12);
            preparedStatement.setNull(5, 12);
            preparedStatement.setBoolean(6, false);
            preparedStatement.addBatch();
            ++n2;
        } else if (object == null) {
            preparedStatement.setString(1, string3);
            preparedStatement.setInt(2, n);
            preparedStatement.setString(3, string2);
            preparedStatement.setString(4, string);
            preparedStatement.setNull(5, 12);
            preparedStatement.setBoolean(6, false);
            preparedStatement.addBatch();
            ++n2;
        } else if (object.getClass() == LinkedHashMap.class) {
            preparedStatement.setString(1, string3);
            preparedStatement.setInt(2, n);
            preparedStatement.setString(3, string2);
            preparedStatement.setNull(4, 12);
            if (string == null) {
                preparedStatement.setNull(5, 12);
            } else {
                preparedStatement.setString(5, string);
            }
            preparedStatement.setBoolean(6, false);
            preparedStatement.addBatch();
            ++n2;
            LinkedHashMap linkedHashMap = (LinkedHashMap)object;
            for (Map.Entry<String, Object> entry2 : linkedHashMap.entrySet()) {
                n2 += TAUdbDatabaseAPI.processElement(preparedStatement, entry2, string3, n);
            }
        } else {
            preparedStatement.setString(1, string3);
            preparedStatement.setInt(2, n);
            preparedStatement.setString(3, string2);
            preparedStatement.setString(4, object.toString());
            if (string == null) {
                preparedStatement.setNull(5, 12);
            } else {
                preparedStatement.setString(5, string);
            }
            preparedStatement.setBoolean(6, object.getClass() == ArrayList.class);
            preparedStatement.addBatch();
            ++n2;
        }
        return n2;
    }

    private static int processPrimaryElement(PreparedStatement preparedStatement, Map.Entry<String, Object> entry, String string, int n) throws SQLException {
        int n2 = 0;
        String string2 = entry.getKey();
        Object object = entry.getValue();
        String string3 = UUID.randomUUID().toString();
        if (object == null && string == null) {
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, "false");
            preparedStatement.addBatch();
            ++n2;
        } else if (object != null && object.getClass() != LinkedHashMap.class) {
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, object.toString());
            preparedStatement.addBatch();
            ++n2;
        }
        return n2;
    }

    public void setView(View view) {
        this.view = view;
    }

    public View getView() {
        return this.view;
    }

    public View getView(int n) {
        List<View> list = null;
        if (this.views == null) {
            int n2 = 0;
            if (this.view != null) {
                n2 = this.view.getID();
            }
            list = View.getViews(n2, this.db);
            this.views = new HashMap<Integer, View>();
            for (View view : list) {
                view.setParent(this.view);
                this.views.put(view.getID(), view);
            }
        }
        return this.views.get(n);
    }

    public List<View> getViewList() throws DatabaseException {
        List<View> list = null;
        if (this.views == null) {
            int n = 0;
            if (this.view != null) {
                n = this.view.getID();
            }
            list = View.getViews(n, this.db);
            this.views = new HashMap<Integer, View>();
            for (View view : list) {
                view.setParent(this.view);
                this.views.put(view.getID(), view);
            }
        }
        return new ArrayList<View>(this.views.values());
    }

    @Override
    public List<Trial> getTrialList(boolean bl) {
        if (this.trials == null) {
            ArrayList<View> arrayList = new ArrayList<View>();
            for (View view = this.view; view != null; view = view.getParent()) {
                arrayList.add(view);
            }
            this.trials = new HashMap();
            List<Trial> list = View.getTrialsForTAUdbView(arrayList, this.db);
            if (list != null) {
                for (Trial trial : list) {
                    this.trials.put(trial.getID(), trial);
                }
            }
            return list;
        }
        return new ArrayList<Trial>(this.trials.values());
    }

    public List<String> getPrimaryMetadataNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string = "SELECT DISTINCT name FROM " + this.db.getSchemaPrefix() + "primary_metadata ORDER BY name";
            PreparedStatement preparedStatement = this.db.prepareStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return arrayList;
    }

    @Override
    public synchronized int saveTrial(Trial trial, Metric metric) throws DatabaseException {
        Group group;
        DataSource dataSource = trial.getDataSource();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Group> iterator = dataSource.getGroups();
        while (iterator.hasNext()) {
            group = iterator.next();
            arrayList.add(group.getName());
        }
        this.metrics = trial.getDataSource().getMetrics();
        int n = this.metrics.size();
        this.intervalEvents = new ArrayList();
        this.intervalEventData = new Vector();
        this.atomicEvents = new ArrayList();
        this.atomicEventData = new Vector();
        group = dataSource.getGroup("TAU_CALLPATH_DERIVED");
        this.intervalEvents = dataSource.getFunctions();
        this.atomicEvents = dataSource.getUserEvents();
        this.totalItems = this.intervalEvents.size() + this.intervalEventData.size() + this.atomicEvents.size() + this.atomicEventData.size();
        try {
            this.db.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Saving Trial Failed: couldn't set AutoCommit to false", sQLException);
        }
        int n2 = 0;
        int n3 = -1;
        if (metric != null) {
            n3 = metric.getID();
        }
        try {
            Hashtable<Integer, Integer> hashtable = null;
            if (metric == null) {
                TAUdbDatabaseAPI.uploadTrial(this.db, trial, false);
            } else {
                n2 = trial.getID();
                hashtable = this.saveMetrics(n2, trial, n3);
                HashMap hashMap = new HashMap();
                hashMap.put(trial.getDataSource().getMetrics().get(n3), hashtable.get(n3));
                Object object = TAUdbDatabaseAPI.getCallDataMap(n2, dataSource, null, this.db);
                if (this.db.getDBType().equals("postgresql")) {
                    TAUdbDatabaseAPI.uploadFunctionProfilesPSQL(dataSource, (Map<TimerCallData, Integer>)object, hashMap, this.db);
                } else {
                    TAUdbDatabaseAPI.uploadFunctionProfiles(dataSource, (Map<TimerCallData, Integer>)object, hashMap, this.db);
                    TAUdbDatabaseAPI.uploadStatistics(dataSource, (Map<TimerCallData, Integer>)object, hashMap, this.db);
                }
            }
            for (Object object : hashtable.keySet()) {
                int n4 = hashtable.get(object);
                for (Metric metric2 : trial.getDataSource().getMetrics()) {
                    if (metric2.getID() != ((Integer)object).intValue() || n4 == -1) continue;
                    metric2.setDbMetricID(n4);
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                this.db.rollback();
                sQLException.printStackTrace();
                throw new DatabaseException("Saving Trial Failed, rollbacks successful", sQLException);
            }
            catch (SQLException sQLException2) {
                throw new DatabaseException("Saving Trial Failed, rollbacks failed!", sQLException2);
            }
        }
        try {
            this.db.commit();
            this.db.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Saving Trial Failed: commit failed!", sQLException);
        }
        return n2;
    }

    @Override
    public FunctionProfile getIntervalEventDetail(Function function) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" WHERE tcd.timer_callpath = " + function.getDatabaseID());
        if (this.metrics != null && this.metrics.size() > 0) {
            stringBuffer.append(" AND tv.metric in (");
            Iterator iterator = this.metrics.iterator();
            while (iterator.hasNext()) {
                Metric metric = (Metric)iterator.next();
                stringBuffer.append(metric.getID());
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        return IntervalLocationProfile.getIntervalEventDetail(this.db, function, stringBuffer.toString());
    }

    public static class TimerCallData {
        public Function function = null;
        public Thread thread = null;
        public double timestamp = 0.0;

        public TimerCallData(Function function, Thread thread, double d) {
            this.function = function;
            this.thread = thread;
            this.timestamp = d;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.function == null ? 0 : this.function.hashCode());
            n = 31 * n + (this.thread == null ? 0 : this.thread.hashCode());
            long l = Double.doubleToLongBits(this.timestamp);
            n = 31 * n + (int)(l ^ l >>> 32);
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof TimerCallData)) {
                return false;
            }
            TimerCallData timerCallData = (TimerCallData)object;
            if (this.function == null ? timerCallData.function != null : !this.function.equals(timerCallData.function)) {
                return false;
            }
            if (this.thread == null ? timerCallData.thread != null : !this.thread.equals(timerCallData.thread)) {
                return false;
            }
            return Double.doubleToLongBits(this.timestamp) == Double.doubleToLongBits(timerCallData.timestamp);
        }
    }
}

