/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.PECategoryDataset;
import client.PerfExplorerClient;
import client.PerfExplorerConnection;
import client.PerfExplorerModel;
import client.ScriptFacade;
import common.ChartDataType;
import common.RMIGeneralChartData;
import common.TransformationType;
import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Trial;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;

public class ChartPane
extends JScrollPane
implements ActionListener,
ImageExport {
    private static ChartPane thePane = null;
    private PerfExplorerConnection server = null;
    private JPanel mainPanel = null;
    private ScriptFacade facade = null;
    private static String UPDATE_COMMAND = "UPDATE_COMMAND";
    private JPanel chartPanel = null;
    private JToggleButton mainOnly = new JToggleButton("Main Only");
    private JToggleButton callPath = new JToggleButton("Call Paths");
    private JToggleButton logY = new JToggleButton("Log Y");
    private JToggleButton scalability = new JToggleButton("Scalability");
    private JToggleButton efficiency = new JToggleButton("Efficiency");
    private JToggleButton constantProblem = new JToggleButton("Strong Scaling");
    private JToggleButton horizontal = new JToggleButton("Horizontal");
    private List tableColumns = null;
    private JLabel titleLabel = new JLabel("Chart Title:");
    private JTextField chartTitle = new MyJTextField(5);
    private JLabel seriesLabel = new JLabel("Series Name/Value:");
    private JComboBox series = null;
    private JLabel xaxisNameLabel = new JLabel("X Axis Name:");
    private JTextField xaxisName = new MyJTextField(5);
    private JLabel yaxisNameLabel = new JLabel("Y Axis Name:");
    private JTextField yaxisName = new MyJTextField(5);
    private JLabel xaxisValueLabel = new JLabel("X Axis Value:");
    private JComboBox xaxisValue = null;
    private JLabel yaxisValueLabel = new JLabel("Y Axis Value:");
    private JComboBox yaxisValue = null;
    private JLabel dimensionLabel = new JLabel("Dimension reduction:");
    private JComboBox dimension = new MyJComboBox();
    private JLabel dimensionXLabel = new JLabel("Cutoff (0<x<100):");
    private JTextField dimensionXValue = new MyJTextField(5);
    private JLabel eventLabel = new JLabel("Event:");
    private JComboBox event = new MyJComboBox();
    private JLabel metricLabel = new JLabel("Metric:");
    private JComboBox metric = new MyJComboBox();
    private JLabel unitsLabel = new JLabel("Units:");
    private JComboBox units = new MyJComboBox();
    private JLabel valueLabel = new JLabel("Value:");
    private JComboBox value = new MyJComboBox();
    private JLabel xmlNameLabel = new JLabel("XML Field:");
    private JComboBox xmlName = new MyJComboBox();
    private String[] unitOptions = new String[]{"microseconds", "milliseconds", "seconds", "minutes", "hours", "units", "thousands (x 1.0E3)", "millions (x 1.0E6)", "billions (x 1.0E9)", "trillions (x 1.0E12)"};
    private JButton apply = null;
    private JButton reset = null;
    private static final String INTERVAL_EVENT_NAME = "interval_event.name";
    private static final String MEAN_INCLUSIVE = "mean.inclusive";
    private static final String MEAN_EXCLUSIVE = "mean.exclusive";
    static /* synthetic */ Class class$java$lang$Integer;

    public static ChartPane getPane() {
        if (thePane == null) {
            JPanel jPanel = new JPanel(new BorderLayout());
            thePane = new ChartPane(jPanel);
        }
        thePane.repaint();
        return thePane;
    }

    private ChartPane(JPanel jPanel) {
        super(jPanel);
        this.server = PerfExplorerConnection.getConnection();
        this.mainPanel = jPanel;
        this.facade = new ScriptFacade();
        JScrollBar jScrollBar = this.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
        this.mainPanel.add((Component)this.createTopMenu(), "North");
        this.mainPanel.add((Component)this.createLeftMenu(), "West");
        this.mainPanel.add((Component)this.createChartPanel(), "Center");
        this.resetChartSettings();
    }

    private void resetChartSettings() {
        this.mainOnly.setSelected(true);
        this.callPath.setSelected(false);
        this.logY.setSelected(false);
        this.scalability.setSelected(false);
        this.efficiency.setSelected(false);
        this.constantProblem.setSelected(false);
        this.horizontal.setSelected(false);
        this.dimension.setSelectedIndex(0);
        this.dimensionXLabel.setEnabled(false);
        this.dimensionXValue.setEnabled(false);
        this.eventLabel.setEnabled(false);
        this.event.setEnabled(false);
        this.xmlNameLabel.setEnabled(false);
        this.xmlName.setEnabled(false);
        Iterator iterator = this.tableColumns.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            String string = (String)e;
            if (string.equalsIgnoreCase("experiment.name")) {
                this.series.setSelectedItem(e);
                continue;
            }
            if (!string.equalsIgnoreCase("trial.xml_metadata")) continue;
            this.xaxisValue.setSelectedItem(e);
        }
        this.yaxisValue.setSelectedIndex(0);
        this.refreshDynamicControls(true, true, false);
    }

    public void refreshDynamicControls(boolean bl, boolean bl2, boolean bl3) {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Object object = perfExplorerModel.getCurrentSelection();
        String string = "";
        String string2 = "";
        String string3 = "";
        Object object2 = null;
        if (bl) {
            object2 = this.metric.getSelectedItem();
            if (object2 != null) {
                string = (String)object2;
            }
            this.metric.removeAllItems();
        }
        if (bl2) {
            object2 = this.event.getSelectedItem();
            if (object2 != null) {
                string2 = (String)object2;
            }
            this.event.removeAllItems();
        }
        if (bl3) {
            object2 = this.xmlName.getSelectedItem();
            if (object2 != null) {
                string3 = (String)object2;
            }
            this.xmlName.removeAllItems();
        }
        if (object instanceof Application || object instanceof Experiment || object instanceof Trial) {
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            if (bl) {
                object6 = this.server.getPotentialMetrics(perfExplorerModel);
                boolean bl4 = false;
                object5 = object6.iterator();
                while (object5.hasNext()) {
                    object4 = (String)object5.next();
                    if (((String)object4).toUpperCase().indexOf("TIME") > 0) {
                        bl4 = true;
                    }
                    this.metric.addItem(object4);
                    if (!string.equals(object4)) continue;
                    this.metric.setSelectedItem(object4);
                }
                if (!bl4) {
                    this.metric.addItem("TIME");
                    if (string.equals("TIME")) {
                        this.metric.setSelectedItem("TIME");
                    }
                }
            }
            if (bl2 && !this.mainOnly.isSelected()) {
                object6 = this.series.getSelectedItem();
                String string4 = (String)object6;
                if (string4.equalsIgnoreCase("interval_event.group_name")) {
                    object5 = this.server.getPotentialGroups(perfExplorerModel);
                    this.event.addItem("All Groups");
                    this.eventLabel.setText("Group:");
                    this.event.setSelectedIndex(0);
                    object4 = object5.iterator();
                    while (object4.hasNext()) {
                        object3 = (String)object4.next();
                        this.event.addItem(object3);
                        if (!string2.equals(object3)) continue;
                        this.event.setSelectedItem(object3);
                    }
                } else {
                    this.series.setSelectedItem(INTERVAL_EVENT_NAME);
                    this.yaxisValue.setSelectedItem(MEAN_EXCLUSIVE);
                    object5 = this.server.getPotentialEvents(perfExplorerModel);
                    this.event.addItem("All Events");
                    this.eventLabel.setText("Event:");
                    this.event.setSelectedIndex(0);
                    object4 = object5.iterator();
                    while (object4.hasNext()) {
                        object3 = (String)object4.next();
                        this.event.addItem(object3);
                        if (!string2.equals(object3)) continue;
                        this.event.setSelectedItem(object3);
                    }
                }
            }
            if (bl3) {
                object6 = this.series.getSelectedItem();
                String string5 = (String)object6;
                object5 = this.xaxisValue.getSelectedItem();
                object4 = (String)object5;
                if (string5.equalsIgnoreCase("trial.xml_metadata") || ((String)object4).equalsIgnoreCase("trial.xml_metadata")) {
                    object3 = this.server.getXMLFields(perfExplorerModel);
                    Iterator iterator = object3.iterator();
                    while (iterator.hasNext()) {
                        String string6 = (String)iterator.next();
                        this.xmlName.addItem(string6);
                        if (string3.equals("") && string6.equalsIgnoreCase("UTC Time")) {
                            this.xmlName.setSelectedItem(string6);
                            continue;
                        }
                        if (!string3.equals(string6)) continue;
                        this.xmlName.setSelectedItem(string6);
                    }
                }
            }
        }
    }

    private JPanel createTopMenu() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.mainOnly.setToolTipText("Only select the \"main\" event (i.e. maximum inclusive)");
        this.mainOnly.addActionListener(this);
        jPanel.add(this.mainOnly);
        this.callPath.setToolTipText("Include \"call path\" events (i.e. main() => foo())");
        this.callPath.addActionListener(this);
        jPanel.add(this.callPath);
        this.logY.setToolTipText("Use a Logarithmic Y axis");
        this.logY.addActionListener(this);
        jPanel.add(this.logY);
        this.scalability.setToolTipText("Create a Scalability Chart");
        this.scalability.addActionListener(this);
        jPanel.add(this.scalability);
        this.efficiency.setToolTipText("Create a Relative Efficiency Chart");
        this.efficiency.addActionListener(this);
        jPanel.add(this.efficiency);
        this.constantProblem.setToolTipText("Scaling type (Strong Scaling or Weak Scaling)");
        this.constantProblem.addActionListener(this);
        jPanel.add(this.constantProblem);
        this.horizontal.setToolTipText("Create a horizontal chart");
        this.horizontal.addActionListener(this);
        jPanel.add(this.horizontal);
        return jPanel;
    }

    private JPanel createLeftMenu() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.titleLabel);
        this.chartTitle.addActionListener(this);
        jPanel.add(this.chartTitle);
        this.tableColumns = this.server.getChartFieldNames();
        jPanel.add(this.seriesLabel);
        this.series = new MyJComboBox(this.tableColumns);
        this.series.addItem(INTERVAL_EVENT_NAME);
        this.series.addItem("interval_event.group_name");
        this.series.addActionListener(this);
        jPanel.add(this.series);
        jPanel.add(this.xaxisValueLabel);
        this.xaxisValue = new MyJComboBox(this.tableColumns);
        this.xaxisValue.addActionListener(this);
        this.xaxisValue.addActionListener(this);
        jPanel.add(this.xaxisValue);
        jPanel.add(this.xaxisNameLabel);
        this.xaxisName.addActionListener(this);
        jPanel.add(this.xaxisName);
        jPanel.add(this.yaxisValueLabel);
        Object[] objectArray = new String[]{MEAN_INCLUSIVE, MEAN_EXCLUSIVE, "mean.inclusive_percentage", "mean.exclusive_percentage", "mean.call", "mean.subroutines", "mean.inclusive_per_call", "mean.sum_exclusive_squared", "total.inclusive", "total.exclusive", "total.inclusive_percentage", "total.exclusive_percentage", "total.call", "total.subroutines", "total.inclusive_per_call", "total.sum_exclusive_squared"};
        this.yaxisValue = new MyJComboBox(objectArray);
        this.yaxisValue.addActionListener(this);
        jPanel.add(this.yaxisValue);
        jPanel.add(this.yaxisNameLabel);
        this.yaxisName.addActionListener(this);
        jPanel.add(this.yaxisName);
        jPanel.add(this.dimensionLabel);
        Object[] objectArray2 = TransformationType.getDimensionReductions();
        this.dimension = new MyJComboBox(objectArray2);
        this.dimension.addActionListener(this);
        this.dimension.addActionListener(this);
        jPanel.add(this.dimension);
        jPanel.add(this.dimensionXLabel);
        this.dimensionXValue.addActionListener(this);
        jPanel.add(this.dimensionXValue);
        jPanel.add(this.metricLabel);
        this.metric = new MyJComboBox();
        this.metric.addActionListener(this);
        jPanel.add(this.metric);
        jPanel.add(this.unitsLabel);
        this.units = new MyJComboBox(this.unitOptions);
        this.units.addActionListener(this);
        this.units.setSelectedIndex(2);
        jPanel.add(this.units);
        jPanel.add(this.eventLabel);
        this.event = new MyJComboBox();
        this.event.addActionListener(this);
        jPanel.add(this.event);
        jPanel.add(this.xmlNameLabel);
        this.xmlName = new MyJComboBox();
        this.xmlName.addActionListener(this);
        jPanel.add(this.xmlName);
        this.apply = new JButton("Apply");
        this.apply.setToolTipText("Apply changes and redraw chart");
        this.apply.addActionListener(this);
        jPanel.add(this.apply);
        this.reset = new JButton("Reset");
        this.reset.setToolTipText("Change back to default settings");
        this.reset.addActionListener(this);
        jPanel.add(this.reset);
        return jPanel;
    }

    private JPanel createChartPanel() {
        this.chartPanel = new JPanel(new BorderLayout());
        return this.chartPanel;
    }

    public JPanel getChartPanel() {
        return this.chartPanel;
    }

    private void updateChart() {
        Object object;
        Object object2;
        this.facade.resetChartDefaults();
        String string = this.chartTitle.getText();
        if (string.length() == 0) {
            string = (String)this.metric.getSelectedItem();
        }
        this.facade.setChartTitle(string);
        Object object3 = this.series.getSelectedItem();
        String string2 = (String)object3;
        if (string2.equalsIgnoreCase("trial.threads_of_execution")) {
            string2 = "trial.node_count * trial.contexts_per_node * trial.threads_per_context";
        } else if (string2.equalsIgnoreCase("trial.XML_METADATA")) {
            string2 = "temp_xml_metadata.metadata_value";
            object2 = this.xaxisValue.getSelectedItem();
            object = (String)object2;
            this.facade.setChartMetadataFieldName((String)object);
        }
        this.facade.setChartSeriesName(string2);
        object3 = this.xaxisValue.getSelectedItem();
        string2 = (String)object3;
        object2 = null;
        if (string2.equalsIgnoreCase("trial.threads_of_execution")) {
            string2 = "trial.node_count * trial.contexts_per_node * trial.threads_per_context";
        } else if (string2.equalsIgnoreCase("trial.XML_METADATA")) {
            string2 = "temp_xml_metadata.metadata_value";
            object = this.xmlName.getSelectedItem();
            object2 = (String)object;
            this.facade.setChartMetadataFieldName((String)object2);
            this.facade.setChartMetadataFieldValue(null);
        }
        object = this.xaxisName.getText();
        if (object == null || ((String)object).length() == 0) {
            object = string2.equalsIgnoreCase("temp_xml_metadata.metadata_value") ? object2 : string2;
        }
        this.facade.setChartXAxisName(string2, (String)object);
        object3 = this.yaxisValue.getSelectedItem();
        string2 = (String)object3;
        string2 = string2.replaceAll("mean", "interval_mean_summary");
        string2 = string2.replaceAll("total", "interval_total_summary");
        String string3 = "avg";
        if (!this.mainOnly.isSelected() && ((String)(object2 = (String)(object3 = this.series.getSelectedItem()))).equalsIgnoreCase("interval_event.group_name")) {
            string3 = "sum";
        }
        string2 = string3 + "(" + string2 + ")";
        object = this.yaxisName.getText();
        if (object == null || ((String)object).length() == 0) {
            object = string2.indexOf("mean") >= 0 ? "Mean " + (String)this.metric.getSelectedItem() : (string2.indexOf("total") >= 0 ? "Total " + (String)this.metric.getSelectedItem() : (String)this.metric.getSelectedItem());
        }
        object = (String)object + " - " + (String)this.units.getSelectedItem();
        this.facade.setChartYAxisName(string2, (String)object);
        object3 = this.metric.getSelectedItem();
        string2 = (String)object3;
        if (string2.equals("TIME")) {
            this.facade.setMetricName("%TIME%");
        } else {
            this.facade.setMetricName(string2);
        }
        object3 = this.units.getSelectedItem();
        string2 = (String)object3;
        this.facade.setChartUnits(string2);
        object3 = this.dimension.getSelectedItem();
        TransformationType transformationType = (TransformationType)object3;
        if (transformationType == TransformationType.OVER_X_PERCENT) {
            object = this.dimensionXValue.getText();
            if (object == null || ((String)object).length() == 0) {
                this.facade.setDimensionReduction(TransformationType.NONE, null);
            } else {
                this.facade.setDimensionReduction(TransformationType.OVER_X_PERCENT, (String)object);
            }
        } else {
            this.facade.setDimensionReduction(TransformationType.NONE, null);
        }
        this.facade.setChartMainEventOnly(this.mainOnly.isSelected() ? 1 : 0);
        if (!this.mainOnly.isSelected()) {
            object3 = this.series.getSelectedItem();
            string2 = (String)object3;
            this.facade.setEventName(null);
            this.facade.setGroupName(null);
            if (string2.equalsIgnoreCase(INTERVAL_EVENT_NAME)) {
                object3 = this.event.getSelectedItem();
                string2 = (String)object3;
                if (!string2.equals("All Events")) {
                    this.facade.setEventName(string2);
                } else {
                    this.facade.setEventName(null);
                }
            } else if (string2.equalsIgnoreCase("interval_event.group_name")) {
                object3 = this.event.getSelectedItem();
                string2 = (String)object3;
                if (!string2.equals("All Groups")) {
                    this.facade.setGroupName(string2);
                } else {
                    this.facade.setGroupName(null);
                }
            }
        }
        this.facade.setChartEventNoCallPath(this.callPath.isSelected() ? 0 : 1);
        this.facade.setChartLogYAxis(this.logY.isSelected() ? 1 : 0);
        this.facade.setChartScalability(this.scalability.isSelected() ? 1 : 0);
        this.facade.setChartEfficiency(this.efficiency.isSelected() ? 1 : 0);
        this.facade.setChartConstantProblem(this.constantProblem.isSelected() ? 1 : 0);
        this.facade.setChartHorizontal(this.horizontal.isSelected() ? 1 : 0);
        this.chartPanel.setVisible(false);
        this.chartPanel.removeAll();
        this.chartPanel.add((Component)new ChartPanel(this.doGeneralChart()), "Center");
        this.repaint();
        this.chartPanel.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.apply) {
            PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
            Object object2 = perfExplorerModel.getCurrentSelection();
            if (object2 instanceof Application || object2 instanceof Experiment || object2 instanceof Trial) {
                this.updateChart();
            } else {
                JOptionPane.showMessageDialog(PerfExplorerClient.getMainFrame(), "Please select one or more Applications, Experiments or Trials.", "Selection Error", 0);
            }
        } else if (object == this.reset) {
            this.resetChartSettings();
        } else if (object == this.scalability) {
            if (this.scalability.isSelected()) {
                this.efficiency.setSelected(false);
            }
        } else if (object == this.efficiency) {
            if (this.efficiency.isSelected()) {
                this.scalability.setSelected(false);
            }
        } else if (object == this.constantProblem) {
            if (this.constantProblem.isSelected()) {
                this.constantProblem.setText("Weak Scaling");
            } else {
                this.constantProblem.setText("Strong Scaling");
            }
        } else if (object == this.mainOnly) {
            if (this.mainOnly.isSelected()) {
                this.eventLabel.setEnabled(false);
                this.event.setEnabled(false);
            } else {
                this.eventLabel.setEnabled(true);
                this.event.setEnabled(true);
                this.refreshDynamicControls(false, true, false);
            }
        } else if (object == this.dimension) {
            if (this.dimension.getSelectedIndex() == 0) {
                this.dimensionXLabel.setEnabled(false);
                this.dimensionXValue.setEnabled(false);
            } else {
                this.dimensionXLabel.setEnabled(true);
                this.dimensionXValue.setEnabled(true);
            }
        } else if (object == this.series || object == this.xaxisValue) {
            Object object3 = this.series.getSelectedItem();
            String string = (String)object3;
            Object object4 = this.xaxisValue.getSelectedItem();
            String string2 = (String)object4;
            if (string.equalsIgnoreCase("trial.xml_metadata") || string2.equalsIgnoreCase("trial.xml_metadata")) {
                this.xmlNameLabel.setEnabled(true);
                this.xmlName.setEnabled(true);
                this.refreshDynamicControls(false, false, true);
            } else {
                this.xmlNameLabel.setEnabled(false);
                this.xmlName.setEnabled(false);
            }
            if (string.equalsIgnoreCase(INTERVAL_EVENT_NAME) || string.equalsIgnoreCase("interval_event.group_name")) {
                this.refreshDynamicControls(false, true, false);
            }
        }
        this.drawChart();
    }

    public void drawChart() {
    }

    private JFreeChart doGeneralChart() {
        Object object;
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        RMIGeneralChartData rMIGeneralChartData = this.server.requestGeneralChartData(perfExplorerModel, ChartDataType.PARAMETRIC_STUDY_DATA);
        PECategoryDataset pECategoryDataset = new PECategoryDataset();
        String string = perfExplorerModel.getChartUnits();
        if (string == null) {
            string = new String("microseconds");
        }
        double d = 1.0;
        if (string.equals("milliseconds")) {
            d = 1000.0;
        } else if (string.equals("seconds")) {
            d = 1000000.0;
        } else if (string.equals("minutes")) {
            d = 6.0E7;
        } else if (string.equals("hours")) {
            d = 3.6E9;
        } else if (string.equals("units")) {
            d = 1.0;
        } else if (string.equals("thousands (x 1.0E3)")) {
            d = 1000.0;
        } else if (string.equals("millions (x 1.0E6)")) {
            d = 1000000.0;
        } else if (string.equals("billions (x 1.0E9)")) {
            d = 1.0E9;
        } else if (string.equals("billions (x 1.0E12)")) {
            d = 1.0E12;
        }
        if (rMIGeneralChartData.getCategoryType() == (class$java$lang$Integer == null ? (class$java$lang$Integer = ChartPane.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            int n;
            if (perfExplorerModel.getChartScalability()) {
                pECategoryDataset.addValue(1.0, (Comparable)((Object)"Ideal"), (Comparable)new Integer(rMIGeneralChartData.getMinimum()));
                pECategoryDataset.addValue(rMIGeneralChartData.getMaximum() / rMIGeneralChartData.getMinimum(), (Comparable)((Object)"Ideal"), (Comparable)new Integer(rMIGeneralChartData.getMaximum()));
                RMIGeneralChartData.CategoryDataRow categoryDataRow = rMIGeneralChartData.getRowData(0);
                for (int i = 0; i < rMIGeneralChartData.getRows(); ++i) {
                    RMIGeneralChartData.CategoryDataRow categoryDataRow2 = rMIGeneralChartData.getRowData(i);
                    if (!this.shortName(categoryDataRow2.series).equals(this.shortName(categoryDataRow.series))) {
                        categoryDataRow = categoryDataRow2;
                    }
                    if (perfExplorerModel.getConstantProblem().booleanValue()) {
                        double d2 = categoryDataRow.categoryInteger.doubleValue() / categoryDataRow2.categoryInteger.doubleValue();
                        double d3 = categoryDataRow.value / categoryDataRow2.value;
                        pECategoryDataset.addValue(d3 / d2, (Comparable)((Object)this.shortName(categoryDataRow2.series)), (Comparable)categoryDataRow2.categoryInteger);
                        continue;
                    }
                    pECategoryDataset.addValue(categoryDataRow.value / categoryDataRow2.value, (Comparable)((Object)this.shortName(categoryDataRow2.series)), (Comparable)categoryDataRow2.categoryInteger);
                }
                object = pECategoryDataset.getColumnKeys();
                for (n = 0; n < object.size(); ++n) {
                    Integer n2 = (Integer)object.get(n);
                    pECategoryDataset.addValue(n2.doubleValue() / (double)rMIGeneralChartData.getMinimum(), (Comparable)((Object)"Ideal"), (Comparable)n2);
                }
            } else if (perfExplorerModel.getChartEfficiency()) {
                RMIGeneralChartData.CategoryDataRow categoryDataRow = rMIGeneralChartData.getRowData(0);
                for (int i = 0; i < rMIGeneralChartData.getRows(); ++i) {
                    RMIGeneralChartData.CategoryDataRow categoryDataRow3 = rMIGeneralChartData.getRowData(i);
                    if (!this.shortName(categoryDataRow3.series).equals(this.shortName(categoryDataRow.series))) {
                        categoryDataRow = categoryDataRow3;
                    }
                    if (perfExplorerModel.getConstantProblem().booleanValue()) {
                        pECategoryDataset.addValue(categoryDataRow.value / categoryDataRow3.value, (Comparable)((Object)this.shortName(categoryDataRow3.series)), (Comparable)categoryDataRow3.categoryInteger);
                        continue;
                    }
                    pECategoryDataset.addValue(categoryDataRow.value * categoryDataRow.categoryInteger.doubleValue() / (categoryDataRow3.value * categoryDataRow3.categoryInteger.doubleValue()), (Comparable)((Object)this.shortName(categoryDataRow3.series)), (Comparable)categoryDataRow3.categoryInteger);
                }
                object = pECategoryDataset.getColumnKeys();
                for (n = 0; n < object.size(); ++n) {
                    Integer n3 = (Integer)object.get(n);
                    pECategoryDataset.addValue(1.0, (Comparable)((Object)"Ideal"), (Comparable)n3);
                }
            } else {
                for (int i = 0; i < rMIGeneralChartData.getRows(); ++i) {
                    object = rMIGeneralChartData.getRowData(i);
                    pECategoryDataset.addValue(((RMIGeneralChartData.CategoryDataRow)object).value / d, (Comparable)((Object)this.shortName(((RMIGeneralChartData.CategoryDataRow)object).series)), (Comparable)((RMIGeneralChartData.CategoryDataRow)object).categoryInteger);
                }
            }
        } else {
            for (int i = 0; i < rMIGeneralChartData.getRows(); ++i) {
                object = rMIGeneralChartData.getRowData(i);
                pECategoryDataset.addValue(((RMIGeneralChartData.CategoryDataRow)object).value / d, (Comparable)((Object)this.shortName(((RMIGeneralChartData.CategoryDataRow)object).series)), (Comparable)((Object)((RMIGeneralChartData.CategoryDataRow)object).categoryString));
            }
        }
        PlotOrientation plotOrientation = PlotOrientation.VERTICAL;
        if (perfExplorerModel.getChartHorizontal()) {
            plotOrientation = PlotOrientation.HORIZONTAL;
        }
        object = ChartFactory.createLineChart((String)perfExplorerModel.getChartTitle(), (String)perfExplorerModel.getChartXAxisLabel(), (String)perfExplorerModel.getChartYAxisLabel(), (CategoryDataset)pECategoryDataset, (PlotOrientation)plotOrientation, (boolean)true, (boolean)true, (boolean)false);
        StandardLegend standardLegend = (StandardLegend)object.getLegend();
        standardLegend.setDisplaySeriesShapes(true);
        CategoryPlot categoryPlot = (CategoryPlot)object.getPlot();
        LineAndShapeRenderer lineAndShapeRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        lineAndShapeRenderer.setDefaultShapesFilled(true);
        lineAndShapeRenderer.setDrawShapes(true);
        lineAndShapeRenderer.setDrawLines(true);
        lineAndShapeRenderer.setItemLabelsVisible(true);
        if (perfExplorerModel.getChartScalability()) {
            // empty if block
        }
        for (int i = 0; i < rMIGeneralChartData.getRows(); ++i) {
            lineAndShapeRenderer.setSeriesStroke(i, (Stroke)new BasicStroke(2.0f));
        }
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        if (perfExplorerModel.getChartLogYAxis()) {
            LogarithmicAxis logarithmicAxis = new LogarithmicAxis(PerfExplorerModel.getModel().getChartYAxisLabel());
            logarithmicAxis.setAutoRangeIncludesZero(true);
            logarithmicAxis.setAllowNegativesFlag(true);
            logarithmicAxis.setLog10TickLabelsFlag(true);
            categoryPlot.setRangeAxis(0, (ValueAxis)logarithmicAxis);
        }
        return object;
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        return this.getChartPanel().getSize();
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        this.getChartPanel().setDoubleBuffered(false);
        this.getChartPanel().paintAll(graphics2D);
        this.getChartPanel().setDoubleBuffered(true);
    }

    private String shortName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(");
        String string2 = null;
        try {
            string2 = stringTokenizer.nextToken();
            if (string2.length() < string.length()) {
                string2 = string2 + "()";
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = string;
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ChartPanelException
    extends Exception {
        ChartPanelException(String string) {
            super(string);
        }
    }

    private class MyJComboBox
    extends JComboBox {
        public MyJComboBox(Object[] objectArray) {
            super(objectArray);
            this.setPrototypeDisplayValue("WWWWW");
        }

        public MyJComboBox() {
            this.setPrototypeDisplayValue("WWWWW");
        }

        public MyJComboBox(List list) {
            super(list.toArray());
            this.setPrototypeDisplayValue("WWWWW");
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (this.isMinimumSizeSet()) {
                Dimension dimension2 = this.getMinimumSize();
                if (dimension2.width > dimension.width) {
                    dimension.width = dimension2.width;
                }
            }
            return dimension;
        }

        public Dimension getMaximumSize() {
            Dimension dimension = super.getMaximumSize();
            Dimension dimension2 = this.getPreferredSize();
            dimension.height = dimension2.height;
            return dimension;
        }
    }

    private class MyJTextField
    extends JTextField {
        public MyJTextField() {
        }

        public MyJTextField(String string, int n) {
            super(string, n);
        }

        public MyJTextField(int n) {
            super(n);
        }

        public MyJTextField(String string) {
            super(string);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (this.isMinimumSizeSet()) {
                Dimension dimension2 = this.getMinimumSize();
                if (dimension2.width > dimension.width) {
                    dimension.width = dimension2.width;
                }
            }
            return dimension;
        }

        public Dimension getMaximumSize() {
            Dimension dimension = super.getMaximumSize();
            Dimension dimension2 = this.getPreferredSize();
            dimension.height = dimension2.height;
            return dimension;
        }
    }
}

