/*
 * Decompiled with CFR 0.152.
 */
package clustering.weka;

import clustering.DataNormalizer;
import clustering.RawDataInterface;
import clustering.weka.WekaRawData;
import java.util.List;

public class WekaDataNormalizer
implements DataNormalizer {
    private RawDataInterface _normalizedData = null;

    private WekaDataNormalizer() {
    }

    public WekaDataNormalizer(RawDataInterface rawDataInterface) {
        int n = rawDataInterface.numDimensions();
        int n2 = rawDataInterface.numVectors();
        List list = rawDataInterface.getEventNames();
        String string = rawDataInterface.getName();
        double[][] dArray = new double[n][2];
        for (int i = 0; i < n; ++i) {
            dArray[i][0] = rawDataInterface.getValue(0, i);
            dArray[i][1] = rawDataInterface.getValue(0, i);
            for (int j = 0; j < n2; ++j) {
                if (dArray[i][0] > rawDataInterface.getValue(j, i)) {
                    dArray[i][0] = rawDataInterface.getValue(j, i);
                }
                if (!(dArray[i][1] < rawDataInterface.getValue(j, i))) continue;
                dArray[i][1] = rawDataInterface.getValue(j, i);
            }
            dArray[i][1] = dArray[i][1] - dArray[i][0];
        }
        this._normalizedData = new WekaRawData(string, list, n2, n);
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                d = rawDataInterface.getValue(i, j);
                d -= dArray[j][0];
                this._normalizedData.addValue(i, j, d /= dArray[j][1]);
            }
        }
    }

    public RawDataInterface getNormalizedData() {
        return this._normalizedData;
    }
}

