/*
 * Decompiled with CFR 0.152.
 */
package server;

import clustering.AnalysisFactory;
import clustering.RawDataInterface;
import common.PerfExplorerException;
import common.PerfExplorerOutput;
import common.RMIPerfExplorerModel;
import common.TransformationType;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.database.DB;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import server.PerfExplorerServer;

public class DataUtils {
    public static RawDataInterface getRawData(DatabaseAPI databaseAPI, RMIPerfExplorerModel rMIPerfExplorerModel) throws PerfExplorerException {
        Object object;
        PerfExplorerServer perfExplorerServer = PerfExplorerServer.getServer();
        AnalysisFactory analysisFactory = perfExplorerServer.getAnalysisFactory();
        PerfExplorerOutput.print("Getting raw data...");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        RawDataInterface rawDataInterface = null;
        double d = 0.0;
        ArrayList<String> arrayList = null;
        PerfExplorerOutput.print("Getting constants...");
        try {
            ResultSet resultSet;
            object = databaseAPI.db();
            PreparedStatement preparedStatement = null;
            StringBuffer stringBuffer = new StringBuffer();
            if (object.getDBType().compareTo("oracle") == 0) {
                stringBuffer.append("select count(p.excl) ");
            } else {
                stringBuffer.append("select count(p.exclusive) ");
            }
            stringBuffer.append("from interval_event e ");
            stringBuffer.append("left outer join interval_location_profile p ");
            stringBuffer.append("on e.id = p.interval_event ");
            if (rMIPerfExplorerModel.getDimensionReduction().equals(TransformationType.OVER_X_PERCENT)) {
                stringBuffer.append("inner join interval_mean_summary s ");
                stringBuffer.append("on e.id = s.interval_event and s.metric = p.metric ");
                stringBuffer.append("and s.exclusive_percentage > ");
                stringBuffer.append("" + rMIPerfExplorerModel.getXPercent() + "");
            }
            stringBuffer.append("where e.trial = ?");
            stringBuffer.append(" and (e.group_name is null or e.group_name not like '%TAU_CALLPATH%') ");
            if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                stringBuffer.append(" and p.metric = ?");
            }
            preparedStatement = object.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, rMIPerfExplorerModel.getTrial().getID());
            if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                preparedStatement.setInt(2, ((Metric)rMIPerfExplorerModel.getCurrentSelection()).getID());
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.close();
            if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("select e.id, e.name from interval_event e ");
                if (rMIPerfExplorerModel.getDimensionReduction().equals(TransformationType.OVER_X_PERCENT)) {
                    stringBuffer.append("inner join interval_mean_summary s on ");
                    stringBuffer.append("e.id = s.interval_event ");
                    stringBuffer.append("and s.exclusive_percentage > ");
                    stringBuffer.append("" + rMIPerfExplorerModel.getXPercent() + "");
                    stringBuffer.append(" where e.trial = ? ");
                    if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                        stringBuffer.append(" and s.metric = ? ");
                    }
                } else {
                    stringBuffer.append("where e.trial = ?");
                }
                stringBuffer.append(" and (e.group_name is null or e.group_name not like '%TAU_CALLPATH%') ");
                stringBuffer.append(" order by 1");
                preparedStatement = object.prepareStatement(stringBuffer.toString());
                preparedStatement.setInt(1, rMIPerfExplorerModel.getTrial().getID());
                if (rMIPerfExplorerModel.getDimensionReduction().equals(TransformationType.OVER_X_PERCENT) && rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                    preparedStatement.setInt(2, ((Metric)rMIPerfExplorerModel.getCurrentSelection()).getID());
                }
                resultSet = preparedStatement.executeQuery();
                n3 = 0;
                arrayList = new ArrayList();
                while (resultSet.next()) {
                    ++n3;
                    arrayList.add(resultSet.getString(2));
                }
                resultSet.close();
                preparedStatement.close();
            } else {
                stringBuffer = new StringBuffer();
                stringBuffer.append("select m.id, m.name from metric m ");
                stringBuffer.append("where m.trial = ?");
                stringBuffer.append(" order by 1");
                preparedStatement = object.prepareStatement(stringBuffer.toString());
                preparedStatement.setInt(1, rMIPerfExplorerModel.getTrial().getID());
                resultSet = preparedStatement.executeQuery();
                n3 = 0;
                arrayList = new ArrayList<String>();
                while (resultSet.next()) {
                    ++n3;
                    arrayList.add(resultSet.getString(2));
                }
                resultSet.close();
                preparedStatement.close();
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append("select max(node), max(context), max(thread) ");
            stringBuffer.append("from interval_location_profile ");
            stringBuffer.append("inner join interval_event ");
            stringBuffer.append("on interval_event.id = interval_event where trial = ? ");
            if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                stringBuffer.append(" and metric = ? ");
            }
            preparedStatement = object.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, rMIPerfExplorerModel.getTrial().getID());
            if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                preparedStatement.setInt(2, ((Metric)rMIPerfExplorerModel.getCurrentSelection()).getID());
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                n4 = resultSet.getInt(1) + 1;
                n5 = resultSet.getInt(2) + 1;
                n6 = resultSet.getInt(3) + 1;
                n2 = n4 * n5 * n6;
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            String string = "ERROR: Couldn't the constant settings from the database!";
            System.err.println(string);
            System.err.println(sQLException.getMessage());
            sQLException.printStackTrace();
            throw new PerfExplorerException(string, sQLException);
        }
        rawDataInterface = analysisFactory.createRawData("Cluster Test", arrayList, n2, n3);
        object = null;
        int n7 = 0;
        int n8 = -1;
        int n9 = 0;
        int n10 = 0;
        d = 0.0;
        try {
            int n11;
            DB dB = databaseAPI.db();
            PreparedStatement preparedStatement = null;
            StringBuffer stringBuffer = new StringBuffer();
            if (rMIPerfExplorerModel.getDimensionReduction().equals(TransformationType.OVER_X_PERCENT)) {
                stringBuffer.append("select e.id, (p.node*");
                stringBuffer.append(n5 * n6);
                stringBuffer.append(") + (p.context*");
                stringBuffer.append(n6);
                if (dB.getDBType().compareTo("oracle") == 0) {
                    stringBuffer.append(") + p.thread as thread, p.metric as metric, p.excl/1000000, ");
                } else {
                    stringBuffer.append(") + p.thread as thread, p.metric as metric, p.exclusive/1000000, ");
                }
                stringBuffer.append("p.inclusive/1000000, s.inclusive_percentage, s.exclusive_percentage ");
                stringBuffer.append("from interval_event e ");
                stringBuffer.append("inner join interval_mean_summary s ");
                stringBuffer.append("on e.id = s.interval_event and (s.exclusive_percentage > ");
                stringBuffer.append(rMIPerfExplorerModel.getXPercent());
                stringBuffer.append("or s.inclusive_percentage = 100.0) ");
                stringBuffer.append(" left outer join interval_location_profile p ");
                stringBuffer.append("on e.id = p.interval_event ");
                stringBuffer.append("and p.metric = s.metric where e.trial = ? ");
            } else {
                stringBuffer.append("select e.id, (p.node*" + n5 * n6 + "");
                stringBuffer.append(") + (p.context*" + n6 + "");
                if (dB.getDBType().compareTo("oracle") == 0) {
                    stringBuffer.append(") + p.thread as thread, p.metric as metric, p.excl, ");
                } else {
                    stringBuffer.append(") + p.thread as thread, p.metric as metric, p.exclusive, ");
                }
                stringBuffer.append("p.inclusive/1000000, p.inclusive_percentage ");
                stringBuffer.append("from interval_event e ");
                stringBuffer.append("left outer join interval_location_profile p ");
                stringBuffer.append("on e.id = p.interval_event where e.trial = ? ");
            }
            if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                stringBuffer.append(" and p.metric = ? ");
            }
            stringBuffer.append(" and (e.group_name is null or e.group_name not like '%TAU_CALLPATH%') ");
            stringBuffer.append(" order by 3,1,2 ");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, rMIPerfExplorerModel.getTrial().getID());
            if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                preparedStatement.setInt(2, ((Metric)rMIPerfExplorerModel.getCurrentSelection()).getID());
            }
            object = preparedStatement.executeQuery();
            int n12 = n11 = rMIPerfExplorerModel.getCurrentSelection() instanceof Metric ? 1 : 3;
            while (object.next()) {
                if (!rMIPerfExplorerModel.getDimensionReduction().equals(TransformationType.OVER_X_PERCENT) || object.getDouble(7) > rMIPerfExplorerModel.getXPercent()) {
                    if (n7 != object.getInt(n11)) {
                        ++n8;
                    }
                    n7 = object.getInt(n11);
                    n10 = object.getInt(2);
                    rawDataInterface.addValue(n10, n8, object.getDouble(4));
                    if (d < object.getDouble(4)) {
                        d = object.getDouble(4);
                    }
                }
                if (object.getDouble(6) == 100.0) {
                    rawDataInterface.addMainValue(n10, n8, object.getDouble(5));
                }
                ++n9;
            }
            object.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            String string = "ERROR: Couldn't the raw data from the database!";
            System.err.println(string);
            System.err.println(sQLException.getMessage());
            sQLException.printStackTrace();
            throw new PerfExplorerException(string, sQLException);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println(arrayIndexOutOfBoundsException.getMessage());
            arrayIndexOutOfBoundsException.printStackTrace();
            PerfExplorerOutput.println("\ncurrentFunction: " + n7);
            PerfExplorerOutput.println("functionIndex: " + n8);
            PerfExplorerOutput.println("rowIndex: " + n9);
            PerfExplorerOutput.println("threadIndex: " + n10);
            System.exit(1);
        }
        PerfExplorerOutput.println(" Done!");
        return rawDataInterface;
    }
}

