/*
 * Decompiled with CFR 0.152.
 */
package server;

import clustering.DataNormalizer;
import clustering.RawDataInterface;
import common.ChartType;
import common.RMIPerfExplorerModel;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DefaultXYItemRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.function.Function2D;
import org.jfree.data.function.LineFunction2D;
import org.jfree.data.function.PowerFunction2D;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.statistics.Regression;
import org.jfree.data.xy.XYDataset;
import server.PCAPlotDataset;
import server.PerfExplorerServer;
import server.ScatterPlotDataset;

public class ImageUtils {
    public static File generateBreakdownThumbnail(RMIPerfExplorerModel rMIPerfExplorerModel, RawDataInterface rawDataInterface, RawDataInterface rawDataInterface2, List list) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < rawDataInterface.numVectors(); ++i) {
            for (int j = 0; j < rawDataInterface.numDimensions(); ++j) {
                defaultCategoryDataset.addValue(rawDataInterface.getValue(i, j), (Comparable)((Object)((String)list.get(j))), (Comparable)((Object)new String(Integer.toString(i))));
            }
        }
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart(null, null, null, (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)true, (boolean)false);
        File file = new File("/tmp/thumbnail." + rMIPerfExplorerModel.toShortString() + ".png");
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)100, (int)100);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        return file;
    }

    public static File generateBreakdownImage(ChartType chartType, RMIPerfExplorerModel rMIPerfExplorerModel, RawDataInterface rawDataInterface, RawDataInterface rawDataInterface2, List list) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < rawDataInterface.numVectors(); ++i) {
            for (int j = 0; j < rawDataInterface.numDimensions(); ++j) {
                defaultCategoryDataset.addValue(rawDataInterface.getValue(i, j), (Comparable)((Object)((String)list.get(j))), (Comparable)((Object)new String(Integer.toString(i))));
            }
        }
        String string = rMIPerfExplorerModel.toString();
        if (chartType == ChartType.CLUSTER_AVERAGES) {
            string = string + " Average Values";
        }
        if (chartType == ChartType.CLUSTER_MAXIMUMS) {
            string = string + " Maximum Values";
        }
        if (chartType == ChartType.CLUSTER_MINIMUMS) {
            string = string + " Minimum Values";
        }
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart((String)string, (String)"Cluster Number", (String)"Total Runtime", (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        File file = new File("/tmp/image." + rMIPerfExplorerModel.toShortString() + ".png");
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)500, (int)500);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        return file;
    }

    public static File generateClusterSizeThumbnail(RMIPerfExplorerModel rMIPerfExplorerModel, int[] nArray, List list) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < nArray.length; ++i) {
            defaultCategoryDataset.addValue((double)nArray[i], (Comparable)((Object)"Threads in cluster"), (Comparable)((Object)new String(Integer.toString(i))));
        }
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart(null, null, null, (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)true, (boolean)false);
        File file = new File("/tmp/thumbnail." + rMIPerfExplorerModel.toShortString() + ".png");
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)100, (int)100);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        return file;
    }

    public static File generateClusterSizeImage(RMIPerfExplorerModel rMIPerfExplorerModel, int[] nArray, List list) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < nArray.length; ++i) {
            defaultCategoryDataset.addValue((double)nArray[i], (Comparable)((Object)"Threads in cluster"), (Comparable)((Object)new String(Integer.toString(i))));
        }
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart((String)rMIPerfExplorerModel.toString(), (String)"Cluster Number", (String)"Threads in cluster", (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        File file = new File("/tmp/image." + rMIPerfExplorerModel.toShortString() + ".png");
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)500, (int)500);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        return file;
    }

    public static File generateClusterScatterplotThumbnail(ChartType chartType, RMIPerfExplorerModel rMIPerfExplorerModel, RawDataInterface[] rawDataInterfaceArray) {
        File file = null;
        if (chartType == ChartType.PCA_SCATTERPLOT) {
            PCAPlotDataset pCAPlotDataset = new PCAPlotDataset(rawDataInterfaceArray);
            JFreeChart jFreeChart = ChartFactory.createScatterPlot(null, null, null, (XYDataset)pCAPlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            file = new File("/tmp/thumbnail." + rMIPerfExplorerModel.toShortString() + ".png");
            try {
                ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)100, (int)100);
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static File generateClusterScatterplotImage(ChartType chartType, RMIPerfExplorerModel rMIPerfExplorerModel, RawDataInterface rawDataInterface, RawDataInterface[] rawDataInterfaceArray) {
        File file = null;
        if (chartType == ChartType.PCA_SCATTERPLOT) {
            PCAPlotDataset pCAPlotDataset = new PCAPlotDataset(rawDataInterfaceArray);
            JFreeChart jFreeChart = ChartFactory.createScatterPlot((String)"Correlation Results", (String)((String)rawDataInterface.getEventNames().get(0)), (String)((String)rawDataInterface.getEventNames().get(1)), (XYDataset)pCAPlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            file = new File("/tmp/image." + rMIPerfExplorerModel.toShortString() + ".png");
            try {
                ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)500, (int)500);
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static File generateCorrelationScatterplotThumbnail(ChartType chartType, RMIPerfExplorerModel rMIPerfExplorerModel, RawDataInterface rawDataInterface, int n, int n2, boolean bl) {
        File file = null;
        if (chartType == ChartType.CORRELATION_SCATTERPLOT) {
            DataNormalizer dataNormalizer = PerfExplorerServer.getServer().getAnalysisFactory().createDataNormalizer(rawDataInterface);
            RawDataInterface rawDataInterface2 = dataNormalizer.getNormalizedData();
            ScatterPlotDataset scatterPlotDataset = new ScatterPlotDataset(rawDataInterface2, rMIPerfExplorerModel.toString(), n, n2, bl);
            JFreeChart jFreeChart = ChartFactory.createScatterPlot(null, null, null, (XYDataset)scatterPlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            file = new File("/tmp/thumbnail." + rMIPerfExplorerModel.toShortString() + ".png");
            try {
                ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)100, (int)100);
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static File generateCorrelationScatterplotImage(ChartType chartType, RMIPerfExplorerModel rMIPerfExplorerModel, RawDataInterface rawDataInterface, int n, int n2, boolean bl, double d) {
        File file = null;
        if (chartType == ChartType.CORRELATION_SCATTERPLOT) {
            DataNormalizer dataNormalizer = PerfExplorerServer.getServer().getAnalysisFactory().createDataNormalizer(rawDataInterface);
            RawDataInterface rawDataInterface2 = dataNormalizer.getNormalizedData();
            ScatterPlotDataset scatterPlotDataset = new ScatterPlotDataset(rawDataInterface2, rMIPerfExplorerModel.toString(), n, n2, bl);
            NumberAxis numberAxis = new NumberAxis((String)rawDataInterface2.getEventNames().get(n));
            numberAxis.setAutoRangeIncludesZero(false);
            NumberAxis numberAxis2 = null;
            numberAxis2 = bl ? new NumberAxis(rawDataInterface2.getMainEventName()) : new NumberAxis((String)rawDataInterface2.getEventNames().get(n2));
            numberAxis2.setAutoRangeIncludesZero(false);
            StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(1);
            standardXYItemRenderer.setShapesFilled(true);
            if (bl) {
                standardXYItemRenderer.setSeriesPaint(0, (Paint)Color.green);
            }
            XYPlot xYPlot = new XYPlot((XYDataset)scatterPlotDataset, (ValueAxis)numberAxis, (ValueAxis)numberAxis2, (XYItemRenderer)standardXYItemRenderer);
            double[] dArray = Regression.getOLSRegression((XYDataset)scatterPlotDataset, (int)0);
            LineFunction2D lineFunction2D = new LineFunction2D(dArray[0], dArray[1]);
            Range range = DatasetUtilities.findDomainExtent((XYDataset)scatterPlotDataset);
            XYDataset xYDataset = DatasetUtilities.sampleFunction2D((Function2D)lineFunction2D, (double)range.getLowerBound(), (double)range.getUpperBound(), (int)100, (String)"Fitted Linear Regression Line");
            xYPlot.setDataset(1, xYDataset);
            DefaultXYItemRenderer defaultXYItemRenderer = new DefaultXYItemRenderer();
            defaultXYItemRenderer.setSeriesPaint(0, (Paint)Color.blue);
            xYPlot.setRenderer(1, (XYItemRenderer)defaultXYItemRenderer);
            double[] dArray2 = Regression.getPowerRegression((XYDataset)scatterPlotDataset, (int)0);
            PowerFunction2D powerFunction2D = new PowerFunction2D(dArray2[0], dArray2[1]);
            XYDataset xYDataset2 = DatasetUtilities.sampleFunction2D((Function2D)powerFunction2D, (double)range.getLowerBound(), (double)range.getUpperBound(), (int)100, (String)"Fitted Power Regression Line");
            xYPlot.setDataset(2, xYDataset2);
            DefaultXYItemRenderer defaultXYItemRenderer2 = new DefaultXYItemRenderer();
            defaultXYItemRenderer2.setSeriesPaint(0, (Paint)Color.black);
            xYPlot.setRenderer(2, (XYItemRenderer)defaultXYItemRenderer2);
            xYPlot.getDomainAxis().setRange(range);
            xYPlot.getRangeAxis().setRange(range);
            JFreeChart jFreeChart = new JFreeChart("Correlation Results: r = " + d, JFreeChart.DEFAULT_TITLE_FONT, (Plot)xYPlot, true);
            file = new File("/tmp/image." + rMIPerfExplorerModel.toShortString() + ".png");
            try {
                ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)500, (int)500);
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        return file;
    }
}

