/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.paraprof.ColorBar;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.GlobalDataWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.enums.CallGraphOption;
import edu.uoregon.tau.paraprof.graph.Layout;
import edu.uoregon.tau.paraprof.graph.Vertex;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.perfdmf.CallPathUtilFuncs;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.MutableTreeNode;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultGraphSelectionModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.Port;

public class CallGraphWindow
extends JFrame
implements ActionListener,
KeyListener,
MouseWheelListener,
ChangeListener,
Observer,
ImageExport,
Printable,
ParaProfWindow {
    private static final long serialVersionUID = -8532506804592254096L;
    private static final int MARGIN = 20;
    private static final int VERTICAL_SPACING = 120;
    private ParaProfTrial ppTrial;
    private Thread thread;
    private JMenu optionsMenu;
    private JCheckBoxMenuItem slidersCheckBox;
    private Graph graph;
    private JScrollPane jGraphPane;
    private CallGraphOption widthOption = CallGraphOption.INCLUSIVE;
    private CallGraphOption colorOption = CallGraphOption.EXCLUSIVE;
    private int boxWidth = 120;
    private JLabel boxWidthLabel = new JLabel("Box width");
    private JSlider boxWidthSlider = new JSlider(0, 500, this.boxWidth);
    private List<FunctionProfile> functionProfileList;
    private DefaultGraphModel model;
    private List<GraphCell> graphCellList;
    private Object[] cells;
    private List<List<Vertex>> levels;
    private List<Vertex.BackEdge> backEdges;
    private Map<FunctionProfile, Vertex> vertexMap;
    private Metric widthMetric;
    private Metric colorMetric;
    private Font font;
    private int boxHeight;
    private double scale = 1.0;
    private DataSorter dataSorter;
    private GlobalDataWindow window;

    public CallGraphWindow(ParaProfTrial paraProfTrial, Thread thread, Component component) {
        this.ppTrial = paraProfTrial;
        paraProfTrial.addObserver(this);
        this.colorMetric = paraProfTrial.getDefaultMetric();
        this.widthMetric = paraProfTrial.getDefaultMetric();
        this.window = paraProfTrial.getFullDataWindow();
        this.dataSorter = new DataSorter(paraProfTrial);
        this.thread = thread;
        if (paraProfTrial.callPathDataPresent()) {
            CallPathUtilFuncs.buildThreadRelations((DataSource)paraProfTrial.getDataSource(), (Thread)thread);
        }
        this.functionProfileList = thread.getFunctionProfiles();
        if (thread.getNodeID() == -1 || thread.getNodeID() == -6) {
            this.setTitle("TAU: ParaProf: Mean Call Graph - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else if (thread.getNodeID() == -3 || thread.getNodeID() == -7) {
            this.setTitle("TAU: ParaProf: Standard Deviation Call Graph - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else {
            this.setTitle("TAU: ParaProf: Call Graph for n,c,t, " + thread.getNodeID() + "," + thread.getContextID() + "," + thread.getThreadID() + " - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        }
        ParaProfUtils.setFrameIcon(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CallGraphWindow.this.thisWindowClosing(windowEvent);
            }
        });
        if (ParaProf.getHelpWindow().isVisible()) {
            this.help(false);
        }
        this.setupMenus();
        this.boxWidthSlider.setPaintTicks(true);
        this.boxWidthSlider.setMajorTickSpacing(50);
        this.boxWidthSlider.setMinorTickSpacing(10);
        this.boxWidthSlider.setPaintLabels(true);
        this.boxWidthSlider.setSnapToTicks(false);
        this.boxWidthSlider.addChangeListener(this);
        this.boxWidthSlider.addKeyListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.font = ParaProf.preferencesWindow.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        this.boxHeight = fontMetrics.getHeight() + 5;
        ColorBar colorBar = new ColorBar();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(colorBar, gridBagConstraints, 0, 0, 2, 1);
        this.createGraph();
        Dimension dimension = this.jGraphPane.getPreferredSize();
        dimension.width += 25;
        dimension.height += 95;
        if (dimension.width > 1000) {
            dimension.width = 1000;
        }
        if (dimension.height > 1000) {
            dimension.height = 1000;
        }
        this.setSize(ParaProfUtils.checkSize(dimension));
        this.setLocation(WindowPlacer.getNewLocation(this, component));
        this.setVisible(true);
        ParaProf.incrementNumWindows();
    }

    private Component createWidthMetricMenu(final CallGraphOption callGraphOption, boolean bl, ButtonGroup buttonGroup) {
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        if (this.ppTrial.getNumberOfMetrics() == 1) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(callGraphOption.toString(), bl);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CallGraphWindow.this.widthOption = callGraphOption;
                    CallGraphWindow.this.recreateGraph();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            return jRadioButtonMenuItem;
        }
        JMenu jMenu = new JMenu(callGraphOption.toString() + "...");
        for (Metric metric : this.ppTrial.getMetrics()) {
            jRadioButtonMenuItem = metric == this.widthMetric && bl ? new JRadioButtonMenuItem(metric.getName(), true) : new JRadioButtonMenuItem(metric.getName());
            final Metric metric2 = metric;
            jRadioButtonMenuItem.addActionListener(new ActionListener(){
                final Metric metric;
                {
                    this.metric = metric2;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CallGraphWindow.this.widthOption = callGraphOption;
                    CallGraphWindow.this.widthMetric = this.metric;
                    CallGraphWindow.this.recreateGraph();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
        }
        return jMenu;
    }

    private Component createColorMetricMenu(final CallGraphOption callGraphOption, boolean bl, ButtonGroup buttonGroup) {
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        if (this.ppTrial.getNumberOfMetrics() == 1) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(callGraphOption.toString(), bl);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CallGraphWindow.this.colorOption = callGraphOption;
                    CallGraphWindow.this.recreateGraph();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            return jRadioButtonMenuItem;
        }
        JMenu jMenu = new JMenu(callGraphOption.toString() + "...");
        for (Metric metric : this.ppTrial.getMetrics()) {
            jRadioButtonMenuItem = metric == this.widthMetric && bl ? new JRadioButtonMenuItem(metric.getName(), true) : new JRadioButtonMenuItem(metric.getName());
            final Metric metric2 = metric;
            jRadioButtonMenuItem.addActionListener(new ActionListener(){
                final Metric metric;
                {
                    this.metric = metric2;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CallGraphWindow.this.colorOption = callGraphOption;
                    CallGraphWindow.this.colorMetric = this.metric;
                    CallGraphWindow.this.recreateGraph();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
        }
        return jMenu;
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = null;
        this.optionsMenu = new JMenu("Options");
        ButtonGroup buttonGroup = null;
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        this.slidersCheckBox = new JCheckBoxMenuItem("Show Width Slider", false);
        this.slidersCheckBox.addActionListener(this);
        this.optionsMenu.add(this.slidersCheckBox);
        jMenu = new JMenu("Box width by...");
        buttonGroup = new ButtonGroup();
        jMenu.add(this.createWidthMetricMenu(CallGraphOption.EXCLUSIVE, CallGraphOption.EXCLUSIVE == this.widthOption, buttonGroup));
        jMenu.add(this.createWidthMetricMenu(CallGraphOption.INCLUSIVE, CallGraphOption.INCLUSIVE == this.widthOption, buttonGroup));
        jMenu.add(this.createWidthMetricMenu(CallGraphOption.EXCLUSIVE_PER_CALL, CallGraphOption.EXCLUSIVE_PER_CALL == this.widthOption, buttonGroup));
        jMenu.add(this.createWidthMetricMenu(CallGraphOption.INCLUSIVE_PER_CALL, CallGraphOption.INCLUSIVE_PER_CALL == this.widthOption, buttonGroup));
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", CallGraphOption.NUMCALLS == this.widthOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.widthOption = CallGraphOption.NUMCALLS;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Child Calls", CallGraphOption.NUMSUBR == this.widthOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.widthOption = CallGraphOption.NUMSUBR;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Static", CallGraphOption.STATIC == this.widthOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.widthOption = CallGraphOption.STATIC;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Name Length", CallGraphOption.NAME_LENGTH == this.widthOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.widthOption = CallGraphOption.NAME_LENGTH;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        this.optionsMenu.add(jMenu);
        jMenu = new JMenu("Box color by...");
        buttonGroup = new ButtonGroup();
        jMenu.add(this.createColorMetricMenu(CallGraphOption.EXCLUSIVE, CallGraphOption.EXCLUSIVE == this.colorOption, buttonGroup));
        jMenu.add(this.createColorMetricMenu(CallGraphOption.INCLUSIVE, CallGraphOption.INCLUSIVE == this.colorOption, buttonGroup));
        jMenu.add(this.createColorMetricMenu(CallGraphOption.EXCLUSIVE_PER_CALL, CallGraphOption.EXCLUSIVE_PER_CALL == this.colorOption, buttonGroup));
        jMenu.add(this.createColorMetricMenu(CallGraphOption.INCLUSIVE_PER_CALL, CallGraphOption.INCLUSIVE_PER_CALL == this.colorOption, buttonGroup));
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", CallGraphOption.NUMCALLS == this.colorOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.colorOption = CallGraphOption.NUMCALLS;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Child Calls", CallGraphOption.NUMSUBR == this.colorOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.colorOption = CallGraphOption.NUMSUBR;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Static", CallGraphOption.STATIC == this.colorOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.colorOption = CallGraphOption.STATIC;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        this.optionsMenu.add(jMenu);
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this, this));
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    private double getMaxValue(CallGraphOption callGraphOption, Metric metric) {
        return this.getMaxValue(callGraphOption, metric.getID());
    }

    private double getMaxValue(CallGraphOption callGraphOption, int n) {
        double d = 1.0;
        int n2 = this.ppTrial.getSelectedSnapshot();
        if (n2 == -1) {
            n2 = this.thread.getNumSnapshots() - 1;
        }
        if (callGraphOption == CallGraphOption.EXCLUSIVE) {
            d = this.thread.getMaxExclusive(n, n2);
        } else if (callGraphOption == CallGraphOption.INCLUSIVE) {
            d = this.thread.getMaxInclusive(n, n2);
        } else if (callGraphOption == CallGraphOption.NUMCALLS) {
            d = this.thread.getMaxNumCalls(n2);
        } else if (callGraphOption == CallGraphOption.NUMSUBR) {
            d = this.thread.getMaxNumSubr(n2);
        } else if (callGraphOption == CallGraphOption.INCLUSIVE_PER_CALL) {
            d = this.thread.getMaxInclusivePerCall(n, n2);
        } else if (callGraphOption == CallGraphOption.EXCLUSIVE_PER_CALL) {
            d = this.thread.getMaxExclusivePerCall(n, n2);
        } else if (callGraphOption == CallGraphOption.STATIC) {
            d = 1.0;
        } else if (this.widthOption == CallGraphOption.NAME_LENGTH) {
            d = 1.0;
        } else {
            throw new ParaProfException("Unexpected CallGraphOption : " + callGraphOption);
        }
        return d;
    }

    private double getValue(FunctionProfile functionProfile, CallGraphOption callGraphOption, double d, Metric metric) {
        return this.getValue(functionProfile, callGraphOption, d, metric.getID());
    }

    private double getValue(FunctionProfile functionProfile, CallGraphOption callGraphOption, double d, int n) {
        int n2 = this.ppTrial.getSelectedSnapshot();
        double d2 = 1.0;
        if (callGraphOption == CallGraphOption.STATIC) {
            d2 = 1.0;
        } else if (callGraphOption == CallGraphOption.EXCLUSIVE) {
            d2 = functionProfile.getExclusive(n2, n) / d;
        } else if (callGraphOption == CallGraphOption.INCLUSIVE) {
            d2 = functionProfile.getInclusive(n2, n) / d;
        } else if (callGraphOption == CallGraphOption.NUMCALLS) {
            d2 = functionProfile.getNumCalls(n2) / d;
        } else if (callGraphOption == CallGraphOption.NUMSUBR) {
            d2 = functionProfile.getNumSubr(n2) / d;
        } else if (callGraphOption == CallGraphOption.INCLUSIVE_PER_CALL) {
            d2 = functionProfile.getInclusivePerCall(n2, n) / d;
        } else if (callGraphOption == CallGraphOption.EXCLUSIVE_PER_CALL) {
            d2 = functionProfile.getExclusivePerCall(n2, n) / d;
        } else if (callGraphOption == CallGraphOption.STATIC) {
            d2 = 1.0;
        } else {
            throw new ParaProfException("Unexpected CallGraphOption : " + callGraphOption);
        }
        return d2;
    }

    private int getWidth(FunctionProfile functionProfile, double d) {
        int n = 0;
        if (this.widthOption == CallGraphOption.NAME_LENGTH) {
            FontMetrics fontMetrics = this.getFontMetrics(this.font);
            n = fontMetrics.stringWidth(functionProfile.getName()) + 5;
        } else {
            n = (int)((double)this.boxWidth * this.getValue(functionProfile, this.widthOption, d, this.widthMetric));
        }
        return n;
    }

    private List<List<Vertex>> constructGraph() {
        int n;
        Object object;
        Vertex vertex;
        Object object2;
        this.vertexMap = new HashMap<FunctionProfile, Vertex>();
        this.backEdges = new ArrayList<Vertex.BackEdge>();
        double d = this.getMaxValue(this.widthOption, this.widthMetric);
        double d2 = this.getMaxValue(this.colorOption, this.colorMetric);
        for (int i = 0; i < this.functionProfileList.size(); ++i) {
            object2 = this.functionProfileList.get(i);
            if (object2 == null || object2.isCallPathFunction()) continue;
            Vertex vertex2 = new Vertex(object2, this.getWidth((FunctionProfile)object2, d), this.boxHeight);
            vertex2.setColorRatio((float)this.getValue((FunctionProfile)object2, this.colorOption, d2, this.colorMetric));
            this.vertexMap.put((FunctionProfile)object2, vertex2);
        }
        Stack<FunctionProfile> stack = new Stack<FunctionProfile>();
        object2 = new Stack();
        for (int i = 0; i < this.functionProfileList.size(); ++i) {
            Object object3;
            FunctionProfile functionProfile = this.functionProfileList.get(i);
            if (functionProfile == null || functionProfile.isCallPathFunction() || (vertex = this.vertexMap.get(functionProfile)).getVisited()) continue;
            ((Vector)object2).add(functionProfile);
            stack.add(null);
            object = functionProfile.getChildProfiles();
            while (object.hasNext()) {
                object3 = (FunctionProfile)object.next();
                stack.add((FunctionProfile)object3);
            }
            while (!stack.empty()) {
                int n2;
                object = (FunctionProfile)stack.pop();
                if (object == null) {
                    ((Stack)object2).pop();
                    continue;
                }
                object3 = this.vertexMap.get(object);
                FunctionProfile functionProfile2 = (FunctionProfile)((Stack)object2).peek();
                Vertex vertex3 = this.vertexMap.get(functionProfile2);
                boolean bl = false;
                Iterator iterator = ((Vector)object2).iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != object) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.backEdges.add(new Vertex.BackEdge(vertex3, (Vertex)object3));
                    continue;
                }
                boolean bl2 = false;
                for (n2 = 0; n2 < vertex3.getChildren().size(); ++n2) {
                    if (vertex3.getChildren().get(n2) != object3) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    vertex3.getChildren().add((Vertex)object3);
                }
                bl2 = false;
                for (n2 = 0; n2 < ((Vertex)object3).getParents().size(); ++n2) {
                    if (((Vertex)object3).getParents().get(n2) != vertex3) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    ((Vertex)object3).getParents().add(vertex3);
                }
                if (((Vertex)object3).getVisited()) continue;
                ((Vertex)object3).setVisited(true);
                ((Vector)object2).add(object);
                stack.add(null);
                Iterator iterator2 = object.getChildProfiles();
                while (iterator2.hasNext()) {
                    FunctionProfile functionProfile3 = (FunctionProfile)iterator2.next();
                    stack.add(functionProfile3);
                }
            }
        }
        List<Vertex> list = Layout.findRoots(this.vertexMap);
        for (n = 0; n < this.functionProfileList.size(); ++n) {
            vertex = this.functionProfileList.get(n);
            if (vertex == null || vertex.isCallPathFunction() || ((Vertex)(object = this.vertexMap.get(vertex))).getLevel() != -1) continue;
            Layout.assignLevel((Vertex)object);
        }
        for (n = 0; n < this.functionProfileList.size(); ++n) {
            vertex = this.functionProfileList.get(n);
            if (vertex == null || vertex.isCallPathFunction()) continue;
            object = this.vertexMap.get(vertex);
            Layout.insertDummies((Vertex)object);
        }
        for (n = 0; n < this.functionProfileList.size(); ++n) {
            vertex = this.functionProfileList.get(n);
            if (vertex == null || vertex.isCallPathFunction()) continue;
            object = this.vertexMap.get(vertex);
            ((Vertex)object).setVisited(false);
        }
        ArrayList<List<Vertex>> arrayList = new ArrayList<List<Vertex>>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            Layout.fillLevels((Vertex)object, arrayList, 0);
        }
        Layout.runSugiyama(arrayList);
        Layout.assignPositions(arrayList);
        return arrayList;
    }

    private void createGraph() {
        this.levels = this.constructGraph();
        this.model = new DefaultGraphModel();
        this.graph = new Graph((GraphModel)this.model, this);
        this.graph.addMouseListener(this.graph);
        this.graph.addKeyListener(this);
        this.graph.addMouseWheelListener(this);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.graph));
        this.createCustomGraph(this.levels, this.backEdges);
        this.jGraphPane = new JScrollPane((Component)((Object)this.graph));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.jGraphPane, gridBagConstraints, 0, 1, 0, 0);
    }

    void recreateGraph() {
        for (int i = 0; i < this.graphCellList.size(); ++i) {
            DefaultGraphCell defaultGraphCell = this.graphCellList.get(i);
            defaultGraphCell.removeAllChildren();
        }
        this.model.remove(this.cells);
        this.reassignWidths(this.levels);
        Layout.assignPositions(this.levels);
        this.createCustomGraph(this.levels, this.backEdges);
    }

    void reassignWidths(List<List<Vertex>> list) {
        double d = this.getMaxValue(this.widthOption, this.widthMetric);
        double d2 = this.getMaxValue(this.colorOption, this.colorMetric);
        for (int i = 0; i < list.size(); ++i) {
            List<Vertex> list2 = list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                Vertex vertex = list2.get(j);
                if (vertex.getUserObject() == null) continue;
                FunctionProfile functionProfile = (FunctionProfile)vertex.getUserObject();
                vertex.setWidth(this.getWidth(functionProfile, d));
                if (vertex.getWidth() < 5) {
                    vertex.setWidth(5);
                }
                vertex.setColorRatio((float)this.getValue(functionProfile, this.colorOption, d2, this.colorMetric));
                vertex.setHeight(this.boxHeight);
            }
        }
    }

    void createCustomGraph(List<List<Vertex>> list, List<Vertex.BackEdge> list2) {
        Vertex vertex;
        Object object;
        int n;
        List<Vertex> list3;
        HashMap<DefaultGraphCell, Map> hashMap = new HashMap<DefaultGraphCell, Map>();
        this.graphCellList = new ArrayList<GraphCell>();
        ArrayList<DefaultGraphCell> arrayList = new ArrayList<DefaultGraphCell>();
        for (int i = 0; i < list.size(); ++i) {
            list3 = list.get(i);
            for (n = 0; n < list3.size(); ++n) {
                object = list3.get(n);
                GraphCell graphCell = null;
                if (((Vertex)object).getUserObject() == null) continue;
                graphCell = this.createGraphCell((Vertex)object, ((Vertex)object).getPosition() - ((Vertex)object).getWidth() / 2, 20 + i * 120, ((Vertex)object).getHeight(), ((Vertex)object).getWidth(), ((Vertex)object).getColorRatio(), hashMap);
                ((Vertex)object).setGraphCell(graphCell);
                arrayList.add(graphCell);
                this.graphCellList.add(graphCell);
            }
        }
        ConnectionSet connectionSet = new ConnectionSet();
        list3 = new ArrayList<Vertex>();
        for (n = 0; n < list.size(); ++n) {
            object = list.get(n);
            for (int i = 0; i < object.size(); ++i) {
                vertex = (Vertex)object.get(i);
                if (vertex.getUserObject() == null) continue;
                GraphCell graphCell = vertex.getGraphCell();
                for (Vertex vertex2 : vertex.getChildren()) {
                    Object object2;
                    if (vertex2.getUserObject() != null) {
                        object2 = vertex2.getGraphCell();
                        DefaultEdge defaultEdge = this.createEdge(graphCell, (DefaultGraphCell)object2, hashMap, connectionSet, null);
                        arrayList.add((DefaultGraphCell)defaultEdge);
                        list3.add((Vertex)defaultEdge);
                        continue;
                    }
                    object2 = new ArrayList();
                    int n2 = 1;
                    ((ArrayList)object2).add(new Point(3000, 3000));
                    while (vertex2.getUserObject() == null) {
                        ((ArrayList)object2).add(new Point(vertex2.getPosition(), 20 + (n + n2) * 120 + this.boxHeight / 2));
                        vertex2 = vertex2.getChildren().get(0);
                        ++n2;
                    }
                    ((ArrayList)object2).add(new Point(3000, 3000));
                    DefaultEdge defaultEdge = this.createEdge(graphCell, vertex2.getGraphCell(), hashMap, connectionSet, (ArrayList<Point>)object2);
                    arrayList.add((DefaultGraphCell)defaultEdge);
                    list3.add((Vertex)defaultEdge);
                }
            }
        }
        for (n = 0; n < list2.size(); ++n) {
            object = list2.get(n);
            ArrayList<Point> arrayList2 = new ArrayList<Point>();
            arrayList2.add(new Point(3000, 3000));
            arrayList2.add(new Point(((Vertex.BackEdge)object).a.getPosition() + ((Vertex.BackEdge)object).a.getWidth() / 2 + 50, ((Vertex.BackEdge)object).a.getLevel() * 120 + 20 + this.boxHeight / 2));
            arrayList2.add(new Point(((Vertex.BackEdge)object).b.getPosition() + 25, ((Vertex.BackEdge)object).b.getLevel() * 120 - 25 + 20));
            arrayList2.add(new Point(3000, 3000));
            vertex = this.createEdge(((Vertex.BackEdge)object).a.getGraphCell(), ((Vertex.BackEdge)object).b.getGraphCell(), hashMap, connectionSet, arrayList2);
            arrayList.add((DefaultGraphCell)vertex);
            list3.add(vertex);
        }
        this.cells = arrayList.toArray();
        this.model.insert(this.cells, hashMap, connectionSet, null, null);
        this.moveDownToVisible(arrayList, list3);
    }

    private void moveDownToVisible(List<DefaultGraphCell> list, List<DefaultEdge> list2) {
        Rectangle2D rectangle2D;
        int n = 0;
        for (int i = 0; i < list2.size(); ++i) {
            CellView cellView = this.graph.getGraphLayoutCache().getMapping((Object)list2.get(i), false);
            rectangle2D = cellView.getBounds();
            if (!(rectangle2D.getY() < (double)n)) continue;
            n = (int)rectangle2D.getY();
        }
        if (n != 0) {
            n -= 5;
            HashMap<Rectangle2D, AttributeMap> hashMap = new HashMap<Rectangle2D, AttributeMap>();
            for (int i = 0; i < list.size(); ++i) {
                rectangle2D = list.get(i);
                AttributeMap attributeMap = rectangle2D.getAttributes();
                CallGraphWindow.translate((Map)attributeMap, 0.0, -n);
                hashMap.put(rectangle2D, attributeMap);
            }
            this.graph.getGraphLayoutCache().edit(hashMap, null, null, null);
        }
    }

    public static void translate(Map map, double d, double d2) {
        if (GraphConstants.isMoveable((Map)map)) {
            List list;
            Rectangle2D rectangle2D = GraphConstants.getBounds((Map)map);
            if (rectangle2D != null) {
                int n = GraphConstants.getMoveableAxis((Map)map);
                if (n == 1) {
                    d2 = 0.0;
                } else if (n == 2) {
                    d = 0.0;
                }
                rectangle2D.setFrame(Math.max(0.0, rectangle2D.getX() + d), Math.max(0.0, rectangle2D.getY() + d2), rectangle2D.getWidth(), rectangle2D.getHeight());
                GraphConstants.setBounds((Map)map, (Rectangle2D)rectangle2D);
            }
            if ((list = GraphConstants.getPoints((Map)map)) != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (!(e instanceof Point2D)) continue;
                    Point2D point2D = (Point2D)e;
                    point2D.setLocation(Math.max(0.0, point2D.getX() + d), Math.max(0.0, point2D.getY() + d2));
                }
                GraphConstants.setPoints((Map)map, (List)list);
            }
        }
    }

    public GraphCell createGraphCell(Vertex vertex, int n, int n2, int n3, int n4, float f, Map<DefaultGraphCell, Map> map) {
        GraphCell graphCell = new GraphCell(vertex);
        Hashtable hashtable = new Hashtable();
        map.put(graphCell, hashtable);
        Rectangle rectangle = new Rectangle(n, n2, n4, n3);
        GraphConstants.setBounds(hashtable, (Rectangle2D)rectangle);
        GraphConstants.setBorderColor(hashtable, (Color)Color.black);
        if (this.colorOption == CallGraphOption.STATIC) {
            GraphConstants.setBackground(hashtable, (Color)Color.orange);
            GraphConstants.setForeground(hashtable, (Color)Color.black);
        } else {
            GraphConstants.setBackground(hashtable, (Color)ColorBar.getColor(f));
            GraphConstants.setForeground(hashtable, (Color)ColorBar.getContrast(ColorBar.getColor(f)));
        }
        GraphConstants.setOpaque(hashtable, (boolean)true);
        GraphConstants.setEditable(hashtable, (boolean)false);
        GraphConstants.setFont(hashtable, (Font)this.font);
        GraphConstants.setBorder(hashtable, (Border)BorderFactory.createRaisedBevelBorder());
        DefaultPort defaultPort = new DefaultPort();
        graphCell.add((MutableTreeNode)defaultPort);
        return graphCell;
    }

    public DefaultEdge createEdge(DefaultGraphCell defaultGraphCell, DefaultGraphCell defaultGraphCell2, Map<DefaultGraphCell, Map> map, ConnectionSet connectionSet, ArrayList<Point> arrayList) {
        DefaultEdge defaultEdge = new DefaultEdge();
        Hashtable hashtable = new Hashtable();
        map.put((DefaultGraphCell)defaultEdge, hashtable);
        if (arrayList != null) {
            GraphConstants.setPoints(hashtable, arrayList);
            GraphConstants.setLineStyle(hashtable, (int)13);
        }
        GraphConstants.setLineEnd(hashtable, (int)1);
        GraphConstants.setEndFill(hashtable, (boolean)true);
        GraphConstants.setDisconnectable(hashtable, (boolean)false);
        if (defaultGraphCell == defaultGraphCell2) {
            DefaultPort defaultPort = new DefaultPort();
            defaultGraphCell.add((MutableTreeNode)defaultPort);
            connectionSet.connect((Object)defaultEdge, (Object)defaultGraphCell.getChildAt(0), (Object)defaultGraphCell.getChildAt(1));
        } else {
            connectionSet.connect((Object)defaultEdge, (Object)defaultGraphCell.getChildAt(0), (Object)defaultGraphCell2.getChildAt(0));
        }
        return defaultEdge;
    }

    private void displaySliders(boolean bl) {
        Container container = this.getContentPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (bl) {
            container.remove(this.jGraphPane);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.boxWidthLabel, gridBagConstraints, 0, 1, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.7;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.boxWidthSlider, gridBagConstraints, 1, 1, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.99;
            this.addCompItem(this.jGraphPane, gridBagConstraints, 0, 2, 2, 1);
        } else {
            container.remove(this.boxWidthLabel);
            container.remove(this.boxWidthSlider);
            container.remove(this.jGraphPane);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.addCompItem(this.jGraphPane, gridBagConstraints, 0, 1, 1, 1);
        }
        this.validate();
    }

    public Edge getEdge(FunctionProfile functionProfile, FunctionProfile functionProfile2) {
        Vertex vertex = this.vertexMap.get(functionProfile);
        Vertex vertex2 = this.vertexMap.get(functionProfile2);
        int n = vertex2.getGraphCell().getChildCount();
        for (int i = 0; i < n; ++i) {
            Port port = (Port)vertex2.getGraphCell().getChildAt(i);
            Iterator iterator = port.edges();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                if (edge.getTarget() != port) continue;
                Port port2 = (Port)edge.getSource();
                Object object = this.model.getParent((Object)port2);
                CellView cellView = this.graph.getGraphLayoutCache().getMapping(object, false);
                GraphCell graphCell = (GraphCell)((Object)cellView.getCell());
                if (graphCell.getVertex() != vertex) continue;
                return edge;
            }
        }
        return null;
    }

    private void handlePrefEvent() {
        this.font = new Font(this.ppTrial.getPreferencesWindow().getFontName(), this.ppTrial.getPreferencesWindow().getFontStyle(), this.ppTrial.getPreferencesWindow().getFontSize());
        this.setFont(this.font);
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        this.boxHeight = fontMetrics.getHeight() + 5;
        this.recreateGraph();
    }

    public void handleColorEvent() {
        Object object;
        Object object2;
        GraphCell graphCell;
        int n;
        Hashtable hashtable = new Hashtable();
        for (n = 0; n < this.graphCellList.size(); ++n) {
            graphCell = this.graphCellList.get(n);
            Vertex vertex = graphCell.getVertex();
            vertex.setPathHighlight(false);
            int n2 = this.model.getChildCount((Object)graphCell);
            for (int i = 0; i < n2; ++i) {
                object2 = this.model.getChild((Object)graphCell, i);
                Iterator iterator = this.model.edges(object2);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    HashMap hashMap = new HashMap();
                    GraphConstants.setLineColor(hashMap, (Color)Color.black);
                    hashtable.put(object, hashMap);
                }
            }
        }
        for (n = 0; n < this.graphCellList.size(); ++n) {
            graphCell = this.graphCellList.get(n);
            if (graphCell.function != this.ppTrial.getHighlightedFunction()) continue;
            for (int i = 0; i < this.functionProfileList.size(); ++i) {
                Function function;
                FunctionProfile functionProfile = this.functionProfileList.get(i);
                if (functionProfile == null || !(function = functionProfile.getFunction()).isCallPathFunction() || ((String)(object2 = function.getName())).indexOf(graphCell.getFunction().getName()) == -1) continue;
                int n3 = ((String)object2).indexOf("=>");
                while (n3 != -1) {
                    object = ((String)object2).substring(0, n3);
                    int n4 = ((String)object2).indexOf("=>", n3 + 1);
                    if (n4 == -1) {
                        n4 = ((String)object2).length();
                    }
                    String string = ((String)object2).substring(n3 + 2, n4);
                    FunctionProfile functionProfile2 = this.thread.getFunctionProfile(this.ppTrial.getDataSource().getFunction(object));
                    FunctionProfile functionProfile3 = this.thread.getFunctionProfile(this.ppTrial.getDataSource().getFunction(string));
                    Vertex vertex = this.vertexMap.get(functionProfile2);
                    vertex.setPathHighlight(true);
                    vertex = this.vertexMap.get(functionProfile3);
                    vertex.setPathHighlight(true);
                    Edge edge = this.getEdge(functionProfile2, functionProfile3);
                    HashMap hashMap = new HashMap();
                    GraphConstants.setLineColor(hashMap, (Color)Color.blue);
                    if (edge != null) {
                        hashtable.put(edge, hashMap);
                    }
                    object2 = ((String)object2).substring(n3 + 3);
                    n3 = ((String)object2).indexOf("=>");
                }
            }
        }
        for (n = 0; n < this.graphCellList.size(); ++n) {
            graphCell = this.graphCellList.get(n);
            HashMap hashMap = new HashMap();
            if (graphCell.function == this.ppTrial.getHighlightedFunction()) {
                GraphConstants.setBorder(hashMap, (Border)BorderFactory.createBevelBorder(0, this.ppTrial.getColorChooser().getHighlightColor(), this.ppTrial.getColorChooser().getHighlightColor()));
            } else if (graphCell.getVertex().getPathHighlight()) {
                GraphConstants.setBorder(hashMap, (Border)BorderFactory.createBevelBorder(0, Color.blue, Color.blue));
            } else if (graphCell.function.isGroupMember(this.ppTrial.getHighlightedGroup())) {
                GraphConstants.setBorder(hashMap, (Border)BorderFactory.createBevelBorder(0, this.ppTrial.getColorChooser().getGroupHighlightColor(), this.ppTrial.getColorChooser().getGroupHighlightColor()));
            } else {
                GraphConstants.setBorder(hashMap, (Border)BorderFactory.createRaisedBevelBorder());
            }
            hashtable.put((Object)((Object)graphCell), hashMap);
        }
        this.graph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    @Override
    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        } else if (string.equals("prefEvent")) {
            this.handlePrefEvent();
        } else if (string.equals("colorEvent")) {
            this.handleColorEvent();
        } else if (string.equals("dataEvent")) {
            this.setupMenus();
            this.validate();
            this.recreateGraph();
        }
    }

    @Override
    public void help(boolean bl) {
        ParaProf.getHelpWindow().clearText();
        if (bl) {
            ParaProf.getHelpWindow().setVisible(true);
        }
        ParaProf.getHelpWindow().writeText("This is the Call Graph Window");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("This window shows you a graph of call paths present in the profile data.");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("Click on a box to highlight paths that go through that function.");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("Right-click on a box to access the Function Data Window for that function.");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("Experiment with the \"Box Width by...\" and \"Box Color by...\" menus (under Options) to display different types of data.");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("If you only see a single line of boxes (no edges connecting them), it probably means that your profile data does not contain call path data.  If you believe this to be incorrect please contact us with the data at tau-bugs@cs.uoregon.edu");
        ParaProf.getHelpWindow().writeText("");
    }

    public Dimension getViewportSize() {
        return this.jGraphPane.getViewport().getExtentSize();
    }

    public Rectangle getViewRect() {
        return this.jGraphPane.getViewport().getViewRect();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    @Override
    public void closeThisWindow() {
        this.setVisible(false);
        this.ppTrial.deleteObserver(this);
        ParaProf.decrementNumWindows();
        this.dispose();
    }

    public GraphCell getGraphCellForLocation(int n, int n2) {
        for (int i = 0; i < this.graphCellList.size(); ++i) {
            GraphCell graphCell = this.graphCellList.get(i);
            AttributeMap attributeMap = graphCell.getAttributes();
            Rectangle2D rectangle2D = GraphConstants.getBounds((Map)attributeMap);
            if (!rectangle2D.contains(n, n2)) continue;
            return graphCell;
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.boxWidth = this.boxWidthSlider.getValue();
            this.recreateGraph();
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = 0;
        n = mouseWheelEvent.getWheelRotation();
        this.scale += 0.1 * (double)n;
        if (this.scale > 5.0) {
            this.scale = 5.0;
        }
        if (this.scale < 0.1) {
            this.scale = 0.1;
        }
        this.graph.setScale(this.scale);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        try {
            char c = keyEvent.getKeyChar();
            if (c == '+' || c == '=') {
                this.scale += 0.1;
                if (this.scale > 5.0) {
                    this.scale = 5.0;
                }
                this.graph.setScale(this.scale);
            } else if (c == '-' || c == '_') {
                this.scale -= 0.1;
                if (this.scale < 0.1) {
                    this.scale = 0.1;
                }
                this.graph.setScale(this.scale);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        if (bl) {
            return this.getPreferredSize();
        }
        return this.getSize();
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        if (!bl) {
            this.graph.setDoubleBuffered(false);
        }
        if (bl2) {
            this.graph.paintAll(graphics2D);
        } else {
            this.graph.paint(graphics2D);
        }
        if (!bl) {
            this.graph.setDoubleBuffered(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        double d = this.graph.getScale();
        try {
            this.graph.setDoubleBuffered(false);
            if (n >= 1) {
                int n2 = 1;
                return n2;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.graph.getWidth(), this.graph.getHeight());
            this.graph.paint(graphics);
        }
        finally {
            this.graph.setDoubleBuffered(true);
            this.graph.setScale(d);
        }
        return 0;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string;
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem && (string = actionEvent.getActionCommand()).equals("Show Width Slider")) {
                if (this.slidersCheckBox.isSelected()) {
                    this.displaySliders(true);
                } else {
                    this.displaySliders(false);
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    @Override
    public JFrame getFrame() {
        return this;
    }

    private class Graph
    extends JGraph
    implements MouseListener {
        private static final long serialVersionUID = 5752402574670873205L;
        private CallGraphWindow callGraphWindow;

        public String getToolTipText(MouseEvent mouseEvent) {
            double d;
            double d2 = (double)mouseEvent.getX() / this.getScale();
            GraphCell graphCell = this.callGraphWindow.getGraphCellForLocation((int)d2, (int)(d = (double)mouseEvent.getY() / this.getScale()));
            if (graphCell != null) {
                return graphCell.getToolTipString();
            }
            return null;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                double d = (double)mouseEvent.getX() / this.getScale();
                double d2 = (double)mouseEvent.getY() / this.getScale();
                GraphCell graphCell = this.callGraphWindow.getGraphCellForLocation((int)d, (int)d2);
                if (graphCell != null) {
                    Function function = graphCell.getFunction();
                    if (ParaProfUtils.rightClick(mouseEvent)) {
                        JPopupMenu jPopupMenu = ParaProfUtils.createFunctionClickPopUp(CallGraphWindow.this.ppTrial, function, CallGraphWindow.this.thread, (Component)((Object)this));
                        jPopupMenu.show((Component)((Object)this), mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        CallGraphWindow.this.ppTrial.toggleHighlightedFunction(function);
                    }
                }
            }
            catch (Exception exception) {
                ParaProfUtils.handleException(exception);
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.setSize(dimension.width + 10, dimension.height + 10);
            return dimension;
        }

        public Graph(GraphModel graphModel, CallGraphWindow callGraphWindow2) {
            super(graphModel);
            this.callGraphWindow = callGraphWindow2;
            this.setSelectionModel((org.jgraph.graph.GraphSelectionModel)new GraphSelectionModel(this));
        }
    }

    public class GraphCell
    extends DefaultGraphCell {
        private static final long serialVersionUID = -8524078198153715353L;
        private final Function function;
        private final FunctionProfile functionProfile;
        private final Vertex vertex;

        public GraphCell(Vertex vertex) {
            super((Object)((FunctionProfile)vertex.getUserObject()).getFunction());
            this.functionProfile = (FunctionProfile)vertex.getUserObject();
            this.function = this.functionProfile.getFunction();
            this.vertex = vertex;
        }

        public String getToolTipString() {
            String string = "<html>" + this.function;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            if (CallGraphWindow.this.widthOption != CallGraphOption.STATIC && CallGraphWindow.this.widthOption != CallGraphOption.NAME_LENGTH) {
                string = string + "<br>Width Value (" + CallGraphWindow.this.widthOption;
                if (CallGraphWindow.this.widthOption != CallGraphOption.NUMCALLS && CallGraphWindow.this.widthOption != CallGraphOption.NUMSUBR) {
                    string2 = UtilFncs.getUnitsString((int)CallGraphWindow.this.window.units(), (boolean)true, (boolean)false, (String)"");
                    string3 = UtilFncs.getOutputString((int)CallGraphWindow.this.window.units(), (double)CallGraphWindow.this.getValue(this.functionProfile, CallGraphWindow.this.widthOption, 1.0, CallGraphWindow.this.widthMetric), (int)ParaProf.defaultNumberPrecision, (boolean)CallGraphWindow.this.widthMetric.isTimeDenominator());
                    string = string + ", " + CallGraphWindow.this.widthMetric.getName();
                } else {
                    string3 = UtilFncs.formatDouble((double)CallGraphWindow.this.getValue(this.functionProfile, CallGraphWindow.this.widthOption, 1.0, CallGraphWindow.this.widthMetric), (int)ParaProf.defaultNumberPrecision, (boolean)true);
                }
                string = string + ") : " + string3 + " " + string2;
            }
            if (CallGraphWindow.this.colorOption != CallGraphOption.STATIC) {
                string = string + "<br>Color Value (" + CallGraphWindow.this.colorOption;
                if (CallGraphWindow.this.colorOption != CallGraphOption.NUMCALLS && CallGraphWindow.this.colorOption != CallGraphOption.NUMSUBR) {
                    string2 = UtilFncs.getUnitsString((int)CallGraphWindow.this.window.units(), (boolean)true, (boolean)false, (String)"");
                    string4 = UtilFncs.getOutputString((int)CallGraphWindow.this.window.units(), (double)CallGraphWindow.this.getValue(this.functionProfile, CallGraphWindow.this.colorOption, 1.0, CallGraphWindow.this.colorMetric), (int)ParaProf.defaultNumberPrecision, (boolean)CallGraphWindow.this.colorMetric.isTimeDenominator());
                    string = string + ", " + CallGraphWindow.this.colorMetric.getName();
                } else {
                    string4 = UtilFncs.formatDouble((double)CallGraphWindow.this.getValue(this.functionProfile, CallGraphWindow.this.colorOption, 1.0, CallGraphWindow.this.colorMetric), (int)ParaProf.defaultNumberPrecision, (boolean)true);
                }
                string = string + ") : " + string4 + " " + string2;
            }
            return string;
        }

        public Function getFunction() {
            return this.function;
        }

        public Vertex getVertex() {
            return this.vertex;
        }
    }

    private static class GraphSelectionModel
    extends DefaultGraphSelectionModel {
        private static final long serialVersionUID = -5718582372004816966L;

        GraphSelectionModel(JGraph jGraph) {
            super(jGraph);
        }

        public Object[] getSelectables() {
            if (this.isChildrenSelectable()) {
                ArrayList arrayList = new ArrayList();
                Stack<Object> stack = new Stack<Object>();
                GraphModel graphModel = this.graph.getModel();
                for (int i = 0; i < graphModel.getRootCount(); ++i) {
                    stack.add(graphModel.getRootAt(i));
                }
                while (!stack.isEmpty()) {
                    Object e = stack.pop();
                    if (!graphModel.isPort(e) && !graphModel.isEdge(e)) {
                        arrayList.add(e);
                    }
                    if (!this.isChildrenSelectable(e)) continue;
                    for (int i = 0; i < graphModel.getChildCount(e); ++i) {
                        stack.add(graphModel.getChild(e, i));
                    }
                }
                return arrayList.toArray();
            }
            return this.graph.getRoots();
        }
    }
}

