/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class ColorBar
extends JComponent {
    private static final long serialVersionUID = -3922523142677845945L;
    private static final double[] colorsR = new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
    private static final double[] colorsG = new double[]{0.0, 1.0, 1.0, 1.0, 0.5, 0.0};
    private static final double[] colorsB = new double[]{1.0, 1.0, 0.0, 0.0, 0.0, 0.0};

    public ColorBar() {
        this.setMinimumSize(new Dimension(10, 20));
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(10, 20);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = this.getWidth();
            int n2 = (n - 1) / 11;
            for (int i = 0; i < n2; ++i) {
                graphics2D.setColor(ColorBar.getColor((float)i / (float)n2));
                graphics2D.fillRect(i * 11 + 1, 1, 10, 18);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Color getColor(float f) {
        int n;
        if ((double)f < 0.125) {
            f *= 8.0f;
            n = 0;
        } else if ((double)f < 0.25) {
            f = (float)((double)f - 0.125) * 8.0f;
            n = 1;
        } else if ((double)f < 0.5) {
            f = (float)((double)f - 0.25) * 4.0f;
            n = 2;
        } else if ((double)f < 0.75) {
            f = (float)((double)f - 0.5) * 4.0f;
            n = 3;
        } else {
            f = (float)((double)f - 0.75) * 4.0f;
            n = 4;
        }
        double d = colorsR[n] + (double)f * (colorsR[n + 1] - colorsR[n]);
        double d2 = colorsG[n] + (double)f * (colorsG[n + 1] - colorsG[n]);
        double d3 = colorsB[n] + (double)f * (colorsB[n + 1] - colorsB[n]);
        d = Math.min(d, 1.0);
        d2 = Math.min(d2, 1.0);
        d3 = Math.min(d3, 1.0);
        d = Math.max(d, 0.0);
        d2 = Math.max(d2, 0.0);
        d3 = Math.max(d3, 0.0);
        return new Color((float)d, (float)d2, (float)d3);
    }

    public static Color getContrast(Color color) {
        float f;
        float f2;
        float f3 = (float)color.getRed() / 255.0f;
        double d = 0.25 * (double)f3 + 0.625 * (double)(f2 = (float)color.getGreen() / 255.0f) + 0.125 * (double)(f = (float)color.getBlue() / 255.0f);
        if (d > 0.5) {
            return Color.black;
        }
        return Color.white;
    }
}

