/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfFileFilter;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.ParaProfView;
import edu.uoregon.tau.perfdmf.CubeDataSource;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.View;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class LoadTrialWindow
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 6863218330000263005L;
    private static int defaultIndex;
    static String lastDirectory;
    private ParaProfManagerWindow paraProfManagerWindow = null;
    private ParaProfApplication application = null;
    private ParaProfExperiment experiment = null;
    private boolean newExperiment;
    private boolean newApplication;
    private JTextField dirLocationField = new JTextField(lastDirectory, 30);
    private JComboBox trialTypes = null;
    private File[] selectedFiles;
    private JButton selectButton = null;
    private JCheckBox monitorTrialCheckBox = new JCheckBox("Monitor Trial");
    private View view;
    private ParaProfView pview;
    private static final String locationSeparator = ", ";

    public LoadTrialWindow(ParaProfManagerWindow paraProfManagerWindow, ParaProfApplication paraProfApplication, ParaProfExperiment paraProfExperiment, boolean bl, boolean bl2) {
        this(paraProfManagerWindow, !paraProfExperiment.dBExperiment());
        this.application = paraProfApplication;
        this.experiment = paraProfExperiment;
        this.newApplication = bl;
        this.newExperiment = bl2;
    }

    public LoadTrialWindow(ParaProfManagerWindow paraProfManagerWindow, boolean bl) {
        this.paraProfManagerWindow = paraProfManagerWindow;
        if (lastDirectory == null) {
            lastDirectory = System.getProperty("user.dir");
            this.dirLocationField.setText(lastDirectory);
        }
        int n = 400;
        int n2 = 200;
        Point point = paraProfManagerWindow.getLocationOnScreen();
        Dimension dimension = paraProfManagerWindow.getSize();
        int n3 = dimension.width;
        int n4 = dimension.height;
        int n5 = (n3 - n) / 2;
        int n6 = (n4 - n2) / 2;
        n5 = (int)point.getX() + n5;
        n6 = (int)point.getY() + n6;
        this.setLocation(n5, n6);
        this.setSize(new Dimension(n, n2));
        this.setTitle("TAU: ParaProf: Load Trial");
        ParaProfUtils.setFrameIcon(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                LoadTrialWindow.this.thisWindowClosing(windowEvent);
            }
        });
        this.selectButton = new JButton("Select Directory");
        this.selectButton.addActionListener(this);
        this.trialTypes = new JComboBox<String>(DataSource.formatTypeStrings);
        this.trialTypes.setMaximumRowCount(DataSource.formatTypeStrings.length);
        this.trialTypes.addActionListener(this);
        this.trialTypes.setSelectedIndex(defaultIndex);
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(new JLabel("Trial Type"), gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(this.trialTypes, gridBagConstraints, 1, 0, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(this.selectButton, gridBagConstraints, 0, 1, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(this.dirLocationField, gridBagConstraints, 1, 1, 2, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        if (bl) {
            this.monitorTrialCheckBox.addActionListener(this);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            this.addCompItem(this.monitorTrialCheckBox, gridBagConstraints, 1, 2, 1, 1);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            JButton jButton = new JButton("Cancel");
            jButton.addActionListener(this);
            this.addCompItem(jButton, gridBagConstraints, 0, 3, 1, 1);
            jButton = new JButton("Ok");
            jButton.addActionListener(this);
            this.addCompItem(jButton, gridBagConstraints, 2, 3, 1, 1);
        } else {
            JButton jButton = new JButton("Cancel");
            jButton.addActionListener(this);
            this.addCompItem(jButton, gridBagConstraints, 0, 2, 1, 1);
            jButton = new JButton("Ok");
            jButton.addActionListener(this);
            this.addCompItem(jButton, gridBagConstraints, 2, 2, 1, 1);
        }
    }

    public LoadTrialWindow(ParaProfManagerWindow paraProfManagerWindow, View view) {
        this(paraProfManagerWindow, true);
        this.pview = new ParaProfView(view);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            if (string.equals("Select Directory")) {
                JFileChooser jFileChooser = new JFileChooser(lastDirectory);
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setDialogTitle("Select Directory");
                jFileChooser.setApproveButtonText("Select");
                if (jFileChooser.showOpenDialog(this) != 0) {
                    return;
                }
                lastDirectory = jFileChooser.getSelectedFile().getParent();
                this.dirLocationField.setText(jFileChooser.getSelectedFile().getCanonicalPath());
            } else if (string.equals("  Select File(s)  ")) {
                JFileChooser jFileChooser = new JFileChooser(lastDirectory);
                jFileChooser.setFileSelectionMode(0);
                if (this.trialTypes.getSelectedIndex() == 0 || this.trialTypes.getSelectedIndex() == 2 || this.trialTypes.getSelectedIndex() == 4 || this.trialTypes.getSelectedIndex() == 8 || this.trialTypes.getSelectedIndex() == 17 || this.trialTypes.getSelectedIndex() == 9) {
                    jFileChooser.setMultiSelectionEnabled(false);
                } else {
                    jFileChooser.setMultiSelectionEnabled(true);
                }
                if (this.trialTypes.getSelectedIndex() == 9) {
                    jFileChooser.addChoosableFileFilter(CubeDataSource.getFilesFilter());
                } else {
                    jFileChooser.setMultiSelectionEnabled(true);
                }
                if (this.trialTypes.getSelectedIndex() == 0) {
                    jFileChooser.setFileFilter(new ParaProfFileFilter(ParaProfFileFilter.PPK));
                } else if (this.trialTypes.getSelectedIndex() == 2) {
                    jFileChooser.setFileFilter(new ParaProfFileFilter(ParaProfFileFilter.XML));
                }
                jFileChooser.setDialogTitle("Select File(s)");
                jFileChooser.setApproveButtonText("Select");
                if (jFileChooser.showOpenDialog(this) != 0) {
                    return;
                }
                this.selectedFiles = jFileChooser.getSelectedFiles();
                lastDirectory = jFileChooser.getSelectedFile().getParent();
                if (!jFileChooser.isMultiSelectionEnabled()) {
                    this.selectedFiles = new File[1];
                    this.selectedFiles[0] = jFileChooser.getSelectedFile();
                }
                String string2 = "";
                for (int i = 0; i < this.selectedFiles.length; ++i) {
                    if (i > 0) {
                        string2 = string2 + locationSeparator;
                    }
                    string2 = string2 + this.selectedFiles[i].toString();
                }
                this.dirLocationField.setText(string2);
                this.dirLocationField.setEditable(true);
            } else if (string.equals("Cancel")) {
                if (this.newApplication) {
                    this.paraProfManagerWindow.handleDelete(this.application);
                } else if (this.newExperiment) {
                    this.paraProfManagerWindow.handleDelete(this.experiment);
                }
                this.closeThisWindow();
            } else if (string.equals("Ok")) {
                String string3 = this.dirLocationField.getText().trim();
                String[] stringArray = string3.split(locationSeparator);
                if (this.trialTypes.getSelectedIndex() == 0 || this.trialTypes.getSelectedIndex() == 2) {
                    File[] fileArray = new File[1];
                    for (int i = 0; i < stringArray.length; ++i) {
                        fileArray[0] = new File(stringArray[i]);
                        if (!fileArray[0].exists() && !fileArray[0].toString().toLowerCase().startsWith("http:")) {
                            JOptionPane.showMessageDialog(this, this.dirLocationField.getText().trim() + " does not exist");
                        }
                        if (this.pview != null) {
                            this.paraProfManagerWindow.addTrial(this.pview, fileArray, this.trialTypes.getSelectedIndex(), false, this.monitorTrialCheckBox.isSelected(), null);
                            continue;
                        }
                        this.paraProfManagerWindow.addTrial(this.application, this.experiment, fileArray, this.trialTypes.getSelectedIndex(), false, this.monitorTrialCheckBox.isSelected());
                    }
                } else {
                    if (this.selectedFiles == null) {
                        this.selectedFiles = new File[1];
                        this.selectedFiles[0] = new File(this.dirLocationField.getText().trim());
                        if (!this.selectedFiles[0].exists()) {
                            JOptionPane.showMessageDialog(this, this.dirLocationField.getText().trim() + " does not exist");
                            return;
                        }
                    }
                    if (this.pview != null) {
                        this.paraProfManagerWindow.addTrial(this.pview, this.selectedFiles, this.trialTypes.getSelectedIndex(), false, this.monitorTrialCheckBox.isSelected(), null);
                    } else {
                        this.paraProfManagerWindow.addTrial(this.application, this.experiment, this.selectedFiles, this.trialTypes.getSelectedIndex(), false, this.monitorTrialCheckBox.isSelected());
                    }
                }
                this.closeThisWindow();
            } else if (string.equals("comboBoxChanged")) {
                if (this.trialTypes.getSelectedIndex() == 1) {
                    this.selectButton.setText("Select Directory");
                    this.dirLocationField.setEditable(true);
                    this.monitorTrialCheckBox.setEnabled(true);
                } else {
                    this.selectButton.setText("  Select File(s)  ");
                    this.monitorTrialCheckBox.setSelected(false);
                    this.monitorTrialCheckBox.setEnabled(false);
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    private void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    private void closeThisWindow() {
        this.setVisible(false);
        this.dispose();
    }

    public static void setDefaultIndex(int n) {
        defaultIndex = n;
    }
}

