/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class MonSummaryWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private ParaProfTrial ppTrial;
    private DataSource dataSource;
    private Function function;
    private edu.uoregon.tau.perfdmf.Thread thread;
    private JSlider slider;
    private JLabel indexLabel = new JLabel("");
    private JCheckBox animateCheckbox = new JCheckBox("Animate");
    private ChartPanel chartPanel;
    private double lastTime;
    private int numBins;
    private int numHistogramsPerEvent;
    private int numDataPoints;
    private int currentVisibleDataPoints;
    private int selectedDataPoint = -1;
    private Animator animationThread;
    private long animationInterval = 1000L;
    String canonicalName;
    String trialPath;
    private MonProbe probeThread;
    private long probeInterval = 5000L;
    private Hashtable functionsToSeries;
    private XYSeriesCollection dataset;
    private edu.uoregon.tau.perfdmf.Thread snapshotThread;
    private int seriesCount;
    private JFreeChart chart;
    private List<Histogram> histograms = new ArrayList<Histogram>();

    public static MonSummaryWindow createMonSummaryWindow(ParaProfTrial paraProfTrial, Component component) {
        try {
            MonSummaryWindow monSummaryWindow = new MonSummaryWindow(paraProfTrial, component);
            return monSummaryWindow;
        }
        catch (Exception exception) {
            throw new DataSourceException(exception);
        }
    }

    private void processData() throws FileNotFoundException, IOException {
        int n;
        int n2 = this.thread.getNodeID();
        String string = "tau.histograms." + n2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        int n3 = Integer.parseInt(bufferedReader.readLine());
        this.numHistogramsPerEvent = Integer.parseInt(bufferedReader.readLine());
        this.numBins = Integer.parseInt(bufferedReader.readLine());
        for (n = 0; n < this.numHistogramsPerEvent; ++n) {
            Histogram histogram = new Histogram();
            histogram.name = bufferedReader.readLine();
            histogram.bins = new int[this.numBins];
            this.histograms.add(histogram);
        }
        n = 0;
        for (int i = 0; i < n3; ++i) {
            int n4;
            String string2 = bufferedReader.readLine().trim();
            if (string2.equals(this.function.getName())) {
                n = 1;
                for (n4 = 0; n4 < this.numHistogramsPerEvent; ++n4) {
                    StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine(), " \t\n\r");
                    this.histograms.get((int)n4).minValue = Double.parseDouble(stringTokenizer.nextToken());
                    this.histograms.get((int)n4).maxValue = Double.parseDouble(stringTokenizer.nextToken());
                    for (int j = 0; j < this.numBins; ++j) {
                        this.histograms.get((int)n4).bins[j] = Integer.parseInt(stringTokenizer.nextToken());
                    }
                }
                continue;
            }
            for (n4 = 0; n4 < this.numHistogramsPerEvent; ++n4) {
                bufferedReader.readLine();
            }
        }
        bufferedReader.close();
        if (n == 0) {
            System.err.println("Warning, Function \"" + this.function.getName() + "\" not found in histogram");
        }
    }

    private JFreeChart createChart() {
        this.dataset = new XYSeriesCollection();
        this.updateDataset();
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)("TauMon: " + this.canonicalName), (String)"Dump ID", (String)"Mean Exclusive Time", (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        ((XYLineAndShapeRenderer)jFreeChart.getXYPlot().getRenderer()).setOutlinePaint((Paint)Color.black);
        Utility.applyDefaultChartTheme((JFreeChart)jFreeChart);
        return jFreeChart;
    }

    private void redraw() {
        if (this.chartPanel != null) {
            this.chartPanel.setChart(this.createChart());
        }
    }

    private MonSummaryWindow(ParaProfTrial paraProfTrial, Component component) throws Exception {
        this.ppTrial = paraProfTrial;
        this.dataSource = paraProfTrial.getDataSource();
        this.functionsToSeries = new Hashtable();
        String string = paraProfTrial.getPathReverse();
        String string2 = paraProfTrial.getPath();
        int n = string.indexOf(".");
        this.canonicalName = string.substring(0, n);
        int n2 = string2.lastIndexOf(File.separator);
        this.trialPath = n2 != -1 ? string2.substring(0, n2) : ".";
        this.setTitle("TAU: ParaProf: Monitoring: " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        this.setLocation(WindowPlacer.getNewLocation(this, component));
        this.setSize(new Dimension(300, 180));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (MonSummaryWindow.this.probeThread != null) {
                    MonSummaryWindow.this.probeThread.end();
                }
                if (MonSummaryWindow.this.animationThread != null) {
                    MonSummaryWindow.this.animationThread.end();
                }
            }
        });
        this.snapshotThread = this.dataSource.getThread(0, 0, 0);
        this.numDataPoints = this.snapshotThread.getNumSnapshots();
        this.selectedDataPoint = 0;
        this.currentVisibleDataPoints = this.numDataPoints < 10 ? this.numDataPoints : 10;
        this.slider = new JSlider(0, this.currentVisibleDataPoints - 1);
        this.slider.setSnapToTicks(true);
        this.slider.setPaintTicks(true);
        this.slider.setValue(this.slider.getMaximum());
        this.slider.setBackground(Color.white);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MonSummaryWindow.this.selectedDataPoint = MonSummaryWindow.this.slider.getValue();
                MonSummaryWindow.this.setLabels();
                MonSummaryWindow.this.updateDataset();
            }
        });
        this.animateCheckbox.setBackground(Color.white);
        this.animateCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (MonSummaryWindow.this.animateCheckbox.isSelected()) {
                        MonSummaryWindow.this.animationThread = new Animator();
                        MonSummaryWindow.this.animationThread.start();
                    } else {
                        MonSummaryWindow.this.animationThread.end();
                        MonSummaryWindow.this.animationThread = null;
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        });
        this.setLabels();
        this.dataset = new XYSeriesCollection();
        this.chart = ChartFactory.createXYLineChart((String)("TauMon: " + this.canonicalName), (String)"Dump ID", (String)"Mean Exclusive Time", (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        ((XYLineAndShapeRenderer)this.chart.getXYPlot().getRenderer()).setOutlinePaint((Paint)Color.black);
        Utility.applyDefaultChartTheme((JFreeChart)this.chart);
        ChartPanel chartPanel = new ChartPanel(this.chart);
        System.out.println("size = " + chartPanel.getPreferredSize());
        chartPanel.setMinimumSize(chartPanel.getPreferredSize());
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        Utility.addCompItem((Container)jPanel, (Component)chartPanel, (GridBagConstraints)gridBagConstraints, (int)0, (int)0, (int)2, (int)1);
        gridBagConstraints.fill = 2;
        Utility.addCompItem((Container)jPanel, (Component)this.indexLabel, (GridBagConstraints)gridBagConstraints, (int)0, (int)1, (int)2, (int)1);
        gridBagConstraints.fill = 2;
        Utility.addCompItem((Container)jPanel, (Component)this.slider, (GridBagConstraints)gridBagConstraints, (int)0, (int)2, (int)2, (int)1);
        gridBagConstraints.fill = 0;
        Utility.addCompItem((Container)jPanel, (Component)this.animateCheckbox, (GridBagConstraints)gridBagConstraints, (int)0, (int)3, (int)1, (int)1);
        this.getContentPane().add(jPanel);
        this.pack();
        ParaProfUtils.setFrameIcon(this);
        this.probeThread = new MonProbe();
        this.probeThread.start();
    }

    private void setLabels() {
        this.indexLabel.setText("Monitoring Dump " + this.selectedDataPoint + " of " + (this.currentVisibleDataPoints - 1));
    }

    private void updateDataset() {
        XYSeries xYSeries;
        this.dataset.removeAllSeries();
        Enumeration enumeration = this.functionsToSeries.elements();
        while (enumeration.hasMoreElements()) {
            xYSeries = (XYSeries)enumeration.nextElement();
            xYSeries.clear();
        }
        for (int i = 0; i < this.currentVisibleDataPoints; ++i) {
            Integer n = i;
            List list = this.snapshotThread.getFunctionProfiles();
            for (int j = 0; j < list.size(); ++j) {
                FunctionProfile functionProfile = (FunctionProfile)list.get(j);
                String string = functionProfile.getName();
                XYSeries xYSeries2 = (XYSeries)this.functionsToSeries.get(string);
                if (xYSeries2 == null) {
                    xYSeries = new XYSeries((Comparable)((Object)string));
                    this.functionsToSeries.put(string, xYSeries);
                } else {
                    xYSeries = xYSeries2;
                }
                if (i <= this.selectedDataPoint) {
                    double d = functionProfile.getExclusive(i, 0);
                    xYSeries.add((Number)n, (Number)d);
                    continue;
                }
                xYSeries.add((Number)n, null);
            }
        }
        enumeration = this.functionsToSeries.elements();
        while (enumeration.hasMoreElements()) {
            this.dataset.addSeries((XYSeries)enumeration.nextElement());
        }
    }

    private void findAndLoadNewData() {
        int n;
        int n2;
        try {
            n2 = this.dataSource.reloadData();
            if (n2 == 0) {
                System.err.println("WARNING: Data Source reload failed");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        n2 = this.dataSource.getMeanData().getNumSnapshots();
        if (n2 > this.numDataPoints) {
            this.numDataPoints = n2;
        }
        this.currentVisibleDataPoints = (n = this.currentVisibleDataPoints + 10) >= this.numDataPoints ? this.numDataPoints : n;
        this.slider.setMaximum(this.currentVisibleDataPoints - 1);
    }

    private void findAndLoadNewDataProfileDeprecated() {
        int n = this.currentVisibleDataPoints + 10 - 1;
        String string = this.trialPath + File.separator + this.canonicalName + "." + n + ".0.0";
        File file = new File(string);
        if (file.isFile()) {
            int n2;
            for (n2 = this.currentVisibleDataPoints; n2 <= n; ++n2) {
                this.dataSource.addThread(n2, 0, 0);
            }
            try {
                n2 = this.dataSource.reloadData() ? 1 : 0;
                if (n2 == 0) {
                    System.err.println("WARNING: Data Source reload failed");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentVisibleDataPoints = n + 1;
            this.slider.setMaximum(this.currentVisibleDataPoints - 1);
        }
    }

    private static class Histogram {
        public String name;
        public int[] bins;
        public double minValue;
        public double maxValue;

        private Histogram() {
        }
    }

    public static class ScrollFlowLayout
    extends FlowLayout {
        private static final long serialVersionUID = 1L;
        public static final int LEFT_TO_RIGHT = 0;
        public static final int RIGHT_TO_LEFT = 1;
        public static final int TOP_TO_BOTTOM = 2;
        private int orientation = 0;
        private int rows;
        private int cols;
        private ScrollPane sp = null;

        public ScrollFlowLayout() {
        }

        public ScrollFlowLayout(ScrollPane scrollPane) {
            this.sp = scrollPane;
        }

        public ScrollFlowLayout(ScrollPane scrollPane, int n) {
            this.sp = scrollPane;
            this.orientation = n;
        }

        public int getTallestElement(Container container) {
            int n = container.getComponentCount();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                int n3 = component.getMinimumSize().height;
                n2 = n2 > n3 ? n2 : n3;
            }
            return n2;
        }

        public int getWidestElement(Container container) {
            int n = container.getComponentCount();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                int n3 = component.getMinimumSize().width;
                n2 = n2 > n3 ? n2 : n3;
            }
            return n2;
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int n;
            int n2 = container.getSize().height - container.getInsets().bottom - container.getInsets().top;
            int n3 = container.getSize().width;
            if (this.sp != null) {
                n2 = this.sp.getSize().height - this.sp.getInsets().bottom - this.sp.getInsets().top;
                n3 = this.sp.getSize().width;
            }
            if ((n = container.getComponentCount()) == 0) {
                return new Dimension(0, 0);
            }
            int n4 = this.getWidestElement(container);
            int n5 = this.getTallestElement(container);
            int n6 = n5 > n2 ? 1 : n2 / n5;
            int n7 = (int)Math.ceil((double)n / (double)n6);
            if (this.orientation == 0) {
                n7 = n4 > n3 ? 1 : n3 / n4;
                n6 = (int)Math.ceil((double)n / (double)n7);
            }
            Dimension dimension = new Dimension(n7 * n4, n6 * n5);
            return dimension;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                int n = container.getSize().height - container.getInsets().bottom - container.getInsets().top;
                int n2 = container.getSize().width;
                if (this.sp != null) {
                    n = this.sp.getSize().height - this.sp.getInsets().bottom - this.sp.getInsets().top;
                    n2 = this.sp.getSize().width;
                }
                int n3 = container.getComponentCount();
                int n4 = this.getWidestElement(container);
                int n5 = this.getTallestElement(container);
                if (n3 == 0) {
                    return;
                }
                container.invalidate();
                if (this.orientation == 0) {
                    int n6 = 0;
                    int n7 = n4 > n2 ? 1 : n2 / n4;
                    int n8 = (int)Math.ceil((double)n3 / (double)n7);
                    for (int i = 0; i < n8; ++i) {
                        for (int j = 0; j < n7; ++j) {
                            if (n6 < n3) {
                                int n9 = j * n4;
                                int n10 = i * n5;
                                container.getComponent(n6).setBounds(n9, n10, n4, n5);
                            }
                            ++n6;
                        }
                    }
                } else if (this.orientation == 2) {
                    int n11 = n5 > n ? 1 : n / n5;
                    int n12 = (int)Math.ceil((double)n3 / (double)n11);
                    int n13 = 0;
                    for (int i = 0; i < n12; ++i) {
                        for (int j = 0; j < n11; ++j) {
                            if (n13 < n3) {
                                int n14 = i * n4;
                                int n15 = j * n5;
                                container.getComponent(n13).setBounds(n14, n15, n4, n5);
                            }
                            ++n13;
                        }
                    }
                }
            }
        }
    }

    private class MonProbe
    extends Thread {
        private boolean allDone = false;
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try {
                    MonSummaryWindow.this.findAndLoadNewData();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };

        private MonProbe() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    if (this.allDone) {
                        return;
                    }
                    SwingUtilities.invokeLater(this.runner);
                    Thread.sleep(MonSummaryWindow.this.probeInterval);
                }
            }
            catch (Exception exception) {
                return;
            }
        }

        public void end() {
            this.allDone = true;
        }
    }

    private class Animator
    extends Thread {
        private volatile boolean stop = false;
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try {
                    if (MonSummaryWindow.this.slider.getValue() >= MonSummaryWindow.this.slider.getMaximum()) {
                        MonSummaryWindow.this.slider.setValue(0);
                        long l = System.currentTimeMillis();
                        MonSummaryWindow.this.lastTime = l;
                    } else {
                        MonSummaryWindow.this.slider.setValue(MonSummaryWindow.this.slider.getValue() + 1);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };

        private Animator() {
        }

        @Override
        public void run() {
            this.stop = false;
            while (!this.stop) {
                try {
                    SwingUtilities.invokeLater(this.runner);
                    Thread.sleep(MonSummaryWindow.this.animationInterval);
                }
                catch (Exception exception) {}
            }
        }

        public void end() {
            this.stop = true;
        }
    }
}

