/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.TauScripter;
import edu.uoregon.tau.paraprof.ApplicationManager;
import edu.uoregon.tau.paraprof.ColorChooser;
import edu.uoregon.tau.paraprof.ColorMap;
import edu.uoregon.tau.paraprof.CommunicationMatrixWindow;
import edu.uoregon.tau.paraprof.ExternalController;
import edu.uoregon.tau.paraprof.FunctionBarChartWindow;
import edu.uoregon.tau.paraprof.HelpWindow;
import edu.uoregon.tau.paraprof.LoadTrialWindow;
import edu.uoregon.tau.paraprof.OSSWriter;
import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.Preferences;
import edu.uoregon.tau.paraprof.PreferencesWindow;
import edu.uoregon.tau.paraprof.interfaces.EclipseHandler;
import edu.uoregon.tau.paraprof.script.ParaProfScript;
import edu.uoregon.tau.paraprof.sourceview.SourceManager;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceExport;
import edu.uoregon.tau.perfdmf.FileList;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.UtilFncs;
import jargs.gnu.CmdLineParser;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class ParaProf
implements ActionListener {
    private static final String VERSION = "Wed Jun  4 03:51:29 PM PDT 2025";
    public static int defaultNumberPrecision = 6;
    public static File paraProfHomeDirectory;
    public static Preferences preferences;
    public static ColorChooser colorChooser;
    public static ColorMap colorMap;
    public static ParaProfManagerWindow paraProfManagerWindow;
    public static ApplicationManager applicationManager;
    private static HelpWindow helpWindow;
    public static PreferencesWindow preferencesWindow;
    public static Runtime runtime;
    private static int numWindowsOpen;
    private static int fileType;
    private static boolean seriesSnap;
    private static File[] sourceFiles;
    private static boolean fixNames;
    private static boolean monitorProfiles;
    private static String configFile;
    public static boolean demoMode;
    public static boolean controlMode;
    public static boolean usePathNameInTrial;
    public static FunctionBarChartWindow theComparisonWindow;
    public static boolean JNLP;
    public static List<ParaProfScript> scripts;
    public static String scriptFile;
    public static boolean insideEclipse;
    public static EclipseHandler eclipseHandler;
    public static SourceManager directoryManager;
    public static String jarLocation;
    public static String schemaLocation;
    private static String range;

    public static HelpWindow getHelpWindow() {
        if (helpWindow == null) {
            helpWindow = new HelpWindow();
        }
        return helpWindow;
    }

    public static SourceManager getDirectoryManager() {
        if (directoryManager == null) {
            directoryManager = new SourceManager(preferences.getSourceLocations());
        }
        return directoryManager;
    }

    public static void registerScript(ParaProfScript paraProfScript) {
        scripts.add(paraProfScript);
    }

    private static void usage() {
        System.err.println("Usage: paraprof [--pack <file>] [--dump] [--dumprank <rank>] [-p] [-m] [-i] [-f <filetype>] <files/directory>\n\ntry `paraprof --help` for more information");
    }

    private static void outputHelp() {
        System.err.println("Usage: paraprof [options] <files/directory> \n\nOptions:\n\n  -f, --filetype <filetype>       Specify type of performance data, options are:\n                                    profiles (default), pprof, dynaprof, mpip,\n                                    gprof, psrun, hpm, packed, cube, hpc, ompp\n                                    snap, perixml, gptl, ipm, google, darshan\n  --range a-b:c                   Load only profiles from the given range(s) of processes\n                                    Seperate individual ids or dash-defined ranges with colons\n  -h, --help                      Display this help message\n\nThe following options will run only from the console (no GUI will launch):\n\n  --merge <file.gz>               Merges snapshot profiles\n  --pack <file>                   Pack the data into packed (.ppk) format\n  --text <file>                   Dump the data into text (.csv) format\n  --dump                          Dump profile data to TAU profile format\n  --dumprank <rank>               Dump profile data for <rank> to TAU profile format\n                                  Specify multiple ranks in with a comma separated list. Use\n                                  a dash between values for a range. Do not use spaces. E.g. 0,4,8-10,16\n  -v, --dumpsummary               Dump derived statistical data to TAU profile format\n  --overwrite                     Allow overwriting of profiles\n  -o, --oss                       Print profile data in OSS style text output\n  -q, --dumpmpisummary            Print high level time and communication summary\n  -d, --metadump                  Print profile metadata (works with --dumpmpisummary)\n  -x, --suppressmetrics           Exclude child calls and exclusive time from --dumpmpisummary\n  -s, --summary                   Print only summary statistics\n                                    (only applies to OSS output)\n  -y, --control                   Enter command line control mode for exploring/loading/exporting database trials\n  --writecomm <file.csv>          Write communication matrix data (if any) to the specified csv file.\n\nNotes:\n  For the TAU profiles type, you can specify either a specific set of profile\nfiles on the commandline, or you can specify a directory (by default the current\ndirectory).  The specified directory will be searched for profile.*.*.* files,\nor, in the case of multiple counters, directories named MULTI_* containing\nprofile data.\n\n");
    }

    public static void incrementNumWindows() {
        ++numWindowsOpen;
    }

    public static void decrementNumWindows() {
        if (--numWindowsOpen <= 0) {
            ParaProf.exitParaProf(0);
        }
    }

    public static void loadDefaultTrial() {
        ParaProf.loadDefaultTrial(null);
    }

    public static void loadDefaultTrial(String string) {
        ParaProfApplication paraProfApplication = applicationManager.addApplication();
        paraProfApplication.setName("Default App");
        ParaProfExperiment paraProfExperiment = paraProfApplication.addExperiment();
        paraProfExperiment.setName("Default Exp");
        paraProfManagerWindow.setVisible(true);
        try {
            if (fileType == 0) {
                for (int i = 0; i < sourceFiles.length; ++i) {
                    File[] fileArray = new File[]{sourceFiles[i]};
                    paraProfManagerWindow.addTrial(paraProfApplication, paraProfExperiment, fileArray, fileType, fixNames, monitorProfiles);
                }
            } else if (sourceFiles.length == 0 && fileType == 16) {
                String string2 = System.getProperty("user.dir");
                File file = new File(string2);
                String[] stringArray = file.list();
                ArrayList<File> arrayList = new ArrayList<File>();
                for (String string3 : stringArray) {
                    if (!string3.endsWith(".txt")) continue;
                    arrayList.add(new File(string3));
                }
                paraProfManagerWindow.addTrial(paraProfExperiment, arrayList.toArray(sourceFiles), fileType, fixNames, monitorProfiles, string);
            } else if (!seriesSnap && fileType == 2) {
                for (int i = 0; i < sourceFiles.length; ++i) {
                    File[] fileArray = new File[]{sourceFiles[i]};
                    paraProfManagerWindow.addTrial(paraProfApplication, paraProfExperiment, fileArray, fileType, fixNames, monitorProfiles);
                }
            } else {
                paraProfManagerWindow.addTrial(paraProfExperiment, sourceFiles, fileType, fixNames, monitorProfiles, string);
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public static void initialize() {
        try {
            if (System.getProperty("jnlp.running") != null) {
                JNLP = true;
            }
        }
        catch (AccessControlException accessControlException) {
            JNLP = true;
        }
        if (!JNLP) {
            paraProfHomeDirectory = new File(System.getProperty("user.home") + "/.ParaProf");
            if (paraProfHomeDirectory.exists()) {
                Object object;
                try {
                    object = new FileInputStream(paraProfHomeDirectory.getPath() + "/ParaProf.conf");
                    ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
                    preferences = (Preferences)objectInputStream.readObject();
                    colorChooser = new ColorChooser(preferences);
                }
                catch (Exception exception) {
                    if (exception instanceof FileNotFoundException) {
                        System.out.println("No preference file present, using defaults!");
                    }
                    System.out.println("Error while trying to read the ParaProf preferences file, using defaults");
                }
                colorMap.setMap(preferences.getAssignedColors());
                preferences.setDatabasePassword(null);
                object = new File(paraProfHomeDirectory.getPath() + "/perfdmf.cfg");
                if (((File)object).exists()) {
                    preferences.setDatabaseConfigurationFile(paraProfHomeDirectory.getPath() + "/perfdmf.cfg");
                }
            } else {
                System.out.println("Did not find ParaProf home directory... creating...");
                paraProfHomeDirectory.mkdir();
                System.out.println("Done creating ParaProf home directory!");
            }
        } else {
            preferences = new Preferences();
        }
        ParaProf.setUIFont(new FontUIResource(new Font(preferences.getFontName(), preferences.getFontStyle(), preferences.getFontSize())));
        if (colorChooser == null) {
            colorChooser = new ColorChooser(null);
        }
        preferencesWindow = new PreferencesWindow(preferences);
        DataSource.setMeanIncludeNulls((!preferences.getComputeMeanWithoutNulls() ? 1 : 0) != 0);
        try {
            System.setProperty("sun.awt.exception.handler", XThrowableHandler.class.getName());
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        paraProfManagerWindow = new ParaProfManagerWindow(configFile);
    }

    public static void loadScripts() {
        if (!JNLP) {
            scripts.clear();
            scriptFile = System.getProperty("user.home") + "/.ParaProf/ParaProf.py";
            if (new File(scriptFile).exists()) {
                try {
                    TauScripter.execfile((String)(System.getProperty("user.home") + "/.ParaProf/ParaProf.py"));
                }
                catch (Exception exception) {
                    new ParaProfErrorDialog("Exception while executing script: ", exception);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Timer) {
            System.out.println("------------------------");
            System.out.println("The amount of memory used by the system is: " + runtime.totalMemory());
            System.out.println("The amount of memory free to the system is: " + runtime.freeMemory());
        }
    }

    public static String getInfoString() {
        DecimalFormat decimalFormat = new DecimalFormat("#.## MB");
        String string = "Free: " + decimalFormat.format((double)Runtime.getRuntime().freeMemory() / 1000000.0) + "\nTotal: " + decimalFormat.format((double)Runtime.getRuntime().totalMemory() / 1000000.0) + "\nMax: " + decimalFormat.format((double)Runtime.getRuntime().maxMemory() / 1000000.0);
        String string2 = "ParaProf\n" + ParaProf.getVersionString() + "\nJVM Memory stats:\n" + string + "\n" + "http://www.cs.uoregon.edu/research/tau\n";
        return string2;
    }

    public static String getVersionString() {
        return new String(VERSION);
    }

    public static void loadPreferences(File file) throws FileNotFoundException, IOException, ClassNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(file);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        preferences = (Preferences)objectInputStream.readObject();
        colorChooser = new ColorChooser(preferences);
        colorMap.setMap(preferences.getAssignedColors());
        Vector<ParaProfTrial> vector = paraProfManagerWindow.getLoadedTrials();
        for (ParaProfTrial paraProfTrial : vector) {
            colorChooser.setColors(paraProfTrial, -1);
            paraProfTrial.updateRegisteredObjects("colorEvent");
            paraProfTrial.updateRegisteredObjects("prefEvent");
        }
    }

    public static void exitParaProf(int n) {
        try {
            ParaProf.savePreferences(new File(paraProfHomeDirectory.getPath() + "/ParaProf.conf"));
        }
        catch (Exception exception) {
            System.err.println("An error occured while trying to save ParaProf preferences.");
            exception.printStackTrace();
        }
        if (!insideEclipse && !controlMode) {
            System.exit(n);
        }
    }

    public static boolean savePreferences(File file) {
        colorChooser.setSavedColors();
        preferences.setAssignedColors(colorMap.getMap());
        preferences.setSourceLocations(ParaProf.getDirectoryManager().getCurrentElements());
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(preferences);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println("An error occured while trying to save ParaProf preferences.");
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        Object object;
        boolean bl;
        ToolTipManager.sharedInstance().setDismissDelay(20000);
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addStringOption('a', "merge");
        CmdLineParser.Option option2 = cmdLineParser.addStringOption('a', "pack");
        CmdLineParser.Option option3 = cmdLineParser.addStringOption('t', "text");
        CmdLineParser.Option option4 = cmdLineParser.addStringOption('c', "schemadir");
        CmdLineParser.Option option5 = cmdLineParser.addBooleanOption('d', "metadump");
        CmdLineParser.Option option6 = cmdLineParser.addStringOption('f', "filetype");
        CmdLineParser.Option option7 = cmdLineParser.addStringOption('g', "configfile");
        CmdLineParser.Option option8 = cmdLineParser.addBooleanOption('h', "help");
        CmdLineParser.Option option9 = cmdLineParser.addBooleanOption('i', "fixnames");
        CmdLineParser.Option option10 = cmdLineParser.addStringOption('j', "jardir");
        CmdLineParser.Option option11 = cmdLineParser.addBooleanOption('m', "monitor");
        CmdLineParser.Option option12 = cmdLineParser.addStringOption('n', "range");
        CmdLineParser.Option option13 = cmdLineParser.addBooleanOption('o', "oss");
        CmdLineParser.Option option14 = cmdLineParser.addBooleanOption('q', "dumpmpisummary");
        CmdLineParser.Option option15 = cmdLineParser.addStringOption('r', "dumprank");
        CmdLineParser.Option option16 = cmdLineParser.addBooleanOption('s', "summary");
        CmdLineParser.Option option17 = cmdLineParser.addBooleanOption('u', "dump");
        CmdLineParser.Option option18 = cmdLineParser.addBooleanOption('v', "dumpsummary");
        CmdLineParser.Option option19 = cmdLineParser.addBooleanOption('w', "overwrite");
        CmdLineParser.Option option20 = cmdLineParser.addBooleanOption('x', "suppressmetrics");
        CmdLineParser.Option option21 = cmdLineParser.addBooleanOption('y', "control");
        CmdLineParser.Option option22 = cmdLineParser.addBooleanOption('z', "demo");
        CmdLineParser.Option option23 = cmdLineParser.addStringOption('a', "writecomm");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println("paraprof: " + optionException.getMessage());
            ParaProf.usage();
            System.exit(-1);
        }
        configFile = (String)cmdLineParser.getOptionValue(option7);
        Boolean bl2 = (Boolean)cmdLineParser.getOptionValue(option8);
        String string = (String)cmdLineParser.getOptionValue(option6);
        Boolean bl3 = (Boolean)cmdLineParser.getOptionValue(option9);
        String string2 = (String)cmdLineParser.getOptionValue(option);
        String string3 = (String)cmdLineParser.getOptionValue(option2);
        String string4 = (String)cmdLineParser.getOptionValue(option3);
        String string5 = (String)cmdLineParser.getOptionValue(option23);
        Boolean bl4 = (Boolean)cmdLineParser.getOptionValue(option17);
        Boolean bl5 = (Boolean)cmdLineParser.getOptionValue(option18);
        Boolean bl6 = (Boolean)cmdLineParser.getOptionValue(option14);
        Boolean bl7 = (Boolean)cmdLineParser.getOptionValue(option20);
        Boolean bl8 = (Boolean)cmdLineParser.getOptionValue(option5);
        Boolean bl9 = (Boolean)cmdLineParser.getOptionValue(option19);
        String string6 = (String)cmdLineParser.getOptionValue(option15);
        if (string6 != null || bl5 != null || bl6 != null || bl8 != null) {
            bl4 = Boolean.TRUE;
        }
        Boolean bl10 = (Boolean)cmdLineParser.getOptionValue(option13);
        Boolean bl11 = (Boolean)cmdLineParser.getOptionValue(option16);
        Boolean bl12 = (Boolean)cmdLineParser.getOptionValue(option11);
        Boolean bl13 = (Boolean)cmdLineParser.getOptionValue(option22);
        Boolean bl14 = (Boolean)cmdLineParser.getOptionValue(option21);
        jarLocation = (String)cmdLineParser.getOptionValue(option10);
        schemaLocation = (String)cmdLineParser.getOptionValue(option4);
        range = (String)cmdLineParser.getOptionValue(option12);
        if (range != null && string == null) {
            string = "profiles";
        }
        controlMode = bl14 != null && bl14 != false;
        boolean bl15 = demoMode = bl13 != null && bl13 != false;
        if (configFile != "") {
            preferences.setDatabaseConfigurationFile(configFile);
        }
        if (bl12 != null) {
            monitorProfiles = bl12;
        }
        if (string3 != null && bl4 != null) {
            System.err.println("--pack and --dump are mutually exclusive");
            System.exit(-1);
        }
        if (bl2 != null && bl2.booleanValue()) {
            ParaProf.outputHelp();
            System.exit(-1);
        }
        String[] stringArray2 = cmdLineParser.getRemainingArgs();
        sourceFiles = new File[stringArray2.length];
        for (bl = false; bl < stringArray2.length; bl += 1) {
            ParaProf.sourceFiles[bl] = new File(stringArray2[bl]);
        }
        if (sourceFiles != null && sourceFiles.length > 0 && sourceFiles[0] != null && sourceFiles[0].exists()) {
            if (sourceFiles[0].isDirectory()) {
                try {
                    LoadTrialWindow.lastDirectory = sourceFiles[0].getCanonicalPath();
                }
                catch (IOException iOException) {}
            } else {
                try {
                    File file = sourceFiles[0].getParentFile();
                    if (file != null && file.exists()) {
                        LoadTrialWindow.lastDirectory = file.getCanonicalPath();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (bl3 != null) {
            fixNames = bl3;
        }
        if (string != null) {
            if (string.equals("profiles")) {
                fileType = 1;
            } else if (string.equals("pprof")) {
                fileType = 8;
            } else if (string.equals("dynaprof")) {
                fileType = 3;
            } else if (string.equals("mpip")) {
                fileType = 4;
            } else if (string.equals("hpm")) {
                fileType = 5;
            } else if (string.equals("gprof")) {
                fileType = 6;
            } else if (string.equals("psrun")) {
                fileType = 7;
            } else if (string.equals("packed")) {
                fileType = 0;
            } else if (string.equals("cube")) {
                fileType = 9;
            } else if (string.equals("hpc")) {
                fileType = 10;
            } else if (string.equals("snapshot")) {
                fileType = 2;
            } else if (string.equals("snap")) {
                seriesSnap = true;
                fileType = 2;
            } else if (string.equals("ompp")) {
                fileType = 11;
            } else if (string.equals("perixml")) {
                fileType = 12;
            } else if (string.equals("gptl")) {
                fileType = 13;
            } else if (string.equals("paraver")) {
                fileType = 14;
            } else if (string.equals("ipm")) {
                fileType = 15;
            } else if (string.equals("google")) {
                fileType = 16;
            } else if (string.equals("darshan")) {
                fileType = 18;
            } else {
                System.err.println("Please enter a valid file type.");
                ParaProf.usage();
                System.exit(-1);
            }
        } else if (stringArray2.length >= 1) {
            fileType = UtilFncs.identifyData((File)sourceFiles[0]);
        }
        if (string2 != null) {
            try {
                if (sourceFiles.length == 0) {
                    FileList fileList = new FileList();
                    sourceFiles = fileList.helperFindSnapshots(System.getProperty("user.dir"));
                }
                if (sourceFiles.length == 0) {
                    System.err.println("No snapshots found\n");
                    System.exit(-1);
                }
                for (int i = 0; i < sourceFiles.length; ++i) {
                    if (2 == UtilFncs.identifyData((File)sourceFiles[i])) continue;
                    System.err.println("Error: File '" + sourceFiles[i] + "' is not a snapshot profile\n");
                    System.exit(-1);
                }
                UtilFncs.mergeSnapshots((File[])sourceFiles, (String)string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.exit(0);
        }
        if (bl10 != null) {
            try {
                bl = false;
                if (bl11 != null) {
                    bl = true;
                }
                object = UtilFncs.initializeDataSource((File[])sourceFiles, (int)fileType, (boolean)fixNames);
                object.load();
                OSSWriter.writeOSS((DataSource)object, bl);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.exit(0);
        }
        if (string3 != null) {
            try {
                File file = new File(string3);
                if (file.exists()) {
                    System.out.println("The file " + string3 + " already exists. Do you want to overwrite?");
                    object = new Scanner(System.in);
                    boolean bl16 = false;
                    boolean bl17 = false;
                    while (!bl16) {
                        System.out.print("[yes/no]: ");
                        Object object2 = ((Scanner)object).nextLine();
                        object2 = ((String)object2).toLowerCase().trim();
                        if (((String)object2).equals("yes") || ((String)object2).equals("y")) {
                            bl17 = true;
                            bl16 = true;
                            continue;
                        }
                        if (!((String)object2).equals("no") && !((String)object2).equals("n")) continue;
                        bl16 = true;
                    }
                    ((Scanner)object).close();
                    if (!bl17) {
                        System.exit(0);
                    }
                }
                object = UtilFncs.initializeDataSource((File[])sourceFiles, (int)fileType, (boolean)fixNames);
                System.out.println("Loading data...");
                object.load();
                System.out.println("Packing data...");
                DataSourceExport.writePacked((DataSource)object, (File)file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.exit(0);
        }
        if (string5 != null) {
            try {
                DataSource dataSource = UtilFncs.initializeDataSource((File[])sourceFiles, (int)fileType, (boolean)fixNames);
                System.out.println("Loading data...");
                dataSource.load();
                System.out.println("Writing data...");
                CommunicationMatrixWindow.writeCommCSV(dataSource, new FileOutputStream(new File(string5)), -1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.exit(0);
        }
        if (string4 != null) {
            try {
                DataSource dataSource = UtilFncs.initializeDataSource((File[])sourceFiles, (int)fileType, (boolean)fixNames);
                System.out.println("Loading data...");
                dataSource.load();
                System.out.println("Writing data...");
                DataSourceExport.writeDelimited((DataSource)dataSource, (OutputStream)new FileOutputStream(new File(string4)));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.exit(0);
        }
        if (bl4 != null && bl4.booleanValue()) {
            try {
                FileList fileList = new FileList();
                object = fileList.helperFindProfiles(".");
                if (!(bl9 != null || bl6 != null && bl6.booleanValue() || bl8 != null && bl8.booleanValue() || object.size() == 0)) {
                    System.err.println("Error: profiles found in current directory, please remove first");
                    return;
                }
                DataSource dataSource = UtilFncs.initializeDataSource((File[])sourceFiles, (int)fileType, (boolean)fixNames);
                Set<Integer> set = null;
                System.out.println("Loading data...");
                if (string6 != null) {
                    set = ParaProf.getRankList(string6);
                    dataSource.setSelectedRank(set);
                }
                dataSource.load();
                System.out.println("Creating TAU Profile data...");
                if (string6 != null) {
                    for (Integer n : set) {
                        Node node = dataSource.getNode(n.intValue());
                        if (node == null) {
                            System.out.println("No profile for rank " + n);
                            continue;
                        }
                        DataSourceExport.writeProfiles((DataSource)dataSource, (File)new File("."), (List)node.getThreads());
                    }
                } else if (bl5 != null) {
                    DataSourceExport.writeAggProfiles((DataSource)dataSource, (File)new File("."));
                } else if (bl6 != null || bl8 != null) {
                    boolean bl18 = false;
                    if (bl8 != null) {
                        bl18 = bl8;
                    }
                    boolean bl19 = false;
                    if (bl7 != null) {
                        bl19 = bl7;
                    }
                    boolean bl20 = false;
                    if (bl6 != null) {
                        bl20 = bl6;
                    }
                    if (bl20) {
                        DataSourceExport.writeAggMPISummary((DataSource)dataSource, (boolean)bl19, (boolean)bl18);
                    } else if (bl18) {
                        DataSourceExport.writeMetaDataSummary((DataSource)dataSource);
                    }
                } else {
                    DataSourceExport.writeProfiles((DataSource)dataSource, (File)new File("."));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.exit(0);
        }
        if (controlMode) {
            ParaProf.initialize();
            ParaProf.loadScripts();
            ExternalController.runController();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ParaProf.initialize();
                        ParaProf.loadScripts();
                        ParaProf.loadDefaultTrial(range);
                    }
                    catch (Exception exception) {
                        ParaProfUtils.handleException(exception);
                    }
                }
            });
        }
    }

    private static Set<Integer> getRankList(String string) {
        string = string.trim();
        String[] stringArray = string.split(",");
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
        for (String string2 : stringArray) {
            if ((string2 = string2.trim()).contains("-")) {
                int n;
                int n2;
                String[] stringArray2 = string2.split("-");
                if (stringArray2.length != 2) {
                    System.out.println("Invalid range specification: " + string2);
                    return null;
                }
                int n3 = Integer.parseInt(stringArray2[0]);
                if (n3 > (n2 = Integer.parseInt(stringArray2[1]))) {
                    n = n3;
                    n3 = n2;
                    n2 = n;
                }
                for (n = n3; n <= n2; ++n) {
                    linkedHashSet.add(n);
                }
                continue;
            }
            linkedHashSet.add(Integer.parseInt(string2));
        }
        return linkedHashSet;
    }

    private static void setUIFont(FontUIResource fontUIResource) {
        Enumeration enumeration = UIManager.getDefaults().keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = UIManager.get(k);
            if (!(object instanceof FontUIResource)) continue;
            UIManager.put(k, fontUIResource);
        }
    }

    static {
        preferences = new Preferences();
        colorMap = new ColorMap();
        applicationManager = new ApplicationManager();
        numWindowsOpen = 0;
        fileType = 1;
        seriesSnap = false;
        sourceFiles = new File[0];
        fixNames = false;
        usePathNameInTrial = false;
        JNLP = false;
        scripts = new ArrayList<ParaProfScript>();
        runtime = Runtime.getRuntime();
    }

    public static class XThrowableHandler {
        public void handle(Throwable throwable) throws Throwable {
            if (throwable instanceof Exception) {
                ParaProfUtils.handleException((Exception)throwable);
            } else {
                System.err.println("Uncaught Throwable: " + throwable.fillInStackTrace());
            }
        }
    }
}

