/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.Thread;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.ScrollPane;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.statistics.SimpleHistogramBin;
import org.jfree.data.statistics.SimpleHistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class PreCompHistogramWindow
extends JFrame {
    private static final long serialVersionUID = 7567591935260297563L;
    private Function function;
    private Thread thread;
    private ChartPanel chartPanel;
    private int numBins;
    private int numHistogramsPerEvent;
    private List<Histogram> histograms = new ArrayList<Histogram>();

    public static PreCompHistogramWindow createHistogramWindow(ParaProfTrial paraProfTrial, Function function, Thread thread, Component component) {
        try {
            PreCompHistogramWindow preCompHistogramWindow = new PreCompHistogramWindow(paraProfTrial, function, thread, component);
            return preCompHistogramWindow;
        }
        catch (Exception exception) {
            throw new DataSourceException(exception);
        }
    }

    private void processData() throws FileNotFoundException, IOException {
        int n;
        int n2 = this.thread.getNodeID();
        String string = "tau.histograms." + n2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        int n3 = Integer.parseInt(bufferedReader.readLine());
        this.numHistogramsPerEvent = Integer.parseInt(bufferedReader.readLine());
        this.numBins = Integer.parseInt(bufferedReader.readLine());
        for (n = 0; n < this.numHistogramsPerEvent; ++n) {
            Histogram histogram = new Histogram();
            histogram.name = bufferedReader.readLine();
            histogram.bins = new int[this.numBins];
            this.histograms.add(histogram);
        }
        n = 0;
        for (int i = 0; i < n3; ++i) {
            int n4;
            String string2 = bufferedReader.readLine().trim();
            if (string2.equals(this.function.getName())) {
                n = 1;
                for (n4 = 0; n4 < this.numHistogramsPerEvent; ++n4) {
                    StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine(), " \t\n\r");
                    this.histograms.get((int)n4).minValue = Double.parseDouble(stringTokenizer.nextToken());
                    this.histograms.get((int)n4).maxValue = Double.parseDouble(stringTokenizer.nextToken());
                    for (int j = 0; j < this.numBins; ++j) {
                        this.histograms.get((int)n4).bins[j] = Integer.parseInt(stringTokenizer.nextToken());
                    }
                }
                continue;
            }
            for (n4 = 0; n4 < this.numHistogramsPerEvent; ++n4) {
                bufferedReader.readLine();
            }
        }
        if (n == 0) {
            System.err.println("Warning, Function \"" + this.function.getName() + "\" not found in histogram");
        }
    }

    private void addHistograms() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new ScrollFlowLayout());
        for (Histogram histogram : this.histograms) {
            SimpleHistogramDataset simpleHistogramDataset = new SimpleHistogramDataset((Comparable)((Object)"foo"));
            double d = (histogram.maxValue - histogram.minValue) / (double)this.numBins;
            double d2 = 1.0;
            if (histogram.name.contains("TIME")) {
                histogram.name = histogram.name + " (seconds)";
                d2 = 1000000.0;
            }
            System.err.println("-------------");
            for (int i = 0; i < this.numBins; ++i) {
                double d3 = histogram.minValue + d * (double)i;
                double d4 = histogram.minValue + d * (double)(i + 1);
                System.out.println("lowerBound = " + (d3 /= d2) + ", upperBound = " + (d4 /= d2));
                SimpleHistogramBin simpleHistogramBin = new SimpleHistogramBin(d3, d4, false, false);
                simpleHistogramBin.setItemCount(histogram.bins[i]);
                simpleHistogramDataset.addBin(simpleHistogramBin);
            }
            simpleHistogramDataset.setAdjustForBinSize(false);
            String string = histogram.name;
            JFreeChart jFreeChart = ChartFactory.createHistogram((String)this.function.getName(), (String)string, (String)"Count", (IntervalXYDataset)simpleHistogramDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            jFreeChart.getXYPlot().getDomainAxis().setUpperBound(histogram.maxValue / d2);
            jFreeChart.getXYPlot().getDomainAxis().setLowerBound(histogram.minValue / d2);
            ((XYBarRenderer)jFreeChart.getXYPlot().getRenderer()).setMargin(0.1);
            ((XYBarRenderer)jFreeChart.getXYPlot().getRenderer()).setBaseOutlinePaint((Paint)Color.black);
            Utility.applyDefaultChartTheme((JFreeChart)jFreeChart);
            this.chartPanel = new ChartPanel(jFreeChart);
            System.out.println("size = " + this.chartPanel.getPreferredSize());
            this.chartPanel.setMinimumSize(this.chartPanel.getPreferredSize());
            jPanel.add((Component)this.chartPanel);
        }
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.add(jPanel);
        jPanel.setLayout(new ScrollFlowLayout(scrollPane));
        this.setContentPane(scrollPane);
    }

    private PreCompHistogramWindow(ParaProfTrial paraProfTrial, Function function, Thread thread, Component component) throws Exception {
        this.function = function;
        this.thread = thread;
        this.setTitle("TAU: ParaProf: Histogram: " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        ParaProfUtils.setFrameIcon(this);
        this.setSize(ParaProfUtils.checkSize(new Dimension(710, 460)));
        this.setLocation(WindowPlacer.getNewLocation(this, component));
        this.processData();
        this.addHistograms();
    }

    private static class Histogram {
        public String name;
        public int[] bins;
        public double minValue;
        public double maxValue;

        private Histogram() {
        }
    }

    public static class ModifiedFlowLayout
    extends FlowLayout {
        private static final long serialVersionUID = -8833423063395605627L;

        public ModifiedFlowLayout() {
        }

        public ModifiedFlowLayout(int n) {
            super(n);
        }

        public ModifiedFlowLayout(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.computeSize(container, false);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.computeSize(container, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension computeSize(Container container, boolean bl) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Insets insets;
                int n = this.getHgap();
                int n2 = this.getVgap();
                int n3 = container.getWidth();
                if (n3 == 0) {
                    n3 = Integer.MAX_VALUE;
                }
                if ((insets = container.getInsets()) == null) {
                    insets = new Insets(0, 0, 0, 0);
                }
                int n4 = 0;
                int n5 = n3 - (insets.left + insets.right + n * 2);
                int n6 = container.getComponentCount();
                int n7 = 0;
                int n8 = insets.top;
                int n9 = 0;
                for (int i = 0; i < n6; ++i) {
                    Dimension dimension;
                    Component component = container.getComponent(i);
                    if (!component.isVisible()) continue;
                    Dimension dimension2 = dimension = bl ? component.getMinimumSize() : component.getPreferredSize();
                    if (n7 == 0 || n7 + dimension.width <= n5) {
                        if (n7 > 0) {
                            n7 += n;
                        }
                        n7 += dimension.width;
                        n9 = Math.max(n9, dimension.height);
                    } else {
                        n7 = dimension.width;
                        n8 += n2 + n9;
                        n9 = dimension.height;
                    }
                    n4 = Math.max(n4, n7);
                }
                return new Dimension(n4 + insets.left + insets.right, n8 += n9);
            }
        }
    }

    public static class ScrollFlowLayout
    extends FlowLayout {
        private static final long serialVersionUID = -6745516606462710969L;
        public static final int LEFT_TO_RIGHT = 0;
        public static final int RIGHT_TO_LEFT = 1;
        public static final int TOP_TO_BOTTOM = 2;
        private int orientation = 0;
        private ScrollPane sp = null;

        public ScrollFlowLayout() {
        }

        public ScrollFlowLayout(ScrollPane scrollPane) {
            this.sp = scrollPane;
        }

        public ScrollFlowLayout(ScrollPane scrollPane, int n) {
            this.sp = scrollPane;
            this.orientation = n;
        }

        public int getTallestElement(Container container) {
            int n = container.getComponentCount();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                int n3 = component.getMinimumSize().height;
                n2 = n2 > n3 ? n2 : n3;
            }
            return n2;
        }

        public int getWidestElement(Container container) {
            int n = container.getComponentCount();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                int n3 = component.getMinimumSize().width;
                n2 = n2 > n3 ? n2 : n3;
            }
            return n2;
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int n;
            int n2 = container.getSize().height - container.getInsets().bottom - container.getInsets().top;
            int n3 = container.getSize().width;
            if (this.sp != null) {
                n2 = this.sp.getSize().height - this.sp.getInsets().bottom - this.sp.getInsets().top;
                n3 = this.sp.getSize().width;
            }
            if ((n = container.getComponentCount()) == 0) {
                return new Dimension(0, 0);
            }
            int n4 = this.getWidestElement(container);
            int n5 = this.getTallestElement(container);
            int n6 = n5 > n2 ? 1 : n2 / n5;
            int n7 = (int)Math.ceil((double)n / (double)n6);
            if (this.orientation == 0) {
                n7 = n4 > n3 ? 1 : n3 / n4;
                n6 = (int)Math.ceil((double)n / (double)n7);
            }
            Dimension dimension = new Dimension(n7 * n4, n6 * n5);
            return dimension;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                int n = container.getSize().height - container.getInsets().bottom - container.getInsets().top;
                int n2 = container.getSize().width;
                if (this.sp != null) {
                    n = this.sp.getSize().height - this.sp.getInsets().bottom - this.sp.getInsets().top;
                    n2 = this.sp.getSize().width;
                }
                int n3 = container.getComponentCount();
                int n4 = this.getWidestElement(container);
                int n5 = this.getTallestElement(container);
                if (n3 == 0) {
                    return;
                }
                container.invalidate();
                if (this.orientation == 0) {
                    int n6 = 0;
                    int n7 = n4 > n2 ? 1 : n2 / n4;
                    int n8 = (int)Math.ceil((double)n3 / (double)n7);
                    for (int i = 0; i < n8; ++i) {
                        for (int j = 0; j < n7; ++j) {
                            if (n6 < n3) {
                                int n9 = j * n4;
                                int n10 = i * n5;
                                container.getComponent(n6).setBounds(n9, n10, n4, n5);
                            }
                            ++n6;
                        }
                    }
                } else if (this.orientation == 2) {
                    int n11 = n5 > n ? 1 : n / n5;
                    int n12 = (int)Math.ceil((double)n3 / (double)n11);
                    int n13 = 0;
                    for (int i = 0; i < n12; ++i) {
                        for (int j = 0; j < n11; ++j) {
                            if (n13 < n3) {
                                int n14 = i * n4;
                                int n15 = j * n5;
                                container.getComponent(n13).setBounds(n14, n15, n4, n5);
                            }
                            ++n13;
                        }
                    }
                }
            }
        }
    }
}

