/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPThread;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfMetric;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.paraprof.interfaces.ToolBarListener;
import edu.uoregon.tau.paraprof.util.ObjectFilter;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Snapshot;
import edu.uoregon.tau.perfdmf.Thread;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Printable;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;

public class SnapshotBreakdownWindow
extends JFrame
implements Observer,
ParaProfWindow,
ImageExport,
ToolBarListener {
    private static final long serialVersionUID = -672895438624791671L;
    private ParaProfTrial ppTrial;
    private Thread thread;
    private ChartPanel panel;
    private DataSorter dataSorter;
    private static int defaultWidth = 750;
    private static int defaultHeight = 610;
    private DefaultTableXYDataset dataSet = new DefaultTableXYDataset();
    private boolean timeline = true;
    private boolean differential = true;
    private boolean middleTime = true;
    private boolean square = true;
    private boolean topTen = true;
    private static final String ST_TOP_TEN = "Top 20";
    private static final String ST_DIFFERENTIAL = "Differential";
    private static final String ST_SQUARE = "Square";
    private static final String ST_TIMELINE = "Timeline";
    private static final int STYLE_STACKED = 0;
    private static final int STYLE_TRANSPARENT_AREA = 1;
    private static final int STYLE_LINE = 2;
    private static final String ST_STYLE_STACKED = "Stacked";
    private static final String ST_STYLE_TRANSPARENT_AREA = "Area";
    private static final String ST_STYLE_LINE = "Line";
    private JFreeChart chart;
    private JToggleButton button_topTen = new JToggleButton("Top 20", this.topTen);
    private JToggleButton button_square = new JToggleButton("Square", this.square);
    private JToggleButton button_timeline = new JToggleButton("Timeline", this.square);
    private JToggleButton button_differential = new JToggleButton("Differential", this.differential);
    private static final int topNum = 20;
    private ObjectFilter filter;
    private int style = 0;

    public SnapshotBreakdownWindow(ParaProfTrial paraProfTrial, Thread thread, Component component) {
        this.ppTrial = paraProfTrial;
        this.thread = thread;
        PPThread pPThread = new PPThread(thread, paraProfTrial);
        this.filter = new ObjectFilter(thread.getSnapshots());
        this.filter.addObserver(this);
        paraProfTrial.addObserver(this);
        this.setTitle("TAU: ParaProf: Snapshots for " + pPThread.getFullName() + " - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SnapshotBreakdownWindow.this.closeThisWindow();
            }
        });
        this.dataSorter = new DataSorter(paraProfTrial);
        this.createToolbar();
        this.chart = this.createChart();
        this.panel = new ChartPanel(this.chart);
        this.getContentPane().add((Component)this.panel);
        this.setSize(ParaProfUtils.checkSize(new Dimension(defaultWidth, defaultHeight)));
        this.setLocation(WindowPlacer.getNewLocation(this, component));
        this.setupMenus();
        ParaProfUtils.setFrameIcon(this);
        ParaProf.incrementNumWindows();
    }

    private void recreateChart() {
        this.topTen = this.button_topTen.isSelected();
        this.square = this.button_square.isSelected();
        this.timeline = this.button_timeline.isSelected();
        this.differential = this.button_differential.isSelected();
        this.getContentPane().remove((Component)this.panel);
        this.chart = this.createChart();
        this.panel = new ChartPanel(this.chart);
        this.getContentPane().add((Component)this.panel);
        this.validate();
        this.repaint();
    }

    private void createToolbar() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotBreakdownWindow.this.recreateChart();
            }
        };
        Vector<String> vector = new Vector<String>();
        vector.add(ST_STYLE_STACKED);
        vector.add(ST_STYLE_TRANSPARENT_AREA);
        vector.add(ST_STYLE_LINE);
        final JComboBox jComboBox = new JComboBox(vector);
        jComboBox.setMaximumSize(jComboBox.getPreferredSize());
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotBreakdownWindow.this.setStyle(jComboBox.getSelectedIndex());
                SnapshotBreakdownWindow.this.toolBarUsed();
            }
        });
        this.button_topTen.addActionListener(actionListener);
        this.button_square.addActionListener(actionListener);
        this.button_differential.addActionListener(actionListener);
        this.button_timeline.addActionListener(actionListener);
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(this.button_topTen);
        jToolBar.add(this.button_square);
        jToolBar.add(this.button_differential);
        jToolBar.add(this.button_timeline);
        jToolBar.addSeparator();
        jToolBar.add(jComboBox);
        jToolBar.addSeparator();
        ParaProfUtils.createMetricToolbarItems(jToolBar, this.ppTrial, this.dataSorter, this);
        jToolBar.addSeparator();
        this.getContentPane().add((Component)jToolBar, "North");
    }

    public void setStyle(int n) {
        this.style = n;
    }

    private JFreeChart createChart() {
        Object object;
        Object object2;
        this.dataSet = new DefaultTableXYDataset();
        this.dataSet.removeAllSeries();
        this.dataSorter.setDescendingOrder(true);
        List list = this.thread.getSnapshots();
        this.dataSorter.setSelectedSnapshotOverride(true);
        this.dataSorter.setSelectedSnapshot(-1);
        List<FunctionProfile> list2 = this.dataSorter.getBasicFunctionProfiles(this.thread);
        long l = this.thread.getStartTime();
        long l2 = 0L;
        int n = list2.size();
        if (this.topTen) {
            n = Math.min(21, list2.size());
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            FunctionProfile functionProfile = list2.get(i);
            if (this.topTen && i == 20) {
                object2 = new XYSeries((Comparable)((Object)"Other"), true, false);
            } else {
                object = functionProfile.getName();
                while (((String)object).indexOf("[{") != -1) {
                    n3 = ((String)object).indexOf("[{");
                    n2 = ((String)object).indexOf("}]");
                    object = ((String)object).substring(0, n3) + ((String)object).substring(n2 + 2);
                }
                object2 = new XYSeries((Comparable)object, true, false);
            }
            object = this.filter.getFilteredObjects();
            for (n3 = 0; n3 < object.size(); ++n3) {
                long l3;
                double d;
                int n4 = n2 = ((Snapshot)object.get(n3)).getID();
                if (this.topTen && i == 20) {
                    d = 0.0;
                    for (int j = i; j < list2.size(); ++j) {
                        FunctionProfile functionProfile2 = list2.get(j);
                        if (this.differential && n4 != 0) {
                            d += this.dataSorter.getValue(functionProfile2, n4) - this.dataSorter.getValue(functionProfile2, n4 - 1);
                            continue;
                        }
                        d += this.dataSorter.getValue(functionProfile2, n4);
                    }
                } else {
                    d = this.differential && n4 != 0 ? this.dataSorter.getValue(functionProfile, n4) - this.dataSorter.getValue(functionProfile, n4 - 1) : this.dataSorter.getValue(functionProfile, n4);
                }
                Snapshot snapshot = (Snapshot)list.get(n2);
                l2 = l3 = snapshot.getTimestamp() - l;
                if (this.timeline) {
                    long l4;
                    long l5;
                    if (n2 == 0) {
                        l5 = l;
                        l4 = 0L;
                    } else {
                        Snapshot snapshot2 = (Snapshot)list.get(n2 - 1);
                        l5 = snapshot2.getTimestamp();
                        l4 = snapshot2.getTimestamp() - l;
                    }
                    if (this.square) {
                        object2.add(1.0E-4 + (double)l4 / 1000000.0, d);
                        object2.add((double)l3 / 1000000.0, d);
                        continue;
                    }
                    if (this.middleTime) {
                        double d2 = l3 - (snapshot.getTimestamp() - l5) / 2L;
                        object2.add(d2 / 1000000.0, d);
                        continue;
                    }
                    object2.add((double)l3 / 1000000.0, d);
                    continue;
                }
                if (this.square) {
                    object2.add((double)n2, d);
                    object2.add((double)n2 + 0.9999, d);
                    continue;
                }
                object2.add((double)n2, d);
            }
            this.dataSet.addSeries(object2);
        }
        ParaProfMetric paraProfMetric = (ParaProfMetric)this.dataSorter.getSelectedMetric();
        int n5 = this.dataSorter.getValueType().getUnits(0, paraProfMetric);
        object2 = this.dataSorter.getValueType().getSuffix(n5, paraProfMetric).trim();
        object = this.dataSorter.getValueType() + " (" + (String)object2 + ")";
        JFreeChart jFreeChart = null;
        if (this.style == 0) {
            jFreeChart = ChartFactory.createStackedXYAreaChart((String)"Snapshot Breakdown", (String)"Snapshots", (String)object, (TableXYDataset)this.dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        } else if (this.style == 1) {
            jFreeChart = ChartFactory.createXYAreaChart((String)"Snapshot Breakdown", (String)"Snapshots", (String)object, (XYDataset)this.dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            jFreeChart.getPlot().setForegroundAlpha(0.4f);
        } else if (this.style == 2) {
            jFreeChart = ChartFactory.createXYLineChart((String)"Snapshot Breakdown", (String)"Snapshots", (String)object, (XYDataset)this.dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        } else {
            throw new ParaProfException("Unrecognized style: " + this.style);
        }
        if (this.timeline) {
            XYPlot xYPlot = jFreeChart.getXYPlot();
            NumberAxis numberAxis = new NumberAxis("Timeline (seconds)");
            numberAxis.setRange(new Range(0.0, (double)l2 / 1000000.0));
            xYPlot.setDomainAxis(0, (ValueAxis)numberAxis);
        } else {
            XYPlot xYPlot = jFreeChart.getXYPlot();
            NumberAxis numberAxis = new NumberAxis("Snapshots");
            numberAxis.setRange(new Range(0.0, (double)list.size()));
            xYPlot.setDomainAxis(0, (ValueAxis)numberAxis);
        }
        return jFreeChart;
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Filter");
        JMenuItem jMenuItem = new JMenuItem("Filter Snapshots");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotBreakdownWindow.this.filter.showFrame("Filter Snapshots");
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(ParaProfUtils.createFileMenu(this, (Printable)this.panel, this));
        jMenuBar.add(jMenu);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        if (ParaProf.scripts.size() > 0) {
            jMenuBar.add(ParaProfUtils.createScriptMenu(this.ppTrial, this));
        }
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    @Override
    public void update(Observable observable, Object object) {
        this.recreateChart();
    }

    @Override
    public void closeThisWindow() {
        try {
            this.filter.closeWindow();
            this.setVisible(false);
            this.ppTrial.deleteObserver(this);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.dispose();
    }

    @Override
    public void help(boolean bl) {
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        this.panel.setDoubleBuffered(false);
        this.panel.paintAll((Graphics)graphics2D);
        this.panel.setDoubleBuffered(true);
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        return this.panel.getSize();
    }

    @Override
    public void toolBarUsed() {
        this.recreateChart();
    }

    @Override
    public JFrame getFrame() {
        return this;
    }
}

