/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import com.graphbuilder.math.Expression;
import com.graphbuilder.math.ExpressionTree;
import com.graphbuilder.math.FuncMap;
import com.graphbuilder.math.VarMap;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.perfdmf.Thread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ThreeDeeGeneralPlotUtils {
    static final String BEGIN = "BEGIN_VIZ";
    static final String END = "END_VIZ";
    private static final String metadata = "metadata(";

    public static VarMap getEvaluation(int n, int n2, Thread thread, ParaProfTrial paraProfTrial, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int[] nArray, Map<String, String> map) {
        FuncMap funcMap = new FuncMap();
        funcMap.loadDefaultFunctions();
        VarMap varMap = new VarMap(false);
        varMap.setValue("maxRank", (double)n2);
        varMap.setValue("rank", (double)n);
        varMap.setValue("color", (double)fArray[3]);
        varMap.setValue("node", (double)thread.getNodeID());
        varMap.setValue("context", (double)thread.getContextID());
        varMap.setValue("thread", (double)thread.getThreadID());
        varMap.setValue("event0.val", (double)fArray[0]);
        varMap.setValue("event1.val", (double)fArray[1]);
        varMap.setValue("event2.val", (double)fArray[2]);
        varMap.setValue("event3.val", (double)fArray[3]);
        varMap.setValue("event0.min", (double)fArray2[0]);
        varMap.setValue("event1.min", (double)fArray2[1]);
        varMap.setValue("event2.min", (double)fArray2[2]);
        varMap.setValue("event3.min", (double)fArray2[3]);
        varMap.setValue("event0.max", (double)fArray3[0]);
        varMap.setValue("event1.max", (double)fArray3[1]);
        varMap.setValue("event2.max", (double)fArray3[2]);
        varMap.setValue("event3.max", (double)fArray3[3]);
        varMap.setValue("event0.mean", (double)fArray4[0]);
        varMap.setValue("event1.mean", (double)fArray4[1]);
        varMap.setValue("event2.mean", (double)fArray4[2]);
        varMap.setValue("event3.mean", (double)fArray4[3]);
        varMap.setValue("axisDimX", (double)nArray[0]);
        varMap.setValue("axisDimY", (double)nArray[1]);
        varMap.setValue("axisDimZ", (double)nArray[2]);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Expression expression = ExpressionTree.parse((String)ThreeDeeGeneralPlotUtils.insertMetaDataValues(entry.getValue(), thread));
            double d = expression.eval(varMap, funcMap);
            varMap.setValue(entry.getKey(), d);
        }
        return varMap;
    }

    private static String insertMetaDataValues(String string, Thread thread) {
        int n = 0;
        while (n >= 0) {
            int n2 = string.indexOf(metadata, n);
            if (n2 == -1) {
                return string;
            }
            int n3 = string.indexOf(41, n2);
            String string2 = string.substring(n2 + 9, n3);
            String string3 = thread.getMetaData().get(string2);
            if (string3 == null && (string3 = thread.getDataSource().getMetaData().get(string2)) == null) {
                System.out.println("Metadata key " + string2 + " not found at top or in node,thread " + thread.getNodeID() + "," + thread.getThreadID() + ". Using 0");
                string3 = "0";
            }
            try {
                Double.parseDouble(string3);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Metadata key " + string2 + " is non-numeric in node,thread " + thread.getNodeID() + "," + thread.getThreadID() + ". Using 0");
                string3 = "0";
            }
            string = string.substring(0, n2) + string3 + string.substring(n3 + 1);
            n = n3;
        }
        return string;
    }

    private static String[] splitEQ(String string) {
        String[] stringArray = new String[2];
        int n = string.indexOf(61);
        stringArray[0] = string.substring(0, n).trim();
        stringArray[1] = string.substring(n + 1).trim();
        return stringArray;
    }

    public static Map<String, String> getExpressions(String string, String string2) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
            boolean bl = false;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!bl && string3.startsWith(BEGIN) && ThreeDeeGeneralPlotUtils.splitEQ(string3)[1].equals(string2)) {
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                if (string3.equals(END)) break;
                if (!string3.contains("=") || string3.startsWith("#")) continue;
                String[] stringArray = ThreeDeeGeneralPlotUtils.splitEQ(string3);
                linkedHashMap.put(stringArray[0], stringArray[1]);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return linkedHashMap;
    }

    public static boolean checkSet(VarMap varMap, String string) {
        String[] stringArray = varMap.getVariableNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static int getPointsPerRank(VarMap varMap) {
        int n = 0;
        boolean bl = ThreeDeeGeneralPlotUtils.checkSet(varMap, "x");
        if (!bl) {
            bl = true;
            while (bl && (bl = ThreeDeeGeneralPlotUtils.checkSet(varMap, "x" + n))) {
                ++n;
            }
        }
        return n;
    }

    public static double[][] getRankCoordinate(VarMap varMap, int n, boolean bl) {
        double[][] dArray = null;
        if (n == 0) {
            dArray = new double[1][4];
            dArray[0][0] = varMap.getValue("x");
            dArray[0][1] = varMap.getValue("y");
            dArray[0][2] = varMap.getValue("z");
            dArray[0][3] = varMap.getValue("color");
        } else {
            dArray = new double[n][4];
            --n;
            for (int i = 0; i <= n; ++i) {
                dArray[i][0] = varMap.getValue("x" + i);
                dArray[i][1] = varMap.getValue("y" + i);
                dArray[i][2] = varMap.getValue("z" + i);
                dArray[i][3] = bl ? varMap.getValue("color" + i) : varMap.getValue("color");
            }
        }
        return dArray;
    }

    public static int[] parseMPIProcName(String string) {
        String string2 = string.substring(string.indexOf(40), string.indexOf(41) + 1);
        return ThreeDeeGeneralPlotUtils.parseTuple(string2);
    }

    public static int[] parseTuple(String string) {
        String[] stringArray = (string = string.substring(1, string.length() - 1)).split(",");
        int n = stringArray.length;
        if (n < 3) {
            n = 3;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i < stringArray.length ? Integer.parseInt(stringArray[i]) : 0;
        }
        return nArray;
    }

    public static List<String> getCustomTopoNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.startsWith(BEGIN)) continue;
                int n = string2.indexOf(61);
                String string3 = string2.substring(n + 1);
                arrayList.add(string3);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList;
    }

    public static int[] parseCrayNodeID(String string) {
        int[] nArray = new int[5];
        int n = string.indexOf(45);
        int n2 = string.indexOf(99, n);
        int n3 = string.indexOf(115, n2);
        int n4 = string.indexOf(110, n3);
        nArray[0] = Integer.parseInt(string.substring(1, n));
        nArray[1] = Integer.parseInt(string.substring(n + 1, n2));
        nArray[2] = Integer.parseInt(string.substring(n2 + 1, n3));
        nArray[3] = Integer.parseInt(string.substring(n3 + 1, n4));
        nArray[4] = Integer.parseInt(string.substring(n4 + 1));
        return nArray;
    }

    private static float[][] getCTMinMax(CrayTopology[] crayTopologyArray) {
        CrayTopology crayTopology = new CrayTopology();
        float[][] fArray = new float[3][3];
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        HashMap hashMap = new HashMap();
        for (CrayTopology crayTopology2 : crayTopologyArray) {
            String string = crayTopology2.x + "_" + crayTopology2.y + "_" + crayTopology2.z;
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new HashSet());
            }
            ((Set)hashMap.get(string)).add(crayTopology2.nid);
            if (bl) {
                crayTopology.cpu = crayTopology2.cpu;
                crayTopology.x = crayTopology2.x;
                crayTopology.y = crayTopology2.y;
                crayTopology.z = crayTopology2.z;
                crayTopology.mpirank = crayTopology2.mpirank;
                n = crayTopology2.x;
                n2 = crayTopology2.y;
                n3 = crayTopology2.z;
                bl = false;
                continue;
            }
            crayTopology.mpirank = Math.max(crayTopology.mpirank, crayTopology2.mpirank);
            crayTopology.cpu = Math.max(crayTopology.cpu, crayTopology2.cpu);
            crayTopology.x = Math.max(crayTopology.x, crayTopology2.x);
            crayTopology.y = Math.max(crayTopology.y, crayTopology2.y);
            crayTopology.z = Math.max(crayTopology.z, crayTopology2.z);
            n = Math.min(n, crayTopology2.x);
            n2 = Math.min(n2, crayTopology2.y);
            n3 = Math.min(n3, crayTopology2.z);
        }
        fArray[0][0] = n;
        fArray[0][1] = n2;
        fArray[0][2] = n3;
        fArray[1][0] = crayTopology.x;
        fArray[1][1] = crayTopology.y;
        fArray[1][2] = crayTopology.z;
        fArray[2][0] = crayTopology.cpu;
        fArray[2][1] = crayTopology.mpirank;
        int n4 = 0;
        for (Set set : hashMap.values()) {
            n4 = Math.max(n4, set.size());
        }
        fArray[2][2] = n4;
        return fArray;
    }

    private static void routerCoordsToNodeCoords(CrayTopology[] crayTopologyArray, int n) {
        for (CrayTopology crayTopology : crayTopologyArray) {
            crayTopology.x = crayTopology.x * n + crayTopology.getNodeIndex(n) % n;
        }
    }

    private static void nodeCoordsToCoreCoords(CrayTopology[] crayTopologyArray, int n) {
        int n2 = 1;
        int n3 = ++n;
        for (int i = (int)Math.ceil(Math.sqrt(n)); i > 1; --i) {
            if (n % i != 0) continue;
            n2 = i;
            n3 = n / i;
            break;
        }
        for (CrayTopology crayTopology : crayTopologyArray) {
            crayTopology.x *= n2;
            crayTopology.z *= n3;
            crayTopology.x += crayTopology.cpu % n2;
            crayTopology.z += crayTopology.cpu / n2;
        }
    }

    private static void validateCoords(CrayTopology[] crayTopologyArray) {
        for (int i = 0; i < crayTopologyArray.length; ++i) {
            CrayTopology crayTopology = crayTopologyArray[i];
            for (int j = i + 1; j < crayTopologyArray.length; ++j) {
                String string;
                String string2;
                CrayTopology crayTopology2 = crayTopologyArray[j];
                if (crayTopology.mpirank == crayTopology2.mpirank || !(string2 = crayTopology.x + "_" + crayTopology.y + "_" + crayTopology.z).equals(string = crayTopology2.x + "_" + crayTopology2.y + "_" + crayTopology2.z)) continue;
                System.out.println("ERROR:\n" + crayTopology.toString() + "\n overlaps\n" + crayTopology2.toString());
            }
        }
    }

    public static CoordMap processCrayCoordinates(CrayTopology[] crayTopologyArray) {
        Arrays.sort(crayTopologyArray);
        float[][] fArray = ThreeDeeGeneralPlotUtils.getCTMinMax(crayTopologyArray);
        int n = (int)fArray[2][2];
        ThreeDeeGeneralPlotUtils.routerCoordsToNodeCoords(crayTopologyArray, n);
        int n2 = (int)fArray[2][0];
        ThreeDeeGeneralPlotUtils.nodeCoordsToCoreCoords(crayTopologyArray, n2);
        ThreeDeeGeneralPlotUtils.validateCoords(crayTopologyArray);
        float[][] fArray2 = new float[crayTopologyArray.length][3];
        for (CrayTopology crayTopology : crayTopologyArray) {
            fArray2[crayTopology.mpirank][0] = crayTopology.x;
            fArray2[crayTopology.mpirank][1] = crayTopology.y;
            fArray2[crayTopology.mpirank][2] = crayTopology.z;
        }
        fArray = ThreeDeeGeneralPlotUtils.getCTMinMax(crayTopologyArray);
        CoordMap coordMap = new CoordMap(fArray[0], fArray[1], fArray2);
        return coordMap;
    }

    public static int[][] parseMapFile(String string) {
        int[][] nArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        ArrayList<String> arrayList2 = null;
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
            arrayList2 = new ArrayList<String>();
            while ((string2 = bufferedReader.readLine()) != null) {
                arrayList.add(string2);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        boolean bl = true;
        for (String object2 : arrayList) {
            if (object2.indexOf(91) != -1) {
                bl = false;
                continue;
            }
            ++n;
        }
        nArray = new int[n][4];
        HashMap hashMap = new HashMap();
        HashMap<String, HostCoords> hashMap2 = new HashMap<String, HostCoords>();
        HostCoords hostCoords = null;
        HostCoords hostCoords2 = null;
        for (String string2 : arrayList) {
            int n2;
            if (string2.length() == 0) continue;
            if (string2.indexOf(91) != -1) {
                int n3;
                int n4 = string2.indexOf(95) + 1;
                n2 = string2.indexOf(93);
                String string3 = string2.substring(n4, n2);
                int n5 = Integer.parseInt(string3);
                n4 = string2.indexOf(61) + 2;
                n2 = string2.length();
                string3 = string2.substring(n4, n2);
                nArray[n5][3] = n3 = string3.indexOf(49);
                continue;
            }
            String[] stringArray = string2.split(":");
            n2 = Integer.parseInt(stringArray[0]);
            int n6 = arrayList2.indexOf(stringArray[1]);
            if (n6 == -1) {
                HostCoords hostCoords3 = new HostCoords(stringArray[1]);
                if (hostCoords == null) {
                    hostCoords = new HostCoords(hostCoords3);
                    hostCoords2 = new HostCoords(hostCoords3);
                } else {
                    hostCoords.minimize(hostCoords3);
                    hostCoords2.maximize(hostCoords3);
                }
                hashMap2.put(stringArray[1], hostCoords3);
                arrayList2.add(stringArray[1]);
                n6 = arrayList2.size() - 1;
                if (bl) {
                    hashMap.put(stringArray[1], 0);
                }
            }
            ((HostCoords)hashMap2.get((Object)stringArray[1])).ranks.add(n2);
            nArray[n2][0] = n6 % 10;
            nArray[n2][1] = n6 / 10 % 8;
            nArray[n2][2] = n6 / 10 / 8;
            if (!bl) continue;
            int n7 = (Integer)hashMap.get(stringArray[1]);
            nArray[n2][3] = n7++;
            hashMap.put(stringArray[1], n7);
        }
        System.out.println("min " + hostCoords.toString());
        System.out.println("max " + hostCoords2.toString());
        for (Map.Entry entry : hashMap2.entrySet()) {
            HostCoords hostCoords4 = (HostCoords)entry.getValue();
            hostCoords4.calculateXYZ(hostCoords, hostCoords2);
            for (int n8 : ((HostCoords)entry.getValue()).ranks) {
                nArray[n8][0] = hostCoords4.x;
                nArray[n8][1] = hostCoords4.y;
                nArray[n8][2] = hostCoords4.z;
            }
            System.out.println((String)entry.getKey() + ": x=" + hostCoords4.x + " y=" + hostCoords4.y + " z=" + hostCoords4.z);
        }
        return nArray;
    }

    public static CoordMap calculateCoreCoordinates(int[][] nArray, int[] nArray2) {
        int n = nArray.length;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n2 = 1;
        float[][] fArray3 = new float[n][3];
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i][3];
            for (int j = 0; j < 3; ++j) {
                int n4 = nArray2[0] + 2;
                if (j == 1) {
                    n4 = nArray2[1] - 1;
                }
                if (j == 2) {
                    n4 = nArray2[2] - 1;
                }
                int n5 = n3 / n4 % nArray2[j];
                int n6 = n5 + nArray[i][j] * (nArray2[j] + n2);
                fArray3[i][j] = n6;
                if (i == 0) {
                    fArray2[j] = n6;
                    fArray[j] = n6;
                    continue;
                }
                fArray2[j] = Math.max(fArray2[j], (float)n6);
                fArray[j] = Math.min(fArray[j], (float)n6);
            }
            System.out.println(i + ": " + fArray3[i][0] + "," + fArray3[i][1] + "," + fArray3[i][2]);
        }
        System.out.println("min: " + fArray[0] + "," + fArray[1] + "," + fArray[2]);
        System.out.println("max: " + fArray2[0] + "," + fArray2[1] + "," + fArray2[2]);
        return new CoordMap(fArray, fArray2, fArray3);
    }

    public static void main(String[] stringArray) {
        ThreeDeeGeneralPlotUtils.parseMapFile(stringArray[0]);
    }

    public static class CrayTopology
    implements Comparable<CrayTopology> {
        public int mpirank;
        public String cname;
        public int nid;
        public int x;
        public int y;
        public int z;
        public int cpu;
        int nodeIndex = -1;

        public CrayTopology(int n, String string, int n2, int n3, int n4, int n5, int n6) {
            this.mpirank = n;
            this.cname = string;
            if (string == null || string.length() == 0) {
                System.out.println("Warning: Cray Node Name Empty or Null on rank: " + n);
            }
            this.nid = n2;
            this.x = n3;
            this.y = n4;
            this.z = n5;
            this.cpu = n6;
        }

        public CrayTopology() {
        }

        @Override
        public int compareTo(CrayTopology crayTopology) {
            if (this.mpirank < crayTopology.mpirank) {
                return -1;
            }
            if (this.mpirank > crayTopology.mpirank) {
                return 1;
            }
            return 0;
        }

        private void calculateNodeIndex(int n) {
            int n2 = this.cname.indexOf("n");
            String string = this.cname.substring(n2 + 1);
            int n3 = Integer.parseInt(string);
            this.nodeIndex = n3 % n;
        }

        public int getNodeIndex(int n) {
            if (this.nodeIndex == -1) {
                this.calculateNodeIndex(n);
            }
            return this.nodeIndex;
        }

        public String toString() {
            return "{ \"mpirank\":" + this.mpirank + ", \"cname\":\"" + this.cname + "\", \"nid\":" + this.nid + ", \"x\":" + this.x + ", \"y\":" + this.y + ", \"z\":" + this.z + ", \"cpu\":" + this.cpu + " }";
        }
    }

    public static class HostCoords {
        int rackX;
        int rackY;
        int cage;
        int slot;
        int node;
        int x;
        int y;
        int z;
        String hostname;
        Set<Integer> ranks = new HashSet<Integer>();

        public String toString() {
            return "HostCoords [rackX=" + this.rackX + ", rackY=" + this.rackY + ", cage=" + this.cage + ", slot=" + this.slot + ", node=" + this.node + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", ranks=" + this.ranks + "]";
        }

        public HostCoords(String string) {
            int[] nArray = ThreeDeeGeneralPlotUtils.parseCrayNodeID(string);
            this.rackX = nArray[0];
            this.rackY = nArray[1];
            this.cage = nArray[2];
            this.slot = nArray[3];
            this.node = nArray[4];
            this.hostname = string;
        }

        public HostCoords(HostCoords hostCoords) {
            this.rackX = hostCoords.rackX;
            this.rackY = hostCoords.rackY;
            this.cage = hostCoords.cage;
            this.slot = hostCoords.slot;
            this.node = hostCoords.node;
            this.x = hostCoords.x;
            this.y = hostCoords.y;
            this.z = hostCoords.z;
            this.hostname = hostCoords.hostname;
        }

        public HostCoords(int n, int n2, int n3, int n4, int n5) {
            this.rackX = n;
            this.rackY = n2;
            this.cage = n3;
            this.slot = n4;
            this.node = n5;
            this.hostname = "c" + n + "-" + n2 + "c" + n3 + "s" + n4 + "n" + n5;
        }

        public void minimize(HostCoords hostCoords) {
            this.rackX = Math.min(this.rackX, hostCoords.rackX);
            this.rackY = Math.min(this.rackY, hostCoords.rackY);
            this.cage = Math.min(this.cage, hostCoords.cage);
            this.slot = Math.min(this.slot, hostCoords.slot);
            this.node = Math.min(this.node, hostCoords.node);
            this.x = Math.min(this.x, hostCoords.x);
            this.y = Math.min(this.y, hostCoords.y);
            this.z = Math.min(this.z, hostCoords.z);
        }

        public void maximize(HostCoords hostCoords) {
            this.rackX = Math.max(this.rackX, hostCoords.rackX);
            this.rackY = Math.max(this.rackY, hostCoords.rackY);
            this.cage = Math.max(this.cage, hostCoords.cage);
            this.slot = Math.max(this.slot, hostCoords.slot);
            this.node = Math.max(this.node, hostCoords.node);
            this.x = Math.max(this.x, hostCoords.x);
            this.y = Math.max(this.y, hostCoords.y);
            this.z = Math.max(this.z, hostCoords.z);
        }

        public void calculateXYZ(HostCoords hostCoords, HostCoords hostCoords2) {
            int n = hostCoords2.rackX - hostCoords.rackX + 1;
            int n2 = hostCoords2.rackY - hostCoords.rackY + 1;
            int n3 = 1;
            int n4 = 1;
            int n5 = hostCoords2.cage - hostCoords.cage + 1;
            int n6 = 1;
            this.x = n * this.rackX + n4 * (this.slot % 2);
            this.y = n2 * this.rackY + n6 * this.node;
            this.z = n5 * this.cage + n3 * (this.slot / 2);
            if (this.x == 0 && this.y == 0 && this.z == 0) {
                System.out.println("All Zero! " + this.hostname + " rackWidth: " + n + " rackX: " + this.rackX + " slotWidth: " + n4 + " slot: " + this.slot);
            }
        }
    }

    static class CoordMap {
        float[] min;
        float[] max;
        float[][] coords;

        public CoordMap(float[] fArray, float[] fArray2, float[][] fArray3) {
            this.min = fArray;
            this.max = fArray2;
            this.coords = fArray3;
        }

        public float[] getMin() {
            return this.min;
        }

        public void setMin(float[] fArray) {
            this.min = fArray;
        }

        public float[] getMax() {
            return this.max;
        }

        public void setMax(float[] fArray) {
            this.max = fArray;
        }

        public float[][] getCoords() {
            return this.coords;
        }

        public void setCoords(float[][] fArray) {
            this.coords = fArray;
        }

        public String toString() {
            String string = "";
            for (int i = 0; i < this.coords.length; ++i) {
                string = string + i + ": " + this.coords[i][0] + "," + this.coords[i][1] + "," + this.coords[i][2] + "\n";
            }
            string = string + "min: " + this.min[0] + "," + this.min[1] + "," + this.min[2] + "\n";
            string = string + "max: " + this.max[0] + "," + this.max[1] + "," + this.max[2] + "\n";
            return string;
        }
    }
}

