/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.barchart;

import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.Searcher;
import edu.uoregon.tau.paraprof.barchart.BarChartModel;
import edu.uoregon.tau.paraprof.barchart.BarChartModelListener;
import edu.uoregon.tau.paraprof.barchart.BarChartPanel;
import edu.uoregon.tau.paraprof.barchart.DrawObject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JPanel;

public class BarChart
extends JPanel
implements MouseListener,
MouseMotionListener,
BarChartModelListener {
    private static final long serialVersionUID = -3802185389413109398L;
    private BarChartModel model;
    private int maxRowLabelStringWidth;
    private boolean maxRowLabelStringWidthSet;
    private int maxValueLabelStringWidth;
    private boolean maxValueLabelStringWidthSet;
    private boolean preferredSizeSet;
    private boolean dataProcessed;
    double[] maxRowValues;
    double[] maxSubValues;
    double maxRowSum;
    double maxOverallValue;
    double[] rowSums;
    double maxSubSum;
    private FontMetrics fontMetrics;
    private boolean leftJustified;
    private int barLengthMultiple = 0;
    private int barLength = 0;
    private int leftMargin = 8;
    private int rightMargin = 12;
    private int horizSpacing = 10;
    private int additionalVerticalSpacing = 0;
    private int barHeight;
    private int topMargin = 0;
    private int rowStart;
    private int rowEnd;
    private ArrayList<DrawObject> rowLabelDrawObjects = new ArrayList();
    private ArrayList<ArrayList<DrawObject>> valueDrawObjects = new ArrayList();
    private BarChartPanel panel;
    private Searcher searcher;
    private int barHorizSpacing = 5;
    private int threshold = 2;
    private boolean stacked = true;
    private boolean normalized = false;
    private boolean singleLine = true;
    private int fontHeight;
    private int mouseCol = -1;
    private int rowHeight;
    private boolean autoResize = true;
    private int autoWidth;
    private static final int minBarSize = 250;
    private static final boolean mouseOverHighlighting = false;

    public BarChart(BarChartModel barChartModel, BarChartPanel barChartPanel) {
        this.model = barChartModel;
        this.panel = barChartPanel;
        barChartModel.addBarChartModelListener(this);
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        this.searcher = new Searcher(this, barChartPanel);
        this.searcher.setTopMargin(this.topMargin);
        this.addMouseListener(this.searcher);
        this.addMouseMotionListener(this.searcher);
        this.setAutoscrolls(true);
        this.barChartChanged();
        this.setToolTipText("...");
    }

    public void sizeChanged() {
        if (!this.autoResize) {
            return;
        }
        if (this.fontMetrics == null) {
            return;
        }
        if (this.leftJustified) {
            int n = this.leftMargin + this.getMaxRowLabelStringWidth();
            this.setBarLength(this.getParent().getWidth() - (n + this.horizSpacing + this.rightMargin));
        } else {
            this.barLengthMultiple = 250;
            int n = this.leftMargin + this.getMaxValueLabelStringWidth() + this.horizSpacing + this.barLengthMultiple + this.horizSpacing + this.getMaxRowLabelStringWidth() + this.rightMargin;
            if (n < this.getParent().getWidth()) {
                this.barLengthMultiple = Math.max(this.barLengthMultiple, this.getParent().getWidth() - (n - this.barLengthMultiple));
            }
            this.setBarLength(this.barLengthMultiple);
            n = this.leftMargin + this.getMaxValueLabelStringWidth() + this.horizSpacing + this.barLengthMultiple + this.horizSpacing + this.getMaxRowLabelStringWidth() + this.rightMargin;
            this.checkPreferredSize();
            this.revalidate();
        }
    }

    public boolean getLeftJustified() {
        return this.leftJustified;
    }

    public void setLeftJustified(boolean bl) {
        this.leftJustified = bl;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Object object;
        int n;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        int n4 = this.rowLabelDrawObjects.size();
        for (n = 0; n < n4; ++n) {
            object = this.rowLabelDrawObjects.get(n);
            if (n2 < ((DrawObject)object).getXBeg() || n2 > ((DrawObject)object).getXEnd() || n3 < ((DrawObject)object).getYBeg() || n3 > ((DrawObject)object).getYEnd()) continue;
            return this.model.getRowLabelToolTipText(n + this.rowStart);
        }
        n4 = this.valueDrawObjects.size();
        for (n = 0; n < n4; ++n) {
            object = this.valueDrawObjects.get(n);
            int n5 = ((ArrayList)object).size();
            for (int i = 0; i < n5; ++i) {
                DrawObject drawObject = (DrawObject)((ArrayList)object).get(i);
                if (drawObject == null || n2 < drawObject.getXBeg() || n2 > drawObject.getXEnd() || n3 < drawObject.getYBeg() || n3 > drawObject.getYEnd()) continue;
                if (i == n5 - 1) {
                    return this.model.getOtherToolTopText(n + this.rowStart);
                }
                return this.model.getValueToolTipText(n + this.rowStart, i);
            }
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        try {
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setColor(Color.white);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.export((Graphics2D)graphics, true, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        int n;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        int n4 = this.rowLabelDrawObjects.size();
        for (n = 0; n < n4; ++n) {
            object = this.rowLabelDrawObjects.get(n);
            if (n2 < ((DrawObject)object).getXBeg() || n2 > ((DrawObject)object).getXEnd() || n3 < ((DrawObject)object).getYBeg() || n3 > ((DrawObject)object).getYEnd()) continue;
            this.model.fireRowLabelClick(n + this.rowStart, mouseEvent, this);
            return;
        }
        n4 = this.valueDrawObjects.size();
        for (n = 0; n < n4; ++n) {
            object = this.valueDrawObjects.get(n);
            int n5 = ((ArrayList)object).size();
            for (int i = 0; i < n5; ++i) {
                DrawObject drawObject = (DrawObject)((ArrayList)object).get(i);
                if (drawObject == null || n2 < drawObject.getXBeg() || n2 > drawObject.getXEnd() || n3 < drawObject.getYBeg() || n3 > drawObject.getYEnd() || i == n5 - 1) continue;
                this.model.fireValueClick(n + this.rowStart, i, mouseEvent, this);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private int getMaxRowLabelStringWidth() {
        if (this.fontMetrics == null) {
            return 0;
        }
        if (!this.maxRowLabelStringWidthSet) {
            this.maxRowLabelStringWidth = 0;
            for (int i = 0; i < this.model.getNumRows(); ++i) {
                String string = this.model.getRowLabel(i);
                this.maxRowLabelStringWidth = Math.max(this.maxRowLabelStringWidth, this.fontMetrics.stringWidth(string));
            }
            this.maxRowLabelStringWidthSet = true;
        }
        return this.maxRowLabelStringWidth;
    }

    private int getMaxValueLabelStringWidth() {
        if (!this.maxValueLabelStringWidthSet) {
            this.maxValueLabelStringWidth = 0;
            for (int i = 0; i < this.model.getNumRows(); ++i) {
                for (int j = 0; j < this.model.getSubSize(); ++j) {
                    String string = this.model.getValueLabel(i, j);
                    this.maxValueLabelStringWidth = Math.max(this.maxValueLabelStringWidth, this.fontMetrics.stringWidth(string));
                }
            }
            this.maxValueLabelStringWidthSet = true;
        }
        return this.maxValueLabelStringWidth;
    }

    private void checkPreferredSize() {
        int n;
        int n2;
        if (this.preferredSizeSet || this.fontMetrics == null) {
            return;
        }
        this.preferredSizeSet = true;
        int n3 = this.model.getNumRows() * this.fontHeight + this.topMargin + this.fontMetrics.getMaxDescent() + this.fontMetrics.getLeading();
        if (!this.singleLine) {
            n2 = this.fontHeight * this.model.getSubSize() + 10;
            n3 = this.model.getNumRows() * n2;
        }
        if (this.autoResize) {
            int n4;
            if (!this.leftJustified) {
                n4 = this.leftMargin + this.getMaxValueLabelStringWidth() + this.horizSpacing + this.barLengthMultiple + this.horizSpacing + this.getMaxRowLabelStringWidth() + this.rightMargin;
                if (this.barLengthMultiple > 250) {
                    n4 = 0;
                }
            } else {
                n4 = 0;
            }
            this.setPreferredSize(new Dimension(n4, n3 + 5));
            this.setSize(new Dimension(n4, n3 + 5));
            this.invalidate();
            return;
        }
        if (this.model.getSubSize() == 1) {
            n = this.leftMargin + this.getMaxValueLabelStringWidth() + this.horizSpacing + this.barLengthMultiple + this.horizSpacing + this.getMaxRowLabelStringWidth() + this.rightMargin;
        } else if (this.singleLine) {
            if (this.stacked) {
                n = this.leftMargin + this.getMaxRowLabelStringWidth() + this.horizSpacing + this.barLengthMultiple + this.rightMargin;
            } else {
                n = this.leftMargin + this.getMaxRowLabelStringWidth() + this.horizSpacing + this.rightMargin;
                for (n2 = 0; n2 < this.model.getSubSize(); ++n2) {
                    int n5 = (int)(this.maxSubValues[n2] / this.maxRowSum * (double)this.barLengthMultiple);
                    if (n5 < this.threshold) continue;
                    System.out.println("goo");
                    n = (int)((double)n + this.maxSubValues[n2] / this.maxRowSum * (double)this.barLengthMultiple);
                }
            }
        } else {
            n2 = this.fontHeight * this.model.getSubSize() + 10;
            n = this.barLengthMultiple + this.getMaxRowLabelStringWidth() + this.getMaxValueLabelStringWidth() + this.leftMargin + 2 * this.horizSpacing + this.rightMargin;
            n3 = this.model.getNumRows() * n2;
        }
        super.setPreferredSize(new Dimension(n, n3 + 5));
        super.setSize(new Dimension(n, n3 + 5));
        this.invalidate();
    }

    private void processData() {
        double d;
        int n;
        if (this.dataProcessed) {
            return;
        }
        this.dataProcessed = true;
        this.maxRowValues = new double[this.model.getNumRows()];
        this.maxSubValues = new double[this.model.getSubSize()];
        this.rowSums = new double[this.model.getNumRows()];
        this.maxRowSum = 0.0;
        this.maxOverallValue = 0.0;
        for (n = 0; n < this.model.getNumRows(); ++n) {
            d = 0.0;
            for (int i = 0; i < this.model.getSubSize(); ++i) {
                double d2 = Math.max(0.0, this.model.getValue(n, i));
                this.maxRowValues[n] = Math.max(this.maxRowValues[n], d2);
                this.maxSubValues[i] = Math.max(this.maxSubValues[i], d2);
                d += d2;
                int n2 = n;
                this.rowSums[n2] = this.rowSums[n2] + d2;
                this.maxOverallValue = Math.max(this.maxOverallValue, d2);
            }
            this.maxRowSum = Math.max(this.maxRowSum, d);
        }
        this.maxSubSum = 0.0;
        for (n = 0; n < this.model.getSubSize(); ++n) {
            d = this.maxSubValues[n];
            this.maxSubSum += d;
        }
    }

    private Color lighter(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = Math.max(n, n2);
        n4 = Math.max(n4, n3);
        n4 = Math.max(n4, 255);
        n += (int)((double)(n4 - n) / 2.36);
        n2 += (int)((double)(n4 - n2) / 2.36);
        n3 += (int)((double)(n4 - n3) / 2.36);
        return new Color(n, n2, n3);
    }

    private void drawBar(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color, Color color2) {
        boolean bl = true;
        if (bl && n4 > 4) {
            graphics2D.setColor(color);
            graphics2D.fillRect(n, n2, n3, n4 - 1);
            graphics2D.setColor(this.lighter(color));
            int n5 = n4 / 4;
            graphics2D.fillRect(n, n2 + n5 / 2 + 1, n3, n5);
            int n6 = n5 / 3;
            graphics2D.setColor(this.lighter(this.lighter(color)));
            graphics2D.fillRect(n, n2 + n5 / 2 + 1 + n6, n3, n6);
            graphics2D.setColor(Color.black);
            if (color2 != null) {
                graphics2D.setColor(color2);
                graphics2D.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 3);
            }
            graphics2D.drawRect(n, n2, n3, n4 - 1);
        } else {
            n4 = Math.max(n4, 1);
            graphics2D.setColor(color);
            graphics2D.fillRect(n, n2, n3, n4);
            if (n4 > 3) {
                graphics2D.setColor(Color.black);
                if (color2 != null) {
                    graphics2D.setColor(color2);
                    graphics2D.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
                }
                graphics2D.drawRect(n, n2, n3, n4);
            }
        }
    }

    private void drawSingleGraph(Graphics2D graphics2D, int n, int n2, int n3) {
        int n4 = n;
        for (int i = this.rowStart; i <= this.rowEnd; ++i) {
            int n5;
            int n6;
            int n7;
            String string = this.model.getRowLabel(i);
            int n8 = this.fontMetrics.stringWidth(string);
            ArrayList<DrawObject> arrayList = new ArrayList<DrawObject>();
            this.valueDrawObjects.add(arrayList);
            String string2 = this.model.getValueLabel(i, 0);
            double d = this.model.getValue(i, 0);
            double d2 = d / this.maxRowSum;
            int n9 = (int)(d2 * (double)this.barLengthMultiple);
            int n10 = this.fontMetrics.stringWidth(string2);
            int n11 = n4 - n3;
            if (this.leftJustified) {
                n7 = n2 + this.horizSpacing;
                n6 = n2 - n8;
                n5 = n2 + n9 + 2 * this.horizSpacing;
            } else {
                n7 = n2 - n9 - this.horizSpacing;
                n6 = n2;
                n5 = n2 - n9 - n10 - 2 * this.horizSpacing;
            }
            this.drawBar(graphics2D, n7, n11, n9, this.barHeight, this.model.getValueColor(i, 0), this.model.getValueHighlightColor(i, 0));
            arrayList.add(new DrawObject(n7, n11, n7 + n9, n4 - n3 + this.barHeight));
            this.searcher.drawHighlights(graphics2D, n6, n4, i);
            graphics2D.setColor(Color.black);
            graphics2D.drawString(string, n6, n4);
            this.rowLabelDrawObjects.add(new DrawObject(n6, n4 - this.fontHeight, n6 + n8, n4));
            graphics2D.drawString(string2, n5, n4);
            n4 += this.rowHeight;
            arrayList.add(null);
        }
    }

    private void drawMultiGraphHorizontal(Graphics2D graphics2D, int n, int n2, int n3) {
        int n4 = n;
        for (int i = this.rowStart; i <= this.rowEnd; ++i) {
            int n5;
            int n6;
            String string = this.model.getRowLabel(i);
            int n7 = this.fontMetrics.stringWidth(string);
            ArrayList<DrawObject> arrayList = new ArrayList<DrawObject>();
            this.valueDrawObjects.add(arrayList);
            int n8 = n4 - n3;
            double d = !this.stacked ? this.maxSubSum : (this.normalized ? this.rowSums[i] : this.maxRowSum);
            if (this.leftJustified) {
                n6 = n2 + this.horizSpacing;
                n5 = n2 - n7;
            } else {
                n6 = 0;
                n5 = 0;
            }
            this.searcher.drawHighlights(graphics2D, n5, n4, i);
            graphics2D.setColor(Color.black);
            graphics2D.drawString(string, n5, n4);
            this.rowLabelDrawObjects.add(new DrawObject(n5, n4 - this.fontHeight, n5 + n7, n4));
            if (d > 0.0) {
                double d2;
                int n9;
                double d3 = 0.0;
                double d4 = 0.0;
                for (n9 = 0; n9 < this.model.getSubSize(); ++n9) {
                    graphics2D.setColor(this.model.getValueColor(i, n9));
                    d2 = this.model.getValue(i, n9);
                    Color color = this.model.getValueColor(i, n9);
                    double d5 = d2 / d;
                    int n10 = (int)(d5 * (double)this.barLengthMultiple + d4);
                    if (this.stacked) {
                        d4 = d5 * (double)this.barLengthMultiple + d4 - (double)n10;
                    }
                    if (n10 < this.threshold && this.stacked) {
                        d3 += d2;
                        arrayList.add(null);
                        continue;
                    }
                    int n11 = (int)(this.maxSubValues[n9] / d * (double)this.barLengthMultiple);
                    if (n11 < this.threshold) {
                        arrayList.add(null);
                        d3 += d2;
                        continue;
                    }
                    if (d2 < 0.0) {
                        arrayList.add(null);
                    } else {
                        if (n9 == this.mouseCol) {
                            color = this.lighter(color);
                        }
                        this.drawBar(graphics2D, n6, n8, n10, this.barHeight, color, this.model.getValueHighlightColor(i, n9));
                        arrayList.add(new DrawObject(n6, n8, n6 + n10, n8 + this.barHeight));
                    }
                    if (!this.stacked) {
                        n6 = (int)((double)n6 + (this.maxSubValues[n9] / d * (double)this.barLengthMultiple + (double)this.barHorizSpacing));
                        continue;
                    }
                    n6 += n10;
                }
                if (this.normalized) {
                    n9 = this.barLengthMultiple + n2 + this.horizSpacing - n6;
                } else {
                    d2 = d3 / d;
                    n9 = this.stacked ? (int)(d2 * (double)this.barLengthMultiple + d4) : (int)(d2 * (double)this.barLengthMultiple);
                }
                this.drawBar(graphics2D, n6, n8, n9, this.barHeight, Color.black, null);
                arrayList.add(new DrawObject(n6, n8, n6 + n9, n8 + this.barHeight));
            }
            n4 += this.rowHeight;
        }
    }

    private void drawMultiGraphVertical(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5 = n;
        for (int i = this.rowStart; i <= this.rowEnd; ++i) {
            String string = this.model.getRowLabel(i);
            int n6 = this.fontMetrics.stringWidth(string);
            ArrayList arrayList = new ArrayList();
            this.valueDrawObjects.add(arrayList);
            double d = this.maxOverallValue;
            this.leftJustified = false;
            int n7 = this.leftJustified ? n2 - n6 : n2;
            int n8 = n5 + this.rowHeight / 2 - n4;
            this.searcher.drawHighlights(graphics2D, n7, n8, i);
            graphics2D.setColor(Color.black);
            graphics2D.drawString(string, n7, n8);
            this.rowLabelDrawObjects.add(new DrawObject(n7, n8 - this.fontHeight, n7 + n6, n8));
            int n9 = n5;
            for (int j = 0; j < this.model.getSubSize(); ++j) {
                int n10;
                int n11;
                double d2 = this.model.getValue(i, j);
                if (d2 < 0.0) {
                    n9 += this.fontHeight;
                    continue;
                }
                String string2 = this.model.getValueLabel(i, j);
                int n12 = this.fontMetrics.stringWidth(string2);
                double d3 = d2 / d;
                int n13 = (int)(d3 * (double)this.barLengthMultiple);
                if (this.leftJustified) {
                    n11 = n2 + this.horizSpacing;
                    n10 = n2 + n13 + 2 * this.horizSpacing;
                } else {
                    n11 = n2 - n13 - this.horizSpacing;
                    n10 = n2 - n13 - n12 - 2 * this.horizSpacing;
                }
                this.drawBar(graphics2D, n11, n9 - n3, n13, this.barHeight, this.model.getValueColor(i, j), this.model.getValueHighlightColor(i, 0));
                graphics2D.drawString(string2, n10, n9);
                n9 += this.fontHeight;
            }
            n5 += this.rowHeight;
        }
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2) {
        Font font = ParaProf.preferencesWindow.getFont();
        graphics2D.setFont(font);
        this.fontMetrics = graphics2D.getFontMetrics(font);
        this.rowLabelDrawObjects.clear();
        this.valueDrawObjects.clear();
        this.fontHeight = this.fontMetrics.getHeight();
        int n = this.fontMetrics.getMaxDescent();
        int n2 = this.fontMetrics.getMaxAscent();
        int n3 = this.fontMetrics.getLeading();
        this.barHeight = n + n2 + n3 - 2;
        if (this.autoResize) {
            if (this.autoWidth != this.getParent().getWidth()) {
                this.sizeChanged();
            }
            this.autoWidth = this.getParent().getWidth();
        }
        this.processData();
        if (this.barLengthMultiple == 0) {
            this.sizeChanged();
        }
        int n4 = this.leftJustified ? this.leftMargin + this.getMaxRowLabelStringWidth() : this.leftMargin + this.getMaxValueLabelStringWidth() + this.horizSpacing + this.barLengthMultiple + this.horizSpacing;
        int n5 = (int)((float)n2 - ((float)n + (float)n2 + (float)n3 - (float)this.barHeight) / 2.0f);
        this.checkPreferredSize();
        this.rowHeight = this.fontHeight + this.additionalVerticalSpacing;
        int n6 = this.rowHeight + this.topMargin;
        if (!this.singleLine) {
            this.rowHeight = this.rowHeight * this.model.getSubSize() + 10;
        }
        this.searcher.setLineHeight(this.rowHeight);
        this.searcher.setMaxDescent(this.fontMetrics.getMaxDescent());
        int[] nArray = ParaProfUtils.computeClipping(this.panel.getViewport().getViewRect(), this.panel.getViewport().getViewRect(), true, bl2, this.model.getNumRows(), this.rowHeight, n6);
        this.rowStart = nArray[0];
        this.rowEnd = nArray[1];
        n6 = nArray[2];
        this.searcher.setVisibleLines(this.rowStart, this.rowEnd);
        this.searcher.setG2d(graphics2D);
        this.searcher.setXOffset(n4);
        if (this.model.getSubSize() == 1) {
            this.drawSingleGraph(graphics2D, n6, n4, n5);
        } else if (this.singleLine) {
            this.drawMultiGraphHorizontal(graphics2D, n6, n4, n5);
        } else {
            this.drawMultiGraphVertical(graphics2D, n6, n4, n5, n2);
        }
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        return null;
    }

    @Override
    public void barChartChanged() {
        this.preferredSizeSet = false;
        this.maxValueLabelStringWidthSet = false;
        this.maxRowLabelStringWidthSet = false;
        this.dataProcessed = false;
        this.setSearchLines();
        this.barLengthMultiple = 0;
        this.repaint();
    }

    private void setSearchLines() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.model.getNumRows(); ++i) {
            arrayList.add(this.model.getRowLabel(i));
        }
        this.searcher.setSearchLines(arrayList);
    }

    public int getBarLength() {
        return this.barLengthMultiple;
    }

    public void setBarLength(int n) {
        this.barLength = n;
        this.barLengthMultiple = n;
        this.preferredSizeSet = false;
        if (!this.stacked) {
            int n2 = n;
            int n3 = n + 1;
            while (n3 > n) {
                int n4;
                n3 = 0;
                double d = 0.0;
                for (n4 = 0; n4 < this.model.getSubSize(); ++n4) {
                    int n5 = (int)(this.maxSubValues[n4] / this.maxSubSum * (double)n2);
                    if (n5 < this.threshold) {
                        d += this.maxSubValues[n4];
                        continue;
                    }
                    n3 += n5 + this.barHorizSpacing;
                }
                n4 = (int)(d / this.maxSubSum * (double)n2);
                n3 += n4;
                if ((n3 += this.horizSpacing + this.horizSpacing) <= n) continue;
                --n2;
            }
            this.barLengthMultiple = n2;
        }
        this.checkPreferredSize();
    }

    public Searcher getSearcher() {
        return this.searcher;
    }

    public boolean getNormalized() {
        return this.normalized;
    }

    public void setNormalized(boolean bl) {
        this.normalized = bl;
        this.preferredSizeSet = false;
    }

    public boolean getStacked() {
        return this.stacked;
    }

    public void setStacked(boolean bl) {
        this.stacked = bl;
        this.setBarLength(this.barLength);
        this.preferredSizeSet = false;
        this.checkPreferredSize();
    }

    public boolean getSingleLine() {
        return this.singleLine;
    }

    public void setSingleLine(boolean bl) {
        this.singleLine = bl;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseCol = -1;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.valueDrawObjects.size();
        for (int i = 0; i < n3; ++i) {
            ArrayList<DrawObject> arrayList = this.valueDrawObjects.get(i);
            int n4 = arrayList.size();
            for (int j = 0; j < n4; ++j) {
                DrawObject drawObject = arrayList.get(j);
                if (drawObject == null) continue;
                int n5 = drawObject.getXBeg();
                int n6 = drawObject.getXEnd();
                int n7 = drawObject.getYBeg() - (this.rowHeight - drawObject.getHeight()) / 2;
                int n8 = drawObject.getYEnd() + (int)(((double)(this.rowHeight - drawObject.getHeight()) + 0.5) / 2.0);
                if (n < n5 || n > n6 || n2 < n7 || n2 > n8) continue;
                this.mouseCol = j;
            }
        }
        this.repaint();
    }

    public int getAdditionalVerticalSpacing() {
        return this.additionalVerticalSpacing;
    }

    public void setAdditionalVerticalSpacing(int n) {
        this.additionalVerticalSpacing = n;
    }

    public boolean getAutoResize() {
        return this.autoResize;
    }

    public void setAutoResize(boolean bl) {
        this.autoResize = bl;
    }

    public BarChartModel getBarChartModel() {
        return this.model;
    }
}

