/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.barchart;

import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.barchart.LegendModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class LegendPanel
extends JPanel {
    private static final long serialVersionUID = -7605496344675426707L;
    private LegendModel model;
    private int xPanelSize;
    private int yPanelSize;
    private int leftMargin = 3;
    private int rightMargin = 50;

    public LegendPanel(LegendModel legendModel) {
        this.model = legendModel;
        this.setBackground(Color.white);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.draw((Graphics2D)graphics);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private void draw(Graphics2D graphics2D) {
        String string;
        int n;
        int n2;
        int n3 = ParaProf.preferencesWindow.getFontSize();
        Font font = ParaProf.preferencesWindow.getFont();
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        int n4 = n2 = fontMetrics.getHeight() - n3;
        for (n = 0; n < this.model.getNumElements(); ++n) {
            string = this.model.getLabel(n);
            Color color = this.model.getColor(n);
            graphics2D.setColor(color);
            graphics2D.fillRect(this.leftMargin, n4, n3, n3);
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(this.leftMargin, n4, n3, n3);
            graphics2D.drawString(string, this.leftMargin + n3 + 5, n4 + n3);
            n4 = n4 + n3 + n2;
        }
        if (n4 + n2 > this.yPanelSize) {
            this.xPanelSize = 0;
            for (n = 0; n < this.model.getNumElements(); ++n) {
                string = this.model.getLabel(n);
                this.xPanelSize = Math.max(this.xPanelSize, fontMetrics.stringWidth(string) + n3 + this.rightMargin);
            }
            this.yPanelSize = n4 + n2;
            this.setMinimumSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.setPreferredSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.revalidate();
        }
    }

    public void setModel(LegendModel legendModel) {
        this.model = legendModel;
    }
}

