/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.barchart;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.SnapshotThreadWindow;
import edu.uoregon.tau.paraprof.barchart.AbstractBarChartModel;
import edu.uoregon.tau.paraprof.util.ObjectFilter;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Snapshot;
import edu.uoregon.tau.perfdmf.Thread;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;

public class ThreadSnapshotBarChartModel
extends AbstractBarChartModel {
    private DataSorter dataSorter;
    private ParaProfTrial ppTrial;
    private List<Object> snapshots;
    private Thread thread;
    private ObjectFilter filter;
    private List<FunctionProfile> list;

    public ThreadSnapshotBarChartModel(SnapshotThreadWindow snapshotThreadWindow, DataSorter dataSorter, ParaProfTrial paraProfTrial, Thread thread) {
        this.dataSorter = dataSorter;
        this.ppTrial = paraProfTrial;
        this.thread = thread;
        this.filter = new ObjectFilter(thread.getSnapshots());
        this.snapshots = this.filter.getFilteredObjects();
        this.list = dataSorter.getBasicFunctionProfiles(thread);
    }

    @Override
    public int getSubSize() {
        return this.list.size();
    }

    @Override
    public void fireRowLabelClick(int n, MouseEvent mouseEvent, JComponent jComponent) {
        Snapshot snapshot = (Snapshot)this.snapshots.get(n);
        ParaProfUtils.handleSnapshotClick(this.ppTrial, this.thread, snapshot, jComponent, mouseEvent);
        System.out.println("right click on " + snapshot);
    }

    @Override
    public void fireValueClick(int n, int n2, MouseEvent mouseEvent, JComponent jComponent) {
    }

    @Override
    public int getNumRows() {
        return this.snapshots.size();
    }

    @Override
    public String getOtherToolTopText(int n) {
        return "asdf";
    }

    @Override
    public String getRowLabel(int n) {
        return ((Snapshot)this.snapshots.get(n)).toString();
    }

    @Override
    public String getRowLabelToolTipText(int n) {
        return "Snapshot: " + ((Snapshot)this.snapshots.get(n)).toString();
    }

    @Override
    public double getValue(int n, int n2) {
        FunctionProfile functionProfile = this.list.get(n2);
        if (functionProfile == null) {
            return 0.0;
        }
        Snapshot snapshot = (Snapshot)this.snapshots.get(n);
        int n3 = snapshot.getID();
        boolean bl = true;
        if (bl && n3 != 0) {
            return functionProfile.getExclusive(n3, this.ppTrial.getDefaultMetric().getID()) - functionProfile.getExclusive(n3 - 1, this.ppTrial.getDefaultMetric().getID());
        }
        return functionProfile.getExclusive(n3, this.ppTrial.getDefaultMetric().getID());
    }

    @Override
    public Color getValueColor(int n, int n2) {
        FunctionProfile functionProfile = this.list.get(n2);
        if (functionProfile == null) {
            return Color.black;
        }
        return functionProfile.getFunction().getColor();
    }

    @Override
    public Color getValueHighlightColor(int n, int n2) {
        return null;
    }

    @Override
    public String getValueLabel(int n, int n2) {
        return "asdf";
    }

    @Override
    public String getValueToolTipText(int n, int n2) {
        FunctionProfile functionProfile = this.list.get(n2);
        if (functionProfile == null) {
            return "";
        }
        return functionProfile.getName();
    }

    @Override
    public void reloadData() {
    }

    @Override
    public DataSorter getDataSorter() {
        return this.dataSorter;
    }
}

