/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.enums;

import edu.uoregon.tau.perfdmf.UserEventProfile;

public abstract class UserEventValueType {
    private final String name;
    public static final UserEventValueType TOTAL = new UserEventValueType("Total"){

        @Override
        public double getValue(UserEventProfile userEventProfile, int n) {
            String string = userEventProfile.getName();
            if (string.startsWith("Memory Utilization (heap, in KB)") || string.contains("/s)")) {
                return -1.0;
            }
            return userEventProfile.getNumSamples(n) * userEventProfile.getMeanValue(n);
        }
    };
    public static final UserEventValueType NUMSAMPLES = new UserEventValueType("Number of Samples"){

        @Override
        public double getValue(UserEventProfile userEventProfile, int n) {
            return userEventProfile.getNumSamples(n);
        }
    };
    public static final UserEventValueType MAX = new UserEventValueType("Max Value"){

        @Override
        public double getValue(UserEventProfile userEventProfile, int n) {
            return userEventProfile.getMaxValue(n);
        }
    };
    public static final UserEventValueType MIN = new UserEventValueType("Min Value"){

        @Override
        public double getValue(UserEventProfile userEventProfile, int n) {
            return userEventProfile.getMinValue(n);
        }
    };
    public static final UserEventValueType MEAN = new UserEventValueType("Mean Value"){

        @Override
        public double getValue(UserEventProfile userEventProfile, int n) {
            return userEventProfile.getMeanValue(n);
        }
    };
    public static final UserEventValueType STDDEV = new UserEventValueType("Standard Deviation"){

        @Override
        public double getValue(UserEventProfile userEventProfile, int n) {
            return userEventProfile.getStdDev(n);
        }
    };
    public static UserEventValueType[] VALUES = new UserEventValueType[]{MAX, MEAN, MIN, NUMSAMPLES, STDDEV, TOTAL};

    private UserEventValueType(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    public double getValue(UserEventProfile userEventProfile) {
        return this.getValue(userEventProfile, -1);
    }

    public abstract double getValue(UserEventProfile var1, int var2);
}

