/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.paraprof.ParaProfMetric;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.treetable.TreeTableWindow;
import edu.uoregon.tau.perfdmf.Metric;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class ColumnChooser
extends JFrame {
    private static final long serialVersionUID = 1252523707923133716L;
    private List<String> statistics = new ArrayList<String>();
    private ParaProfMetric numCalls;
    private ParaProfMetric numSubr;
    private CheckBoxCellRenderer checkBoxCellRenderer = new CheckBoxCellRenderer();
    private JList metricJList;
    private DefaultListModel metricModel;
    private JList valueJList;
    private DefaultListModel valueModel;
    private JList statsJList;
    private DefaultListModel statsModel;
    private TreeTableWindow ttWindow;

    public ColumnChooser(TreeTableWindow treeTableWindow, ParaProfTrial paraProfTrial) {
        int n;
        this.ttWindow = treeTableWindow;
        this.setTitle("Choose Columns");
        this.setSize(500, 400);
        this.numCalls = new ParaProfMetric();
        this.numCalls.setName("Calls");
        this.numSubr = new ParaProfMetric();
        this.numSubr.setName("Child Calls");
        this.valueModel = new DefaultListModel();
        this.valueModel.addElement(new CheckBoxListItem("Exclusive Value", true));
        this.valueModel.addElement(new CheckBoxListItem("Inclusive Value", true));
        this.valueModel.addElement(new CheckBoxListItem("Exclusive Percent Value", false));
        this.valueModel.addElement(new CheckBoxListItem("Inclusive Percent Value", false));
        this.valueModel.addElement(new CheckBoxListItem("Exclusive Value Per Call", false));
        this.valueModel.addElement(new CheckBoxListItem("Inclusive Value Per Call", false));
        this.statistics.add("Standard Deviation");
        this.statistics.add("Mini Histogram");
        Metric metric = null;
        if (paraProfTrial.getMetrics().size() > 3) {
            metric = paraProfTrial.getDefaultMetric();
        }
        List<Metric> list = paraProfTrial.getMetrics();
        this.metricModel = new DefaultListModel();
        for (n = 0; n < list.size(); ++n) {
            boolean bl = true;
            if (metric != null && list.get(n) != metric) {
                bl = false;
            }
            this.metricModel.addElement(new CheckBoxListItem((ParaProfMetric)list.get(n), bl));
        }
        this.metricModel.addElement(new CheckBoxListItem("Calls", true));
        this.metricModel.addElement(new CheckBoxListItem("Child Calls", true));
        this.metricJList = new JList(this.metricModel);
        this.metricJList.setCellRenderer(this.checkBoxCellRenderer);
        this.metricJList.addMouseListener(new MouseController(this.metricJList, this.metricModel));
        this.valueJList = new JList(this.valueModel);
        this.valueJList.setCellRenderer(this.checkBoxCellRenderer);
        this.valueJList.addMouseListener(new MouseController(this.valueJList, this.valueModel));
        this.statsModel = new DefaultListModel();
        for (n = 0; n < this.statistics.size(); ++n) {
            this.statsModel.addElement(new CheckBoxListItem(this.statistics.get(n), true));
        }
        this.statsJList = new JList(this.statsModel);
        this.statsJList.setCellRenderer(this.checkBoxCellRenderer);
        this.statsJList.addMouseListener(new MouseController(this.statsJList, this.statsModel));
        Container container = this.getContentPane();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Utility.addCompItem((Container)this.getContentPane(), (Component)new JLabel("Metrics"), (GridBagConstraints)gridBagConstraints, (int)0, (int)0, (int)1, (int)1);
        Utility.addCompItem((Container)this.getContentPane(), (Component)new JLabel("Values"), (GridBagConstraints)gridBagConstraints, (int)1, (int)0, (int)1, (int)1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        Utility.addCompItem((Container)this.getContentPane(), (Component)new JScrollPane(this.metricJList), (GridBagConstraints)gridBagConstraints, (int)0, (int)1, (int)1, (int)1);
        Utility.addCompItem((Container)this.getContentPane(), (Component)new JScrollPane(this.valueJList), (GridBagConstraints)gridBagConstraints, (int)1, (int)1, (int)1, (int)1);
        gridBagConstraints.weighty = 0.1;
        JButton jButton = new JButton("close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ColumnChooser.this.ttWindow.updateColumns();
                    ColumnChooser.this.dispose();
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Utility.addCompItem((Container)container, (Component)jPanel, (GridBagConstraints)gridBagConstraints, (int)1, (int)2, (int)1, (int)1);
    }

    private void center(JFrame jFrame) {
        int n = jFrame.getX() + jFrame.getWidth() / 2;
        int n2 = jFrame.getY() + jFrame.getHeight() / 2;
        int n3 = n - this.getWidth() / 2;
        int n4 = n2 - this.getHeight() / 2;
        n3 = Math.max(n3, 0);
        n4 = Math.max(n4, 0);
        this.setLocation(n3, n4);
    }

    public ListModel getMetricModel() {
        return this.metricModel;
    }

    public ListModel getValueModel() {
        return this.valueModel;
    }

    public void showDialog(JFrame jFrame, boolean bl) {
        this.center(jFrame);
        this.setVisible(true);
    }

    static class CheckBoxCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        private static final long serialVersionUID = -262593527091777147L;

        CheckBoxCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(jList.getBackground());
            CheckBoxListItem checkBoxListItem = (CheckBoxListItem)object;
            this.setText(checkBoxListItem.getUserObject().toString());
            this.setSelected(checkBoxListItem.getSelected());
            return this;
        }
    }

    static class MouseController
    implements MouseListener {
        private JList list;
        private ListModel model;

        public MouseController(JList jList, ListModel listModel) {
            this.list = jList;
            this.model = listModel;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = this.list.locationToIndex(point);
            CheckBoxListItem checkBoxListItem = (CheckBoxListItem)this.model.getElementAt(n);
            if (checkBoxListItem.getSelected()) {
                checkBoxListItem.setSelected(false);
            } else {
                checkBoxListItem.setSelected(true);
            }
            this.list.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    static class CheckBoxListItem {
        private Object userObject;
        private boolean selected;

        public CheckBoxListItem(Object object, boolean bl) {
            this.userObject = object;
            this.selected = bl;
        }

        public boolean getSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public Object getUserObject() {
            return this.userObject;
        }
    }
}

