/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.common.treetable.AbstractTreeTableModel;
import edu.uoregon.tau.common.treetable.TreeTableModel;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPUserEventProfile;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.treetable.ContextEventTreeNode;
import edu.uoregon.tau.paraprof.treetable.ContextEventWindow;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ContextEventModel
extends AbstractTreeTableModel {
    private static String[] cNames = new String[]{"Name", "Total", "NumSamples", "MaxValue", "MinValue", "MeanValue", "Std. Dev."};
    private static String[] cNamesNoTotal = new String[]{"Name", "NumSamples", "MaxValue", "MinValue", "MeanValue", "Std. Dev."};
    private static Class<?>[] cTypes = new Class[]{TreeTableModel.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class};
    private static Class<?>[] cTypesNoTotal = new Class[]{TreeTableModel.class, Double.class, Double.class, Double.class, Double.class, Double.class};
    private List<ContextEventTreeNode> roots;
    private ParaProfTrial ppTrial;
    private Thread thread;
    private ContextEventWindow window;
    private int sortColumn;
    private boolean sortAscending;
    DataSorter dataSorter;
    private boolean showTotal = true;

    public ContextEventModel(ContextEventWindow contextEventWindow, ParaProfTrial paraProfTrial, Thread thread, boolean bl) {
        super(null);
        this.ppTrial = paraProfTrial;
        this.thread = thread;
        this.window = contextEventWindow;
        this.root = new ContextEventTreeNode("root", this);
        this.setupData();
    }

    public Thread getThread() {
        return this.thread;
    }

    public void showTotal(boolean bl) {
        this.showTotal = bl;
    }

    private void setupData() {
        this.roots = new ArrayList<ContextEventTreeNode>();
        this.dataSorter = new DataSorter(this.ppTrial);
        List<PPUserEventProfile> list = this.dataSorter.getUserEventProfiles(this.thread);
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        if (this.window.getTreeMode()) {
            Object object;
            for (PPUserEventProfile object2 : list) {
                Object object3;
                object = object2.getUserEventProfile();
                if (object.getUserEvent().isContextEvent()) {
                    object3 = UtilFncs.getContextEventRoot((String)ParaProfUtils.getUserEventDisplayName(object.getUserEvent())).trim();
                    hashMap.put(object3, 1);
                    continue;
                }
                object3 = new ContextEventTreeNode((UserEventProfile)object, this, null);
                this.roots.add((ContextEventTreeNode)object3);
            }
            for (String string : hashMap.keySet()) {
                object = new ContextEventTreeNode(string, this);
                this.roots.add((ContextEventTreeNode)object);
            }
        }
        Collections.sort(this.roots);
    }

    public String getColumnName(int n) {
        if (this.showTotal) {
            return cNames[n];
        }
        return cNamesNoTotal[n];
    }

    public Class getColumnClass(int n) {
        if (this.showTotal) {
            return cTypes[n];
        }
        return cTypesNoTotal[n];
    }

    public int getColorMetric() {
        return 0;
    }

    public int getColumnCount() {
        if (this.showTotal) {
            return cNames.length;
        }
        return cNamesNoTotal.length;
    }

    public Object getValueAt(Object object, int n) {
        ContextEventTreeNode contextEventTreeNode = (ContextEventTreeNode)object;
        UserEventProfile userEventProfile = contextEventTreeNode.getUserEventProfile();
        if (!this.showTotal) {
            ++n;
        }
        if (userEventProfile == null) {
            return null;
        }
        switch (n) {
            case 1: {
                if (userEventProfile.getName().startsWith("Memory Utilization (heap, in KB)") || userEventProfile.getName().contains("/s)") || !userEventProfile.getUserEvent().isShowTotal()) {
                    return null;
                }
                return new Double(userEventProfile.getNumSamples(this.dataSorter.getSelectedSnapshot()) * userEventProfile.getMeanValue(this.dataSorter.getSelectedSnapshot()));
            }
            case 2: {
                return new Double(userEventProfile.getNumSamples(this.dataSorter.getSelectedSnapshot()));
            }
            case 3: {
                return new Double(userEventProfile.getMaxValue(this.dataSorter.getSelectedSnapshot()));
            }
            case 4: {
                return new Double(userEventProfile.getMinValue(this.dataSorter.getSelectedSnapshot()));
            }
            case 5: {
                return new Double(userEventProfile.getMeanValue(this.dataSorter.getSelectedSnapshot()));
            }
            case 6: {
                return new Double(userEventProfile.getStdDev(this.dataSorter.getSelectedSnapshot()));
            }
        }
        return null;
    }

    public Object getChild(Object object, int n) {
        if (object == this.root) {
            return this.roots.get(n);
        }
        ContextEventTreeNode contextEventTreeNode = (ContextEventTreeNode)object;
        return contextEventTreeNode.getChildren().get(n);
    }

    public int getChildCount(Object object) {
        if (object == this.root) {
            return this.roots.size();
        }
        if (this.window.getTreeMode()) {
            ContextEventTreeNode contextEventTreeNode = (ContextEventTreeNode)object;
            return contextEventTreeNode.getNumChildren();
        }
        return 0;
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public void sortColumn(int n, boolean bl) {
        super.sortColumn(n, bl);
        this.sortColumn = n;
        this.sortAscending = bl;
        Collections.sort(this.roots);
        for (ContextEventTreeNode contextEventTreeNode : this.roots) {
            contextEventTreeNode.sortChildren();
        }
    }

    public boolean getSortAscending() {
        return this.sortAscending;
    }
}

