package edu.uoregon.tau.taucdt.preferences;

import org.eclipse.cdt.debug.internal.ui.preferences.ComboFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.jface.util.Assert;

public class VarComboFieldEditor  extends ComboFieldEditor{

	/**
	 * The names (labels) and underlying values to populate the combo widget.  These should be
	 * arranged as: { {name1, value1}, {name2, value2}, ...}
	 */
	private String[][] fEntryNamesAndValues;
	
	public VarComboFieldEditor(String arg0, String arg1, String[][] arg2, Composite arg3) {
		super(arg0, arg1, arg2, arg3);
		// TODO Auto-generated constructor stub
	}
	
	public void resetNamesAndValues(String[][] entryNamesAndValues){
		Assert.isTrue(checkArray(entryNamesAndValues));
		fEntryNamesAndValues=entryNamesAndValues;
		fCombo.select(0);
		fCombo.removeAll();
		
		for (int i = 0; i < fEntryNamesAndValues.length; i++) {
			fCombo.add(fEntryNamesAndValues[i][0], i);
		}		
		fCombo.select(0);
	}
	
	
	/**
	 * Checks whether given <code>String[][]</code> is of "type" 
	 * <code>String[][2]</code>.
	 *
	 * @return <code>true</code> if it is ok, and <code>false</code> otherwise
	 */
	private boolean checkArray(String[][] table) {
		if (table == null) {
			return false;
		}
		for (int i = 0; i < table.length; i++) {
			String[] array = table[i];
			if (array == null || array.length != 2) {
				return false;
			}
		}
		return true;
	}

}
