/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.math;

public class VarMap {
    private boolean caseSensitive = true;
    private String[] name = new String[2];
    private double[] value = new double[2];
    private int numVars = 0;

    public VarMap() {
        this(true);
    }

    public VarMap(boolean bl) {
        this.caseSensitive = bl;
    }

    public double getValue(String string) {
        for (int i = 0; i < this.numVars; ++i) {
            if ((!this.caseSensitive || !this.name[i].equals(string)) && (this.caseSensitive || !this.name[i].equalsIgnoreCase(string))) continue;
            return this.value[i];
        }
        throw new RuntimeException("variable value has not been set: " + string);
    }

    public void setValue(String string, double d) {
        if (string == null) {
            throw new IllegalArgumentException("varName cannot be null");
        }
        for (int i = 0; i < this.numVars; ++i) {
            if ((!this.caseSensitive || !this.name[i].equals(string)) && (this.caseSensitive || !this.name[i].equalsIgnoreCase(string))) continue;
            this.value[i] = d;
            return;
        }
        if (this.numVars == this.name.length) {
            String[] stringArray = new String[2 * this.numVars];
            double[] dArray = new double[stringArray.length];
            for (int i = 0; i < this.numVars; ++i) {
                stringArray[i] = this.name[i];
                dArray[i] = this.value[i];
            }
            this.name = stringArray;
            this.value = dArray;
        }
        this.name[this.numVars] = string;
        this.value[this.numVars] = d;
        ++this.numVars;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public String[] getVariableNames() {
        String[] stringArray = new String[this.numVars];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.name[i];
        }
        return stringArray;
    }

    public double[] getValues() {
        double[] dArray = new double[this.numVars];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.value[i];
        }
        return dArray;
    }

    public void remove(String string) {
        for (int i = 0; i < this.numVars; ++i) {
            if ((!this.caseSensitive || !this.name[i].equals(string)) && (this.caseSensitive || !this.name[i].equalsIgnoreCase(string))) continue;
            for (int j = i + 1; j < this.numVars; ++j) {
                this.name[j - 1] = this.name[j];
                this.value[j - 1] = this.value[j];
            }
            --this.numVars;
            this.name[this.numVars] = null;
            this.value[this.numVars] = 0.0;
            break;
        }
    }
}

