/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.common.TrackerInputStream;
import edu.uoregon.tau.perfdmf.Cube3XMLHandler;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.zip.GZIPInputStream;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Cube3DataSource
extends DataSource {
    private File file;
    private volatile Cube3XMLHandler handler = new Cube3XMLHandler(this);
    private volatile TrackerInputStream tracker;

    public Cube3DataSource(File file) {
        this.file = file;
    }

    @Override
    public void load() throws FileNotFoundException, IOException, DataSourceException, SQLException {
        try {
            GZIPInputStream gZIPInputStream;
            long l = System.currentTimeMillis();
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            xMLReader.setContentHandler(this.handler);
            xMLReader.setErrorHandler(this.handler);
            FileInputStream fileInputStream = new FileInputStream(this.file);
            this.tracker = new TrackerInputStream((InputStream)fileInputStream);
            try {
                GZIPInputStream gZIPInputStream2;
                gZIPInputStream = gZIPInputStream2 = new GZIPInputStream((InputStream)this.tracker);
            }
            catch (IOException iOException) {
                fileInputStream.close();
                fileInputStream = new FileInputStream(this.file);
                this.tracker = new TrackerInputStream((InputStream)fileInputStream);
                gZIPInputStream = this.tracker;
            }
            xMLReader.parse(new InputSource(new BufferedInputStream(gZIPInputStream)));
            this.setGroupNamesPresent(true);
            this.generateDerivedData();
            l = System.currentTimeMillis() - l;
        }
        catch (SAXException sAXException) {
            throw new DataSourceException(sAXException);
        }
    }

    @Override
    public int getProgress() {
        int n = 0;
        if (this.handler != null) {
            n = this.handler.getProgress();
        }
        return n;
    }

    @Override
    public void cancelLoad() {
    }
}

