/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Thread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class GAMESSDataSource
extends DataSource {
    private Function function = null;
    private Node node = null;
    private Context context = null;
    private Thread thread = null;
    private int nodeID = -1;
    private int contextID = -1;
    private int threadID = -1;
    boolean initialized = false;
    private File file = null;
    private int nodeCount = 1;
    private int coreCount = 1;
    private String inputString;
    private StringBuffer phaseName;
    private List<MyEvent> events = new ArrayList<MyEvent>();
    private double cpuTime;
    private double totalCpuTime = 0.0;
    private double totalWallClockTime = 0.0;
    private double currentWallClockTime = 0.0;
    private FunctionProfile fp;
    private Map<String, String> metadata = new HashMap<String, String>();
    private Map<String, Integer> atomCounts = new HashMap<String, Integer>();

    public GAMESSDataSource(File file) {
        this.setMetrics(new Vector<Metric>());
        this.file = file;
    }

    public GAMESSDataSource() {
    }

    @Override
    public void cancelLoad() {
    }

    @Override
    public int getProgress() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void load() throws FileNotFoundException, IOException, DataSourceException, SQLException {
        try {
            Object object;
            long l = System.currentTimeMillis();
            this.nodeID = 0;
            this.contextID = 0;
            this.threadID = 0;
            FileInputStream fileInputStream = new FileInputStream(this.file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            this.atomCounts.put(new String("C"), new Integer(0));
            this.atomCounts.put(new String("N"), new Integer(0));
            this.atomCounts.put(new String("H"), new Integer(0));
            this.atomCounts.put(new String("O"), new Integer(0));
            block2: while ((this.inputString = bufferedReader.readLine()) != null) {
                this.inputString = this.inputString.trim();
                if (this.inputString.startsWith("PARALLEL VERSION RUNNING ON")) {
                    this.parseNodeCount();
                    continue;
                }
                if (this.inputString.startsWith("FINAL RHF ENERGY IS")) {
                    this.parseAccuracy();
                    continue;
                }
                if (this.inputString.startsWith("....")) {
                    if (this.inputString.equals("...... PI ENERGY ANALYSIS ......") || this.inputString.equals("...... END OF PI ENERGY ANALYSIS ......")) continue;
                    this.parsePhaseName();
                    continue;
                }
                if (this.inputString.startsWith("ON NODE")) {
                    this.parseStepTime(true);
                    continue;
                }
                if (this.inputString.startsWith("STEP CPU TIME =")) {
                    this.parseStepTime(false);
                    continue;
                }
                if (this.inputString.startsWith("TOTAL WALL CLOCK TIME")) {
                    this.parseTime();
                    this.createEvent();
                    continue;
                }
                if (this.inputString.startsWith("TOTAL NUMBER OF ") || this.inputString.startsWith("NUMBER OF ") || this.inputString.startsWith("SPIN MULTIPLICITY") || this.inputString.startsWith("THE NUCLEAR REPULSION")) {
                    this.parseMetadata();
                    continue;
                }
                if (!this.inputString.startsWith("ATOM      ATOMIC                      COORDINATES (BOHR)")) continue;
                this.inputString = bufferedReader.readLine();
                while ((this.inputString = bufferedReader.readLine()) != null) {
                    void var8_11;
                    this.inputString = this.inputString.trim();
                    if (this.inputString.equals("")) continue block2;
                    object = new StringTokenizer(this.inputString, " ");
                    String string = ((StringTokenizer)object).nextToken();
                    Integer n = this.atomCounts.get(string);
                    if (n == null) {
                        Integer n2 = new Integer(0);
                    }
                    Integer object2 = new Integer(var8_11.intValue() + 1);
                    this.atomCounts.put(string, object2);
                }
            }
            object = new MyEvent("MAIN", this.totalCpuTime, this.totalWallClockTime, this.events.size());
            this.nodeID = 0;
            while (this.nodeID < this.nodeCount) {
                this.threadID = 0;
                while (this.threadID < this.coreCount) {
                    this.initializeThread();
                    this.createFunction(this.thread, (MyEvent)object, false);
                    for (MyEvent myEvent : this.events) {
                        this.createFunction(this.thread, myEvent, false);
                        this.createFunction(this.thread, myEvent, true);
                    }
                    this.setMetadata();
                    ++this.threadID;
                }
                ++this.nodeID;
            }
            l = System.currentTimeMillis() - l;
            this.generateDerivedData();
            this.aggregateMetaData();
            this.buildXMLMetaData();
            this.setGroupNamesPresent(true);
        }
        catch (Exception exception) {
            if (exception instanceof DataSourceException) {
                throw (DataSourceException)exception;
            }
            throw new DataSourceException(exception);
        }
    }

    private void parseNodeCount() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.inputString, " ");
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        int n = Integer.parseInt(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        this.nodeCount = Integer.parseInt(stringTokenizer.nextToken());
        this.coreCount = n / this.nodeCount;
    }

    private void createEvent() {
        MyEvent myEvent = new MyEvent(this.phaseName.toString(), this.cpuTime, this.currentWallClockTime, 0);
        this.events.add(myEvent);
    }

    private void parseTime() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.inputString, " ");
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        double d = Double.parseDouble(stringTokenizer.nextToken());
        this.currentWallClockTime = d - this.totalWallClockTime;
        this.totalWallClockTime = d;
    }

    private void parseStepTime(boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.inputString, " ");
        if (bl) {
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
        }
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        if (!bl) {
            stringTokenizer.nextToken();
        }
        this.cpuTime = Double.parseDouble(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        if (!bl) {
            stringTokenizer.nextToken();
        }
        this.totalCpuTime = Double.parseDouble(stringTokenizer.nextToken());
    }

    private void parsePhaseName() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.inputString, " ");
        String string = stringTokenizer.nextToken();
        this.phaseName = new StringBuffer();
        if (!string.equals("DONE")) {
            stringTokenizer.nextToken();
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("...")) continue;
            this.phaseName.append(string2);
            this.phaseName.append(" ");
        }
    }

    private void parseAccuracy() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.inputString, " ");
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
    }

    public void initializeThread() {
        this.nodeID = this.nodeID == -1 ? 0 : this.nodeID;
        this.contextID = this.contextID == -1 ? 0 : this.contextID;
        this.threadID = this.threadID == -1 ? 0 : this.threadID;
        this.node = this.getNode(this.nodeID);
        if (this.node == null) {
            this.node = this.addNode(this.nodeID);
        }
        this.context = this.node.getContext(this.contextID);
        if (this.context == null) {
            this.context = this.node.addContext(this.contextID);
        }
        this.thread = this.context.getThread(this.threadID);
        if (this.thread == null) {
            this.thread = this.context.addThread(this.threadID);
        }
    }

    public Thread getThread() {
        return this.thread;
    }

    private void createFunction(Thread thread, MyEvent myEvent, boolean bl) {
        if (bl) {
            this.function = this.addFunction("MAIN => " + myEvent.name);
            this.function.addGroup(this.addGroup("TAU_CALLPATH"));
        } else {
            this.function = this.addFunction(myEvent.name);
        }
        this.function.addGroup(this.addGroup("TAU_DEFAULT"));
        this.fp = new FunctionProfile(this.function, 3);
        thread.addFunctionProfile(this.fp);
        this.fp.setNumCalls(1.0);
        this.fp.setNumSubr(myEvent.subroutines);
        String string = "CPU TIME";
        Metric metric = this.addMetric(string, thread);
        if (myEvent.name.equals("MAIN")) {
            this.fp.setInclusive(metric.getID(), myEvent.cpu);
            this.fp.setExclusive(metric.getID(), 0.0);
        } else {
            this.fp.setInclusive(metric.getID(), myEvent.cpu);
            this.fp.setExclusive(metric.getID(), myEvent.cpu);
        }
        String string2 = "Time";
        Metric metric2 = this.addMetric(string2, thread);
        if (myEvent.name.equals("MAIN")) {
            this.fp.setInclusive(metric2.getID(), myEvent.wall);
            this.fp.setExclusive(metric2.getID(), 0.0);
        } else {
            this.fp.setInclusive(metric2.getID(), myEvent.wall);
            this.fp.setExclusive(metric2.getID(), myEvent.wall);
        }
        String string3 = "CPU UTILIZATION";
        Metric metric3 = this.addMetric(string3, thread);
        if (myEvent.name.equals("MAIN")) {
            if (myEvent.wall == 0.0) {
                this.fp.setInclusive(metric3.getID(), 0.0);
            } else {
                this.fp.setInclusive(metric3.getID(), myEvent.cpu / myEvent.wall);
            }
            this.fp.setExclusive(metric3.getID(), 1.0);
        } else if (myEvent.wall == 0.0) {
            this.fp.setInclusive(metric3.getID(), 0.0);
            this.fp.setExclusive(metric3.getID(), 0.0);
        } else {
            this.fp.setInclusive(metric3.getID(), myEvent.cpu / myEvent.wall);
            this.fp.setExclusive(metric3.getID(), myEvent.cpu / myEvent.wall);
        }
    }

    private void parseMetadata() {
        if (this.inputString.startsWith("TOTAL NUMBER OF") || this.inputString.startsWith("NUMBER OF ") || this.inputString.startsWith("SPIN MULTIPLICITY")) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.inputString, "=");
            String string = stringTokenizer.nextToken().trim();
            String string2 = stringTokenizer.nextToken().trim();
            this.metadata.put(string, string2);
        } else if (this.inputString.startsWith("THE NUCLEAR REPULSION")) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.inputString, " ");
            stringTokenizer.nextToken().trim();
            String string = stringTokenizer.nextToken().trim();
            string = string + " " + stringTokenizer.nextToken().trim();
            string = string + " " + stringTokenizer.nextToken().trim();
            stringTokenizer.nextToken().trim();
            String string3 = stringTokenizer.nextToken().trim();
            this.metadata.put(string, string3);
        }
    }

    private void setMetadata() {
        for (String string : this.metadata.keySet()) {
            String string2 = this.metadata.get(string);
            this.getThread().getMetaData().put(string, string2);
        }
        for (String string : this.atomCounts.keySet()) {
            Integer n = this.atomCounts.get(string);
            this.getThread().getMetaData().put("NUMBER OF ATOMS: " + string, n.toString());
        }
        Iterator<String> iterator = this.atomCounts.keySet().iterator();
    }

    private class MyEvent {
        public String name = new String();
        public double cpu = 0.0;
        public double wall = 0.0;
        public int subroutines = 0;

        public MyEvent(String string, double d, double d2, int n) {
            this.name = string;
            this.cpu = d * 1000000.0;
            this.wall = d2 * 1000000.0;
            if (this.cpu > this.wall) {
                this.wall = this.cpu;
            }
        }
    }
}

