/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.PSRunDataSource;
import edu.uoregon.tau.perfdmf.Snapshot;
import edu.uoregon.tau.perfdmf.Thread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PSRunLoadHandler
extends DefaultHandler {
    private StringBuffer accumulator = new StringBuffer();
    protected String currentElement;
    protected String metricName;
    protected String metricValue;
    protected Hashtable<String, String> metricHash = new Hashtable();
    private String fileName;
    private String functionName;
    private String lineno;
    private boolean isProfile;
    private PSRunDataSource dataSource;
    private double totalProfileValue;
    private Map<String, String> attribMap = new HashMap<String, String>();
    private String pid = "-1";
    private String thread = "-1";
    private Map<String, String> metadata = new HashMap<String, String>();
    private List<String> metaPrefix = new ArrayList<String>();
    private boolean inMetadata = false;
    private int cacheIndex = 0;
    private int sequence;
    private double wallticks = 1.0;
    private double clockspeed = 1.0;
    private double wallclock = 1.0;
    private double totalsamples = 1.0;
    private boolean itimer;

    public PSRunLoadHandler(PSRunDataSource pSRunDataSource) {
        this.dataSource = pSRunDataSource;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    private String getInsensitiveValue(Attributes attributes, String string) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getLocalName(i).equalsIgnoreCase(string)) continue;
            return attributes.getValue(i);
        }
        return null;
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        if (this.isProfile) {
            Function function = this.dataSource.getFunction("Entire application");
            if (function == null) {
                function = this.dataSource.addFunction("Entire application", 1);
            }
            FunctionProfile functionProfile = new FunctionProfile(function, this.dataSource.getNumberOfMetrics(), this.dataSource.getThread().getNumSnapshots());
            this.dataSource.getThread().addFunctionProfile(functionProfile);
            functionProfile.setExclusive(0, 0.0);
            functionProfile.setInclusive(0, this.totalProfileValue);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        block6: {
            int n;
            block14: {
                int n2;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block5: {
                                                this.accumulator.setLength(0);
                                                if (!string2.equalsIgnoreCase("hwpcprofile")) break block5;
                                                this.isProfile = true;
                                                this.inMetadata = false;
                                                break block6;
                                            }
                                            if (string2.equalsIgnoreCase("hwpcprofiledata")) {
                                                throw new DataSourceException("<html><center>This PerfSuite XML file contains unprocessed profile data.<br>Please use `psprocess -x` (from PerfSuite) to generate a processed XML file.</center></html>");
                                            }
                                            if (!string2.equalsIgnoreCase("hwpcevent")) break block7;
                                            this.currentElement = "hwpcevent";
                                            this.metricName = attributes.getValue("name");
                                            break block6;
                                        }
                                        if (!string2.equalsIgnoreCase("file")) break block8;
                                        this.fileName = this.getInsensitiveValue(attributes, "name");
                                        break block6;
                                    }
                                    if (!string2.equalsIgnoreCase("function")) break block9;
                                    this.functionName = this.getInsensitiveValue(attributes, "name");
                                    break block6;
                                }
                                if (!string2.equalsIgnoreCase("line")) break block10;
                                this.lineno = this.getInsensitiveValue(attributes, "lineno");
                                break block6;
                            }
                            if (!string2.equalsIgnoreCase("multihwpcprofilereport")) break block11;
                            this.isProfile = true;
                            break block6;
                        }
                        if (!string2.equalsIgnoreCase("hwpcprofilereport")) break block12;
                        this.isProfile = true;
                        break block6;
                    }
                    if (!string2.equalsIgnoreCase("executioninfo")) break block13;
                    this.inMetadata = true;
                    this.cacheIndex = 0;
                    break block6;
                }
                if (!string2.equalsIgnoreCase("cache") || !this.inMetadata) break block14;
                ++this.cacheIndex;
                this.metaPrefix.add(string2 + this.cacheIndex + ": ");
                StringBuffer stringBuffer = new StringBuffer();
                for (n2 = 0; n2 < this.metaPrefix.size(); ++n2) {
                    stringBuffer.append(this.metaPrefix.get(n2));
                }
                for (n2 = 0; n2 < attributes.getLength(); ++n2) {
                    String string4 = attributes.getQName(n2);
                    this.metadata.put(stringBuffer.toString() + string4, attributes.getValue(string4).trim());
                }
                break block6;
            }
            if (string2.equalsIgnoreCase("pid") || string2.equalsIgnoreCase("thread") || !this.inMetadata) break block6;
            this.metaPrefix.add(string2 + ": ");
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < this.metaPrefix.size(); ++n) {
                stringBuffer.append(this.metaPrefix.get(n));
            }
            for (n = 0; n < attributes.getLength(); ++n) {
                String string5 = attributes.getQName(n);
                this.metadata.put(stringBuffer.toString() + string5, attributes.getValue(string5).trim());
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.accumulator.append(cArray, n, n2);
    }

    private void processAnnotation(String string) {
        Object object;
        String string2;
        String string3 = "TAU^";
        if (string.indexOf(string3) == -1) {
            return;
        }
        int n = string.indexOf(string3) + string3.length();
        while (n != -1) {
            int n2 = string.indexOf("^", n) + 1;
            int n3 = string.indexOf("^", n2) + 1;
            if (n2 <= 0 || n3 <= 0) break;
            string2 = string.substring(n, n2 - 1);
            object = string.substring(n2, n3 - 1);
            this.attribMap.put(string2, (String)object);
            n = n3;
        }
        String string4 = this.attribMap.get("seq");
        this.sequence = Integer.parseInt(string4);
        Thread thread = this.dataSource.getThread();
        thread.addSnapshots(this.sequence + 1);
        string2 = this.attribMap.get("phase");
        object = thread.getSnapshots().get(this.sequence);
        ((Snapshot)object).setName(string2);
        long l = Long.parseLong(this.attribMap.get("timestamp"));
        ((Snapshot)object).setTimestamp(l);
        thread.getMetaData().put("Starting Timestamp", this.attribMap.get("start"));
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        Object object;
        if (string2.equalsIgnoreCase("wallclock")) {
            object = this.accumulator.toString();
            this.wallticks = Double.parseDouble((String)object);
        }
        if (string2.equalsIgnoreCase("totalsamples")) {
            object = this.accumulator.toString();
            this.totalsamples = Double.parseDouble((String)object);
        }
        if (string2.equalsIgnoreCase("clockspeed")) {
            object = this.accumulator.toString();
            this.clockspeed = Double.parseDouble((String)object);
            this.wallclock = this.wallticks / this.clockspeed;
        }
        if (string2.equalsIgnoreCase("annotation")) {
            object = this.accumulator.toString();
            this.processAnnotation((String)object);
        } else if (string2.equalsIgnoreCase("hwpcevent")) {
            if (this.metricName.compareTo("ITIMER_PROF") == 0) {
                this.itimer = true;
            }
            if (!this.isProfile) {
                this.metricValue = this.accumulator.toString();
                this.metricHash.put(this.metricName, new String(this.metricValue));
            } else {
                this.dataSource.addMetric(this.metricName);
            }
        } else if (string2.equalsIgnoreCase("line")) {
            double d = Double.parseDouble(this.accumulator.toString());
            if (this.itimer) {
                d = d / this.totalsamples * this.wallclock;
            }
            this.totalProfileValue += d;
            Function function = this.dataSource.addFunction(this.functionName + ":" + this.fileName + ":" + this.lineno);
            FunctionProfile functionProfile = this.dataSource.getThread().getFunctionProfile(function);
            if (functionProfile == null) {
                functionProfile = new FunctionProfile(function, this.dataSource.getNumberOfMetrics(), this.dataSource.getThread().getNumSnapshots());
            }
            this.dataSource.getThread().addFunctionProfile(functionProfile);
            functionProfile.setExclusive(this.sequence, 0, d);
            functionProfile.setInclusive(this.sequence, 0, d);
        } else if (string2.equalsIgnoreCase("pid")) {
            this.pid = this.accumulator.toString();
            this.metadata.put(string2, this.pid);
        } else if (string2.equalsIgnoreCase("thread")) {
            this.thread = this.accumulator.toString();
            this.dataSource.incrementThread(this.thread, this.pid);
            this.metadata.put(string2, this.thread);
        } else if (string2.equalsIgnoreCase("hwpcprofilereport")) {
            object = this.dataSource.getFunction("Entire application");
            if (object == null) {
                object = this.dataSource.addFunction("Entire application", 1);
            }
            FunctionProfile functionProfile = new FunctionProfile((Function)object, this.dataSource.getNumberOfMetrics(), this.dataSource.getThread().getNumSnapshots());
            this.dataSource.getThread().addFunctionProfile(functionProfile);
            functionProfile.setExclusive(0, 0.0);
            functionProfile.setInclusive(0, this.totalProfileValue);
            for (String string4 : this.metadata.keySet()) {
                String string5 = this.metadata.get(string4);
                this.dataSource.getThread().getMetaData().put(string4, string5.trim());
            }
        } else if (!string2.equalsIgnoreCase("multihwpcprofilereport")) {
            if (string2.equalsIgnoreCase("executioninfo")) {
                this.inMetadata = false;
                this.metaPrefix.clear();
            } else if (string2.equalsIgnoreCase("machineinfo")) {
                this.inMetadata = false;
                this.metaPrefix.clear();
            } else if (this.inMetadata) {
                this.metaPrefix.remove(this.metaPrefix.size() - 1);
                object = new StringBuffer();
                for (int i = 0; i < this.metaPrefix.size(); ++i) {
                    ((StringBuffer)object).append(this.metaPrefix.get(i));
                }
                this.metadata.put(object + string2, this.accumulator.toString().trim());
            }
        }
    }

    public Map<String, String> getAttributes() {
        return this.attribMap;
    }

    public Hashtable<String, String> getMetricHash() {
        return this.metricHash;
    }

    public boolean getIsProfile() {
        return this.isProfile;
    }
}

