/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.common.AlphanumComparator;
import edu.uoregon.tau.common.Gzip;
import edu.uoregon.tau.common.MetaDataMap;
import edu.uoregon.tau.perfdmf.AtomicEvent;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Database;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.database.DBConnector;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTrial;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class Trial
implements Serializable,
Comparable<Trial> {
    private static final long serialVersionUID = 3356242487725127605L;
    public static final String XML_METADATA = "XML_METADATA";
    public static final String XML_METADATA_GZ = "XML_METADATA_GZ";
    protected int trialID;
    private int experimentID;
    private int applicationID;
    protected String name;
    protected List<Metric> metrics;
    protected String[] fields;
    protected DataSource dataSource;
    protected Database database;
    protected MetaDataMap metaData = new MetaDataMap();
    protected MetaDataMap uncommonMetaData = new MetaDataMap();
    protected Map<Integer, Function> intervalEventMap = null;
    protected Map<Integer, AtomicEvent> atomicEventMap = null;
    private boolean xmlMetaDataLoaded = false;
    private static AlphanumComparator alphanum = new AlphanumComparator();

    public boolean isXmlMetaDataLoaded() {
        return this.xmlMetaDataLoaded;
    }

    public void setXmlMetaDataLoaded(boolean bl) {
        this.xmlMetaDataLoaded = bl;
    }

    private void parseMetaData(String string) {
        try {
            this.metaData = new MetaDataMap();
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            XMLParser xMLParser = new XMLParser(this.metaData, this.uncommonMetaData);
            xMLReader.setContentHandler(xMLParser);
            xMLReader.setErrorHandler(xMLParser);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            xMLReader.parse(new InputSource(byteArrayInputStream));
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Trial() {
        this.fields = new String[0];
    }

    public Trial(Trial trial) {
        this.name = trial.getName();
        this.applicationID = trial.getApplicationID();
        this.experimentID = trial.getExperimentID();
        this.trialID = trial.getID();
        this.fields = (String[])trial.fields.clone();
        this.metaData = trial.metaData;
        this.uncommonMetaData = trial.uncommonMetaData;
        this.database = trial.database;
        this.dataSource = trial.dataSource;
    }

    public int getNumFields() {
        return this.fields.length;
    }

    public String getFieldName(int n) {
        return this.database.getTrialFieldNames()[n];
    }

    public int getFieldType(int n) {
        return this.database.getTrialFieldTypes()[n];
    }

    public String getField(int n) {
        return this.fields[n];
    }

    public void loadXMLMetadata(DB dB) throws SQLException {
        HashMap<Integer, Function> hashMap = new HashMap<Integer, Function>();
        this.loadXMLMetadata(dB, hashMap);
    }

    public void loadXMLMetadata(DB dB, Map<Integer, Function> map) throws SQLException {
        if (this.isXmlMetaDataLoaded()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ");
        boolean bl = true;
        int n = -1;
        for (int i = 0; i < this.database.getTrialFieldNames().length; ++i) {
            if (!this.database.getTrialFieldNames()[i].toUpperCase().equals(XML_METADATA_GZ) && !this.database.getTrialFieldNames()[i].toUpperCase().equals(XML_METADATA)) continue;
            if (this.database.getTrialFieldNames()[i].toUpperCase().equals(XML_METADATA_GZ)) {
                // empty if block
            }
            if (this.database.getTrialFieldNames()[i].toUpperCase().equals(XML_METADATA)) {
                n = i;
            }
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("t." + this.database.getTrialFieldNames()[i]);
            bl = false;
        }
        stringBuffer.append(" from " + dB.getSchemaPrefix() + "trial t inner join " + dB.getSchemaPrefix() + "experiment e ");
        stringBuffer.append("on t.experiment = e.id ");
        stringBuffer.append("WHERE t.experiment = " + this.getExperimentID() + " AND t.id = " + this.getID());
        ResultSet resultSet = null;
        resultSet = dB.executeQuery(stringBuffer.toString());
        if (resultSet.next()) {
            this.setField(n, resultSet.getString(1));
            InputStream inputStream = resultSet.getBinaryStream(2);
            String string = Gzip.decompress((InputStream)inputStream);
            if (string != null && string.length() > 0) {
                this.setField(XML_METADATA, string);
                this.parseMetaData(string);
            }
        }
        this.setXmlMetaDataLoaded(true);
    }

    public String getField(String string) {
        if (this.database.getTrialFieldNames() == null) {
            return null;
        }
        String string2 = null;
        for (int i = 0; i < this.database.getTrialFieldNames().length; ++i) {
            if (!string.toUpperCase().equals(this.database.getTrialFieldNames()[i].toUpperCase()) || i >= this.fields.length) continue;
            string2 = this.fields[i];
            break;
        }
        return string2;
    }

    public void setField(String string, String string2) {
        for (int i = 0; i < this.database.getTrialFieldNames().length; ++i) {
            if (!string.toUpperCase().equals(this.database.getTrialFieldNames()[i].toUpperCase())) continue;
            if (!DBConnector.isIntegerType(this.database.getTrialFieldTypes()[i]) || string2 != null) {
                // empty if block
            }
            if (!DBConnector.isFloatingPointType(this.database.getTrialFieldTypes()[i]) || string2 != null) {
                // empty if block
            }
            if (this.fields.length <= i) {
                this.fields = new String[this.database.getTrialFieldTypes().length];
            }
            this.fields[i] = string2;
        }
    }

    public void setField(int n, String string) {
        if (!DBConnector.isIntegerType(this.database.getTrialFieldTypes()[n]) || string != null) {
            // empty if block
        }
        if (!DBConnector.isFloatingPointType(this.database.getTrialFieldTypes()[n]) || string != null) {
            // empty if block
        }
        this.fields[n] = string;
    }

    public int getID() {
        return this.trialID;
    }

    public int getExperimentID() {
        return this.experimentID;
    }

    public int getApplicationID() {
        return this.applicationID;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public int getMetricCount() {
        if (this.getMetrics() == null) {
            return 0;
        }
        return this.getMetrics().size();
    }

    public void addMetric(Metric metric) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<Metric>();
        }
        this.metrics.add(metric);
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public void setID(int n) {
        this.trialID = n;
    }

    public void setExperimentID(int n) {
        this.experimentID = n;
    }

    public void setApplicationID(int n) {
        this.applicationID = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void getTrialMetrics(DB dB) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select id, name ");
        stringBuffer.append("from " + dB.getSchemaPrefix() + "metric ");
        stringBuffer.append("where trial = ");
        stringBuffer.append(this.getID());
        stringBuffer.append(" order by id ");
        try {
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                Metric metric = new Metric();
                metric.setID(resultSet.getInt(1));
                metric.setName(resultSet.getString(2));
                metric.setTrialID(this.getID());
                this.addMetric(metric);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static String[] getFieldNames(DB dB) {
        Trial.getMetaData(dB);
        return dB.getDatabase().getTrialFieldNames();
    }

    public static void getMetaData(DB dB) {
        Trial.getMetaData(dB, false);
    }

    public static void getMetaData(DB dB, boolean bl) {
        try {
            String[] stringArray;
            Object object;
            int n;
            ResultSet resultSet = null;
            DatabaseMetaData databaseMetaData = dB.getMetaData();
            resultSet = dB.getDBType().compareTo("oracle") == 0 || dB.getDBType().compareTo("derby") == 0 || dB.getDBType().compareTo("h2") == 0 || dB.getDBType().compareTo("db2") == 0 ? databaseMetaData.getColumns(null, null, "TRIAL", "%") : databaseMetaData.getColumns(null, null, "trial", "%");
            Vector<String> vector = new Vector<String>();
            Vector<Integer> vector2 = new Vector<Integer>();
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            boolean bl2 = false;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            for (n = 0; n < resultSetMetaData.getColumnCount(); ++n) {
            }
            while (resultSet.next()) {
                n = resultSet.getInt("DATA_TYPE");
                object = resultSet.getString("COLUMN_NAME");
                stringArray = resultSet.getString("TYPE_NAME");
                Integer n2 = new Integer(resultSet.getInt("COLUMN_SIZE"));
                if (((String)object).equals("ID")) {
                    if (bl2) break;
                    bl2 = true;
                }
                if (!bl && (!DBConnector.isReadAbleType(n) || ((String)object).toUpperCase().compareTo("ID") == 0 || ((String)object).toUpperCase().compareTo("NAME") == 0 || ((String)object).toUpperCase().compareTo("APPLICATION") == 0 || ((String)object).toUpperCase().compareTo("EXPERIMENT") == 0)) continue;
                vector.add(resultSet.getString("COLUMN_NAME"));
                vector2.add(new Integer(n));
                arrayList.add(stringArray);
                arrayList2.add(n2);
            }
            resultSet.close();
            String[] stringArray2 = new String[vector.size()];
            object = new int[vector2.size()];
            stringArray = new String[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                stringArray2[i] = (String)vector.get(i);
                object[i] = (Integer)vector2.get(i);
                stringArray[i] = (Integer)arrayList2.get(i) > 255 ? (String)arrayList.get(i) + "(" + ((Integer)arrayList2.get(i)).toString() + ")" : (String)arrayList.get(i);
            }
            dB.getDatabase().setTrialFieldNames(stringArray2);
            dB.getDatabase().setTrialFieldTypes((int[])object);
            dB.getDatabase().setTrialFieldTypeNames(stringArray);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public static Vector<Trial> getTrialListWithoutMetadata(DB dB, String string) {
        return Trial.getTrialList(dB, string, false);
    }

    public static Vector<Trial> getTrialList(DB dB, String string, boolean bl) {
        if (dB.getSchemaVersion() > 0) {
            return TAUdbTrial.getTrialList(dB, bl, string);
        }
        try {
            Object object;
            Trial.getMetaData(dB);
            Database database = dB.getDatabase();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("select t.id, t.experiment, e.application, ");
            stringBuffer.append("t.name");
            for (int i = 0; i < database.getTrialFieldNames().length; ++i) {
                if (!bl && (database.getTrialFieldNames()[i].toUpperCase().equals(XML_METADATA_GZ) || database.getTrialFieldNames()[i].toUpperCase().equals(XML_METADATA))) continue;
                stringBuffer.append(", t." + database.getTrialFieldNames()[i]);
            }
            stringBuffer.append(" from " + dB.getSchemaPrefix() + "trial t inner join " + dB.getSchemaPrefix() + "experiment e ");
            stringBuffer.append("on t.experiment = e.id ");
            stringBuffer.append(string);
            stringBuffer.append(" order by t.name, t.id ");
            Vector<Trial> vector = new Vector<Trial>();
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                object = new Trial();
                ((Trial)object).setDatabase(dB.getDatabase());
                int n = 1;
                ((Trial)object).setID(resultSet.getInt(n++));
                ((Trial)object).setExperimentID(resultSet.getInt(n++));
                ((Trial)object).setApplicationID(resultSet.getInt(n++));
                ((Trial)object).setName(resultSet.getString(n++));
                boolean bl2 = false;
                for (int i = 0; i < database.getTrialFieldNames().length; ++i) {
                    if (database.getTrialFieldNames()[i].equalsIgnoreCase(XML_METADATA_GZ)) {
                        InputStream inputStream;
                        String string2;
                        if (!bl || dB.getDBType().compareTo("sqlite") == 0) continue;
                        if ((string2 = Gzip.decompress((InputStream)(inputStream = resultSet.getBinaryStream(n++)))) != null && string2.length() > 0) {
                            ((Trial)object).setField(XML_METADATA, string2);
                            super.parseMetaData(string2);
                        }
                        bl2 = true;
                        ((Trial)object).setXmlMetaDataLoaded(true);
                        continue;
                    }
                    if (database.getTrialFieldNames()[i].equalsIgnoreCase(XML_METADATA)) {
                        if (!bl || bl2) continue;
                        ((Trial)object).setField(i, resultSet.getString(n++));
                        ((Trial)object).setXmlMetaDataLoaded(true);
                        continue;
                    }
                    ((Trial)object).setField(i, resultSet.getString(n++));
                }
                vector.addElement((Trial)object);
            }
            resultSet.close();
            object = vector.elements();
            while (object.hasMoreElements()) {
                Trial trial = (Trial)object.nextElement();
                trial.getTrialMetrics(dB);
            }
            Collections.sort(vector);
            return vector;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void rename(DB dB, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE " + dB.getSchemaPrefix() + "trial SET name = ?");
        stringBuffer.append(" WHERE id = ?");
        try {
            PreparedStatement preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, this.trialID);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.setName(string);
    }

    public int saveTrial(DB dB) {
        if (dB.getSchemaVersion() > 0) {
            return TAUdbTrial.saveTrialTAUdb(dB, this.trialID, this.dataSource, this.name);
        }
        boolean bl = this.exists(dB);
        int n = 0;
        try {
            int n2;
            Object object;
            this.database = dB.getDatabase();
            boolean bl2 = false;
            Timestamp timestamp = null;
            String string = null;
            if (this.getMetaData() != null) {
                string = this.getMetaData().get("UTC Time");
            }
            if (string == null && this.getDataSource() != null && this.getDataSource().getAllThreads() != null && this.getDataSource().getAllThreads().get(0).getMetaData() != null) {
                string = this.getDataSource().getAllThreads().get(0).getMetaData().get("UTC Time");
            }
            if (string != null) {
                try {
                    object = DataSource.dateTime.parse(string);
                    timestamp = new Timestamp(((Date)object).getTime());
                    bl2 = true;
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
            }
            this.checkForMetadataColumn(dB);
            this.checkForMetadataColumn2(dB);
            if (!bl) {
                Trial.getMetaData(dB);
                this.fields = new String[this.database.getTrialFieldNames().length];
            }
            if (this.getDataSource() != null) {
                this.setField("node_count", Integer.toString(1 + this.getDataSource().getMaxNCTNumbers()[0]));
                this.setField("contexts_per_node", Integer.toString(1 + this.getDataSource().getMaxNCTNumbers()[1]));
                this.setField("threads_per_context", Integer.toString(1 + this.getDataSource().getMaxNCTNumbers()[2]));
            }
            if (this.getDataSource() != null && (object = this.getDataSource().getMetadataString()) != null && ((String)object).length() > 0) {
                if (dB.getDBType().compareTo("sqlite") == 0) {
                    this.setField(XML_METADATA, (String)object);
                    this.setField(XML_METADATA_GZ, null);
                } else {
                    this.setField(XML_METADATA, null);
                    this.setField(XML_METADATA_GZ, (String)object);
                }
            }
            boolean bl3 = false;
            for (int i = 0; i < this.getNumFields(); ++i) {
                if (!this.getFieldName(i).equals("date") || this.getFieldType(i) != 93) continue;
                bl3 = true;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (bl) {
                stringBuffer.append("UPDATE " + dB.getSchemaPrefix() + "trial SET name = ?, experiment = ?");
                for (n2 = 0; n2 < this.getNumFields(); ++n2) {
                    if (!DBConnector.isWritableType(this.getFieldType(n2))) continue;
                    stringBuffer.append(", " + this.getFieldName(n2) + " = ?");
                }
                if (bl2 && bl3) {
                    stringBuffer.append(", date = ?");
                }
                stringBuffer.append(" WHERE id = ?");
            } else {
                stringBuffer.append("INSERT INTO " + dB.getSchemaPrefix() + "trial (name, experiment");
                for (n2 = 0; n2 < this.getNumFields(); ++n2) {
                    if (!DBConnector.isWritableType(this.getFieldType(n2))) continue;
                    stringBuffer.append(", " + this.getFieldName(n2));
                }
                if (bl2 && bl3) {
                    stringBuffer.append(", date");
                }
                stringBuffer.append(") VALUES (?, ?");
                for (n2 = 0; n2 < this.getNumFields(); ++n2) {
                    if (!DBConnector.isWritableType(this.getFieldType(n2))) continue;
                    stringBuffer.append(", ?");
                }
                if (bl2 && bl3) {
                    stringBuffer.append(", ?");
                }
                stringBuffer.append(")");
            }
            PreparedStatement preparedStatement = dB.prepareStatement(stringBuffer.toString());
            int n3 = 1;
            preparedStatement.setString(n3++, this.name);
            preparedStatement.setInt(n3++, this.experimentID);
            for (int i = 0; i < this.getNumFields(); ++i) {
                if (!DBConnector.isWritableType(this.getFieldType(i))) continue;
                if (this.getFieldName(i).equalsIgnoreCase(XML_METADATA_GZ)) {
                    if (this.getField(i) == null) {
                        preparedStatement.setNull(n3++, this.getFieldType(i));
                        continue;
                    }
                    byte[] byArray = Gzip.compress((String)this.getField(i));
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    preparedStatement.setBinaryStream(n3++, (InputStream)byteArrayInputStream, byArray.length);
                    continue;
                }
                int n4 = this.getFieldType(i);
                if (this.getField(i) == null) {
                    preparedStatement.setNull(n3++, n4);
                    continue;
                }
                if (n4 == 12 || n4 == 2005 || n4 == -1) {
                    preparedStatement.setString(n3++, this.getField(i));
                    continue;
                }
                if (n4 == 4) {
                    preparedStatement.setInt(n3++, Integer.parseInt(this.getField(i)));
                    continue;
                }
                if (n4 == 3 || n4 == 8 || n4 == 6) {
                    preparedStatement.setDouble(n3++, Double.parseDouble(this.getField(i)));
                    continue;
                }
                if (n4 == 92 || n4 == 93) {
                    preparedStatement.setString(n3++, this.getField(i));
                    continue;
                }
                preparedStatement.setNull(n3++, n4);
            }
            if (bl2 && bl3) {
                preparedStatement.setTimestamp(n3++, timestamp);
            }
            if (bl) {
                preparedStatement.setInt(n3, this.trialID);
            }
            preparedStatement.executeUpdate();
            preparedStatement.close();
            if (bl) {
                n = this.trialID;
            } else {
                String string2 = new String();
                string2 = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM trial" : (dB.getDBType().compareTo("sqlite") == 0 ? "select seq from sqlite_sequence where name = 'trial'" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM trial" : (dB.getDBType().compareTo("h2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM trial" : (dB.getDBType().compareTo("oracle") == 0 ? "select " + dB.getSchemaPrefix() + "trial_id_seq.currval FROM dual" : "select currval('trial_id_seq');")))));
                n = Integer.parseInt(dB.getDataItem(string2));
            }
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while saving the trial.");
            sQLException.printStackTrace();
        }
        return n;
    }

    private static void deleteAtomicLocationProfilesMySQL(DB dB, int n) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select id ");
        stringBuffer.append("from " + dB.getSchemaPrefix() + "atomic_event where trial = ");
        stringBuffer.append(n);
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("DELETE FROM atomic_location_profile WHERE atomic_event IN (-1");
        ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
        while (resultSet.next()) {
            stringBuffer2.append(", " + resultSet.getInt(1));
        }
        resultSet.close();
        PreparedStatement preparedStatement = dB.prepareStatement(stringBuffer2.toString() + ")");
        preparedStatement.execute();
        preparedStatement.close();
    }

    private static void deleteIntervalLocationProfilesMySQL(DB dB, int n) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select id ");
        stringBuffer.append("from " + dB.getSchemaPrefix() + "interval_event where trial = ");
        stringBuffer.append(n);
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(" (-1");
        ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
        while (resultSet.next()) {
            stringBuffer2.append(", " + resultSet.getInt(1));
        }
        resultSet.close();
        PreparedStatement preparedStatement = dB.prepareStatement("DELETE FROM interval_location_profile WHERE interval_event IN" + stringBuffer2.toString() + ")");
        preparedStatement.execute();
        preparedStatement.close();
        preparedStatement = dB.prepareStatement("DELETE FROM interval_mean_summary WHERE interval_event IN" + stringBuffer2.toString() + ")");
        preparedStatement.execute();
        preparedStatement.close();
        preparedStatement = dB.prepareStatement("DELETE FROM interval_total_summary WHERE interval_event IN" + stringBuffer2.toString() + ")");
        preparedStatement.execute();
        preparedStatement.close();
    }

    public static void deleteMetric(DB dB, int n, int n2) throws SQLException {
        if (dB.getSchemaVersion() > 0) {
            TAUdbTrial.deleteMetric(dB, n, n2);
            return;
        }
        PreparedStatement preparedStatement = null;
        preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "interval_location_profile WHERE metric = ?");
        preparedStatement.setInt(1, n2);
        preparedStatement.execute();
        preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "interval_mean_summary WHERE metric = ?");
        preparedStatement.setInt(1, n2);
        preparedStatement.execute();
        preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "interval_total_summary WHERE metric = ?");
        preparedStatement.setInt(1, n2);
        preparedStatement.execute();
        preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "metric WHERE id = ?");
        preparedStatement.setInt(1, n2);
        preparedStatement.execute();
    }

    public static void deleteTrial(DB dB, int n) throws SQLException {
        if (dB.getSchemaVersion() > 0) {
            TAUdbTrial.deleteTrial(dB, new int[]{n});
            return;
        }
        PreparedStatement preparedStatement = null;
        if (dB.getDBType().compareTo("mysql") == 0) {
            Trial.deleteAtomicLocationProfilesMySQL(dB, n);
        } else {
            preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "atomic_location_profile WHERE atomic_event in (SELECT id FROM " + dB.getSchemaPrefix() + "atomic_event WHERE trial = ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
        }
        preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "atomic_event WHERE trial = ?");
        preparedStatement.setInt(1, n);
        preparedStatement.execute();
        if (dB.getDBType().compareTo("mysql") == 0) {
            Trial.deleteIntervalLocationProfilesMySQL(dB, n);
        } else {
            preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "interval_location_profile WHERE interval_event IN (SELECT id FROM " + dB.getSchemaPrefix() + "interval_event WHERE trial = ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
        }
        if (dB.getDBType().compareTo("mysql") != 0) {
            preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "interval_mean_summary WHERE interval_event IN (SELECT id FROM " + dB.getSchemaPrefix() + "interval_event WHERE trial = ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
        }
        if (dB.getDBType().compareTo("mysql") != 0) {
            preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "interval_total_summary WHERE interval_event IN (SELECT id FROM " + dB.getSchemaPrefix() + "interval_event WHERE trial = ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
        }
        preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "interval_event WHERE trial = ?");
        preparedStatement.setInt(1, n);
        preparedStatement.execute();
        preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "metric WHERE trial = ?");
        preparedStatement.setInt(1, n);
        preparedStatement.execute();
        preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "trial WHERE id = ?");
        preparedStatement.setInt(1, n);
        preparedStatement.execute();
    }

    private boolean exists(DB dB) {
        boolean bl = false;
        try {
            PreparedStatement preparedStatement = dB.prepareStatement("SELECT name FROM " + dB.getSchemaPrefix() + "trial WHERE id = ?");
            preparedStatement.setInt(1, this.trialID);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                bl = true;
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while saving the application.");
            sQLException.printStackTrace();
        }
        return bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void checkForMetadataColumn(DB dB) {
        String[] stringArray = Trial.getFieldNames(dB);
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(XML_METADATA)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ALTER TABLE " + dB.getSchemaPrefix() + "trial ADD ");
            if (dB.getDBType().equalsIgnoreCase("oracle")) {
                stringBuffer.append(" ( ");
            } else {
                stringBuffer.append(" COLUMN ");
            }
            stringBuffer.append(XML_METADATA);
            if (dB.getDBType().equalsIgnoreCase("oracle")) {
                stringBuffer.append(" CLOB)");
            } else if (dB.getDBType().equalsIgnoreCase("derby")) {
                stringBuffer.append(" CLOB");
            } else if (dB.getDBType().equalsIgnoreCase("h2")) {
                stringBuffer.append(" CLOB");
            } else if (dB.getDBType().equalsIgnoreCase("db2")) {
                stringBuffer.append(" CLOB");
            } else if (dB.getDBType().equalsIgnoreCase("mysql")) {
                stringBuffer.append(" TEXT");
            } else if (dB.getDBType().equalsIgnoreCase("postgresql")) {
                stringBuffer.append(" TEXT");
            }
            try {
                dB.execute(stringBuffer.toString());
            }
            catch (SQLException sQLException) {
                System.err.println("Unable to add XML_METADATA column to trial table.");
                sQLException.printStackTrace();
            }
        }
    }

    private void checkForMetadataColumn2(DB dB) {
        String[] stringArray = Trial.getFieldNames(dB);
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(XML_METADATA_GZ)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ALTER TABLE " + dB.getSchemaPrefix() + "trial ADD ");
            if (dB.getDBType().equalsIgnoreCase("oracle")) {
                stringBuffer.append(" ( ");
            } else {
                stringBuffer.append(" COLUMN ");
            }
            stringBuffer.append(XML_METADATA_GZ);
            if (dB.getDBType().equalsIgnoreCase("oracle")) {
                stringBuffer.append(" BLOB)");
            } else if (dB.getDBType().equalsIgnoreCase("derby")) {
                stringBuffer.append(" BLOB");
            } else if (dB.getDBType().equalsIgnoreCase("h2")) {
                stringBuffer.append(" BLOB");
            } else if (dB.getDBType().equalsIgnoreCase("db2")) {
                stringBuffer.append(" BLOB");
            } else if (dB.getDBType().equalsIgnoreCase("mysql")) {
                stringBuffer.append(" LONGBLOB");
            } else if (dB.getDBType().equalsIgnoreCase("postgresql")) {
                stringBuffer.append(" BYTEA");
            }
            try {
                dB.execute(stringBuffer.toString());
            }
            catch (SQLException sQLException) {
                System.err.println("Unable to add XML_METADATA_GZ column to trial table.");
                sQLException.printStackTrace();
            }
        }
    }

    public MetaDataMap getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaDataMap metaDataMap) {
        this.metaData = metaDataMap;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
        this.fields = new String[database.getTrialFieldNames().length];
    }

    public MetaDataMap getUncommonMetaData() {
        return this.uncommonMetaData;
    }

    public void setUncommonMetaData(MetaDataMap metaDataMap) {
        this.uncommonMetaData = metaDataMap;
    }

    @Override
    public int compareTo(Trial trial) {
        Integer n = this.getID();
        Integer n2 = trial.getID();
        return n.compareTo(n2);
    }

    public boolean hasMetadata() {
        return this.metaData.size() != 0;
    }

    public Map<Integer, Function> getFunctionMap() {
        return this.intervalEventMap;
    }

    public void setFunctionMap(Map<Integer, Function> map) {
        this.intervalEventMap = map;
    }

    public Map<Integer, AtomicEvent> getAtomicEventMap() {
        return this.atomicEventMap;
    }

    public void setAtomicEventMap(Map<Integer, AtomicEvent> map) {
        this.atomicEventMap = map;
    }

    private static class XMLParser
    extends DefaultHandler {
        private StringBuffer accumulator = new StringBuffer();
        private String currentName = "";
        private MetaDataMap common;
        private MetaDataMap other;
        private MetaDataMap current;
        private MetaDataMap.MetaDataKey key = null;

        public XMLParser(MetaDataMap metaDataMap, MetaDataMap metaDataMap2) {
            this.common = metaDataMap;
            this.other = metaDataMap2;
            this.current = metaDataMap;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.accumulator = new StringBuffer();
            if (string2.equals("CommonProfileAttributes")) {
                this.current = this.common;
            } else if (string2.equals("ProfileAttributes")) {
                this.current = this.other;
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string2.equals("name")) {
                this.currentName = this.accumulator.toString().trim();
                this.key = this.current.newKey(this.accumulator.toString().trim());
            } else if (string2.equals("value")) {
                String string4 = this.accumulator.toString().trim();
                this.current.put(this.key, (Object)string4);
                this.key = null;
            } else if (string2.equals("timer_context") || string2.equals("tau:timer_context")) {
                this.key.timer_context = this.accumulator.toString().trim();
            } else if (string2.equals("call_number") || string2.equals("tau:call_number")) {
                this.key.call_number = Integer.parseInt(this.accumulator.toString().trim());
            } else if (string2.equals("timestamp") || string2.equals("tau:timestamp")) {
                this.key.timestamp = Long.parseLong(this.accumulator.toString().trim());
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.accumulator.append(cArray, n, n2);
        }
    }
}

