/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.database;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;

public class ParseConfig
implements Serializable {
    private static final long serialVersionUID = -22449977900556139L;
    private String perfdmfHome;
    private String jdbcJarFile;
    private String jdbcDriver;
    private String dbType;
    private String dbHost;
    private String dbPort;
    private String dbName;
    private String dbSchemaPrefix = "";
    private String dbUserName;
    private String dbPasswd;
    private String dbSchema;
    private boolean dbUseSSL = false;
    private String dbKeystore;
    private String dbKeystorePasswd;
    private String dbTruststore;
    private String dbTruststorePasswd;
    private String xmlSAXParser;
    private String path;
    private String name;

    private boolean stringToBool(String string) {
        return string != null && ("yes".equalsIgnoreCase(string) || "y".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string));
    }

    public ParseConfig(String string) {
        this.path = string;
        String[] stringArray = string.split("\\.");
        this.name = stringArray[stringArray.length - 1];
        if (this.name.compareTo("cfg") == 0) {
            this.name = "Default";
        }
        try {
            String string2;
            BufferedReader bufferedReader;
            if (string.toLowerCase().startsWith("http:")) {
                String string3 = "";
                if (string.toLowerCase().startsWith("http://")) {
                    string3 = "http://" + string.toString().substring(7).replace('\\', '/');
                } else if (string.toLowerCase().startsWith("http:/")) {
                    string3 = "http://" + string.toString().substring(6).replace('\\', '/');
                }
                URL uRL = new URL(string3);
                InputStream inputStream = uRL.openStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
            } else {
                bufferedReader = new BufferedReader(new FileReader(new File(string)));
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).startsWith("#") || string2.equals("")) continue;
                String string4 = this.getNameToken(string2).toLowerCase();
                String string5 = this.getValueToken(string2);
                if (string4.equals("perfdmf_home")) {
                    this.perfdmfHome = string5;
                    continue;
                }
                if (string4.equals("jdbc_db_jarfile")) {
                    this.jdbcJarFile = string5;
                    continue;
                }
                if (string4.equals("jdbc_db_driver")) {
                    this.jdbcDriver = string5;
                    continue;
                }
                if (string4.equals("jdbc_db_type")) {
                    this.dbType = string5;
                    continue;
                }
                if (string4.equals("db_hostname")) {
                    this.dbHost = string5;
                    continue;
                }
                if (string4.equals("db_portnum")) {
                    this.dbPort = string5;
                    continue;
                }
                if (string4.equals("db_dbname")) {
                    this.dbName = string5;
                    continue;
                }
                if (string4.equals("db_schemaprefix")) {
                    this.dbSchemaPrefix = string5;
                    continue;
                }
                if (string4.equals("db_username")) {
                    this.dbUserName = string5;
                    continue;
                }
                if (string4.equals("db_use_ssl")) {
                    this.dbUseSSL = this.stringToBool(string5);
                    continue;
                }
                if (string4.equals("db_keystore")) {
                    this.dbKeystore = string5;
                    continue;
                }
                if (string4.equals("db_keystore_password")) {
                    this.dbKeystorePasswd = string5;
                    continue;
                }
                if (string4.equals("db_truststore")) {
                    this.dbTruststore = string5;
                    continue;
                }
                if (string4.equals("db_truststore_password")) {
                    this.dbTruststorePasswd = string5;
                    continue;
                }
                if (string4.equals("db_password")) {
                    this.dbPasswd = string5;
                    continue;
                }
                if (string4.equals("db_schemafile")) {
                    this.dbSchema = string5;
                    continue;
                }
                if (string4.equals("xml_sax_parser")) {
                    this.xmlSAXParser = string5;
                    continue;
                }
                System.out.println(string4 + " is not a valid configuration item.");
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getNameToken(String string) {
        int n = string.indexOf(":");
        if (n > 0) {
            return string.substring(0, n).trim();
        }
        return null;
    }

    public String getConnectionString() {
        String string = this.getDBType().equals("derby") ? "jdbc:" + this.getDBType() + ":" + this.getDBName() : (this.getDBType().equals("sqlite") ? "jdbc:" + this.getDBType() + ":" + this.getDBName() : (this.getDBType().equals("h2") ? "jdbc:" + this.getDBType() + ":" + this.getDBName() + ";AUTO_SERVER=TRUE" : (this.getDBType().equals("oracle") ? "jdbc:oracle:thin:@//" + this.getDBHost() + ":" + this.getDBPort() + "/" + this.getDBName() : "jdbc:" + this.getDBType() + "://" + this.getDBHost() + ":" + this.getDBPort() + "/" + this.getDBName())));
        return string;
    }

    public String getValueToken(String string) {
        int n = string.indexOf(":");
        if (n > 0) {
            return string.substring(n + 1).trim();
        }
        return null;
    }

    public String getPerfDMFHome() {
        return this.perfdmfHome;
    }

    public String getJDBCJarFile() {
        return this.jdbcJarFile;
    }

    public String getJDBCDriver() {
        return this.jdbcDriver;
    }

    public String getDBType() {
        return this.dbType;
    }

    public String getDBHost() {
        return this.dbHost;
    }

    public String getDBPort() {
        return this.dbPort;
    }

    public String getDBName() {
        return this.dbName;
    }

    public String getDBSchemaPrefix() {
        return this.dbSchemaPrefix;
    }

    public String getDBUserName() {
        return this.dbUserName;
    }

    public boolean getDBUseSSL() {
        return this.dbUseSSL;
    }

    public String getDBKeystore() {
        return this.dbKeystore;
    }

    public String getDBKeystorePasswd() {
        return this.dbKeystorePasswd;
    }

    public String getDBTruststore() {
        return this.dbTruststore;
    }

    public String getDBTruststorePasswd() {
        return this.dbTruststorePasswd;
    }

    public String getDBPasswd() {
        return this.dbPasswd;
    }

    public String getDBSchema() {
        return this.dbSchema;
    }

    public String getXMLSAXParser() {
        return this.xmlSAXParser;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }
}

