/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.taudb;

import edu.uoregon.tau.perfdmf.View;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.taudb.TAUdbDatabaseAPI;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTrial;
import edu.uoregon.tau.perfdmf.taudb.ViewCreatorRuleListener;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class ViewCreatorGUI
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -5859741019248347898L;
    static final String METADATA = "METADATA";
    static final String READ_TYPE = "Read Type";
    private JPanel panel;
    private JPanel rulePane;
    private List<ViewCreatorRuleListener> ruleListeners;
    private String anyOrAll;
    private TAUdbDatabaseAPI databaseAPI;
    private DB db;
    private int parentID;
    private View edit = null;

    public ViewCreatorGUI(TAUdbDatabaseAPI tAUdbDatabaseAPI) {
        this(tAUdbDatabaseAPI, -1);
    }

    public ViewCreatorGUI(TAUdbDatabaseAPI tAUdbDatabaseAPI, int n) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.databaseAPI = tAUdbDatabaseAPI;
        this.db = tAUdbDatabaseAPI.getDb();
        this.parentID = n;
        this.ruleListeners = new ArrayList<ViewCreatorRuleListener>();
        this.setTitle("TAUdb View Creator");
        this.setDefaultCloseOperation(2);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.rulePane = new JPanel();
        this.rulePane.setLayout(new BoxLayout(this.rulePane, 1));
        JScrollPane jScrollPane = new JScrollPane(this.rulePane);
        jScrollPane.setPreferredSize(new Dimension(800, 200));
        this.createNewRule();
        this.rulePane.validate();
        this.rulePane.setVisible(true);
        this.panel.add(this.addMatch("and"));
        this.panel.add(jScrollPane);
        this.panel.add(this.getSaveButtons());
        this.panel.validate();
        this.getContentPane().add(this.panel);
    }

    public ViewCreatorGUI(TAUdbDatabaseAPI tAUdbDatabaseAPI, View view) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.databaseAPI = tAUdbDatabaseAPI;
        this.db = tAUdbDatabaseAPI.getDb();
        this.edit = view;
        this.parentID = -1;
        if (view.getParent() != null) {
            this.parentID = view.getParent().getID();
        }
        this.ruleListeners = new ArrayList<ViewCreatorRuleListener>();
        this.setTitle("TAUdb View Creator");
        this.setDefaultCloseOperation(3);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.rulePane = new JPanel();
        this.rulePane.setLayout(new BoxLayout(this.rulePane, 1));
        JScrollPane jScrollPane = new JScrollPane(this.rulePane);
        jScrollPane.setPreferredSize(new Dimension(800, 200));
        ResultSet resultSet = View.getViewParameters(this.db, view.getID());
        String string = "and";
        try {
            while (resultSet.next()) {
                if (resultSet.getRow() == 1 && resultSet.getString(1).equals("or")) {
                    string = "or";
                }
                String string2 = resultSet.getString(4);
                String string3 = resultSet.getString(5);
                String string4 = resultSet.getString(6);
                String string5 = null;
                if (string3 == null || string4 == null) {
                    this.createNewRule();
                    break;
                }
                if (string3.equals(">=")) {
                    resultSet.next();
                    string5 = resultSet.getString(6);
                }
                this.copyRule(string2, string3, string4, string5);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.rulePane.validate();
        this.rulePane.setVisible(true);
        this.panel.add(this.addMatch(string));
        this.panel.add(jScrollPane);
        this.panel.add(this.getSaveButtons());
        this.panel.validate();
        this.getContentPane().add(this.panel);
    }

    private JPanel getSaveButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JButton jButton = new JButton("Save");
        jButton.setActionCommand("Save");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("Cancel");
        jButton2.addActionListener(this);
        jPanel.add(jButton2);
        jPanel.add(jButton);
        return jPanel;
    }

    public void close() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("Save".equals(actionEvent.getActionCommand())) {
            String string = this.checkValues();
            if (string != null) {
                JOptionPane.showMessageDialog(this, string + " is not a valid numeric value.", "Invalid Value", 0);
                return;
            }
            if (this.edit == null) {
                String string2 = JOptionPane.showInputDialog(this, "Please enter the name of this TAUdb View", "Save TAUdb View", -1);
                if (string2 != null && string2.length() > 0) {
                    this.saveView(string2);
                    this.close();
                }
            } else {
                this.editView();
                this.close();
            }
        } else if ("Cancel".equals(actionEvent.getActionCommand())) {
            this.close();
        } else if ("comboBoxChanged".equals(actionEvent.getActionCommand())) {
            this.anyOrAll = ((JComboBox)actionEvent.getSource()).getSelectedItem().toString();
        }
    }

    private void saveView(String string) {
        try {
            int n = View.saveView(this.db, string, this.anyOrAll, this.parentID);
            this.saveViewParameters(n);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void editView() {
        int n = this.edit.getID();
        try {
            View.clearViewParameters(this.db, n);
            this.saveViewParameters(n);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void saveViewParameters(int n) throws SQLException {
        for (ViewCreatorRuleListener viewCreatorRuleListener : this.ruleListeners) {
            if (!viewCreatorRuleListener.isRuleEnabled()) continue;
            View.ViewRule viewRule = viewCreatorRuleListener.getViewRule();
            View.saveViewRule(this.db, n, viewRule);
        }
    }

    private String checkValues() {
        for (ViewCreatorRuleListener viewCreatorRuleListener : this.ruleListeners) {
            View.ViewRule viewRule = viewCreatorRuleListener.getViewRule();
            if (!viewRule.getType().equals("read as a number")) continue;
            String string = viewRule.getValue();
            if (!View.ViewRule.isNumber(string)) {
                return string;
            }
            if (!viewRule.getOperator().equals("is in the range") || View.ViewRule.isNumber(string = viewRule.getValue2())) continue;
            return string;
        }
        return null;
    }

    private JPanel addMatch(String string) {
        JPanel jPanel = new JPanel();
        String[] stringArray = new String[]{"and", "or"};
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        JLabel jLabel = new JLabel("Match ");
        JLabel jLabel2 = new JLabel(" of the following rules.");
        jComboBox.addActionListener(this);
        jComboBox.setSelectedItem(string);
        jPanel.add(jLabel);
        jPanel.add(jComboBox);
        jPanel.add(jLabel2);
        return jPanel;
    }

    public void copyRule(String string, String string2, String string3, String string4) {
        String string5 = "read as a string";
        if (string3 != null && View.ViewRule.isNumber(string3)) {
            string5 = "read as a number";
        }
        String[] stringArray = new String[]{"read as a string", "read as a number"};
        JPanel jPanel = new JPanel();
        String[] stringArray2 = stringArray;
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray2);
        jComboBox.setEditable(false);
        jComboBox.setName(READ_TYPE);
        JPanel jPanel2 = new JPanel(new CardLayout());
        ViewCreatorRuleListener viewCreatorRuleListener = new ViewCreatorRuleListener();
        this.ruleListeners.add(viewCreatorRuleListener);
        jComboBox.addActionListener(viewCreatorRuleListener);
        if (string3 == null) {
            jPanel2.add(this.addStringField(viewCreatorRuleListener, null, null), "read as a string");
            jPanel2.add(this.addNumberField(viewCreatorRuleListener, null, null, null), "read as a number");
        } else if (string5.equals("read as a string")) {
            jPanel2.add(this.addStringField(viewCreatorRuleListener, string2, string3), "read as a string");
            jPanel2.add(this.addNumberField(viewCreatorRuleListener, null, null, null), "read as a number");
        } else if (string5.equals("read as a number")) {
            jPanel2.add(this.addStringField(viewCreatorRuleListener, null, null), "read as a string");
            jPanel2.add(this.addNumberField(viewCreatorRuleListener, string2, string3, string4), "read as a number");
        }
        ViewCreatorListner viewCreatorListner = new ViewCreatorListner(jPanel2);
        jComboBox.addItemListener(viewCreatorListner);
        if (string5.equals("read as a number")) {
            jComboBox.setSelectedItem("read as a number");
        } else {
            jComboBox.setSelectedItem("read as a string");
        }
        JButton jButton = new JButton("+");
        JButton jButton2 = new JButton("-");
        jButton.addActionListener(viewCreatorListner);
        jButton2.addActionListener(viewCreatorListner);
        String[] stringArray3 = this.getMetaDataList();
        JComboBox<String> jComboBox2 = new JComboBox<String>(stringArray3);
        jComboBox2.addActionListener(viewCreatorRuleListener);
        jComboBox2.setEditable(false);
        jComboBox2.setName(METADATA);
        if (stringArray3.length > 0) {
            if (string != null) {
                jComboBox2.setSelectedItem(string);
            } else {
                jComboBox2.setSelectedIndex(0);
            }
        }
        jPanel.add(jComboBox2, "West");
        jPanel.add(jComboBox, "Center");
        jPanel.add((Component)jPanel2, "East");
        jPanel.add(jButton2);
        jPanel.add(jButton);
        jPanel.setAlignmentX(0.5f);
        viewCreatorRuleListener.setContainer(jPanel);
        this.rulePane.add(jPanel);
    }

    public void createNewRule() {
        this.copyRule(null, null, null, null);
    }

    private String[] getMetaDataList() {
        String[] stringArray = new String[]{};
        List<String> list = this.databaseAPI.getPrimaryMetadataNames();
        for (String string : TAUdbTrial.TRIAL_COLUMNS) {
            list.add(string);
        }
        return list.toArray(stringArray);
    }

    private Component addNumberField(ViewCreatorRuleListener viewCreatorRuleListener, String string, String string2, String string3) {
        JPanel jPanel = new JPanel();
        String[] stringArray = new String[]{"is equal to", "is not equal to", "is greater than", "is less than", "is in the range"};
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.addActionListener(viewCreatorRuleListener);
        jComboBox.setEditable(false);
        JPanel jPanel2 = new JPanel();
        JTextField jTextField = new JTextField();
        jTextField.setPreferredSize(new Dimension(100, 20));
        jTextField.getDocument().addDocumentListener(viewCreatorRuleListener);
        jPanel2.add(jTextField);
        JPanel jPanel3 = new JPanel();
        JTextField jTextField2 = new JTextField();
        jTextField2.setPreferredSize(new Dimension(100, 20));
        jTextField2.getDocument().addDocumentListener(viewCreatorRuleListener);
        jPanel3.add(jTextField2);
        JPanel jPanel4 = new JPanel();
        JTextField jTextField3 = new JTextField();
        jTextField3.setPreferredSize(new Dimension(100, 20));
        jTextField3.getDocument().addDocumentListener(viewCreatorRuleListener);
        jPanel4.add(jTextField3);
        JPanel jPanel5 = new JPanel();
        JTextField jTextField4 = new JTextField();
        jTextField4.setPreferredSize(new Dimension(100, 20));
        jTextField4.getDocument().addDocumentListener(viewCreatorRuleListener);
        jPanel5.add(jTextField4);
        JPanel jPanel6 = new JPanel();
        JTextField jTextField5 = new JTextField();
        jTextField5.setPreferredSize(new Dimension(100, 20));
        jTextField5.getDocument().addDocumentListener(viewCreatorRuleListener);
        jTextField5.getDocument().putProperty("is in the range", "begin");
        jPanel6.add(jTextField5);
        JTextField jTextField6 = new JTextField();
        jTextField6.setPreferredSize(new Dimension(100, 20));
        jTextField6.getDocument().addDocumentListener(viewCreatorRuleListener);
        jTextField6.getDocument().putProperty("is in the range", "end");
        jPanel6.add(jTextField6);
        JPanel jPanel7 = new JPanel(new CardLayout());
        jPanel7.add((Component)jPanel4, "is equal to");
        jPanel7.add((Component)jPanel5, "is not equal to");
        jPanel7.add((Component)jPanel2, "is greater than");
        jPanel7.add((Component)jPanel3, "is less than");
        jPanel7.add((Component)jPanel6, "is in the range");
        jComboBox.addItemListener(new ViewCreatorListner(jPanel7));
        jPanel.add(jComboBox, "West");
        jPanel.add((Component)jPanel7, "East");
        if (string != null && string2 != null) {
            if (string.equals("=")) {
                jComboBox.setSelectedItem("is equal to");
                jTextField3.setText(string2);
            } else if (string.equals("!=")) {
                jComboBox.setSelectedItem("is not equal to");
                jTextField4.setText(string2);
            } else if (string.equals(">")) {
                jComboBox.setSelectedItem("is greater than");
                jTextField.setText(string2);
            } else if (string.equals("<")) {
                jComboBox.setSelectedItem("is less than");
                jTextField2.setText(string2);
            } else if (string3 != null) {
                jComboBox.setSelectedItem("is in the range");
                jTextField5.setText(string2);
                jTextField6.setText(string3);
            }
        }
        return jPanel;
    }

    private Component addDateField() {
        JPanel jPanel = new JPanel();
        String[] stringArray = new String[]{"is", "is after", "is before", "is between"};
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setEditable(false);
        jComboBox.setSelectedIndex(0);
        JPanel jPanel2 = new JPanel();
        JFormattedTextField jFormattedTextField = new JFormattedTextField(new SimpleDateFormat("MM/dd/yyyy"));
        jFormattedTextField.setValue(new Date());
        jPanel2.add(jFormattedTextField);
        JPanel jPanel3 = new JPanel();
        jFormattedTextField = new JFormattedTextField(new SimpleDateFormat("MM/dd/yyyy"));
        jFormattedTextField.setValue(new Date());
        jPanel3.add(jFormattedTextField);
        JPanel jPanel4 = new JPanel();
        jFormattedTextField = new JFormattedTextField(new SimpleDateFormat("MM/dd/yyyy"));
        jFormattedTextField.setValue(new Date());
        jPanel4.add(jFormattedTextField);
        JPanel jPanel5 = new JPanel();
        jFormattedTextField = new JFormattedTextField(new SimpleDateFormat("MM/dd/yyyy"));
        jFormattedTextField.setValue(new Date());
        jPanel5.add(jFormattedTextField);
        jFormattedTextField = new JFormattedTextField(new SimpleDateFormat("MM/dd/yyyy"));
        jFormattedTextField.setValue(new Date());
        jPanel5.add(jFormattedTextField);
        JPanel jPanel6 = new JPanel(new CardLayout());
        jPanel6.add((Component)jPanel4, "is");
        jPanel6.add((Component)jPanel2, "is after");
        jPanel6.add((Component)jPanel3, "is before");
        jPanel6.add((Component)jPanel5, "is between");
        jComboBox.addItemListener(new ViewCreatorListner(jPanel6));
        jPanel.add(jComboBox, "West");
        jPanel.add((Component)jPanel6, "East");
        return jPanel;
    }

    private Component addStringField(ViewCreatorRuleListener viewCreatorRuleListener, String string, String string2) {
        JPanel jPanel = new JPanel();
        String[] stringArray = new String[]{"is exactly", "beings with", "ends with", "contains", "does not contain"};
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setEditable(false);
        jComboBox.addActionListener(viewCreatorRuleListener);
        jComboBox.setSelectedIndex(0);
        JPanel jPanel2 = new JPanel();
        JTextField jTextField = new JTextField("", 20);
        jTextField.getDocument().addDocumentListener(viewCreatorRuleListener);
        jPanel2.add(jTextField);
        JPanel jPanel3 = new JPanel();
        JTextField jTextField2 = new JTextField("", 20);
        jTextField2.getDocument().addDocumentListener(viewCreatorRuleListener);
        jPanel3.add(jTextField2);
        JPanel jPanel4 = new JPanel();
        JTextField jTextField3 = new JTextField("", 20);
        jTextField3.getDocument().addDocumentListener(viewCreatorRuleListener);
        jPanel4.add(jTextField3);
        JPanel jPanel5 = new JPanel();
        JTextField jTextField4 = new JTextField("", 20);
        jTextField4.getDocument().addDocumentListener(viewCreatorRuleListener);
        jPanel5.add(jTextField4);
        JPanel jPanel6 = new JPanel();
        JTextField jTextField5 = new JTextField("", 20);
        jTextField5.getDocument().addDocumentListener(viewCreatorRuleListener);
        jPanel6.add(jTextField5);
        JPanel jPanel7 = new JPanel(new CardLayout());
        jPanel7.add((Component)jPanel5, "is exactly");
        jPanel7.add((Component)jPanel2, "beings with");
        jPanel7.add((Component)jPanel4, "ends with");
        jPanel7.add((Component)jPanel3, "contains");
        jPanel7.add((Component)jPanel6, "does not contain");
        jComboBox.addItemListener(new ViewCreatorListner(jPanel7));
        jPanel.add(jComboBox, "West");
        jPanel.add((Component)jPanel7, "East");
        if (string != null && string2 != null) {
            if (string.equals("=")) {
                jComboBox.setSelectedItem("is exactly");
                jTextField4.setText(string2);
            } else if (string.equals("like")) {
                boolean bl = string2.startsWith("%");
                boolean bl2 = string2.endsWith("%");
                if (bl2 && bl) {
                    jComboBox.setSelectedItem("contains");
                    jTextField2.setText(string2.substring(1, string2.length() - 1));
                } else if (bl2) {
                    jComboBox.setSelectedItem("beings with");
                    jTextField.setText(string2.substring(0, string2.length() - 1));
                } else if (bl) {
                    jComboBox.setSelectedItem("ends with");
                    jTextField3.setText(string2.substring(1));
                }
            } else if (string.equals("not like")) {
                jComboBox.setSelectedItem("does not contain");
                jTextField5.setText(string2.substring(1, string2.length() - 1));
            }
        }
        return jPanel;
    }

    private static void createAndShowGUI() {
        ViewCreatorGUI viewCreatorGUI = new ViewCreatorGUI(null);
        viewCreatorGUI.pack();
        viewCreatorGUI.setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewCreatorGUI.createAndShowGUI();
            }
        });
    }

    public class ViewCreatorListner
    implements ItemListener,
    ActionListener {
        JPanel cards;

        public ViewCreatorListner(JPanel jPanel) {
            this.cards = jPanel;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            CardLayout cardLayout = (CardLayout)this.cards.getLayout();
            cardLayout.show(this.cards, (String)itemEvent.getItem());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JButton) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (jButton.getText().equals("+")) {
                    ViewCreatorGUI.this.createNewRule();
                    ViewCreatorGUI.this.panel.validate();
                } else if (jButton.getText().equals("-")) {
                    ViewCreatorGUI.this.rulePane.remove(jButton.getParent());
                    jButton.getParent().setEnabled(false);
                    ViewCreatorGUI.this.rulePane.getParent().validate();
                }
            }
        }
    }
}

