/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.common;

import java.io.IOException;
import java.io.InputStream;

public class XMLRootWrapInputStream
extends InputStream {
    private InputStream stream;
    private static String before = "<root>";
    private static String after = "</root>";
    private int position = 0;
    private static int BEFORE = 0;
    private static int DURING = 1;
    private static int AFTER = 2;
    private int state = BEFORE;

    public XMLRootWrapInputStream(InputStream inputStream) {
        this.stream = inputStream;
    }

    @Override
    public int read() throws IOException {
        if (this.state == DURING) {
            int n = this.stream.read();
            if (n == -1) {
                this.state = AFTER;
                this.position = 0;
            }
            return n;
        }
        if (this.state == BEFORE) {
            char c = before.charAt(this.position++);
            if (this.position == before.length()) {
                this.state = DURING;
            }
            return c;
        }
        if (this.state == AFTER) {
            if (this.position < after.length()) {
                return after.charAt(this.position++);
            }
            return -1;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        if (this.state == DURING) {
            int n = this.stream.read(byArray);
            if (n == -1) {
                this.state = AFTER;
                this.position = 0;
            }
            return n;
        }
        return super.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.state == DURING) {
            int n3 = this.stream.read(byArray, n, n2);
            if (n3 == -1) {
                this.state = AFTER;
                this.position = 0;
            }
            return n3;
        }
        return super.read(byArray, n, n2);
    }
}

