/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.common.treetable;

import edu.uoregon.tau.common.treetable.AbstractTreeTableModel;
import edu.uoregon.tau.common.treetable.JTreeTable;
import edu.uoregon.tau.common.treetable.SortTableModel;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TreeTableModelAdapter
extends AbstractTableModel
implements SortTableModel {
    private static final long serialVersionUID = -2121699681828347799L;
    private JTree tree;
    private AbstractTreeTableModel treeTableModel;
    private JTreeTable jTreeTable;

    public TreeTableModelAdapter(AbstractTreeTableModel abstractTreeTableModel, JTreeTable jTreeTable) {
        this.tree = jTreeTable.getTree();
        this.jTreeTable = jTreeTable;
        this.treeTableModel = abstractTreeTableModel;
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
        abstractTreeTableModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    @Override
    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.treeTableModel.getColumnName(n);
    }

    public Class<Object> getColumnClass(int n) {
        return this.treeTableModel.getColumnClass(n);
    }

    @Override
    public int getRowCount() {
        return this.tree.getRowCount();
    }

    protected Object nodeForRow(int n) {
        TreePath treePath = this.tree.getPathForRow(n);
        return treePath.getLastPathComponent();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.treeTableModel.getValueAt(this.nodeForRow(n), n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.treeTableModel.isCellEditable(this.nodeForRow(n), n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.treeTableModel.setValueAt(object, this.nodeForRow(n), n2);
    }

    public Vector<TreePath> getExpandedPaths() {
        Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(this.getRootPath());
        Vector<TreePath> vector = new Vector<TreePath>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement());
            }
        }
        return vector;
    }

    public void restoreExpandedPaths(Vector<TreePath> vector) {
        Enumeration<TreePath> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            TreePath treePath = enumeration.nextElement();
            this.tree.expandPath(treePath);
        }
    }

    public TreePath getRootPath() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeTableModel.getRoot();
        return new TreePath(defaultMutableTreeNode.getPath());
    }

    protected void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }

    @Override
    public void updateTreeTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Vector<TreePath> vector = TreeTableModelAdapter.this.getExpandedPaths();
                TreeTableModelAdapter.this.treeTableModel.fireTreeStructureChanged(this, ((DefaultMutableTreeNode)TreeTableModelAdapter.this.treeTableModel.getRoot()).getPath(), null, null);
                TreeTableModelAdapter.this.restoreExpandedPaths(vector);
                TreeTableModelAdapter.this.jTreeTable.getTableHeader().repaint();
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    @Override
    public boolean isSortable(int n) {
        return this.treeTableModel.isSortable(n);
    }

    @Override
    public void sortColumn(int n, boolean bl) {
        this.treeTableModel.sortColumn(n, bl);
        this.updateTreeTable();
    }
}

