/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.client.Expression;
import edu.uoregon.tau.perfexplorer.client.MyComboBoxRenderer;
import edu.uoregon.tau.perfexplorer.client.ParsingException;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerClient;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerConnection;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerExpression;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerModel;
import edu.uoregon.tau.perfexplorer.common.ScriptThread;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Scanner;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DerivedMetricWindow
extends JFrame
implements ActionListener,
Observer,
ListSelectionListener,
ItemListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private static Application selectApp = new Application();
    private static Experiment selectExp = new Experiment();
    private static Trial selectTrial = new Trial();
    private JButton derive = new JButton("Apply");
    private JPanel input = new JPanel();
    private JPanel selectButtons = new JPanel();
    private JPanel newExpression = new JPanel();
    private JPanel buttons = new JPanel();
    private DefaultListModel expressionList = new DefaultListModel();
    private JButton add = new JButton("Add");
    private JButton edit = new JButton("Edit");
    private JButton remove = new JButton("Remove");
    private JButton selectAll = new JButton("Select All");
    private JButton deselect = new JButton("Deselect All");
    private JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
    private JMenuBar mb = new JMenuBar();
    private JMenuItem open = new JMenuItem("Load from File");
    private JMenuItem save = new JMenuItem("Save");
    private JMenuItem saveas = new JMenuItem("Save As");
    private JMenuItem copy = new JMenuItem("Save As");
    private JMenuItem paste = new JMenuItem("Save As");
    private JMenuItem cut = new JMenuItem("Save As");
    private JTextField addExpression = new JTextField(25);
    private JButton leftParen = new JButton("(");
    private JButton rightParen = new JButton(")");
    private JButton plus = new JButton("+");
    private JButton minus = new JButton("-");
    private JButton times = new JButton("*");
    private JButton divide = new JButton("/");
    private JButton clear = new JButton("Clear");
    private JButton equals = new JButton("=");
    private JButton insert = new JButton("Insert");
    private JComboBox metrics = new JComboBox();
    JList expression;
    private PerfExplorerClient mainWindow;
    JTextPane textPane;

    public static void main(String[] stringArray) {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        ListIterator<Application> listIterator = perfExplorerConnection.getApplicationList();
        Application application = listIterator.next();
        ListIterator<Experiment> listIterator2 = perfExplorerConnection.getExperimentList(application.getID());
        Experiment experiment = listIterator2.next();
        ListIterator<Trial> listIterator3 = perfExplorerConnection.getTrialList(experiment.getID(), false);
        Trial trial = listIterator3.next();
        new DerivedMetricWindow(PerfExplorerClient.getMainFrame(), application, experiment, trial).setVisible(true);
    }

    public DerivedMetricWindow(PerfExplorerClient perfExplorerClient, Application application, Experiment experiment, Trial trial) {
        this(perfExplorerClient);
        selectApp = application;
        selectExp = experiment;
        selectTrial = trial;
    }

    public DerivedMetricWindow(PerfExplorerClient perfExplorerClient) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.getContentPane().setLayout(new GridBagLayout());
        int n = 650;
        int n2 = 563;
        this.setSize(new Dimension(n, n2));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n3 = dimension.height;
        int n4 = dimension.width;
        Object var9_9 = null;
        if (var9_9 == null || var9_9.x + n > n4 || var9_9.y + n2 > n3) {
            int n5 = (n4 - n) / 2;
            int n6 = (n3 - n2) / 2;
            if (n5 > 50) {
                n5 -= 50;
            }
            if (n6 > 50) {
                n6 -= 50;
            }
            this.setLocation(n5, n6);
        }
        this.setTitle("Expression Window");
        this.mainWindow = perfExplorerClient;
        JMenu jMenu = new JMenu("File");
        this.open = new JMenuItem("Load from File");
        this.open.addActionListener(this);
        jMenu.add(this.open);
        this.save = new JMenuItem("Save");
        this.save.addActionListener(this);
        jMenu.add(this.save);
        this.saveas = new JMenuItem("Save Selected");
        this.saveas.addActionListener(this);
        jMenu.add(this.saveas);
        JMenu jMenu2 = new JMenu("Edit");
        this.cut = new JMenuItem("Cut");
        this.cut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.cut.setMnemonic(84);
        this.cut.addActionListener(this);
        jMenu2.add(this.cut);
        this.copy = new JMenuItem("Copy");
        this.copy.addActionListener(this);
        this.copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copy.setMnemonic(67);
        jMenu2.add(this.copy);
        this.paste = new JMenuItem("Paste");
        this.paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.paste.setMnemonic(80);
        this.paste.addActionListener(this);
        jMenu2.add(this.paste);
        this.mb = new JMenuBar();
        this.mb.add(jMenu);
        this.mb.add(jMenu2);
        this.setJMenuBar(this.mb);
        this.input.setLayout(new GridBagLayout());
        this.expression = new JList(this.expressionList){
            private static final long serialVersionUID = -789541234065276141L;

            public String getToolTipText(MouseEvent mouseEvent) {
                int n = this.locationToIndex(mouseEvent.getPoint());
                if (-1 < n) {
                    String string = DerivedMetricWindow.this.expressionList.get(n).toString();
                    String string2 = "<html>";
                    String string3 = "<html>";
                    char[] cArray = string.toCharArray();
                    for (int i = 0; i < cArray.length; ++i) {
                        string3 = string2 = string2 + cArray[i];
                        if (i % 80 != 0 || i == 0) continue;
                        string2 = string2 + "<br>";
                    }
                    return string3.trim();
                }
                return null;
            }
        };
        this.expression.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.expression);
        jScrollPane.setPreferredSize(new Dimension(400, 350));
        this.derive.addActionListener(this);
        this.add.addActionListener(this);
        this.addCompItem(this.input, (Component)jScrollPane, gridBagConstraints, 0, 1, 475, 350);
        this.addCompItem(this, (Component)this.input, gridBagConstraints, 1, 1, 500, 500);
        this.selectButtons.setLayout(new GridBagLayout());
        this.selectAll.addActionListener(this);
        this.deselect.addActionListener(this);
        this.remove.addActionListener(this);
        this.edit.addActionListener(this);
        this.addCompItem(this.selectButtons, (Component)this.edit, gridBagConstraints, 0, 2, 1, 1);
        this.addCompItem(this.selectButtons, (Component)this.remove, gridBagConstraints, 0, 3, 1, 1);
        this.addCompItem(this.selectButtons, (Component)this.selectAll, gridBagConstraints, 0, 0, 1, 1);
        this.addCompItem(this.selectButtons, (Component)this.deselect, gridBagConstraints, 0, 1, 1, 1);
        this.addCompItem(this.selectButtons, (Component)this.derive, gridBagConstraints, 0, 4, 1, 1);
        this.addCompItem(this, (Component)this.selectButtons, gridBagConstraints, 501, 2, 1, 1);
        this.saveas.setEnabled(false);
        this.derive.setEnabled(false);
        this.edit.setEnabled(false);
        this.remove.setEnabled(false);
        this.cut.setEnabled(false);
        this.copy.setEnabled(false);
        this.expression.setToolTipText("Expressions");
        this.buttons.setLayout(new GridBagLayout());
        Dimension dimension2 = new Dimension(4, 25);
        this.equals.addActionListener(this);
        this.plus.addActionListener(this);
        this.minus.addActionListener(this);
        this.times.addActionListener(this);
        this.divide.addActionListener(this);
        this.leftParen.addActionListener(this);
        this.rightParen.addActionListener(this);
        this.equals.setPreferredSize(dimension2);
        this.plus.setPreferredSize(dimension2);
        this.minus.setPreferredSize(dimension2);
        this.times.setPreferredSize(dimension2);
        this.divide.setPreferredSize(dimension2);
        this.leftParen.setPreferredSize(dimension2);
        this.rightParen.setPreferredSize(dimension2);
        this.addCompItem(this.buttons, (Component)this.plus, gridBagConstraints, 0, 0, 1, 1);
        this.addCompItem(this.buttons, (Component)this.minus, gridBagConstraints, 1, 0, 1, 1);
        this.addCompItem(this.buttons, (Component)this.divide, gridBagConstraints, 2, 0, 1, 1);
        this.addCompItem(this.buttons, (Component)this.times, gridBagConstraints, 3, 0, 1, 1);
        this.addCompItem(this.buttons, (Component)this.leftParen, gridBagConstraints, 4, 0, 1, 1);
        this.addCompItem(this.buttons, (Component)this.rightParen, gridBagConstraints, 5, 0, 1, 1);
        this.addCompItem(this.buttons, (Component)this.equals, gridBagConstraints, 6, 0, 1, 1);
        this.addCompItem(this, (Component)this.buttons, gridBagConstraints, 1, 503, 1, 1);
        this.newExpression.setLayout(new GridBagLayout());
        this.addExpression.addActionListener(this);
        this.addExpression.setSize(20, 1);
        this.metrics = new JComboBox();
        this.metrics.setRenderer(new MyComboBoxRenderer());
        this.metrics.addActionListener(this);
        this.metrics.setPreferredSize(new Dimension(10, 22));
        this.clear.addActionListener(this);
        this.insert.addActionListener(this);
        this.addCompItem(this.newExpression, (Component)this.addExpression, gridBagConstraints, 1, 1, 25, 1);
        this.addCompItem(this.newExpression, (Component)this.insert, gridBagConstraints, 0, 0, 1, 1);
        this.addCompItem(this.newExpression, (Component)this.metrics, gridBagConstraints, 1, 0, 1, 1);
        this.addCompItem(this.newExpression, (Component)this.add, gridBagConstraints, 0, 1, 1, 1);
        this.addCompItem(this.newExpression, (Component)this.clear, gridBagConstraints, 26, 1, 1, 1);
        this.addCompItem(this, (Component)this.newExpression, gridBagConstraints, 1, 502, 1, 1);
        this.loadMetrics();
    }

    private void setClipboard(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }

    private String getFromClipboard() {
        boolean bl;
        String string = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        boolean bl2 = bl = transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (bl) {
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                System.out.println(unsupportedFlavorException);
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                System.out.println(iOException);
                iOException.printStackTrace();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object.equals(this.selectAll)) {
                int[] nArray = new int[this.expressionList.getSize()];
                for (int i = 0; i < this.expressionList.getSize(); ++i) {
                    nArray[i] = i;
                }
                this.expression.setSelectedIndices(nArray);
            } else if (object.equals(this.deselect)) {
                this.expression.getSelectionModel().clearSelection();
            } else if (object.equals(this.copy)) {
                this.copy();
            } else if (object.equals(this.cut)) {
                this.cut();
            } else if (object.equals(this.paste)) {
                this.paste();
            } else if (object.equals(this.add)) {
                this.addExpression();
            } else if (object.equals(this.open)) {
                this.openFile();
            } else if (object.equals(this.save)) {
                this.saveFile();
            } else if (object.equals(this.saveas)) {
                this.saveSelected();
            } else if (object.equals(this.derive)) {
                if (this.expression.isSelectionEmpty()) {
                    JOptionPane.showMessageDialog(this, "Please select an expression.", "Warning", 2);
                } else {
                    this.deriveMetric();
                }
            } else if (object.equals(this.edit)) {
                if (this.expression.isSelectionEmpty()) {
                    JOptionPane.showMessageDialog(this, "Please select an expression.", "Warning", 2);
                } else {
                    this.edit(this.expression.getSelectedValue().toString());
                }
            } else if (object.equals(this.remove)) {
                this.remove();
            } else if (object.equals(this.insert)) {
                this.insertExpression("\"" + this.metrics.getSelectedItem().toString() + "\"");
            } else if (object.equals(this.plus)) {
                this.insertExpression("+");
            } else if (object.equals(this.minus)) {
                this.insertExpression("-");
            } else if (object.equals(this.times)) {
                this.insertExpression("*");
            } else if (object.equals(this.divide)) {
                this.insertExpression("/");
            } else if (object.equals(this.leftParen)) {
                this.insertExpression("(");
            } else if (object.equals(this.rightParen)) {
                this.insertExpression(")");
            } else if (object.equals(this.equals)) {
                this.insertExpression("=");
            } else if (object.equals(this.clear)) {
                this.addExpression.setText("");
                this.addExpression.requestFocusInWindow();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void insertExpression(String string) {
        this.addExpression.replaceSelection(string);
        this.addExpression.requestFocusInWindow();
        int n = this.addExpression.getSelectionStart();
        this.addExpression.setCaretPosition(n);
        if (this.addExpression.getText().length() == n) {
            this.addExpression.setText(this.addExpression.getText() + " ");
            this.addExpression.setCaretPosition(n);
        }
    }

    private void loadMetrics() {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        List<String> list = perfExplorerConnection.getPotentialMetrics(PerfExplorerModel.getModel());
        if (list.size() > 0) {
            for (String string : list) {
                this.metrics.addItem(string);
            }
            this.metrics.setSelectedIndex(0);
        }
    }

    private void remove() {
        if (this.expression.isSelectionEmpty()) {
            JOptionPane.showMessageDialog(this, "Please select an expression.", "Warning", 2);
        } else {
            while (!this.expression.isSelectionEmpty()) {
                this.expressionList.removeElementAt(this.expression.getSelectedIndex());
            }
        }
    }

    private void edit(String string) {
        String string2 = (String)JOptionPane.showInputDialog(this, "Edit Expression:\n", "Edit", -1, null, null, string);
        if (string2 != null) {
            boolean bl = this.validate(string2);
            if (bl) {
                int n = this.expression.getSelectedIndex();
                this.expressionList.removeElementAt(n);
                this.expressionList.add(n, string2);
            } else {
                this.edit(string2);
            }
        }
    }

    private boolean validate(String string) {
        boolean bl = PerfExplorerExpression.validate(string);
        if (!bl) {
            JOptionPane.showMessageDialog(this, "The expression you entered is not valid.", "Invalid Expression", 0);
        }
        return bl;
    }

    private void cut() {
        this.copy();
        this.remove();
    }

    private void addExpression() {
        this.addExpression("");
    }

    private void addExpression(String string) {
        String string2 = this.addExpression.getText();
        if (string2 == null) {
            JOptionPane.showMessageDialog(this, "You cannot add a blank expression.", "Warning", 2);
        } else if (string2.trim().equals("")) {
            JOptionPane.showMessageDialog(this, "You cannot add a blank expression.", "Warning", 2);
        } else {
            boolean bl = this.validate(string2);
            if (bl) {
                this.expressionList.addElement(string2.trim());
            }
        }
    }

    private void copy() {
        Object[] objectArray = this.expression.getSelectedValues();
        String string = "";
        for (Object object : objectArray) {
            string = string + object + "\n";
        }
        this.setClipboard(string);
    }

    private void paste() {
        String string = this.getFromClipboard();
        this.addExpressions(new Scanner(string));
    }

    private void openFile() throws FileNotFoundException {
        int n = this.fc.showOpenDialog(this);
        if (n == 0) {
            this.addExpressions(new Scanner(this.fc.getSelectedFile()));
        }
    }

    private void addExpressions(Scanner scanner) {
        while (scanner.hasNextLine()) {
            String string = scanner.nextLine().trim();
            if (string.equals("")) continue;
            if (Expression.validate(string)) {
                this.expressionList.addElement(string);
                continue;
            }
            this.addExpression(string);
        }
    }

    private void saveFile() throws IOException {
        if (this.getFiletoSave()) {
            File file = this.fc.getSelectedFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            String string = "";
            for (Object object : this.expressionList.toArray()) {
                string = string + object.toString() + "\n";
            }
            fileOutputStream.write(string.getBytes());
        }
    }

    private boolean getFiletoSave() {
        int n = this.fc.showSaveDialog(this);
        if (n == 0) {
            int n2;
            File file = this.fc.getSelectedFile();
            if (file.exists() && (n2 = JOptionPane.showOptionDialog(this, "\"" + file.getName() + "\" already exists. Do you want to replace it? ", "Replace File", 0, 2, null, null, null)) == 1) {
                return this.getFiletoSave();
            }
            return true;
        }
        return false;
    }

    private void saveSelected() throws IOException {
        if (this.expression.isSelectionEmpty()) {
            JOptionPane.showMessageDialog(this, "Please select an expression.", "Warning", 2);
            return;
        }
        if (this.getFiletoSave()) {
            int[] nArray;
            File file = this.fc.getSelectedFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            String string = "";
            for (int n : nArray = this.expression.getSelectedIndices()) {
                string = string + this.expressionList.get(n) + "\n";
            }
            fileOutputStream.write(string.getBytes());
        }
    }

    private void deriveMetric() {
        String string = "Are you sure you want to apply the selected expressions to \n";
        if (selectTrial != null) {
            string = string + "the \"" + selectTrial.getName() + "\" trial from the \"" + selectExp.getName() + "\" experiment from the \"" + selectApp.getName() + "\" application?";
        } else if (selectExp != null) {
            string = string + "all the trials in the \"" + selectExp.getName() + "\" experiment in the \"" + selectApp.getName() + "\" application?";
        } else if (selectApp != null) {
            string = string + "all the trials in the all of the expriments in the \"" + selectApp.getName() + "\" application?";
        }
        int n = JOptionPane.showOptionDialog(this, string, "Confirm Trials", 0, 2, null, null, null);
        if (n == 1) {
            return;
        }
        Object[] objectArray = this.expression.getSelectedValues();
        String string2 = "";
        for (Object object : objectArray) {
            string2 = string2 + object + "\n";
        }
        try {
            Object object;
            PerfExplorerExpression perfExplorerExpression = new PerfExplorerExpression();
            String string3 = null;
            object = null;
            String string4 = null;
            if (selectApp != null) {
                string3 = selectApp.getName();
            }
            if (selectExp != null) {
                object = selectExp.getName();
            }
            if (selectTrial != null) {
                string4 = selectTrial.getName();
            }
            String string5 = perfExplorerExpression.getScriptFromExpressions(string3, (String)object, string4, string2);
            new ScriptThread(string5, true);
        }
        catch (ParsingException parsingException) {
            JOptionPane.showMessageDialog(this.mainWindow, "The expression did not parse correctly.\n" + parsingException.getMessage(), "Parse Error", 0);
        }
    }

    public void addCompItem(JFrame jFrame, Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        jFrame.getContentPane().add(component, gridBagConstraints);
    }

    public void addCompItem(Container container, Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.fill = 2;
        container.add(component, gridBagConstraints);
    }

    public void update(Observable observable, Object object) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (this.expression.isSelectionEmpty()) {
                this.saveas.setEnabled(false);
                this.derive.setEnabled(false);
                this.edit.setEnabled(false);
                this.remove.setEnabled(false);
                this.cut.setEnabled(false);
                this.copy.setEnabled(false);
            } else {
                this.saveas.setEnabled(true);
                this.derive.setEnabled(true);
                this.edit.setEnabled(true);
                this.remove.setEnabled(true);
                this.cut.setEnabled(true);
                this.copy.setEnabled(true);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }
}

