/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.perfexplorer.client.ParsingException;
import edu.uoregon.tau.perfexplorer.client.TestExpression;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Scanner;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expression {
    public static void main(String[] stringArray) throws ParsingException {
        System.out.println(Expression.validate("\"a++100\"+\"b+_110\""));
        System.out.println(Expression.validate("(a+b)*c"));
        System.out.println(Expression.validate("(a+b+b)*(a+b)/(34+\"b-a:\")"));
        System.out.println(Expression.validate("(a-b+c.d*f)-ab*(ab*c)/2-(3-4)*(34+a"));
        System.out.println(Expression.validate("(a+b+b)*(a+b)/(34+\"b-a:\")"));
        System.out.println(Expression.validate("(a+b+b)*(a+b)/(34+\"b-a:\")"));
    }

    public String parse(String string) throws ParsingException {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\"') {
                ++i;
                while (cArray[i] != '\"') {
                    ++i;
                }
                continue;
            }
            if (cArray[i] != '=') continue;
            return this.evaluateExpression(string.substring(0, i), Expression.infixToPostfix(string.substring(i + 1)));
        }
        return this.evaluateExpression(null, Expression.infixToPostfix(string));
    }

    public String parseExpressions(String string) throws ParsingException {
        return this.parseMany(new Scanner(string));
    }

    public String parseFile(String string) throws ParsingException, FileNotFoundException {
        Scanner scanner = new Scanner(new File(string));
        return this.parseMany(scanner);
    }

    private String parseMany(Scanner scanner) throws ParsingException {
        String string = "";
        while (scanner.hasNextLine()) {
            String string2 = scanner.nextLine();
            string2.trim();
            if (string2.equals("")) continue;
            string = this.parse(string2.trim());
        }
        return string;
    }

    public static boolean validate(String string) {
        try {
            new TestExpression().parse(string);
            return true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
        catch (ParsingException parsingException) {
            return false;
        }
    }

    private static ArrayList<String> infixToPostfix(String string) throws ParsingException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        Stack<Character> stack = new Stack<Character>();
        char[] cArray = string.toCharArray();
        block20: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\"': {
                    ++i;
                    while (cArray[i] != '\"') {
                        string2 = string2 + cArray[i];
                        ++i;
                    }
                    continue block20;
                }
                case '+': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(Character.valueOf('+'));
                    continue block20;
                }
                case '-': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(Character.valueOf('-'));
                    continue block20;
                }
                case '/': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(' && ((Character)stack.peek()).charValue() != '-' && ((Character)stack.peek()).charValue() != '+') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(Character.valueOf('/'));
                    continue block20;
                }
                case '*': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(' && ((Character)stack.peek()).charValue() != '-' && ((Character)stack.peek()).charValue() != '+') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(Character.valueOf('*'));
                    continue block20;
                }
                case '(': {
                    stack.push(Character.valueOf('('));
                    continue block20;
                }
                case ')': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                        stack.pop();
                        continue block20;
                    }
                    catch (EmptyStackException emptyStackException) {
                        throw new ParsingException("Unmatched )");
                    }
                }
                case ' ': {
                    continue block20;
                }
                default: {
                    string2 = string2 + c;
                }
            }
        }
        if (!string2.equals("")) {
            arrayList.add(string2 + "");
        }
        string2 = "";
        while (!stack.isEmpty()) {
            arrayList.add(stack.pop() + "");
        }
        return arrayList;
    }

    private static boolean isValue(String string) {
        try {
            Double.valueOf(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private String evaluateExpression(String string, ArrayList<String> arrayList) throws ParsingException {
        if (string != null) {
            string = string.trim();
        }
        if (arrayList.size() == 1) {
            return this.rename(string, arrayList.get(0));
        }
        for (int i = 0; arrayList.size() > 1 && arrayList.size() > i; ++i) {
            if (!Expression.isOperation(arrayList.get(i))) continue;
            try {
                String string2;
                double d;
                char c = arrayList.remove(i).trim().charAt(0);
                String string3 = arrayList.remove(i - 1);
                String string4 = arrayList.remove(i - 2);
                i -= 2;
                if (arrayList.size() >= 2 || string == null) {
                    if (Expression.isValue(string4)) {
                        d = Double.valueOf(string4);
                        string2 = this.applyOperation(d, string3, c);
                    } else if (Expression.isValue(string3)) {
                        d = Double.valueOf(string3);
                        string2 = this.applyOperation(string4, d, c);
                    } else {
                        string2 = this.applyOperation(string4, string3, c);
                    }
                } else if (Expression.isValue(string4)) {
                    d = Double.valueOf(string4);
                    string2 = this.applyOperation(d, string3, c, string);
                } else if (Expression.isValue(string3)) {
                    d = Double.valueOf(string3);
                    string2 = this.applyOperation(string4, d, c, string);
                } else {
                    string2 = this.applyOperation(string4, string3, c, string);
                }
                arrayList.add(i, string2);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ParsingException();
            }
        }
        return arrayList.get(0);
    }

    private static boolean isOperation(String string) {
        char c = string.charAt(0);
        return c == '+' || c == '-' || c == '*' || c == '/';
    }

    protected abstract String rename(String var1, String var2);

    protected abstract String applyOperation(String var1, String var2, char var3, String var4);

    protected abstract String applyOperation(String var1, double var2, char var4, String var5);

    protected abstract String applyOperation(double var1, String var3, char var4, String var5);

    protected abstract String applyOperation(String var1, String var2, char var3);

    protected abstract String applyOperation(String var1, double var2, char var4);

    protected abstract String applyOperation(double var1, String var3, char var4);
}

