/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfexplorer.client.ParsingException;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Scanner;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfExplorerExpression {
    private static String spaces = "  ";

    public static void main(String[] stringArray) {
        PerfExplorerExpression perfExplorerExpression = new PerfExplorerExpression();
        try {
            System.out.println(perfExplorerExpression.getScriptFromExpressions("Matrix", "200", null, "\"TIME+TIME\"+300/TIME*20\n TIME++TIME \n 20*TIME+32/(10+TIME)"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String getNewName(String string) {
        try {
            ArrayList<String> arrayList = PerfExplorerExpression.infixToPostfix(string);
            if (arrayList.size() < 2) {
                return null;
            }
            for (int i = 0; arrayList.size() > 1 && arrayList.size() > i; ++i) {
                if (!PerfExplorerExpression.isOperation(arrayList.get(i))) continue;
                try {
                    String string2 = arrayList.remove(i);
                    String string3 = arrayList.remove(i - 1);
                    String string4 = arrayList.remove(i - 2);
                    arrayList.add(i -= 2, "(" + string4 + string2 + string3 + ")");
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return null;
                }
            }
            return arrayList.get(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean validate(String string) {
        String string2 = PerfExplorerExpression.getNewName(string);
        return string2 != null;
    }

    private static ArrayList<String> infixToPostfix(String string) throws ParsingException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        Stack<Character> stack = new Stack<Character>();
        char[] cArray = string.toCharArray();
        block20: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\"': {
                    ++i;
                    while (cArray[i] != '\"') {
                        string2 = string2 + cArray[i];
                        ++i;
                    }
                    continue block20;
                }
                case '+': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(new Character('+'));
                    continue block20;
                }
                case '-': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(new Character('-'));
                    continue block20;
                }
                case '/': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(' && ((Character)stack.peek()).charValue() != '-' && ((Character)stack.peek()).charValue() != '+') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(new Character('/'));
                    continue block20;
                }
                case '*': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(' && ((Character)stack.peek()).charValue() != '-' && ((Character)stack.peek()).charValue() != '+') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(new Character('*'));
                    continue block20;
                }
                case '(': {
                    stack.push(new Character('('));
                    continue block20;
                }
                case ')': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                        stack.pop();
                        continue block20;
                    }
                    catch (EmptyStackException emptyStackException) {
                        throw new ParsingException("Unmatched )");
                    }
                }
                case ' ': {
                    continue block20;
                }
                default: {
                    string2 = string2 + c;
                }
            }
        }
        if (!string2.equals("")) {
            arrayList.add(string2 + "");
        }
        string2 = "";
        while (!stack.isEmpty()) {
            arrayList.add(stack.pop() + "");
        }
        return arrayList;
    }

    private static boolean isOperation(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            char c = string.charAt(0);
            return c == '+' || c == '-' || c == '*' || c == '/';
        }
        return false;
    }

    public String getScriptFromExpressions(String string, String string2, String string3, String string4) throws ParsingException {
        String string5 = PerfExplorerExpression.initScript();
        string5 = string5 + this.parseExpressions(string4);
        string5 = string5 + this.finalizeScript(string, string2, string3);
        return string5;
    }

    public String getScriptFromFile(String string, String string2, String string3, String string4) throws ParsingException, FileNotFoundException {
        String string5 = PerfExplorerExpression.initScript();
        string5 = string5 + this.parseFile(string4);
        string5 = string5 + this.finalizeScript(string, string2, string3);
        return string5;
    }

    public String parseExpressions(String string) throws ParsingException {
        return this.parseMany(new Scanner(string));
    }

    public String parseFile(String string) throws ParsingException, FileNotFoundException {
        Scanner scanner = new Scanner(new File(string));
        return this.parseMany(scanner);
    }

    private String parseMany(Scanner scanner) throws ParsingException {
        String string = "";
        while (scanner.hasNextLine()) {
            String string2 = scanner.nextLine();
            string2 = string2.trim();
            PerfExplorerExpression.validate(string2);
            if (string2.equals("")) continue;
            string = string + spaces + "result, newName = addDerivedOperation( result,";
            string = string + "\"" + string2 + "\")\n";
        }
        return string;
    }

    private String finalizeScript(String string, String string2, String string3) {
        if (string == null) {
            return PerfExplorerExpression.endOfScript();
        }
        String string4 = "";
        string4 = string4 + spaces + "saver = SaveResultOperation(result)\n";
        string4 = string4 + spaces + "saver.processData()\n";
        string4 = string4 + spaces + "return\n";
        string4 = string4 + "print \"--------------- JPython test script start ------------\"\n";
        if (string2 == null) {
            string4 = string4 + "inExp = Utilities.getExperimentsForApplication(\"" + string + "\")\n";
            string4 = string4 + "for exp in inExp:\n";
            string4 = string4 + "  trials = Utilities.getTrialsForExperiment(\"" + string + "\", exp.getName())\n";
            string4 = string4 + "  for trial in trials:\n";
            string4 = string4 + "     result = load(\"" + string + "\",exp.getName(),trial.getName())\n";
            string4 = string4 + "     computeDerived(result)\n";
            string4 = string4 + "\n";
            string4 = string4 + "print \"---------------- JPython test script end -------------\"\n";
            return string4;
        }
        if (string3 == null) {
            string4 = string4 + "trials = Utilities.getTrialsForExperiment(\"" + string + "\", \"" + string2 + "\")\n";
            string4 = string4 + "for trial in trials:\n";
            string4 = string4 + "   result = load(\"" + string + "\",\"" + string2 + "\", trial.getName())\n";
            string4 = string4 + "   computeDerived(result)\n";
            string4 = string4 + "\n";
            string4 = string4 + "print \"---------------- JPython test script end -------------\"\n";
            return string4;
        }
        string4 = string4 + "result = load(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\")\n";
        string4 = string4 + "computeDerived(result)\n";
        string4 = string4 + "print \"---------------- JPython test script end -------------\"\n";
        return string4;
    }

    private static String endOfScript() {
        String string = spaces + "saver = SaveResultOperation(result)\n";
        string = string + spaces + "saver.setForceOverwrite(True)\n";
        string = string + spaces + "saver.processData()\n";
        string = string + spaces + "return\n";
        string = string + "print \"--------------- JPython test script start ------------\"\n";
        string = string + PerfExplorerExpression.addApplicaitons();
        string = string + "for app in apps:\n";
        string = string + " inExp = Utilities.getExperimentsForApplication(app)\n";
        string = string + " for exp in inExp:\n";
        string = string + "   trials = Utilities.getTrialsForExperiment(app, exp.getName())\n";
        string = string + "   for trial in trials:\n";
        string = string + "      result = load(app,exp.getName(),trial.getName())\n";
        string = string + "      computeDerived(result)\n";
        string = string + "\n";
        string = string + "print \"---------------- JPython test script end -------------\"\n";
        return string;
    }

    private static String initScript() {
        String string = "from edu.uoregon.tau.perfexplorer.glue import *\n";
        string = string + "from java.util import HashSet\n";
        string = string + "from java.util import ArrayList\n";
        string = string + "from edu.uoregon.tau.perfdmf import Trial\n";
        string = string + "from edu.uoregon.tau.perfdmf import Metric\n";
        string = string + "from edu.uoregon.tau.perfexplorer.glue import PerformanceResult\n";
        string = string + "from edu.uoregon.tau.perfexplorer.glue import PerformanceAnalysisOperation\n";
        string = string + "from edu.uoregon.tau.perfexplorer.glue import ExtractEventOperation\n";
        string = string + "from edu.uoregon.tau.perfexplorer.glue import Utilities\n";
        string = string + "from edu.uoregon.tau.perfexplorer.glue import BasicStatisticsOperation\n";
        string = string + "from edu.uoregon.tau.perfexplorer.glue import DeriveMetricOperation\n";
        string = string + "from edu.uoregon.tau.perfexplorer.glue import ScaleMetricOperation\n";
        string = string + "from edu.uoregon.tau.perfexplorer.glue import DeriveMetricEquation\n";
        string = string + "from edu.uoregon.tau.perfexplorer.glue import DeriveMetricsFileOperation\n";
        string = string + "from edu.uoregon.tau.perfexplorer.glue import MergeTrialsOperation\n";
        string = string + "from edu.uoregon.tau.perfexplorer.glue import TrialResult\n";
        string = string + "from edu.uoregon.tau.perfexplorer.glue import AbstractResult\n";
        string = string + "from edu.uoregon.tau.perfexplorer.glue import DrawGraph\n";
        string = string + "from edu.uoregon.tau.perfexplorer.glue import SaveResultOperation\n";
        string = string + PerfExplorerExpression.loadMethod();
        string = string + PerfExplorerExpression.addDerivedOperation();
        string = string + PerfExplorerExpression.computeDerived();
        return string;
    }

    private static String loadMethod() {
        String string = "\n";
        string = string + "def load(inApp, inExp, inTrial):\n";
        string = string + spaces + "trial1 = Utilities.getTrial(inApp, inExp, inTrial)\n";
        string = string + spaces + "result1 = TrialResult(trial1)\n";
        string = string + spaces + "return result1\n";
        string = string + "\n";
        return string;
    }

    private static final String addDerivedOperation() {
        String string = "";
        string = string + "def addDerivedOperation(result, equation, newName=\"\"):\n";
        string = string + spaces + "# derive the metric\n";
        string = string + spaces + "derivor = DeriveMetricEquation(result,equation )\n";
        string = string + spaces + "if newName:\n";
        string = string + spaces + "      derivor.setNewName(newName)\n";
        string = string + spaces + "\n";
        string = string + spaces + "derived = derivor.processData().get(0)\n";
        string = string + spaces + "newName = derived.getMetrics().toArray()[0]\n";
        string = string + spaces + "merger = MergeTrialsOperation(result)\n";
        string = string + spaces + "merger.addInput(derived)\n";
        string = string + spaces + "derived = merger.processData().get(0)\n";
        string = string + spaces + "return derived, newName\n";
        string = string + "\n";
        return string;
    }

    private static final String computeDerived() {
        return "def computeDerived(result):\n";
    }

    private static String addApplicaitons() {
        String string = "apps = [";
        PerfExplorerServer perfExplorerServer = PerfExplorerServer.getServer();
        List<Application> list = perfExplorerServer.getApplicationList();
        for (Application application : list) {
            string = string + "'" + application.getName() + "'";
        }
        if (string.charAt(string.length() - 1) == ',') {
            string = string.substring(0, string.length() - 1);
        }
        return string + "]\n";
    }
}

