/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.common.TreeUI;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.View;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfexplorer.client.DeriveMetricsPane;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerJTabbedPane;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerJTree;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerModel;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PerfExplorerTreeMouseListener
implements MouseListener,
ActionListener {
    private PerfExplorerJTree tree;
    private Object clickedOnObject = null;
    private DefaultMutableTreeNode selectedNode = null;
    private TreePath fullPathNode = null;
    JPopupMenu perfExPopup = null;
    JPopupMenu multiPopup = null;

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Delete")) {
                    this.handleDelete(this.clickedOnObject, true);
                } else if (string.equals("Rename")) {
                    if (this.clickedOnObject instanceof Application) {
                        this.tree.startEditingAtPath(this.fullPathNode);
                    } else if (this.clickedOnObject instanceof Experiment) {
                        this.tree.startEditingAtPath(this.fullPathNode);
                    } else if (this.clickedOnObject instanceof Trial) {
                        this.tree.startEditingAtPath(this.fullPathNode);
                    } else if (this.clickedOnObject instanceof View) {
                        this.tree.startEditingAtPath(new TreePath(((View)this.clickedOnObject).getDMTN().getPath()));
                    } else if (this.clickedOnObject instanceof Metric) {
                        this.tree.startEditingAtPath(this.fullPathNode);
                    }
                }
                this.clickedOnObject = null;
                this.fullPathNode = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public PerfExplorerTreeMouseListener(PerfExplorerJTree perfExplorerJTree) {
        this.tree = perfExplorerJTree;
        this.perfExPopup = TreeUI.getPerfExPopUp((ActionListener)this);
        this.multiPopup = TreeUI.getMultiPopUp((ActionListener)this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        TreePath[] treePathArray;
        if (!TreeUI.rightClick((MouseEvent)mouseEvent)) {
            PerfExplorerJTabbedPane perfExplorerJTabbedPane;
            int n;
            Object object = PerfExplorerModel.getModel().getCurrentSelection();
            if (object != null && object instanceof Metric && (n = (perfExplorerJTabbedPane = PerfExplorerJTabbedPane.getPane()).getSelectedIndex()) == 4) {
                DeriveMetricsPane.getPane().metricClick((Metric)object);
            }
            return;
        }
        int n = this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        int[] nArray = this.tree.getSelectionRows();
        boolean bl = false;
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            this.tree.setSelectionRow(n);
        }
        if ((treePathArray = this.tree.getSelectionPaths()) == null) {
            return;
        }
        if (treePathArray.length > 1) {
            this.clickedOnObject = treePathArray;
            if (TreeUI.rightClick((MouseEvent)mouseEvent)) {
                this.multiPopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
            }
        } else if (treePathArray.length == 1) {
            TreePath treePath;
            this.fullPathNode = treePath = treePathArray[0];
            this.selectedNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = this.selectedNode.getUserObject();
            if (object instanceof Application) {
                this.clickedOnObject = object;
                this.perfExPopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
            } else if (object instanceof Experiment) {
                this.clickedOnObject = object;
                this.perfExPopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
            } else if (object instanceof Trial) {
                this.clickedOnObject = object;
                this.perfExPopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
            } else if (object instanceof View) {
                if (((View)object).toString().equals("All Trials")) {
                    return;
                }
                this.clickedOnObject = object;
                this.perfExPopup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void handleDelete(Object object, boolean bl) throws SQLException, DatabaseException {
        int n;
        if (bl && (n = JOptionPane.showConfirmDialog(this.tree, "Are you sure you want to permanently delete this item from the database and all views?", "Confirm Delete", 0)) != 0) {
            return;
        }
        if (object instanceof TreePath[]) {
            TreePath[] treePathArray = (TreePath[])object;
            for (int i = 0; i < treePathArray.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                Object object2 = defaultMutableTreeNode.getUserObject();
                this.handleDelete(object2, false);
            }
        } else if (object instanceof Application) {
            Application application = (Application)object;
            DatabaseAPI databaseAPI = PerfExplorerServer.getServer().getSession(application.getDatabase());
            if (databaseAPI != null) {
                databaseAPI.deleteApplication(application.getID());
                this.deleteTreeItem(application);
            }
        } else if (object instanceof Experiment) {
            Experiment experiment = (Experiment)object;
            DatabaseAPI databaseAPI = PerfExplorerServer.getServer().getSession(experiment.getDatabase());
            if (databaseAPI != null) {
                databaseAPI.deleteExperiment(experiment.getID());
                this.deleteTreeItem(experiment);
            }
        } else if (object instanceof Trial) {
            Trial trial = (Trial)object;
            DatabaseAPI databaseAPI = PerfExplorerServer.getServer().getSession(trial.getDatabase());
            if (databaseAPI != null) {
                databaseAPI.deleteTrial(trial.getID());
                this.deleteTreeItem(trial);
            }
        } else if (object instanceof View) {
            View view = (View)object;
            this.deleteView(view);
        }
    }

    private void deleteTreeItem(Object object) {
        if (this.selectedNode != null && this.selectedNode.getUserObject().equals(object)) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
            TreeNode treeNode = this.selectedNode.getParent();
            this.selectedNode.removeFromParent();
            defaultTreeModel.reload(treeNode);
        }
    }

    private void deleteView(View view) {
        DatabaseAPI databaseAPI = PerfExplorerServer.getServer().getSession(view.getDatabase());
        try {
            View.deleteView((int)view.getID(), (DB)databaseAPI.getDb());
            this.deleteTreeItem(view);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

