/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.client.ImagePanel;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerClient;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerConnection;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerImageButton;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerModel;
import edu.uoregon.tau.perfexplorer.common.RMIPerformanceResults;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class PerformanceExplorerPane
extends JScrollPane
implements ActionListener {
    private static final long serialVersionUID = 2397547783148145635L;
    private static PerformanceExplorerPane thePane = null;
    private JPanel imagePanel = null;
    private Hashtable<String, RMIPerformanceResults> resultsHash = null;
    private RMIPerformanceResults results = null;
    private static final int imagesPerRow = 6;

    public static PerformanceExplorerPane getPane() {
        if (thePane == null) {
            JPanel jPanel = new JPanel(new BorderLayout());
            thePane = new PerformanceExplorerPane(jPanel);
        }
        thePane.repaint();
        return thePane;
    }

    private PerformanceExplorerPane(JPanel jPanel) {
        super(jPanel);
        this.imagePanel = jPanel;
        this.resultsHash = new Hashtable();
        JScrollBar jScrollBar = this.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
    }

    public JPanel getImagePanel() {
        return this.imagePanel;
    }

    public void updateImagePanel() {
        this.imagePanel.removeAll();
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        if (perfExplorerModel.getCurrentSelection() instanceof Metric || perfExplorerModel.getCurrentSelection() instanceof Trial) {
            PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
            this.results = perfExplorerConnection.getPerformanceResults(perfExplorerModel);
            if (this.results.getResultCount() == 0) {
                return;
            }
            int n = 0;
            List<String> list = this.results.getDescriptions();
            List<byte[]> list2 = this.results.getThumbnails();
            int n2 = list.size();
            this.resultsHash.put(perfExplorerModel.toString(), this.results);
            JPanel jPanel = null;
            jPanel = this.results.getResultCount() % 6 == 0 ? new JPanel(new GridLayout(this.results.getResultCount() / 6, 6)) : new JPanel(new GridLayout(this.results.getResultCount() / 5, 5));
            for (int i = n; i < n2; ++i) {
                ImageIcon imageIcon = new ImageIcon(list2.get(i));
                String string = list.get(i);
                PerfExplorerImageButton perfExplorerImageButton = new PerfExplorerImageButton(imageIcon, i, string);
                perfExplorerImageButton.addActionListener(this);
                jPanel.add(perfExplorerImageButton);
            }
            this.imagePanel.add((Component)jPanel, "North");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = Integer.parseInt(actionEvent.getActionCommand());
        String string = this.results.getDescriptions().get(n);
        ImageIcon imageIcon = new ImageIcon(this.results.getImages().get(n));
        JFrame jFrame = new JFrame("TAU/PerfExplorer: " + string);
        int n2 = 500;
        int n3 = 500;
        Point point = PerfExplorerClient.getMainFrame().getLocationOnScreen();
        Dimension dimension = PerfExplorerClient.getMainFrame().getSize();
        int n4 = dimension.width;
        int n5 = dimension.height;
        int n6 = (n4 - n2) / 2;
        int n7 = (n5 - n3) / 2;
        n6 = (int)point.getX() + n6;
        n7 = (int)point.getY() + n7;
        jFrame.setLocation(n6, n7);
        jFrame.setSize(new Dimension(n2, n3));
        ImagePanel imagePanel = new ImagePanel(imageIcon.getImage());
        imagePanel.setPreferredSize(new Dimension(n2, n3));
        imagePanel.setSize(n2, n3);
        jFrame.getContentPane().add(imagePanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

