/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.common.treetable.AbstractTreeTableModel;
import edu.uoregon.tau.common.treetable.JTreeTable;
import edu.uoregon.tau.perfexplorer.client.JTreeContentHandler;
import edu.uoregon.tau.perfexplorer.client.JTreeErrorHandler;
import edu.uoregon.tau.perfexplorer.client.JTreeLexicalHandler;
import edu.uoregon.tau.perfexplorer.client.TreePortionCellRenderer;
import edu.uoregon.tau.perfexplorer.client.XMLModel;
import java.awt.Component;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXTreeViewer
extends JFrame {
    private static final long serialVersionUID = -176395314854266217L;
    private String vendorParserClass = "org.apache.xerces.parsers.SAXParser";
    private JTreeTable jTreeTable;
    AbstractTreeTableModel xmlModel;

    public SAXTreeViewer() {
        super("SAX Tree Viewer");
        this.setSize(600, 450);
    }

    public void init(String string) throws IOException, SAXException {
        new DefaultMutableTreeNode("XML String");
        this.buildTree(string);
        this.getContentPane().add((Component)new JScrollPane((Component)this.jTreeTable), "Center");
    }

    public JTreeTable getTreeTable(String string) throws IOException, SAXException {
        this.jTreeTable = this.buildTree(string);
        this.jTreeTable.expandAll(true);
        return this.jTreeTable;
    }

    public JTreeTable buildTree(String string) throws IOException, SAXException {
        XMLReader xMLReader;
        try {
            xMLReader = XMLReaderFactory.createXMLReader(this.vendorParserClass);
        }
        catch (SAXException sAXException) {
            try {
                xMLReader = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
            }
            catch (SAXException sAXException2) {
                try {
                    xMLReader = XMLReaderFactory.createXMLReader("gnu.xml.aelfred2.XmlReader");
                }
                catch (SAXException sAXException3) {
                    try {
                        xMLReader = XMLReaderFactory.createXMLReader("com.bluecast.xml.Piccolo");
                    }
                    catch (SAXException sAXException4) {
                        try {
                            xMLReader = XMLReaderFactory.createXMLReader("oracle.xml.parser.v2.SAXParser");
                        }
                        catch (SAXException sAXException5) {
                            try {
                                xMLReader = XMLReaderFactory.createXMLReader();
                            }
                            catch (SAXException sAXException6) {
                                throw new NoClassDefFoundError("No SAX parser is available");
                            }
                        }
                    }
                }
            }
        }
        JTreeContentHandler jTreeContentHandler = new JTreeContentHandler();
        JTreeErrorHandler jTreeErrorHandler = new JTreeErrorHandler();
        JTreeLexicalHandler jTreeLexicalHandler = new JTreeLexicalHandler(jTreeContentHandler);
        xMLReader.setContentHandler(jTreeContentHandler);
        xMLReader.setErrorHandler(jTreeErrorHandler);
        xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", jTreeLexicalHandler);
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        xMLReader.parse(inputSource);
        this.xmlModel = new XMLModel(jTreeContentHandler.getRoot());
        JTreeTable jTreeTable = new JTreeTable(this.xmlModel, true, false);
        jTreeTable.getTree().setCellRenderer(new TreePortionCellRenderer());
        return jTreeTable;
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 1) {
                System.out.println("Usage: java SAXTreeViewer [XML Document URI]");
                System.exit(0);
            }
            SAXTreeViewer sAXTreeViewer = new SAXTreeViewer();
            sAXTreeViewer.init(stringArray[0]);
            sAXTreeViewer.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

