/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.clustering.weka;

import edu.uoregon.tau.perfexplorer.clustering.ClusterDescription;
import edu.uoregon.tau.perfexplorer.clustering.ClusterException;
import edu.uoregon.tau.perfexplorer.clustering.ClusterInterface;
import edu.uoregon.tau.perfexplorer.clustering.RawDataInterface;
import edu.uoregon.tau.perfexplorer.clustering.weka.WekaRawData;
import weka.attributeSelection.PrincipalComponents;
import weka.core.Instance;
import weka.core.Instances;

public abstract class WekaAbstractCluster
implements ClusterInterface {
    protected boolean doPCA = false;
    protected Instances instances = null;
    protected Instances clusterCentroids = null;
    protected Instances clusterMaximums = null;
    protected Instances clusterMinimums = null;
    protected Instances clusterStandardDeviations = null;
    protected RawDataInterface inputData = null;

    WekaAbstractCluster() {
        this.reset();
    }

    public void reset() {
        this.clusterCentroids = null;
        this.clusterMaximums = null;
        this.clusterMinimums = null;
        this.clusterStandardDeviations = null;
    }

    public void setInputData(RawDataInterface rawDataInterface) {
        this.instances = (Instances)rawDataInterface.getData();
        this.inputData = rawDataInterface;
    }

    public Instances handlePCA(Instances instances) throws Exception {
        PrincipalComponents principalComponents = new PrincipalComponents();
        principalComponents.setMaximumAttributeNames(1);
        principalComponents.setNormalize(true);
        principalComponents.setTransformBackToOriginal(true);
        principalComponents.buildEvaluator(instances);
        return principalComponents.transformedData(instances);
    }

    public ClusterDescription getClusterDescription(int n) throws ClusterException {
        return null;
    }

    public RawDataInterface getClusterCentroids() {
        WekaRawData wekaRawData = new WekaRawData(this.clusterCentroids);
        return wekaRawData;
    }

    public RawDataInterface getClusterStandardDeviations() {
        if (this.clusterStandardDeviations == null) {
            return null;
        }
        WekaRawData wekaRawData = new WekaRawData(this.clusterStandardDeviations);
        return wekaRawData;
    }

    public void doPCA(boolean bl) {
        this.doPCA = bl;
    }

    public int getNumInstances() {
        return this.instances.numInstances();
    }

    protected abstract double getSquaredError();

    protected void evaluateCluster() {
    }

    public abstract int clusterInstance(int var1);

    public abstract int clusterInstance(Instance var1) throws Exception;

    public int[] clusterInstances() {
        int[] nArray = new int[this.instances.numInstances()];
        for (int i = 0; i < this.instances.numInstances(); ++i) {
            nArray[i] = this.clusterInstance(i);
        }
        return nArray;
    }

    public RawDataInterface getClusterMaximums() {
        Object object;
        if (this.clusterMaximums == null) {
            try {
                int n;
                object = (Instances)this.inputData.getData();
                this.clusterMaximums = new Instances(object, 0);
                int n2 = this.clusterCentroids.numInstances();
                Instances[] instancesArray = new Instances[n2];
                for (n = 0; n < n2; ++n) {
                    instancesArray[n] = new Instances(object, 0);
                }
                for (n = 0; n < object.numInstances(); ++n) {
                    int n3 = this.clusterInstance(object.instance(n));
                    if (n3 < 0) continue;
                    instancesArray[n3].add(new Instance(1.0, object.instance(n).toDoubleArray()));
                }
                for (n = 0; n < n2; ++n) {
                    int n4;
                    double[] dArray = new double[object.numAttributes()];
                    for (n4 = 1; n4 < instancesArray[n].numAttributes(); ++n4) {
                        dArray[n4] = instancesArray[n].instance(0).value(n4);
                    }
                    for (n4 = 1; n4 < instancesArray[n].numAttributes(); ++n4) {
                        for (int i = 0; i < instancesArray[n].numInstances(); ++i) {
                            dArray[n4] = Math.max(dArray[n4], instancesArray[n].instance(0).value(n4));
                        }
                    }
                    this.clusterMaximums.add(new Instance(1.0, dArray));
                }
            }
            catch (Exception exception) {
                System.err.println("getServer exception: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        object = new WekaRawData(this.clusterMaximums);
        return object;
    }

    public RawDataInterface getClusterMinimums() {
        Object object;
        if (this.clusterMinimums == null) {
            try {
                int n;
                object = (Instances)this.inputData.getData();
                this.clusterMinimums = new Instances(object, 0);
                int n2 = this.clusterCentroids.numInstances();
                Instances[] instancesArray = new Instances[n2];
                for (n = 0; n < n2; ++n) {
                    instancesArray[n] = new Instances(object, 0);
                }
                for (n = 0; n < object.numInstances(); ++n) {
                    int n3 = this.clusterInstance(object.instance(n));
                    if (n3 < 0) continue;
                    instancesArray[this.clusterInstance(object.instance(n))].add(new Instance(1.0, object.instance(n).toDoubleArray()));
                }
                for (n = 0; n < n2; ++n) {
                    int n4;
                    double[] dArray = new double[object.numAttributes()];
                    for (n4 = 1; n4 < instancesArray[n].numAttributes(); ++n4) {
                        dArray[n4] = instancesArray[n].instance(0).value(n4);
                    }
                    for (n4 = 1; n4 < instancesArray[n].numAttributes(); ++n4) {
                        for (int i = 0; i < instancesArray[n].numInstances(); ++i) {
                            dArray[n4] = Math.min(dArray[n4], instancesArray[n].instance(0).value(n4));
                        }
                    }
                    this.clusterMinimums.add(new Instance(1.0, dArray));
                }
            }
            catch (Exception exception) {
                System.err.println("getServer exception: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        object = new WekaRawData(this.clusterMinimums);
        return object;
    }

    public double getBetweenError() {
        int n;
        Instance instance = new Instance(this.clusterCentroids.numAttributes());
        for (int i = 0; i < this.clusterCentroids.numInstances(); ++i) {
            Instance instance2 = this.clusterCentroids.instance(i);
            for (n = 0; n < instance2.numAttributes(); ++n) {
                double d = instance.value(n) + instance2.value(n);
                instance.setValue(n, d);
            }
        }
        double d = 0.0;
        for (n = 0; n < this.clusterCentroids.numInstances(); ++n) {
            d += this.distance(instance, this.clusterCentroids.instance(n));
        }
        return d;
    }

    private double distance(Instance instance, Instance instance2) {
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        while (n < instance.numValues() || n2 < instance2.numValues()) {
            double d2;
            int n3 = n >= instance.numValues() ? this.clusterCentroids.numAttributes() : instance.index(n);
            int n4 = n2 >= instance2.numValues() ? this.clusterCentroids.numAttributes() : instance2.index(n2);
            if (n3 == this.clusterCentroids.classIndex()) {
                ++n;
                continue;
            }
            if (n4 == this.clusterCentroids.classIndex()) {
                ++n2;
                continue;
            }
            if (n3 == n4) {
                d2 = this.difference(n3, instance.valueSparse(n), instance2.valueSparse(n2));
                ++n;
                ++n2;
            } else if (n3 > n4) {
                d2 = this.difference(n4, 0.0, instance2.valueSparse(n2));
                ++n2;
            } else {
                d2 = this.difference(n3, instance.valueSparse(n), 0.0);
                ++n;
            }
            d += d2 * d2;
        }
        return d;
    }

    private double difference(int n, double d, double d2) {
        switch (this.clusterCentroids.attribute(n).type()) {
            case 1: {
                if (Instance.isMissingValue((double)d) || Instance.isMissingValue((double)d2) || (int)d != (int)d2) {
                    return 1.0;
                }
                return 0.0;
            }
            case 0: {
                if (Instance.isMissingValue((double)d) || Instance.isMissingValue((double)d2)) {
                    if (Instance.isMissingValue((double)d) && Instance.isMissingValue((double)d2)) {
                        return 1.0;
                    }
                    double d3 = Instance.isMissingValue((double)d2) ? d : d2;
                    if (d3 < 0.5) {
                        d3 = 1.0 - d3;
                    }
                    return d3;
                }
                return d - d2;
            }
        }
        return 0.0;
    }
}

