/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.common;

import edu.uoregon.tau.perfdmf.Database;
import edu.uoregon.tau.perfdmf.database.ConnectionManager;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.database.ParseConfig;
import edu.uoregon.tau.perfexplorer.common.PerfExplorerOutput;
import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;

public class Configure {
    private static String Greeting = "\nNow testing your database connection.\n";
    private static String Usage = "Usage: configure [{-h,--help}] [{-g,--configfile} filename] [{-t,--schemaLocation} path]";
    private String tau_root = "";
    private String db_dbname = "perfdmf";
    private String db_password = "";
    private ParseConfig parser;
    private String configFileName;
    private String perfExplorerSchema = null;

    public Configure(String string) {
        this.tau_root = string;
    }

    public void initialize(String string) {
        PerfExplorerOutput.println(Greeting);
        try {
            this.configFileName = string;
            File file = new File(this.configFileName);
            if (file.exists()) {
                PerfExplorerOutput.println("Configuration file found...");
                this.parseConfigFile();
            } else {
                PerfExplorerOutput.println("Configuration file NOT found...");
                PerfExplorerOutput.println("a new configuration file will be created.");
            }
        }
        catch (IOException iOException) {
            PerfExplorerOutput.println("I/O Error occurred.");
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    public void parseConfigFile() throws IOException, FileNotFoundException {
        PerfExplorerOutput.println("Parsing config file...");
        this.parser = new ParseConfig(this.configFileName);
        this.db_dbname = this.parser.getDBName();
        this.db_password = this.parser.getDBPasswd();
    }

    public void createDB(boolean bl) {
        DB dB;
        ConnectionManager connectionManager;
        block16: {
            Object object;
            connectionManager = null;
            dB = null;
            try {
                connectionManager = this.db_password != null ? new ConnectionManager(new Database(this.configFileName), this.db_password) : new ConnectionManager(new Database(this.configFileName), true);
                connectionManager.connect();
                PerfExplorerOutput.println();
                dB = connectionManager.getDB();
            }
            catch (Exception exception) {
                object = new StringBuilder();
                ((StringBuilder)object).append("\nPlease make sure that your DBMS is configured ");
                ((StringBuilder)object).append("correctly, and the database ");
                ((StringBuilder)object).append(this.db_dbname + " has been created.");
                PerfExplorerOutput.println(((StringBuilder)object).toString());
                System.exit(1);
            }
            try {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("SELECT * FROM ");
                stringBuilder.append(dB.getSchemaPrefix() + "analysis_settings");
                object = dB.executeQuery(stringBuilder.toString());
                object.close();
            }
            catch (SQLException sQLException) {
                Object object2;
                PerfExplorerOutput.print("Perfexplorer tables not found.");
                object = "";
                if (this.perfExplorerSchema == null && bl) {
                    PerfExplorerOutput.print("Would you like to upload the schema? [y/n]: ");
                    object2 = new BufferedReader(new InputStreamReader(System.in));
                    try {
                        object = ((BufferedReader)object2).readLine();
                    }
                    catch (IOException iOException) {
                        PerfExplorerOutput.println("I/O Error occurred.");
                        System.err.println(sQLException.getMessage());
                        iOException.printStackTrace();
                        System.exit(-1);
                    }
                } else {
                    object = "y";
                }
                if (!((String)object).equals("y") && !((String)object).equals("Y")) break block16;
                object2 = "";
                if (this.perfExplorerSchema == null) {
                    String string = "dbschema.";
                    if (dB.getSchemaVersion() > 0) {
                        string = "taudb.";
                    }
                    object2 = this.tau_root + File.separator + string + dB.getDBType().toLowerCase();
                } else {
                    if (dB.getSchemaVersion() > 0) {
                        this.perfExplorerSchema = this.perfExplorerSchema.replaceAll("dbschema", "taudb");
                    }
                    object2 = this.perfExplorerSchema;
                }
                PerfExplorerOutput.println("Uploading Schema: " + (String)object2);
                if (connectionManager.genParentSchema((String)object2) == 0) {
                    PerfExplorerOutput.println("Successfully uploaded schema\n");
                }
                System.err.println("Error uploading schema\n");
                System.exit(1);
            }
        }
        try {
            if (dB.checkSchema() != 0) {
                System.err.print("\nIncompatible schema found.  ");
                System.err.println("Please contact us at tau-team@cs.uoregon.edu");
                System.err.println("for a conversion script.");
                System.exit(1);
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\nError trying to confirm schema:");
            sQLException.printStackTrace();
            System.exit(1);
        }
        connectionManager.dbclose();
        PerfExplorerOutput.println("Database connection successful.");
        PerfExplorerOutput.println("Configuration complete.");
    }

    public static void loadDefaultSchema(String string, String string2, String string3) {
        Configure configure = new Configure(string3);
        configure.tau_root = string3;
        configure.initialize(string);
        configure.createDB(false);
    }

    public static void main(String[] stringArray) {
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addStringOption('g', "configfile");
        CmdLineParser.Option option2 = cmdLineParser.addStringOption('t', "schemaLocation");
        CmdLineParser.Option option3 = cmdLineParser.addStringOption('a', "arch");
        CmdLineParser.Option option4 = cmdLineParser.addBooleanOption('h', "help");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println(optionException.getMessage());
            System.err.println(Usage);
            System.exit(-1);
        }
        String string = (String)cmdLineParser.getOptionValue(option);
        String string2 = (String)cmdLineParser.getOptionValue(option2);
        String string3 = (String)cmdLineParser.getOptionValue(option3);
        Boolean bl = (Boolean)cmdLineParser.getOptionValue(option4);
        if (bl != null && bl.booleanValue()) {
            System.err.println(Usage);
            System.exit(-1);
        }
        if (string == null) {
            string = new String("");
        }
        if (string2 == null) {
            string2 = new String("");
        }
        if (string3 == null) {
            string3 = new String("");
        }
        Configure configure = new Configure(string2);
        configure.tau_root = string2;
        configure.initialize(string);
        configure.createDB(true);
    }

    public String getPerfExplorerSchema() {
        return this.perfExplorerSchema;
    }

    public void setPerfExplorerSchema(String string) {
        this.perfExplorerSchema = string;
    }
}

