/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.common;

import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.FieldPosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMISortableIntervalEvent
implements Serializable,
Comparable<RMISortableIntervalEvent> {
    private static final long serialVersionUID = -4062837640988586241L;
    public int metricIndex;
    private Function function;
    private int trialID;
    private DatabaseAPI dataSession;

    public RMISortableIntervalEvent(Function function, int n, DatabaseAPI databaseAPI, int n2) {
        this.function = function;
        this.trialID = n;
        this.metricIndex = n2;
        this.dataSession = databaseAPI;
    }

    public FunctionProfile getMeanSummary() {
        if (this.function.getMeanProfile() != null) {
            return this.function.getMeanProfile();
        }
        FunctionProfile functionProfile = null;
        try {
            functionProfile = this.dataSession.getIntervalEventDetail(this.function);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.function.setMeanProfile(functionProfile);
        return functionProfile;
    }

    public Function getFunction() {
        return this.function;
    }

    public int getTrialID() {
        return this.trialID;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            DecimalFormat decimalFormat = new DecimalFormat("00.00");
            FieldPosition fieldPosition = new FieldPosition(0);
            decimalFormat.format(this.function.getMeanProfile().getExclusive(this.metricIndex), stringBuffer, fieldPosition);
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.append(" : ");
        stringBuffer.append(this.function.getName());
        return stringBuffer.toString();
    }

    @Override
    public int compareTo(RMISortableIntervalEvent rMISortableIntervalEvent) {
        FunctionProfile functionProfile = null;
        FunctionProfile functionProfile2 = null;
        try {
            functionProfile = this.getMeanSummary();
            functionProfile2 = rMISortableIntervalEvent.getMeanSummary();
        }
        catch (Exception exception) {
            return 0;
        }
        if (functionProfile.getExclusive(this.metricIndex) < functionProfile2.getExclusive(this.metricIndex)) {
            return 1;
        }
        if (functionProfile.getExclusive(this.metricIndex) > functionProfile2.getExclusive(this.metricIndex)) {
            return -1;
        }
        return 0;
    }
}

