/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.DefaultResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractPhasesOperation
extends AbstractPerformanceOperation {
    private static final long serialVersionUID = 1775154091500218639L;
    private String phaseNamePrefix = null;

    public ExtractPhasesOperation(PerformanceResult performanceResult, String string) {
        super(performanceResult);
        this.phaseNamePrefix = string;
    }

    public ExtractPhasesOperation(Trial trial, String string) {
        super(trial);
        this.phaseNamePrefix = string;
    }

    public ExtractPhasesOperation(List<PerformanceResult> list, String string) {
        super(list);
        this.phaseNamePrefix = string;
    }

    @Override
    public List<PerformanceResult> processData() {
        this.outputs = new ArrayList();
        for (PerformanceResult performanceResult : this.inputs) {
            DefaultResult defaultResult = new DefaultResult(performanceResult, false);
            this.outputs.add(defaultResult);
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : performanceResult.getEvents()) {
                if (!string.startsWith(this.phaseNamePrefix)) continue;
                string.replaceAll(this.phaseNamePrefix, "").trim();
                for (String string2 : performanceResult.getMetrics()) {
                    for (Integer n : performanceResult.getThreads()) {
                        defaultResult.putExclusive(hashSet.size(), this.phaseNamePrefix + " measurement", string2, defaultResult.getExclusive(hashSet.size(), this.phaseNamePrefix + " measurement", string2) + performanceResult.getExclusive(n, string, string2));
                        defaultResult.putInclusive(hashSet.size(), this.phaseNamePrefix + " measurement", string2, defaultResult.getInclusive(hashSet.size(), this.phaseNamePrefix + " measurement", string2) + performanceResult.getInclusive(n, string, string2));
                        defaultResult.putCalls(hashSet.size(), this.phaseNamePrefix + " measurement", defaultResult.getCalls(hashSet.size(), this.phaseNamePrefix + " measurement") + performanceResult.getCalls(n, string));
                        defaultResult.putSubroutines(hashSet.size(), this.phaseNamePrefix + " measurement", defaultResult.getSubroutines(hashSet.size(), this.phaseNamePrefix + " measurement") + performanceResult.getSubroutines(n, string));
                    }
                    defaultResult.putExclusive(hashSet.size(), this.phaseNamePrefix + " measurement", string2, defaultResult.getExclusive(hashSet.size(), this.phaseNamePrefix + " measurement", string2) / (double)performanceResult.getThreads().size());
                    defaultResult.putInclusive(hashSet.size(), this.phaseNamePrefix + " measurement", string2, defaultResult.getInclusive(hashSet.size(), this.phaseNamePrefix + " measurement", string2) / (double)performanceResult.getThreads().size());
                    defaultResult.putCalls(hashSet.size(), this.phaseNamePrefix + " measurement", defaultResult.getCalls(hashSet.size(), this.phaseNamePrefix + " measurement") / (double)performanceResult.getThreads().size());
                    defaultResult.putSubroutines(hashSet.size(), this.phaseNamePrefix + " measurement", defaultResult.getSubroutines(hashSet.size(), this.phaseNamePrefix + " measurement") / (double)performanceResult.getThreads().size());
                }
                hashSet.add(string);
            }
            defaultResult.updateEventMap();
        }
        return this.outputs;
    }
}

