/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.BasicStatisticsOperation;
import edu.uoregon.tau.perfexplorer.glue.DefaultResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.glue.RatioOperation;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadImbalanceOperation
extends AbstractPerformanceOperation {
    private static final long serialVersionUID = 3765199846343102905L;
    public static String COMPUTATION = "Computation";
    public static String KERNEL_COMPUTATION = "Kernel Computation";
    public static String COMMUNICATION = "MPI";
    public static String COMMUNICATION_METHOD = "MPI_";
    public static String KERNEL_COMMUNICATION = "Kernel MPI";
    private static String MPI_INIT = "MPI_Init";
    private static String MPI_FINALIZE = "MPI_Finalize";
    public static int MEAN = 0;
    public static int MAX = 1;
    public static int MIN = 2;
    public static int STDDEV = 3;
    public static int COMMUNICATION_EFFICIENCY = 1;
    public static int LOAD_BALANCE = 4;
    public static int COMPUTATION_SPLITS = 5;
    private boolean percentage = true;

    public LoadImbalanceOperation(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    public LoadImbalanceOperation(Trial trial) {
        super(trial);
    }

    public LoadImbalanceOperation(List<PerformanceResult> list) {
        super(list);
    }

    @Override
    public List<PerformanceResult> processData() {
        for (PerformanceResult performanceResult : this.inputs) {
            DefaultResult defaultResult = new DefaultResult(performanceResult, false);
            for (Integer n : performanceResult.getThreads()) {
                defaultResult.putCalls(n, COMPUTATION, 1.0);
                defaultResult.putSubroutines(n, COMPUTATION, 0.0);
                defaultResult.putCalls(n, COMMUNICATION, 1.0);
                defaultResult.putSubroutines(n, COMMUNICATION, 0.0);
                defaultResult.putCalls(n, KERNEL_COMPUTATION, 1.0);
                defaultResult.putSubroutines(n, KERNEL_COMPUTATION, 0.0);
                defaultResult.putCalls(n, KERNEL_COMMUNICATION, 1.0);
                defaultResult.putSubroutines(n, KERNEL_COMMUNICATION, 0.0);
                for (String string : performanceResult.getMetrics()) {
                    double d;
                    double d2;
                    defaultResult.putExclusive(n, COMPUTATION, string, 0.0);
                    defaultResult.putInclusive(n, COMPUTATION, string, 0.0);
                    defaultResult.putInclusive(n, COMMUNICATION, string, 0.0);
                    defaultResult.putExclusive(n, COMMUNICATION, string, 0.0);
                    defaultResult.putExclusive(n, KERNEL_COMPUTATION, string, 0.0);
                    defaultResult.putInclusive(n, KERNEL_COMPUTATION, string, 0.0);
                    defaultResult.putInclusive(n, KERNEL_COMMUNICATION, string, 0.0);
                    defaultResult.putExclusive(n, KERNEL_COMMUNICATION, string, 0.0);
                    double d3 = d2 = performanceResult.getInclusive(n, performanceResult.getMainEvent(), string);
                    for (String string2 : performanceResult.getEvents()) {
                        d = performanceResult.getExclusive(n, string2, string);
                        if (!string2.contains(COMMUNICATION_METHOD)) continue;
                        double d4 = defaultResult.getExclusive(n, COMMUNICATION, string);
                        defaultResult.putExclusive(n, COMMUNICATION, string, d + d4);
                        defaultResult.putInclusive(n, COMMUNICATION, string, d + d4);
                        if (string2.contains(MPI_INIT) || string2.contains(MPI_FINALIZE)) {
                            d3 -= d;
                            continue;
                        }
                        d4 = defaultResult.getExclusive(n, KERNEL_COMMUNICATION, string);
                        defaultResult.putExclusive(n, KERNEL_COMMUNICATION, string, d + d4);
                        defaultResult.putInclusive(n, KERNEL_COMMUNICATION, string, d + d4);
                    }
                    double d5 = defaultResult.getExclusive(n, COMMUNICATION, string);
                    d = d2 - d5;
                    if (this.percentage) {
                        defaultResult.putInclusive(n, COMPUTATION, string, d / d2);
                        defaultResult.putExclusive(n, COMPUTATION, string, d / d2);
                        defaultResult.putInclusive(n, COMMUNICATION, string, d5 / d2);
                        defaultResult.putExclusive(n, COMMUNICATION, string, d5 / d2);
                    } else {
                        defaultResult.putInclusive(n, COMPUTATION, string, d);
                        defaultResult.putExclusive(n, COMPUTATION, string, d);
                        defaultResult.putInclusive(n, COMMUNICATION, string, d5);
                        defaultResult.putExclusive(n, COMMUNICATION, string, d5);
                    }
                    d5 = defaultResult.getExclusive(n, KERNEL_COMMUNICATION, string);
                    d = d3 - d5;
                    if (this.percentage) {
                        defaultResult.putInclusive(n, KERNEL_COMPUTATION, string, d / d3);
                        defaultResult.putExclusive(n, KERNEL_COMPUTATION, string, d / d3);
                        defaultResult.putInclusive(n, KERNEL_COMMUNICATION, string, d5 / d3);
                        defaultResult.putExclusive(n, KERNEL_COMMUNICATION, string, d5 / d3);
                        continue;
                    }
                    defaultResult.putInclusive(n, KERNEL_COMPUTATION, string, d);
                    defaultResult.putExclusive(n, KERNEL_COMPUTATION, string, d);
                    defaultResult.putInclusive(n, KERNEL_COMMUNICATION, string, d5);
                    defaultResult.putExclusive(n, KERNEL_COMMUNICATION, string, d5);
                }
            }
            BasicStatisticsOperation basicStatisticsOperation = new BasicStatisticsOperation(defaultResult, false);
            List<PerformanceResult> object2 = basicStatisticsOperation.processData();
            this.outputs.add(object2.get(BasicStatisticsOperation.MEAN));
            this.outputs.add(object2.get(BasicStatisticsOperation.MAX));
            this.outputs.add(object2.get(BasicStatisticsOperation.MIN));
            this.outputs.add(object2.get(BasicStatisticsOperation.STDDEV));
            RatioOperation ratioOperation = new RatioOperation(object2.get(BasicStatisticsOperation.MEAN), object2.get(BasicStatisticsOperation.MAX));
            this.outputs.add(ratioOperation.processData().get(0));
            this.outputs.add(defaultResult);
        }
        return this.outputs;
    }

    public void setPercentage(boolean bl) {
        this.percentage = bl;
    }

    public boolean getPercentage() {
        return this.percentage;
    }
}

