/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.DefaultResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaleMetricOperation
extends AbstractPerformanceOperation {
    private static final long serialVersionUID = -2410741879318876211L;
    public static final String ADD = "+";
    public static final String SUBTRACT = "-";
    public static final String MULTIPLY = "*";
    public static final String DIVIDE = "/";
    private String metric = null;
    private Double value = 0.0;
    private String operation = "+";
    private String newName = null;
    private boolean rightValue = false;

    public ScaleMetricOperation(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    public ScaleMetricOperation(Trial trial) {
        super(trial);
    }

    public ScaleMetricOperation(List<PerformanceResult> list) {
        super(list);
    }

    public ScaleMetricOperation(PerformanceResult performanceResult, String string, Double d, String string2) {
        super(performanceResult);
        this.metric = string;
        this.value = d;
        this.operation = string2;
        this.rightValue = true;
        this.newName = "(" + string + string2 + d.toString() + ")";
        if (!performanceResult.getMetrics().contains(string)) {
            System.err.println("\n\n *** ERROR: Trial does not have a metric named: " + string + " ***\n\n");
        }
    }

    public ScaleMetricOperation(PerformanceResult performanceResult, Double d, String string, String string2) {
        super(performanceResult);
        this.metric = string;
        this.value = d;
        this.operation = string2;
        this.rightValue = false;
        this.newName = "(" + d.toString() + string2 + string + ")";
        if (!performanceResult.getMetrics().contains(string)) {
            System.err.println("\n\n *** ERROR: Trial does not have a metric named: " + string + " ***\n\n");
        }
    }

    @Override
    public List<PerformanceResult> processData() {
        for (PerformanceResult performanceResult : this.inputs) {
            DefaultResult defaultResult = new DefaultResult(performanceResult, false);
            for (String string : performanceResult.getEvents()) {
                for (Integer n : performanceResult.getThreads()) {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    if (this.rightValue) {
                        d4 = performanceResult.getInclusive(n, string, this.metric);
                        d3 = performanceResult.getExclusive(n, string, this.metric);
                        d2 = this.value;
                        d = this.value;
                    } else {
                        d4 = this.value;
                        d3 = this.value;
                        d2 = performanceResult.getInclusive(n, string, this.metric);
                        d = performanceResult.getExclusive(n, string, this.metric);
                    }
                    double d5 = 0.0;
                    double d6 = 0.0;
                    if (this.operation.equals(ADD)) {
                        d5 = d4 + d2;
                        d6 = d3 + d;
                    } else if (this.operation.equals(SUBTRACT)) {
                        d5 = d4 - d2;
                        d6 = d3 - d;
                    } else if (this.operation.equals(MULTIPLY)) {
                        d5 = d4 * d2;
                        d6 = d3 * d;
                    } else if (this.operation.equals(DIVIDE)) {
                        if (d2 == 0.0 || d == 0.0) {
                            d5 = 0.0;
                            d6 = 0.0;
                        } else {
                            d5 = d4 / d2;
                            d6 = d3 / d;
                        }
                    }
                    defaultResult.putInclusive(n, string, this.newName, d5);
                    defaultResult.putExclusive(n, string, this.newName, d6);
                    defaultResult.putCalls(n, string, performanceResult.getCalls(n, string));
                    defaultResult.putSubroutines(n, string, performanceResult.getSubroutines(n, string));
                }
            }
            this.outputs.add(defaultResult);
        }
        return this.outputs;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String string) {
        this.newName = string;
    }
}

