/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue.psl;

import edu.uoregon.tau.perfexplorer.glue.psl.CodeRegion;
import edu.uoregon.tau.perfexplorer.glue.psl.Experiment;
import edu.uoregon.tau.perfexplorer.glue.psl.VirtualNode;

public class RegionSummary {
    private String processingUnit = null;
    private CodeRegion codeRegion = null;
    private Experiment experiment = null;
    private double inclusiveTime = 0.0;
    private double exclusiveTime = 0.0;
    private double totalInstructions = 0.0;
    private double floatingPointInstructions = 0.0;
    private double[] cacheMisses = new double[]{0.0, 0.0, 0.0};
    private double[] cacheAccesses = new double[]{0.0, 0.0, 0.0};

    public double getExclusiveTime() {
        return this.exclusiveTime;
    }

    public double getTotalInstructions() {
        return this.totalInstructions;
    }

    public double getFloatingPointInstructions() {
        return this.floatingPointInstructions;
    }

    public RegionSummary(Experiment experiment, CodeRegion codeRegion, String string) {
        this.experiment = experiment;
        this.experiment.addRegionSummary(this);
        this.codeRegion = codeRegion;
    }

    public CodeRegion getCodeRegion() {
        return this.codeRegion;
    }

    public void setCodeRegion(CodeRegion codeRegion) {
        this.codeRegion = codeRegion;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public void setExperiment(Experiment experiment) {
        this.experiment = experiment;
    }

    public String getProcessingUnit() {
        return this.processingUnit;
    }

    public void setProcessingUnit(String string) {
        this.processingUnit = string;
    }

    public VirtualNode getExecutionNode() {
        VirtualNode virtualNode = null;
        return virtualNode;
    }

    public double getIdentifiedOverhead() {
        double d = 0.0;
        return d;
    }

    public double getExecutionTime() {
        return this.inclusiveTime;
    }

    public double getSynchronizationTime() {
        double d = 0.0;
        return d;
    }

    public double getReceiveTime() {
        double d = 0.0;
        if (this.codeRegion.getGroupType() == CodeRegion.GroupType.MPI && this.codeRegion.getShortName().toUpperCase().indexOf("RECV") > -1) {
            d = this.inclusiveTime;
        }
        return d;
    }

    public double getCommunicationTime() {
        double d = 0.0;
        return d;
    }

    public double getLossOfParallelism() {
        double d = 0.0;
        return d;
    }

    public double getControlOfParallelism() {
        double d = 0.0;
        return d;
    }

    public double getNumberOfInstructions() {
        double d = 0.0;
        return d;
    }

    public double getNumberOfCacheMisses(int n) {
        return this.cacheMisses[n];
    }

    public double getNumberOfCacheHits(int n) {
        return this.cacheAccesses[n] - this.cacheMisses[n];
    }

    public double getNumberOfCacheAccesses(int n) {
        return this.cacheAccesses[n];
    }

    public void setCacheMisses(double[] dArray) {
        this.cacheMisses = dArray;
    }

    public void setExclusiveTime(double d) {
        this.exclusiveTime = d;
    }

    public void setFloatingPointInstructions(double d) {
        this.floatingPointInstructions = d;
    }

    public void setInclusiveTime(double d) {
        this.inclusiveTime = d;
    }

    public void setTotalInstructions(double d) {
        this.totalInstructions = d;
    }

    public double[] getCacheAccesses() {
        return this.cacheAccesses;
    }

    public void setCacheAccesses(double[] dArray) {
        this.cacheAccesses = dArray;
    }
}

