/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue.psl;

import edu.uoregon.tau.perfexplorer.glue.psl.Experiment;
import edu.uoregon.tau.perfexplorer.glue.psl.RegionSummary;
import edu.uoregon.tau.perfexplorer.glue.psl.RegionSummaryFilter;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionSummaryIterator
implements Iterator<RegionSummary> {
    private RegionSummaryFilter filter = null;
    private Iterator<RegionSummary> summaries = null;
    private Set<RegionSummary> summarySet = null;
    private RegionSummary currentSummary = null;

    public RegionSummaryIterator(RegionSummaryFilter regionSummaryFilter, Experiment experiment) {
        this.filter = regionSummaryFilter;
        this.summarySet = experiment.getRegionSummaries();
        this.reset();
    }

    public RegionSummaryIterator(Experiment experiment) {
        this.summarySet = experiment.getRegionSummaries();
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return this.currentSummary != null;
    }

    @Override
    public RegionSummary next() {
        RegionSummary regionSummary = this.currentSummary;
        if (regionSummary != null) {
            this.getNext();
        }
        return regionSummary;
    }

    private void getNext() {
        this.currentSummary = null;
        while (this.summaries.hasNext()) {
            RegionSummary regionSummary = this.summaries.next();
            if (this.filter != null) {
                if (!this.filter.accept(regionSummary)) continue;
                this.currentSummary = regionSummary;
                break;
            }
            this.currentSummary = regionSummary;
            break;
        }
    }

    @Override
    public void remove() {
    }

    public RegionSummaryFilter getFilter() {
        return this.filter;
    }

    public void setFilter(RegionSummaryFilter regionSummaryFilter) {
        this.filter = regionSummaryFilter;
    }

    public void reset() {
        this.summaries = this.summarySet.iterator();
        this.getNext();
    }
}

