/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.CorrelationPlotDataset;
import client.PECategoryDataset;
import client.PerfExplorerChartWindow;
import client.PerfExplorerConnection;
import client.PerfExplorerModel;
import client.SpeedupXYLineAndShapeRenderer;
import common.ChartDataType;
import common.RMIChartData;
import common.RMIGeneralChartData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class PerfExplorerChart
extends PerfExplorerChartWindow {
    static /* synthetic */ Class class$java$lang$Integer;

    public PerfExplorerChart(JFreeChart jFreeChart, String string) {
        super(jFreeChart, string);
    }

    public static PerfExplorerChart doFractionChart() {
        XYSeries xYSeries;
        List list;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), ChartDataType.FRACTION_OF_TOTAL);
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
        List list2 = rMIChartData.getRowLabels();
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            list = rMIChartData.getRowData(i);
            xYSeries = new XYSeries(PerfExplorerChart.shortName((String)list2.get(i)), true, false);
            for (int j = 0; j < list.size(); ++j) {
                double[] dArray = (double[])list.get(j);
                xYSeries.add(dArray[0], dArray[1]);
            }
            defaultTableXYDataset.addSeries(xYSeries);
        }
        JFreeChart jFreeChart = ChartFactory.createStackedXYAreaChart((String)("Total " + PerfExplorerModel.getModel().getMetricName() + " Breakdown for " + PerfExplorerModel.getModel().toString()), (String)"Number of Processors", (String)("Percentage of Total " + PerfExplorerModel.getModel().getMetricName()), (TableXYDataset)defaultTableXYDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        list = jFreeChart.getXYPlot();
        xYSeries = new NumberAxis("Percentage of Total " + PerfExplorerModel.getModel().getMetricName());
        xYSeries.setRange(new Range(0.0, 100.0));
        list.setRangeAxis(0, (ValueAxis)xYSeries);
        return new PerfExplorerChart(jFreeChart, "Total " + PerfExplorerModel.getModel().getMetricName() + " Breakdown");
    }

    public static PerfExplorerChart doCorrelationChart() {
        Object object;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), ChartDataType.CORRELATION_DATA);
        CorrelationPlotDataset correlationPlotDataset = new CorrelationPlotDataset(rMIChartData, false);
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)("Correlation Results: " + PerfExplorerModel.getModel().toString() + ": " + PerfExplorerModel.getModel().getMetricName()), (String)"Processors", (String)("Exclusive " + PerfExplorerModel.getModel().getMetricName() + " for Event"), (XYDataset)correlationPlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        PerfExplorerChart.customizeChart(jFreeChart, rMIChartData.getRows(), true);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        if (PerfExplorerModel.getModel().getConstantProblem().booleanValue()) {
            object = new LogarithmicAxis("Exclusive " + PerfExplorerModel.getModel().getMetricName() + " for Event");
            object.setAutoRangeIncludesZero(true);
            object.setAllowNegativesFlag(true);
            object.setLog10TickLabelsFlag(true);
            xYPlot.setRangeAxis(0, (ValueAxis)object);
        } else {
            object = new NumberAxis("Inclusive " + PerfExplorerModel.getModel().getMetricName() + " for " + (String)rMIChartData.getRowLabels().get(0));
            object.setAutoRangeIncludesZero(false);
            xYPlot.setRangeAxis(1, (ValueAxis)object);
        }
        object = new CorrelationPlotDataset(rMIChartData, true);
        xYPlot.setDataset(1, (XYDataset)object);
        xYPlot.mapDatasetToRangeAxis(1, 1);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer();
        standardXYItemRenderer.setSeriesPaint(0, (Paint)Color.black);
        standardXYItemRenderer.setPlotShapes(true);
        standardXYItemRenderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{10.0f, 6.0f}, 0.0f));
        standardXYItemRenderer.setToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", (NumberFormat)new DecimalFormat("processors: #######"), (NumberFormat)new DecimalFormat("value: #,##0.00")));
        xYPlot.setRenderer(1, (XYItemRenderer)standardXYItemRenderer);
        return new PerfExplorerChart(jFreeChart, "Total " + PerfExplorerModel.getModel().getMetricName() + " Breakdown");
    }

    public static PerfExplorerChart doEfficiencyChart() {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), ChartDataType.RELATIVE_EFFICIENCY);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list = rMIChartData.getRowLabels();
        double d = 0.0;
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            List list2 = rMIChartData.getRowData(i);
            XYSeries xYSeries = new XYSeries(PerfExplorerChart.shortName((String)list.get(i)), true, false);
            double[] dArray = (double[])list2.get(0);
            for (int j = 0; j < list2.size(); ++j) {
                double[] dArray2 = (double[])list2.get(j);
                d = dArray[0] / dArray2[0];
                double d2 = PerfExplorerModel.getModel().getConstantProblem() != false ? dArray[1] * d : dArray[1];
                xYSeries.add(dArray2[0], d2 / dArray2[1]);
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)("Relative Efficiency - " + PerfExplorerModel.getModel().toString() + ":" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Value", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart(jFreeChart, rMIChartData.getRows(), false);
        return new PerfExplorerChart(jFreeChart, "Relative Efficiency");
    }

    public static PerfExplorerChart doGeneralChart() {
        CategoryAxis categoryAxis;
        Object object;
        Object object2;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        RMIGeneralChartData rMIGeneralChartData = perfExplorerConnection.requestGeneralChartData(perfExplorerModel, ChartDataType.PARAMETRIC_STUDY_DATA);
        PECategoryDataset pECategoryDataset = new PECategoryDataset();
        if (rMIGeneralChartData.getCategoryType() == (class$java$lang$Integer == null ? (class$java$lang$Integer = PerfExplorerChart.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            if (perfExplorerModel.getChartScalability()) {
                pECategoryDataset.addValue(1.0, (Comparable)((Object)"Ideal"), (Comparable)new Integer(rMIGeneralChartData.getMinimum()));
                pECategoryDataset.addValue(rMIGeneralChartData.getMaximum() / rMIGeneralChartData.getMinimum(), (Comparable)((Object)"Ideal"), (Comparable)new Integer(rMIGeneralChartData.getMaximum()));
                object2 = rMIGeneralChartData.getRowData(0);
                for (int i = 0; i < rMIGeneralChartData.getRows(); ++i) {
                    RMIGeneralChartData.CategoryDataRow categoryDataRow = rMIGeneralChartData.getRowData(i);
                    if (!PerfExplorerChart.shortName(categoryDataRow.series).equals(PerfExplorerChart.shortName(object2.series))) {
                        object2 = categoryDataRow;
                    }
                    if (perfExplorerModel.getConstantProblem().booleanValue()) {
                        double d = object2.categoryInteger.doubleValue() / categoryDataRow.categoryInteger.doubleValue();
                        double d2 = object2.value / categoryDataRow.value;
                        pECategoryDataset.addValue(d2 / d, (Comparable)((Object)PerfExplorerChart.shortName(categoryDataRow.series)), (Comparable)categoryDataRow.categoryInteger);
                        continue;
                    }
                    pECategoryDataset.addValue(object2.value / categoryDataRow.value, (Comparable)((Object)PerfExplorerChart.shortName(categoryDataRow.series)), (Comparable)categoryDataRow.categoryInteger);
                }
                object = pECategoryDataset.getColumnKeys();
                for (int i = 0; i < object.size(); ++i) {
                    Integer n = (Integer)object.get(i);
                    pECategoryDataset.addValue(n.doubleValue() / (double)rMIGeneralChartData.getMinimum(), (Comparable)((Object)"Ideal"), (Comparable)n);
                }
            } else {
                for (int i = 0; i < rMIGeneralChartData.getRows(); ++i) {
                    object = rMIGeneralChartData.getRowData(i);
                    pECategoryDataset.addValue(((RMIGeneralChartData.CategoryDataRow)object).value / 1000000.0, (Comparable)((Object)PerfExplorerChart.shortName(((RMIGeneralChartData.CategoryDataRow)object).series)), (Comparable)((RMIGeneralChartData.CategoryDataRow)object).categoryInteger);
                }
            }
        } else {
            for (int i = 0; i < rMIGeneralChartData.getRows(); ++i) {
                object = rMIGeneralChartData.getRowData(i);
                pECategoryDataset.addValue(((RMIGeneralChartData.CategoryDataRow)object).value / 1000000.0, (Comparable)((Object)PerfExplorerChart.shortName(((RMIGeneralChartData.CategoryDataRow)object).series)), (Comparable)((Object)((RMIGeneralChartData.CategoryDataRow)object).categoryString));
            }
        }
        object2 = PlotOrientation.VERTICAL;
        if (perfExplorerModel.getChartHorizontal()) {
            object2 = PlotOrientation.HORIZONTAL;
        }
        object = ChartFactory.createLineChart((String)perfExplorerModel.getChartTitle(), (String)perfExplorerModel.getChartXAxisLabel(), (String)perfExplorerModel.getChartYAxisLabel(), (CategoryDataset)pECategoryDataset, (PlotOrientation)object2, (boolean)true, (boolean)true, (boolean)false);
        StandardLegend standardLegend = (StandardLegend)object.getLegend();
        standardLegend.setDisplaySeriesShapes(true);
        CategoryPlot categoryPlot = (CategoryPlot)object.getPlot();
        LineAndShapeRenderer lineAndShapeRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        lineAndShapeRenderer.setDefaultShapesFilled(true);
        lineAndShapeRenderer.setDrawShapes(true);
        lineAndShapeRenderer.setDrawLines(true);
        lineAndShapeRenderer.setItemLabelsVisible(true);
        if (perfExplorerModel.getChartScalability()) {
            // empty if block
        }
        for (int i = 0; i < rMIGeneralChartData.getRows(); ++i) {
            lineAndShapeRenderer.setSeriesStroke(i, (Stroke)new BasicStroke(2.0f));
        }
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setAutoRangeIncludesZero(true);
        if (rMIGeneralChartData.getCategoryType() != (class$java$lang$Integer == null ? (class$java$lang$Integer = PerfExplorerChart.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            categoryAxis = categoryPlot.getDomainAxis();
            categoryAxis.setSkipCategoryLabelsToFit(true);
            categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        }
        if (perfExplorerModel.getChartLogYAxis()) {
            categoryAxis = new LogarithmicAxis(PerfExplorerModel.getModel().getChartYAxisLabel());
            categoryAxis.setAutoRangeIncludesZero(true);
            categoryAxis.setAllowNegativesFlag(true);
            categoryAxis.setLog10TickLabelsFlag(true);
            categoryPlot.setRangeAxis(0, (ValueAxis)categoryAxis);
        }
        return new PerfExplorerChart((JFreeChart)object, "General Chart");
    }

    public static PerfExplorerChart doEfficiencyEventsChart() {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), ChartDataType.RELATIVE_EFFICIENCY_EVENTS);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list = rMIChartData.getRowLabels();
        double d = 0.0;
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            List list2 = rMIChartData.getRowData(i);
            XYSeries xYSeries = new XYSeries(PerfExplorerChart.shortName((String)list.get(i)), true, false);
            double[] dArray = (double[])list2.get(0);
            for (int j = 0; j < list2.size(); ++j) {
                double[] dArray2 = (double[])list2.get(j);
                d = dArray[0] / dArray2[0];
                double d2 = PerfExplorerModel.getModel().getConstantProblem() != false ? dArray[1] * d : dArray[1];
                xYSeries.add(dArray2[0], d2 / dArray2[1]);
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)("Relative Efficiency by Event for " + PerfExplorerModel.getModel().toString() + ":" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Value", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart(jFreeChart, rMIChartData.getRows(), false);
        return new PerfExplorerChart(jFreeChart, "Relative Efficiency by Event");
    }

    public static PerfExplorerChart doEfficiencyOneEventChart() {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), ChartDataType.RELATIVE_EFFICIENCY_ONE_EVENT);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list = rMIChartData.getRowLabels();
        double d = 0.0;
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            List list2 = rMIChartData.getRowData(i);
            XYSeries xYSeries = new XYSeries(PerfExplorerChart.shortName((String)list.get(i)), true, false);
            double[] dArray = (double[])list2.get(0);
            for (int j = 0; j < list2.size(); ++j) {
                double[] dArray2 = (double[])list2.get(j);
                d = dArray[0] / dArray2[0];
                double d2 = PerfExplorerModel.getModel().getConstantProblem() != false ? dArray[1] * d : dArray[1];
                xYSeries.add(dArray2[0], d2 / dArray2[1]);
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)("Relative Efficiency for " + PerfExplorerModel.getModel().getEventName() + ":" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Value", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart(jFreeChart, rMIChartData.getRows(), false);
        return new PerfExplorerChart(jFreeChart, "Relative Efficiency for Event");
    }

    public static PerfExplorerChart doSpeedupChart() {
        List list;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), ChartDataType.RELATIVE_EFFICIENCY);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list2 = rMIChartData.getRowLabels();
        double d = 99999.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            list = rMIChartData.getRowData(i);
            XYSeries xYSeries = new XYSeries(PerfExplorerChart.shortName((String)list2.get(i)), true, false);
            double[] dArray = (double[])list.get(0);
            for (int j = 0; j < list.size(); ++j) {
                double[] dArray2 = (double[])list.get(j);
                double d4 = dArray[0] / dArray2[0];
                double d5 = PerfExplorerModel.getModel().getConstantProblem() != false ? dArray[1] * d4 : dArray[1];
                d3 = d5 / dArray2[1];
                xYSeries.add(dArray2[0], d3 / d4);
                if (!(d2 < dArray2[0])) continue;
                d2 = dArray2[0];
            }
            if (d > dArray[0]) {
                d = dArray[0];
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        XYSeries xYSeries = new XYSeries("ideal", true, false);
        xYSeries.add(d, 1.0);
        xYSeries.add(d2, d2 / d);
        xYSeriesCollection.addSeries(xYSeries);
        list = ChartFactory.createXYLineChart((String)("Relative Speedup - " + PerfExplorerModel.getModel().toString() + ":" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Value", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart((JFreeChart)list, rMIChartData.getRows(), true);
        return new PerfExplorerChart((JFreeChart)list, "Relative Speedup");
    }

    public static PerfExplorerChart doSpeedupEventsChart() {
        List list;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), ChartDataType.RELATIVE_EFFICIENCY_EVENTS);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list2 = rMIChartData.getRowLabels();
        double d = 99999.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            list = rMIChartData.getRowData(i);
            XYSeries xYSeries = new XYSeries(PerfExplorerChart.shortName((String)list2.get(i)), true, false);
            double[] dArray = (double[])list.get(0);
            for (int j = 0; j < list.size(); ++j) {
                double[] dArray2 = (double[])list.get(j);
                d4 = dArray[0] / dArray2[0];
                d3 = PerfExplorerModel.getModel().getConstantProblem() != false ? dArray[1] * d4 : dArray[1];
                d5 = d3 / dArray2[1];
                xYSeries.add(dArray2[0], d5 / d4);
                if (!(d2 < dArray2[0])) continue;
                d2 = dArray2[0];
            }
            if (d > dArray[0]) {
                d = dArray[0];
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        XYSeries xYSeries = new XYSeries("ideal", true, false);
        xYSeries.add(d, 1.0);
        xYSeries.add(d2, d2 / d);
        xYSeriesCollection.addSeries(xYSeries);
        list = ChartFactory.createXYLineChart((String)("Relative Speedup by Event for " + PerfExplorerModel.getModel().toString() + ":" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Value", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart((JFreeChart)list, rMIChartData.getRows(), true);
        return new PerfExplorerChart((JFreeChart)list, "Relative Speedup by Event");
    }

    public static PerfExplorerChart doSpeedupOneEventChart() {
        List list;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), ChartDataType.RELATIVE_EFFICIENCY_ONE_EVENT);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list2 = rMIChartData.getRowLabels();
        double d = 99999.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            list = rMIChartData.getRowData(i);
            XYSeries xYSeries = new XYSeries(PerfExplorerChart.shortName((String)list2.get(i)), true, false);
            double[] dArray = (double[])list.get(0);
            for (int j = 0; j < list.size(); ++j) {
                double[] dArray2 = (double[])list.get(j);
                d4 = dArray[0] / dArray2[0];
                d3 = PerfExplorerModel.getModel().getConstantProblem() != false ? dArray[1] * d4 : dArray[1];
                d5 = d3 / dArray2[1];
                xYSeries.add(dArray2[0], d5 / d4);
                if (!(d2 < dArray2[0])) continue;
                d2 = dArray2[0];
            }
            if (d > dArray[0]) {
                d = dArray[0];
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        XYSeries xYSeries = new XYSeries("ideal", true, false);
        xYSeries.add(d, 1.0);
        xYSeries.add(d2, d2 / d);
        xYSeriesCollection.addSeries(xYSeries);
        list = ChartFactory.createXYLineChart((String)("Relative Speedup for " + PerfExplorerModel.getModel().getEventName() + ":" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Value", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart((JFreeChart)list, rMIChartData.getRows(), true);
        return new PerfExplorerChart((JFreeChart)list, "Relative Speedup for Event");
    }

    public static PerfExplorerChart doTimestepsChart() {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), ChartDataType.RELATIVE_EFFICIENCY);
        int n = Integer.parseInt(PerfExplorerModel.getModel().getTotalTimesteps());
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list = rMIChartData.getRowLabels();
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            List list2 = rMIChartData.getRowData(i);
            XYSeries xYSeries = new XYSeries(PerfExplorerChart.shortName((String)list.get(i)), true, false);
            for (int j = 0; j < list2.size(); ++j) {
                double[] dArray = (double[])list2.get(j);
                xYSeries.add(dArray[0], (double)n / dArray[1]);
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)("Timesteps Per Second (" + n + " total timesteps):" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Timesteps", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart(jFreeChart, rMIChartData.getRows(), false);
        return new PerfExplorerChart(jFreeChart, "Timesteps per Second");
    }

    public static PerfExplorerChart doTotalTimeChart() {
        XYSeries xYSeries;
        List list;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), ChartDataType.RELATIVE_EFFICIENCY);
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list2 = rMIChartData.getRowLabels();
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            list = rMIChartData.getRowData(i);
            xYSeries = new XYSeries(PerfExplorerChart.shortName((String)list2.get(i)), true, false);
            n2 += list.size();
            for (int j = 0; j < list.size(); ++j) {
                double[] dArray = (double[])list.get(j);
                xYSeries.add(dArray[0], dArray[1]);
                if (d > dArray[1]) {
                    ++n;
                }
                d = dArray[1];
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)("Total Execution:" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)PerfExplorerModel.getModel().getMetricNameUnits(), (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart(jFreeChart, rMIChartData.getRows(), false);
        if (n > n2 / 2) {
            list = jFreeChart.getXYPlot();
            xYSeries = new LogarithmicAxis(PerfExplorerModel.getModel().getMetricName());
            xYSeries.setAutoRangeIncludesZero(true);
            xYSeries.setAllowNegativesFlag(true);
            xYSeries.setLog10TickLabelsFlag(true);
            list.setRangeAxis(0, (ValueAxis)xYSeries);
        }
        return new PerfExplorerChart(jFreeChart, "Total Execution " + PerfExplorerModel.getModel().getMetricName() + "");
    }

    public static PerfExplorerChart doCommunicationChart() {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), ChartDataType.TOTAL_FOR_GROUP);
        RMIChartData rMIChartData2 = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), ChartDataType.RELATIVE_EFFICIENCY);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list = rMIChartData.getRowLabels();
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            List list2 = rMIChartData.getRowData(i);
            List list3 = rMIChartData2.getRowData(i);
            XYSeries xYSeries = new XYSeries(PerfExplorerChart.shortName((String)list.get(i)), true, false);
            for (int j = 0; j < list2.size(); ++j) {
                double[] dArray = (double[])list2.get(j);
                double[] dArray2 = (double[])list3.get(j);
                xYSeries.add(dArray[0], dArray[1] / dArray2[1]);
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)(PerfExplorerModel.getModel().getGroupName() + " " + PerfExplorerModel.getModel().getMetricName() + " / Total " + PerfExplorerModel.getModel().getMetricName() + " - " + PerfExplorerModel.getModel().toString()), (String)"Number of Processors", (String)"Fraction", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart(jFreeChart, rMIChartData.getRows(), false);
        return new PerfExplorerChart(jFreeChart, PerfExplorerModel.getModel().getGroupName() + " " + PerfExplorerModel.getModel().getMetricName() + " / Total " + PerfExplorerModel.getModel().getMetricName());
    }

    public static PerfExplorerChart doEfficiencyPhasesChart() {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), ChartDataType.RELATIVE_EFFICIENCY_PHASES);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list = rMIChartData.getRowLabels();
        double d = 0.0;
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            List list2 = rMIChartData.getRowData(i);
            XYSeries xYSeries = new XYSeries(PerfExplorerChart.shortName((String)list.get(i)), true, false);
            double[] dArray = (double[])list2.get(0);
            for (int j = 0; j < list2.size(); ++j) {
                double[] dArray2 = (double[])list2.get(j);
                d = dArray[0] / dArray2[0];
                double d2 = dArray[1] * d;
                xYSeries.add(dArray2[0], d2 / dArray2[1]);
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)("Relative Efficiency by Phase for " + PerfExplorerModel.getModel().toString() + ":" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Value", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart(jFreeChart, rMIChartData.getRows(), false);
        return new PerfExplorerChart(jFreeChart, "Relative Efficiency by Event");
    }

    public static PerfExplorerChart doSpeedupPhasesChart() {
        List list;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), ChartDataType.RELATIVE_EFFICIENCY_PHASES);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list2 = rMIChartData.getRowLabels();
        double d = 99999.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            list = rMIChartData.getRowData(i);
            XYSeries xYSeries = new XYSeries(PerfExplorerChart.shortName((String)list2.get(i)), true, false);
            double[] dArray = (double[])list.get(0);
            for (int j = 0; j < list.size(); ++j) {
                double[] dArray2 = (double[])list.get(j);
                double d4 = dArray[0] / dArray2[0];
                double d5 = dArray[1] * d4;
                d3 = d5 / dArray2[1];
                xYSeries.add(dArray2[0], d3 / d4);
                if (!(d2 < dArray2[0])) continue;
                d2 = dArray2[0];
            }
            if (d > dArray[0]) {
                d = dArray[0];
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        XYSeries xYSeries = new XYSeries("ideal", true, false);
        xYSeries.add(d, 1.0);
        xYSeries.add(d2, d2 / d);
        xYSeriesCollection.addSeries(xYSeries);
        list = ChartFactory.createXYLineChart((String)("Relative Speedup by Phase for " + PerfExplorerModel.getModel().toString() + ":" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Value", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart((JFreeChart)list, rMIChartData.getRows(), true);
        return new PerfExplorerChart((JFreeChart)list, "Relative Speedup by Event");
    }

    public static PerfExplorerChart doFractionPhasesChart() {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), ChartDataType.FRACTION_OF_TOTAL_PHASES);
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
        List list = rMIChartData.getRowLabels();
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            List list2 = rMIChartData.getRowData(i);
            XYSeries xYSeries = new XYSeries(PerfExplorerChart.shortName((String)list.get(i)), true, false);
            for (int j = 0; j < list2.size(); ++j) {
                double[] dArray = (double[])list2.get(j);
                xYSeries.add(dArray[0], dArray[1]);
            }
            defaultTableXYDataset.addSeries(xYSeries);
        }
        JFreeChart jFreeChart = ChartFactory.createStackedXYAreaChart((String)("Total " + PerfExplorerModel.getModel().getMetricName() + " Breakdown for " + PerfExplorerModel.getModel().toString()), (String)"Number of Processors", (String)("Percentage of Total " + PerfExplorerModel.getModel().getMetricName()), (TableXYDataset)defaultTableXYDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        return new PerfExplorerChart(jFreeChart, "Total " + PerfExplorerModel.getModel().getMetricName() + " Breakdown");
    }

    private static void customizeChart(JFreeChart jFreeChart, int n, boolean bl) {
        StandardLegend standardLegend = (StandardLegend)jFreeChart.getLegend();
        standardLegend.setDisplaySeriesShapes(true);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        XYLineAndShapeRenderer xYLineAndShapeRenderer = null;
        xYLineAndShapeRenderer = bl ? new SpeedupXYLineAndShapeRenderer(n) : new XYLineAndShapeRenderer();
        xYLineAndShapeRenderer.setDefaultShapesFilled(true);
        xYLineAndShapeRenderer.setItemLabelsVisible(true);
        xYLineAndShapeRenderer.setToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", (NumberFormat)new DecimalFormat("processors: #######"), (NumberFormat)new DecimalFormat("value: #,##0.00")));
        for (int i = 0; i < n; ++i) {
            xYLineAndShapeRenderer.setSeriesStroke(i, (Stroke)new BasicStroke(2.0f));
        }
        if (bl) {
            xYLineAndShapeRenderer.setSeriesShapesVisible(n, false);
        }
        xYPlot.setRenderer((XYItemRenderer)xYLineAndShapeRenderer);
    }

    public static String shortName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(");
        String string2 = null;
        try {
            string2 = stringTokenizer.nextToken();
            if (string2.length() < string.length()) {
                string2 = string2 + "()";
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = string;
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

