/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.PerfExplorerConnection;
import client.PerfExplorerJTree;
import client.PerfExplorerModel;
import common.RMIView;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;

public class PerfExplorerViews {
    public static void createNewView(JFrame jFrame, int n) {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        Object[] objectArray = new Object[]{new String("Application"), new String("Experiment"), new String("Trial")};
        String string = (String)JOptionPane.showInputDialog(jFrame, "Select a level in the hierarchy:", "Select Level", -1, null, objectArray, "Application");
        if (string == null) {
            return;
        }
        String[] stringArray = perfExplorerConnection.getMetaData(string);
        Object[] objectArray2 = new String[stringArray.length + 1];
        objectArray2[0] = new String("name");
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray2[i + 1] = stringArray[i];
        }
        String string2 = (String)JOptionPane.showInputDialog(jFrame, "Select a column to filter:", "Select Column", -1, null, objectArray2, objectArray2[0]);
        if (string2 == null) {
            return;
        }
        Object[] objectArray3 = new Object[]{"=", "!=", "<", ">", "<=", ">=", "like", "not like"};
        String string3 = (String)JOptionPane.showInputDialog(jFrame, "Select an operator:", "Select Operator", -1, null, objectArray3, objectArray3[0]);
        if (string3 == null) {
            return;
        }
        List list = perfExplorerConnection.getPossibleValues(string, string2);
        if (list.size() < 2) {
            JOptionPane.showMessageDialog(jFrame, "The column " + string2.toUpperCase() + " in table " + string.toUpperCase() + " has only one distinct value.\nPlease select another table and/or column.", "Request Status", 0);
            return;
        }
        String string4 = new String("CREATE VIEW FOR EACH");
        if (string3.equals("=")) {
            list.add(string4);
        }
        String string5 = null;
        string5 = string3.equals("like") || string3.equals("not like") ? JOptionPane.showInputDialog(jFrame, "Please enter a value to filter (use % for wildcard):", "Enter Value", -1) : (String)JOptionPane.showInputDialog(jFrame, "Select a value to filter (required):", "Select Value", -1, null, list.toArray(), list.get(0));
        if (string5 == null) {
            return;
        }
        if (string5.equals(string4)) {
            for (int i = 0; i < list.size() - 1; ++i) {
                string5 = (String)list.get(i);
                String string6 = string + ":" + string2 + " = " + string5;
                if (string5 == null) continue;
                perfExplorerConnection.createNewView(string6, n, string, string2, string3, string5);
            }
        } else {
            String string7 = (String)JOptionPane.showInputDialog(jFrame, "Please enter a name for this view (required):", "Enter View Name", -1, null, null, string + ":" + string2 + " " + string3 + " " + string5);
            if (string7 == null) {
                return;
            }
            int n2 = perfExplorerConnection.createNewView(string7, n, string, string2, string3, string5);
        }
        JOptionPane.showMessageDialog(jFrame, "View(s) Created.", "View Created", -1);
    }

    public static void createNewSubView(JFrame jFrame) {
        Object object;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        int n = -1;
        List list = perfExplorerConnection.getViews(n);
        Iterator iterator = list.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (iterator.hasNext()) {
            object = (RMIView)iterator.next();
            arrayList.add(((RMIView)object).getField("NAME"));
            hashtable.put(((RMIView)object).getField("NAME"), ((RMIView)object).getField("ID"));
        }
        object = (String)JOptionPane.showInputDialog(jFrame, "Select a view on which to base this sub-view:", "Select View", -1, null, arrayList.toArray(), null);
        if (object != null) {
            String string = (String)hashtable.get(object);
            PerfExplorerViews.createNewView(jFrame, Integer.parseInt(string));
        }
    }

    public static void deleteCurrentView(JFrame jFrame) {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Object object = perfExplorerModel.getCurrentSelection();
        if (object instanceof RMIView) {
            PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
            RMIView rMIView = (RMIView)object;
            perfExplorerConnection.deleteView(rMIView.getField("id"));
            PerfExplorerJTree perfExplorerJTree = PerfExplorerJTree.getTree();
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)perfExplorerJTree.getModel();
            defaultTreeModel.removeNodeFromParent(rMIView.getDMTN());
        } else {
            JOptionPane.showMessageDialog(jFrame, "Current selection is not a View.\nPlease select the view to delete before attempting to delete it.", "Selection Error", 0);
        }
    }
}

