/*
 * Decompiled with CFR 0.152.
 */
package server;

import clustering.AnalysisFactory;
import clustering.ClusterException;
import common.AnalysisType;
import common.ChartDataType;
import common.ChartType;
import common.ConfigureFiles;
import common.EngineType;
import common.PerfExplorerException;
import common.PerfExplorerOutput;
import common.RMIChartData;
import common.RMICubeData;
import common.RMIGeneralChartData;
import common.RMIPerfExplorer;
import common.RMIPerfExplorerModel;
import common.RMIPerformanceResults;
import common.RMISortableIntervalEvent;
import common.RMIVarianceData;
import common.RMIView;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.IntervalEvent;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.database.DB;
import jargs.gnu.CmdLineParser;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.StubNotFoundException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import server.ChartData;
import server.GeneralChartData;
import server.QueryManager;
import server.Queue;
import server.TimerThread;

public class PerfExplorerServer
extends UnicastRemoteObject
implements RMIPerfExplorer {
    private static String USAGE = "Usage: PerfExplorerClient [{-h,--help}] {-c,--configfile}=<config_file> [{-e,--engine}=<analysis_engine>] [{-p,--port}=<port_number>]\n  where analysis_engine = R or Weka";
    private DatabaseAPI session = null;
    private List sessions = new ArrayList();
    private List sessionStrings = new ArrayList();
    private List requestQueues = new ArrayList();
    private List timerThreads = new ArrayList();
    private List timers = new ArrayList();
    private static PerfExplorerServer theServer = null;
    private AnalysisFactory factory = null;
    private EngineType engineType;

    public static PerfExplorerServer getServer() {
        return theServer;
    }

    public static PerfExplorerServer getServer(String string, EngineType engineType) {
        try {
            if (theServer == null) {
                theServer = new PerfExplorerServer(string, engineType, 0, false);
            }
        }
        catch (Exception exception) {
            System.err.println("getServer exception: " + exception.getMessage());
            exception.printStackTrace();
        }
        return theServer;
    }

    private PerfExplorerServer(String string, EngineType engineType, int n, boolean bl) throws RemoteException {
        super(n);
        PerfExplorerOutput.setQuiet(bl);
        theServer = this;
        DatabaseAPI databaseAPI = null;
        this.engineType = engineType;
        int n2 = 0;
        List list = ConfigureFiles.getConfigurationNames();
        if (string != null && string.length() > 0 && !list.contains(string)) {
            list.add(string);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            DatabaseAPI databaseAPI2 = null;
            String string2 = (String)iterator.next();
            PerfExplorerOutput.print("Connecting...");
            try {
                databaseAPI2 = new DatabaseAPI();
                databaseAPI2.initialize(string2, false);
                databaseAPI = new DatabaseAPI();
                databaseAPI.initialize(string2, false);
                PerfExplorerOutput.println(" Connected to " + databaseAPI2.db().getConnectString() + ".");
                this.sessions.add(databaseAPI2);
                this.sessionStrings.add(databaseAPI2.db().getConnectString());
                Queue queue = new Queue();
                this.requestQueues.add(queue);
                object = new TimerThread(this, databaseAPI, n2++);
                this.timers.add(object);
                Thread thread = new Thread((Runnable)object);
                this.timerThreads.add(thread);
                thread.start();
                this.session = databaseAPI2;
            }
            catch (Exception exception) {
                if (exception instanceof FileNotFoundException) {
                    System.err.println(exception.getMessage());
                    continue;
                }
                System.err.println("Error connecting to " + string2 + "!");
                System.err.println(exception.getMessage());
                object = new StringBuffer();
                ((StringBuffer)object).append("\nPlease make sure that your DBMS is ");
                ((StringBuffer)object).append("configured correctly, and the database ");
                ((StringBuffer)object).append("has been created.");
                ((StringBuffer)object).append("\nSee the PerfExplorer and/or PerfDMF");
                ((StringBuffer)object).append("configuration utilities for details.\n");
                System.err.println(((StringBuffer)object).toString());
            }
        }
    }

    public AnalysisFactory getAnalysisFactory() {
        if (this.factory == null) {
            try {
                this.factory = AnalysisFactory.buildFactory(this.engineType);
            }
            catch (ClusterException clusterException) {
                System.err.println(clusterException.getMessage());
                System.err.println(this.engineType);
                System.exit(1);
            }
        }
        return this.factory;
    }

    public String sayHello() {
        PerfExplorerOutput.println("sayHello()...");
        String string = new String("Hello, client - this is server!");
        return string;
    }

    public List getApplicationList() {
        List list = this.session.getApplicationList();
        return list;
    }

    public List getExperimentList(int n) {
        this.session.setApplication(n);
        List list = null;
        try {
            list = this.session.getExperimentList();
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        return list;
    }

    public List getTrialList(int n) {
        try {
            this.session.setExperiment(n);
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        List list = this.session.getTrialList();
        return list;
    }

    public void stopServer() {
        PerfExplorerOutput.println("stopServer()...");
        for (int i = 0; i < this.timers.size(); ++i) {
            TimerThread timerThread = (TimerThread)this.timers.get(i);
            timerThread.cancel();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    public String requestAnalysis(RMIPerfExplorerModel rMIPerfExplorerModel, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (!bl && this.checkForRequest(rMIPerfExplorerModel) != 0) {
                throw new PerfExplorerException("Request already exists");
            }
            int n = this.insertRequest(rMIPerfExplorerModel);
            stringBuffer.append("Request " + n + " queued.");
            rMIPerfExplorerModel.setAnalysisID(n);
            stringBuffer.append("\nRequest accepted.");
            Queue queue = (Queue)this.requestQueues.get(rMIPerfExplorerModel.getConnectionIndex());
            queue.enqueue(rMIPerfExplorerModel);
        }
        catch (PerfExplorerException perfExplorerException) {
            String string = perfExplorerException.getMessage();
            Throwable throwable = perfExplorerException.getCause();
            if (throwable != null) {
                string = string + "\n" + throwable.getMessage();
            }
            return string;
        }
        return stringBuffer.toString();
    }

    public RMIPerformanceResults getCorrelationResults(RMIPerfExplorerModel rMIPerfExplorerModel) {
        RMIPerformanceResults rMIPerformanceResults = new RMIPerformanceResults();
        try {
            DB dB = this.getDB();
            PreparedStatement preparedStatement = null;
            if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                preparedStatement = dB.prepareStatement("select id from analysis_settings where application = ? and experiment = ? and trial = ? and metric = ? and method = ? order by id desc");
                preparedStatement.setInt(1, rMIPerfExplorerModel.getApplication().getID());
                preparedStatement.setInt(2, rMIPerfExplorerModel.getExperiment().getID());
                preparedStatement.setInt(3, rMIPerfExplorerModel.getTrial().getID());
                preparedStatement.setInt(4, ((Metric)rMIPerfExplorerModel.getCurrentSelection()).getID());
                preparedStatement.setString(5, AnalysisType.CORRELATION_ANALYSIS.toString());
            } else {
                preparedStatement = dB.prepareStatement("select id from analysis_settings where application = ? and experiment = ? and trial = ? and metric is null and method = ? order by id desc");
                preparedStatement.setInt(1, rMIPerfExplorerModel.getApplication().getID());
                preparedStatement.setInt(2, rMIPerfExplorerModel.getExperiment().getID());
                preparedStatement.setInt(3, rMIPerfExplorerModel.getTrial().getID());
                preparedStatement.setString(4, AnalysisType.CORRELATION_ANALYSIS.toString());
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            int n = 0;
            if (!resultSet.next()) {
                preparedStatement.close();
                return rMIPerformanceResults;
            }
            n = resultSet.getInt(1);
            preparedStatement.close();
            preparedStatement = dB.prepareStatement("select id, description, thumbnail_size, thumbnail, image_size, image, result_type from analysis_result where analysis_settings = ? and result_type = ? order by id asc");
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, ChartType.CORRELATION_SCATTERPLOT.toString());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                int n2 = resultSet.getInt(3);
                InputStream inputStream = resultSet.getBinaryStream(4);
                byte[] byArray = new byte[n2];
                int n3 = inputStream.read(byArray);
                int n4 = resultSet.getInt(5);
                InputStream inputStream2 = resultSet.getBinaryStream(6);
                byte[] byArray2 = new byte[n4];
                n3 = inputStream2.read(byArray2);
                String string3 = resultSet.getString(7);
                rMIPerformanceResults.getDescriptions().add(string2);
                rMIPerformanceResults.getIDs().add(string);
                rMIPerformanceResults.getThumbnails().add(byArray);
                rMIPerformanceResults.getImages().add(byArray2);
            }
            preparedStatement.close();
        }
        catch (Exception exception) {
            String string = "\nERROR: Couldn't select the analysis settings from the database!";
            System.err.println(string);
            exception.printStackTrace();
        }
        return rMIPerformanceResults;
    }

    public RMIPerformanceResults getPerformanceResults(RMIPerfExplorerModel rMIPerfExplorerModel) {
        RMIPerformanceResults rMIPerformanceResults = new RMIPerformanceResults();
        try {
            DB dB = this.getDB();
            PreparedStatement preparedStatement = null;
            if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                preparedStatement = dB.prepareStatement("select id from analysis_settings where application = ? and experiment = ? and trial = ? and metric = ? and method = ? order by id desc");
                preparedStatement.setInt(1, rMIPerfExplorerModel.getApplication().getID());
                preparedStatement.setInt(2, rMIPerfExplorerModel.getExperiment().getID());
                preparedStatement.setInt(3, rMIPerfExplorerModel.getTrial().getID());
                preparedStatement.setInt(4, ((Metric)rMIPerfExplorerModel.getCurrentSelection()).getID());
                preparedStatement.setString(5, AnalysisType.K_MEANS.toString());
            } else {
                preparedStatement = dB.prepareStatement("select id from analysis_settings where application = ? and experiment = ? and trial = ? and metric is null and method = ? order by id desc");
                preparedStatement.setInt(1, rMIPerfExplorerModel.getApplication().getID());
                preparedStatement.setInt(2, rMIPerfExplorerModel.getExperiment().getID());
                preparedStatement.setInt(3, rMIPerfExplorerModel.getTrial().getID());
                preparedStatement.setString(4, AnalysisType.K_MEANS.toString());
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            int n = 0;
            if (!resultSet.next()) {
                preparedStatement.close();
                return rMIPerformanceResults;
            }
            n = resultSet.getInt(1);
            preparedStatement.close();
            preparedStatement = dB.prepareStatement("select id, description, thumbnail_size, thumbnail, image_size, image, result_type from analysis_result where analysis_settings = ? order by id asc");
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                int n2 = resultSet.getInt(3);
                InputStream inputStream = resultSet.getBinaryStream(4);
                byte[] byArray = new byte[n2];
                int n3 = inputStream.read(byArray);
                int n4 = resultSet.getInt(5);
                InputStream inputStream2 = resultSet.getBinaryStream(6);
                byte[] byArray2 = new byte[n4];
                n3 = inputStream2.read(byArray2);
                String string3 = resultSet.getString(7);
                rMIPerformanceResults.getDescriptions().add(string2);
                rMIPerformanceResults.getIDs().add(string);
                rMIPerformanceResults.getThumbnails().add(byArray);
                rMIPerformanceResults.getImages().add(byArray2);
            }
            preparedStatement.close();
        }
        catch (Exception exception) {
            String string = "\nERROR: Couldn't select the analysis settings from the database!";
            System.err.println(string);
            exception.printStackTrace();
        }
        return rMIPerformanceResults;
    }

    public void taskFinished(int n) {
        Queue queue = (Queue)this.requestQueues.get(n);
        RMIPerfExplorerModel rMIPerfExplorerModel = queue.dequeue();
    }

    public RMIPerfExplorerModel getNextRequest(int n) {
        Queue queue = (Queue)this.requestQueues.get(n);
        RMIPerfExplorerModel rMIPerfExplorerModel = queue.peekNext();
        return rMIPerfExplorerModel;
    }

    public DB getDB() {
        return this.session.db();
    }

    public int checkForRequest(RMIPerfExplorerModel rMIPerfExplorerModel) throws PerfExplorerException {
        int n = 0;
        try {
            DB dB = this.getDB();
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.prepareStatement("select id from analysis_settings where application = ? and experiment = ? and trial = ? and metric = ? and method = ? and dimension_reduction = ? and normalization = ?");
            preparedStatement.setInt(1, rMIPerfExplorerModel.getApplication().getID());
            preparedStatement.setInt(2, rMIPerfExplorerModel.getExperiment().getID());
            preparedStatement.setInt(3, rMIPerfExplorerModel.getTrial().getID());
            preparedStatement.setInt(4, ((Metric)rMIPerfExplorerModel.getCurrentSelection()).getID());
            preparedStatement.setString(5, rMIPerfExplorerModel.getClusterMethod().toString());
            preparedStatement.setString(6, rMIPerfExplorerModel.getDimensionReduction().toString());
            preparedStatement.setString(7, rMIPerfExplorerModel.getNormalization().toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            String string = "ERROR: Couldn't select the analysis settings from the database!";
            System.err.println(string);
            sQLException.printStackTrace();
            throw new PerfExplorerException(string, sQLException);
        }
        return n;
    }

    public int insertRequest(RMIPerfExplorerModel rMIPerfExplorerModel) throws PerfExplorerException {
        int n = 0;
        try {
            DB dB = this.getDB();
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.prepareStatement("insert into analysis_settings (application, experiment, trial, metric, method, dimension_reduction, normalization) values (?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.setInt(1, rMIPerfExplorerModel.getApplication().getID());
            preparedStatement.setInt(2, rMIPerfExplorerModel.getExperiment().getID());
            preparedStatement.setInt(3, rMIPerfExplorerModel.getTrial().getID());
            if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                preparedStatement.setInt(4, ((Metric)rMIPerfExplorerModel.getCurrentSelection()).getID());
            } else {
                preparedStatement.setNull(4, 4);
            }
            preparedStatement.setString(5, rMIPerfExplorerModel.getClusterMethod().toString());
            preparedStatement.setString(6, rMIPerfExplorerModel.getDimensionReduction().toString());
            preparedStatement.setString(7, rMIPerfExplorerModel.getNormalization().toString());
            preparedStatement.execute();
            preparedStatement.close();
            String string = new String();
            string = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM analysis_settings" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM analysis_settings" : (dB.getDBType().compareTo("oracle") == 0 ? "SELECT as_id_seq.currval FROM DUAL" : "select currval('analysis_settings_id_seq');")));
            n = Integer.parseInt(dB.getDataItem(string));
        }
        catch (SQLException sQLException) {
            String string = "ERROR: Couldn't insert the analysis settings into the database!\nPlease make sure that the analysis_settings and analysis_results tables\nhave been created in the database, and that\nR and the Omegahat interface have been installed on this machine.";
            System.err.println(string);
            sQLException.printStackTrace();
            throw new PerfExplorerException(string, sQLException);
        }
        return n;
    }

    public RMIChartData requestChartData(RMIPerfExplorerModel rMIPerfExplorerModel, ChartDataType chartDataType) {
        ChartData chartData = ChartData.getChartData(rMIPerfExplorerModel, chartDataType);
        return chartData;
    }

    public RMIGeneralChartData requestGeneralChartData(RMIPerfExplorerModel rMIPerfExplorerModel, ChartDataType chartDataType) {
        GeneralChartData generalChartData = GeneralChartData.getChartData(rMIPerfExplorerModel, chartDataType);
        return generalChartData;
    }

    public List getXMLFields(RMIPerfExplorerModel rMIPerfExplorerModel) {
        List list = GeneralChartData.getXMLFields(rMIPerfExplorerModel);
        return list;
    }

    public List getPotentialGroups(RMIPerfExplorerModel rMIPerfExplorerModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Object object;
            Object object2;
            DB dB = this.getDB();
            StringBuffer stringBuffer = new StringBuffer("select distinct ie.group_name ");
            stringBuffer.append(" from interval_event ie inner join trial t on ie.trial = t.id ");
            stringBuffer.append(" inner join experiment e on t.experiment = e.id ");
            Object object3 = rMIPerfExplorerModel.getCurrentSelection();
            if (object3 instanceof RMIView) {
                stringBuffer.append(rMIPerfExplorerModel.getViewSelectionPath(true, true, dB.getDBType()));
            } else {
                object2 = rMIPerfExplorerModel.getMultiSelection();
                if (object2 == null) {
                    object = rMIPerfExplorerModel.getCurrentSelection();
                    if (object instanceof Application) {
                        stringBuffer.append(" where e.application = ");
                        stringBuffer.append(rMIPerfExplorerModel.getApplication().getID());
                    } else if (object instanceof Experiment) {
                        stringBuffer.append(" where t.experiment = ");
                        stringBuffer.append(rMIPerfExplorerModel.getExperiment().getID());
                    } else if (object instanceof Trial) {
                        stringBuffer.append(" where t.id = ");
                        stringBuffer.append(rMIPerfExplorerModel.getTrial().getID());
                    }
                } else {
                    Application application;
                    int n;
                    object = rMIPerfExplorerModel.getCurrentSelection();
                    if (object instanceof Application) {
                        stringBuffer.append(" where e.application in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Application)object2.get(n);
                            if (n > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(application.getID());
                        }
                        stringBuffer.append(")");
                    } else if (object instanceof Experiment) {
                        stringBuffer.append(" where t.experiment in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Experiment)object2.get(n);
                            if (n > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(application.getID());
                        }
                        stringBuffer.append(")");
                    } else if (object instanceof Trial) {
                        stringBuffer.append(" where t.id in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Trial)object2.get(n);
                            if (n > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(application.getID());
                        }
                        stringBuffer.append(")");
                    }
                }
            }
            object2 = dB.prepareStatement(stringBuffer.toString());
            object = object2.executeQuery();
            while (object.next()) {
                arrayList.add(object.getString(1));
            }
            object2.close();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't select the groups from the database!";
            System.err.println(string);
            exception.printStackTrace();
        }
        return arrayList;
    }

    public List getPotentialMetrics(RMIPerfExplorerModel rMIPerfExplorerModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            Object object;
            Object object2;
            DB dB = this.getDB();
            if (dB.getDBType().compareTo("db2") == 0) {
                stringBuffer.append("select distinct count(cast (m.name as VARCHAR(256))), cast (m.name as VARCHAR(256)) ");
            } else {
                stringBuffer.append("select distinct count(m.name), m.name ");
            }
            stringBuffer.append(" from metric m inner join trial t on m.trial = t.id ");
            Object object3 = rMIPerfExplorerModel.getCurrentSelection();
            if (object3 instanceof RMIView) {
                stringBuffer.append(rMIPerfExplorerModel.getViewSelectionPath(true, true, dB.getDBType()));
            } else {
                stringBuffer.append(" inner join experiment e on t.experiment = e.id ");
                object2 = rMIPerfExplorerModel.getMultiSelection();
                if (object2 == null) {
                    object = rMIPerfExplorerModel.getCurrentSelection();
                    if (object instanceof Application) {
                        stringBuffer.append(" where e.application = ");
                        stringBuffer.append(rMIPerfExplorerModel.getApplication().getID());
                    } else if (object instanceof Experiment) {
                        stringBuffer.append(" where t.experiment = ");
                        stringBuffer.append(rMIPerfExplorerModel.getExperiment().getID());
                    } else if (object instanceof Trial) {
                        stringBuffer.append(" where t.id = ");
                        stringBuffer.append(rMIPerfExplorerModel.getTrial().getID());
                    }
                } else {
                    Application application;
                    object = rMIPerfExplorerModel.getCurrentSelection();
                    if (object instanceof Application) {
                        stringBuffer.append(" where e.application in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Application)object2.get(n);
                            if (n > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(application.getID());
                        }
                        stringBuffer.append(")");
                    } else if (object instanceof Experiment) {
                        stringBuffer.append(" where t.experiment in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Experiment)object2.get(n);
                            if (n > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(application.getID());
                        }
                        stringBuffer.append(")");
                    } else if (object instanceof Trial) {
                        stringBuffer.append(" where t.id in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Trial)object2.get(n);
                            if (n > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(application.getID());
                        }
                        stringBuffer.append(")");
                    }
                }
            }
            if (dB.getDBType().compareTo("db2") == 0) {
                stringBuffer.append(" group by cast (m.name as VARCHAR(256)) order by 1 desc");
            } else if (dB.getDBType().compareTo("mysql") == 0) {
                stringBuffer.append(" group by 2 order by 1 desc");
            } else {
                stringBuffer.append(" group by m.name order by count(m.name) desc");
            }
            object2 = dB.prepareStatement(stringBuffer.toString());
            object = object2.executeQuery();
            n = 0;
            while (object.next()) {
                if (n == 0) {
                    n = object.getInt(1);
                }
                if (object.getInt(1) != n) continue;
                arrayList.add(object.getString(2));
            }
            object.close();
            object2.close();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't select the metrics from the database!";
            System.err.println(string);
            System.err.println(stringBuffer.toString());
            exception.printStackTrace();
        }
        return arrayList;
    }

    public List getPotentialEvents(RMIPerfExplorerModel rMIPerfExplorerModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Object object;
            Object object2;
            DB dB = this.getDB();
            StringBuffer stringBuffer = new StringBuffer();
            if (dB.getDBType().compareTo("db2") == 0) {
                stringBuffer.append("select distinct cast (m.name as VARCHAR(256))");
            } else {
                stringBuffer.append("select distinct ie.name ");
            }
            stringBuffer.append(" from interval_event ie inner join trial t on ie.trial = t.id ");
            stringBuffer.append(" inner join experiment e on t.experiment = e.id ");
            Object object3 = rMIPerfExplorerModel.getCurrentSelection();
            if (object3 instanceof RMIView) {
                stringBuffer.append(rMIPerfExplorerModel.getViewSelectionPath(true, true, dB.getDBType()));
            } else {
                object2 = rMIPerfExplorerModel.getMultiSelection();
                if (object2 == null) {
                    object = rMIPerfExplorerModel.getCurrentSelection();
                    if (object instanceof Application) {
                        stringBuffer.append(" where e.application = ");
                        stringBuffer.append(rMIPerfExplorerModel.getApplication().getID());
                    } else if (object instanceof Experiment) {
                        stringBuffer.append(" where t.experiment = ");
                        stringBuffer.append(rMIPerfExplorerModel.getExperiment().getID());
                    } else if (object instanceof Trial) {
                        stringBuffer.append(" where t.id = ");
                        stringBuffer.append(rMIPerfExplorerModel.getTrial().getID());
                    }
                } else {
                    Application application;
                    int n;
                    object = rMIPerfExplorerModel.getCurrentSelection();
                    if (object instanceof Application) {
                        stringBuffer.append(" where e.application in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Application)object2.get(n);
                            if (n > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(application.getID());
                        }
                        stringBuffer.append(")");
                    } else if (object instanceof Experiment) {
                        stringBuffer.append(" where t.experiment in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Experiment)object2.get(n);
                            if (n > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(application.getID());
                        }
                        stringBuffer.append(")");
                    } else if (object instanceof Trial) {
                        stringBuffer.append(" where t.id in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Trial)object2.get(n);
                            if (n > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(application.getID());
                        }
                        stringBuffer.append(")");
                    }
                }
            }
            stringBuffer.append(" and (group_name is null or group_name not like '%TAU_CALLPATH%') ");
            object2 = dB.prepareStatement(stringBuffer.toString());
            object = object2.executeQuery();
            while (object.next()) {
                arrayList.add(object.getString(1));
            }
            object2.close();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't select the events from the database!";
            System.err.println(string);
            exception.printStackTrace();
        }
        return arrayList;
    }

    private static String shortName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(");
        String string2 = null;
        try {
            string2 = stringTokenizer.nextToken();
            if (string2.length() < string.length()) {
                string2 = string2 + "()";
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = string;
        }
        return string2;
    }

    public String[] getMetaData(String string) {
        String[] stringArray = null;
        try {
            if (string.equalsIgnoreCase("application")) {
                stringArray = Application.getFieldNames((DB)this.getDB());
            } else if (string.equalsIgnoreCase("experiment")) {
                stringArray = Experiment.getFieldNames((DB)this.getDB());
            } else if (string.equalsIgnoreCase("trial")) {
                stringArray = Trial.getFieldNames((DB)this.getDB());
            }
        }
        catch (Exception exception) {
            String string2 = "ERROR: Couldn't select the columns from the database!";
            System.err.println(string2);
            exception.printStackTrace();
        }
        return stringArray;
    }

    public List getPossibleValues(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            DB dB = this.getDB();
            StringBuffer stringBuffer = new StringBuffer("select distinct ");
            if (dB.getDBType().compareTo("db2") == 0) {
                stringBuffer.append("cast (");
                stringBuffer.append(string2);
                stringBuffer.append(" as varchar(256))");
            } else {
                stringBuffer.append(string2);
            }
            stringBuffer.append(" from ");
            stringBuffer.append(string.toLowerCase());
            PreparedStatement preparedStatement = dB.prepareStatement(stringBuffer.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            preparedStatement.close();
        }
        catch (Exception exception) {
            String string3 = "ERROR: Couldn't select the potential values from the database!";
            System.err.println(string3);
            exception.printStackTrace();
        }
        return arrayList;
    }

    public int createNewView(String string, int n, String string2, String string3, String string4, String string5) {
        int n2 = 0;
        try {
            DB dB = this.getDB();
            PreparedStatement preparedStatement = null;
            preparedStatement = n > 0 ? dB.prepareStatement("insert into trial_view (name, table_name, column_name, operator, value, parent) values (?, ?, ?, ?, ?, ?)") : dB.prepareStatement("insert into trial_view (name, table_name, column_name, operator, value) values (?, ?, ?, ?, ?)");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, string3);
            preparedStatement.setString(4, string4);
            preparedStatement.setString(5, string5);
            if (n > 0) {
                preparedStatement.setInt(6, n);
            }
            preparedStatement.execute();
            preparedStatement.close();
            String string6 = new String();
            string6 = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM trial_view" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM trial_view" : (dB.getDBType().compareTo("oracle") == 0 ? "SELECT " + dB.getSchemaPrefix() + "tv_id_seq.currval FROM DUAL" : "select currval('trial_view_id_seq');")));
            n2 = Integer.parseInt(dB.getDataItem(string6));
        }
        catch (Exception exception) {
            String string7 = "ERROR: Couldn't select the columns from the database!";
            System.err.println(string7);
            exception.printStackTrace();
        }
        return n2;
    }

    public void deleteView(String string) {
        try {
            DB dB = this.getDB();
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.prepareStatement("delete from trial_view where id = ?");
            preparedStatement.setString(1, string);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (Exception exception) {
            String string2 = "ERROR: Couldn't delete the view from the database!";
            System.err.println(string2);
            exception.printStackTrace();
        }
    }

    public List getViews(int n) {
        ArrayList<RMIView> arrayList = new ArrayList<RMIView>();
        try {
            DB dB = this.getDB();
            Iterator iterator = RMIView.getFieldNames(dB);
            if (!iterator.hasNext()) {
                throw new Exception("The Database is not modified to support views.");
            }
            StringBuffer stringBuffer = new StringBuffer("select ");
            stringBuffer.append((String)iterator.next());
            while (iterator.hasNext()) {
                stringBuffer.append(", ");
                stringBuffer.append((String)iterator.next());
            }
            stringBuffer.append(" from trial_view");
            if (n != -1) {
                if (n == 0) {
                    stringBuffer.append(" where parent is null");
                } else {
                    stringBuffer.append(" where parent = ");
                    stringBuffer.append(n);
                }
            }
            PreparedStatement preparedStatement = dB.prepareStatement(stringBuffer.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                RMIView rMIView = new RMIView();
                for (int i = 1; i <= RMIView.getFieldCount(); ++i) {
                    rMIView.addField(resultSet.getString(i));
                }
                arrayList.add(rMIView);
            }
            preparedStatement.close();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't select views from the database!";
            System.err.println(string);
            exception.printStackTrace();
        }
        return arrayList;
    }

    public List getTrialsForView(List list) {
        AbstractList abstractList = new ArrayList();
        try {
            DB dB = this.getDB();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" inner join application a on e.application = a.id WHERE ");
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(" AND ");
                }
                RMIView rMIView = (RMIView)list.get(i);
                if (dB.getDBType().compareTo("db2") == 0) {
                    stringBuffer.append(" cast (");
                }
                if (rMIView.getField("TABLE_NAME").equalsIgnoreCase("Application")) {
                    stringBuffer.append(" a.");
                } else if (rMIView.getField("TABLE_NAME").equalsIgnoreCase("Experiment")) {
                    stringBuffer.append(" e.");
                } else {
                    stringBuffer.append(" t.");
                }
                stringBuffer.append(rMIView.getField("COLUMN_NAME"));
                if (dB.getDBType().compareTo("db2") == 0) {
                    stringBuffer.append(" as varchar(256)) ");
                }
                stringBuffer.append(" " + rMIView.getField("OPERATOR") + " '");
                stringBuffer.append(rMIView.getField("VALUE"));
                stringBuffer.append("' ");
            }
            abstractList = Trial.getTrialList((DB)dB, (String)stringBuffer.toString());
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't select views from the database!";
            System.err.println(string);
            exception.printStackTrace();
        }
        return abstractList;
    }

    public RMIVarianceData getVariationAnalysis(RMIPerfExplorerModel rMIPerfExplorerModel) {
        RMIVarianceData rMIVarianceData = new RMIVarianceData();
        try {
            DB dB = this.getDB();
            PreparedStatement preparedStatement = null;
            StringBuffer stringBuffer = new StringBuffer();
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuffer.append("select ie.name, ");
                stringBuffer.append("avg(ilp.excl), ");
                stringBuffer.append("avg(ilp.exclusive_percentage), ");
                stringBuffer.append("avg(ilp.call), ");
                stringBuffer.append("avg(ilp.excl / ilp.call), ");
                stringBuffer.append("max(ilp.excl), ");
                stringBuffer.append("min(ilp.excl), ");
                stringBuffer.append("stddev(ilp.excl) ");
            } else if (dB.getDBType().compareTo("derby") == 0) {
                stringBuffer.append("select ie.name, ");
                stringBuffer.append("avg(ilp.exclusive), ");
                stringBuffer.append("avg(ilp.exclusive_percentage), ");
                stringBuffer.append("avg(ilp.num_calls), ");
                stringBuffer.append("avg(ilp.exclusive / ilp.num_calls), ");
                stringBuffer.append("max(ilp.exclusive), ");
                stringBuffer.append("min(ilp.exclusive), ");
                stringBuffer.append("0 ");
            } else if (dB.getDBType().compareTo("db2") == 0) {
                stringBuffer.append("select cast (ie.name as varchar(256)), ");
                stringBuffer.append("avg(ilp.exclusive), ");
                stringBuffer.append("avg(ilp.exclusive_percentage), ");
                stringBuffer.append("avg(ilp.call), ");
                stringBuffer.append("avg(ilp.exclusive / ilp.call), ");
                stringBuffer.append("max(ilp.exclusive), ");
                stringBuffer.append("min(ilp.exclusive), ");
                stringBuffer.append("stddev(ilp.exclusive) ");
            } else if (dB.getDBType().compareTo("mysql") == 0) {
                stringBuffer.append("select ie.name, ");
                stringBuffer.append("avg(ilp.exclusive), ");
                stringBuffer.append("avg(ilp.exclusive_percentage), ");
                stringBuffer.append("avg(ilp.call), ");
                stringBuffer.append("avg(ilp.exclusive / ilp.`call`), ");
                stringBuffer.append("max(ilp.exclusive), ");
                stringBuffer.append("min(ilp.exclusive), ");
                stringBuffer.append("stddev(ilp.exclusive) ");
            } else {
                stringBuffer.append("select ie.name, ");
                stringBuffer.append("avg(ilp.exclusive), ");
                stringBuffer.append("avg(ilp.exclusive_percentage), ");
                stringBuffer.append("avg(ilp.call), ");
                stringBuffer.append("avg(ilp.exclusive / ilp.call), ");
                stringBuffer.append("max(ilp.exclusive), ");
                stringBuffer.append("min(ilp.exclusive), ");
                stringBuffer.append("stddev(ilp.exclusive) ");
            }
            stringBuffer.append("from interval_location_profile ilp ");
            stringBuffer.append("inner join interval_event ie ");
            stringBuffer.append("on ilp.interval_event = ie.id ");
            stringBuffer.append("where ie.trial = ? and ilp.metric = ? ");
            stringBuffer.append("and (ie.group_name is null ");
            stringBuffer.append("or (ie.group_name not like '%TAU_CALLPATH%' ");
            stringBuffer.append("and group_name not like '%TAU_PHASE%')) ");
            if (dB.getDBType().compareTo("db2") == 0) {
                stringBuffer.append("group by ie.id, cast (ie.name as VARCHAR(256)) order by cast (ie.name as VARCHAR(256)) ");
            } else {
                stringBuffer.append("group by ie.id, ie.name order by ie.name");
            }
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, rMIPerfExplorerModel.getTrial().getID());
            Metric metric = (Metric)rMIPerfExplorerModel.getCurrentSelection();
            preparedStatement.setInt(2, metric.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                rMIVarianceData.addEventName(resultSet.getString(1));
                double[] dArray = new double[8];
                dArray[0] = resultSet.getDouble(2);
                dArray[1] = resultSet.getDouble(3);
                dArray[2] = resultSet.getDouble(4);
                dArray[3] = resultSet.getDouble(5);
                dArray[4] = resultSet.getDouble(6);
                dArray[5] = resultSet.getDouble(7);
                String string = resultSet.getString(8);
                if (string == null || string.trim().equalsIgnoreCase("nan") || string.trim().equals("0")) {
                    dArray[6] = 0.0;
                    dArray[7] = 0.0;
                } else {
                    dArray[6] = resultSet.getDouble(8);
                    dArray[7] = dArray[6] / (dArray[4] - dArray[5]) * dArray[1];
                }
                rMIVarianceData.addValues(dArray);
            }
            rMIVarianceData.addValueName("name");
            rMIVarianceData.addValueName("excl");
            rMIVarianceData.addValueName("excl %");
            rMIVarianceData.addValueName("calls");
            rMIVarianceData.addValueName("excl/call");
            rMIVarianceData.addValueName("max");
            rMIVarianceData.addValueName("min");
            rMIVarianceData.addValueName("stddev");
            rMIVarianceData.addValueName("(stddev/range)*%");
            resultSet.close();
            preparedStatement.close();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't get variation from the database!";
            System.err.println(string);
            exception.printStackTrace();
        }
        return rMIVarianceData;
    }

    public RMICubeData getCubeData(RMIPerfExplorerModel rMIPerfExplorerModel) {
        RMICubeData rMICubeData = null;
        try {
            int n;
            DB dB = this.getDB();
            PreparedStatement preparedStatement = null;
            StringBuffer stringBuffer = new StringBuffer();
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuffer.append("select interval_event.id, stddev(excl) ");
            } else if (dB.getDBType().compareTo("derby") == 0) {
                stringBuffer.append("select interval_event.id, avg(exclusive) ");
            } else {
                stringBuffer.append("select interval_event.id, stddev(exclusive) ");
            }
            stringBuffer.append("from interval_location_profile ");
            stringBuffer.append("inner join interval_event ");
            stringBuffer.append("on interval_event = interval_event.id ");
            stringBuffer.append("where trial = ? and metric = ? ");
            stringBuffer.append("and (group_name is null or (");
            stringBuffer.append("group_name not like '%TAU_CALLPATH%' ");
            stringBuffer.append("and group_name not like '%TAU_PHASE%')) ");
            stringBuffer.append("group by interval_event.id ");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, rMIPerfExplorerModel.getTrial().getID());
            Metric metric = (Metric)rMIPerfExplorerModel.getCurrentSelection();
            preparedStatement.setInt(2, metric.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            StringBuffer stringBuffer2 = new StringBuffer();
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                if (resultSet.getString(2) == null || resultSet.getString(2).trim().equalsIgnoreCase("NaN") || resultSet.getString(2).trim().equals("") || resultSet.getString(2).trim().equals("0") || resultSet.getDouble(2) == 0.0) continue;
                if (bl) {
                    stringBuffer2.append(",");
                }
                stringBuffer2.append(resultSet.getString(1));
                bl = true;
                arrayList.add(resultSet.getString(1));
            }
            resultSet.close();
            preparedStatement.close();
            stringBuffer = new StringBuffer();
            if (dB.getDBType().compareTo("db2") == 0) {
                preparedStatement = dB.prepareStatement("declare global temporary table working_table (id int) on commit preserve rows not logged ");
                preparedStatement.execute();
                preparedStatement.close();
                preparedStatement = dB.prepareStatement("insert into SESSION.working_table (id) values (?)");
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    int n2 = Integer.parseInt((String)iterator.next());
                    preparedStatement.setInt(1, n2);
                    preparedStatement.execute();
                }
                preparedStatement.close();
                stringBuffer.append("select interval_event.id, cast (name as varchar(256)), (stddev(exclusive)/ ");
                stringBuffer.append("(max(exclusive)-min(exclusive)))* ");
                stringBuffer.append("avg(exclusive_percentage) ");
                stringBuffer.append("from interval_location_profile ");
                stringBuffer.append("inner join interval_event ");
                stringBuffer.append("on interval_event = interval_event.id ");
                stringBuffer.append("inner join SESSION.working_table on ");
                stringBuffer.append("interval_event.id = SESSION.working_table.id ");
                stringBuffer.append("group by interval_event.id, cast (name as varchar(256))");
            } else {
                if (dB.getDBType().compareTo("oracle") == 0) {
                    stringBuffer.append("select interval_event.id, name, (stddev(excl)/ ");
                    stringBuffer.append("(max(excl)-min(excl))) * ");
                    stringBuffer.append("avg(exclusive_percentage) ");
                } else if (dB.getDBType().compareTo("derby") == 0) {
                    stringBuffer.append("select interval_event.id, name, avg(exclusive) ");
                } else {
                    stringBuffer.append("select interval_event.id, name, (stddev(exclusive)/ ");
                    stringBuffer.append("(max(exclusive)-min(exclusive)))* ");
                    stringBuffer.append("avg(exclusive_percentage) ");
                }
                stringBuffer.append("from interval_location_profile ");
                stringBuffer.append("inner join interval_event ");
                stringBuffer.append("on interval_event = interval_event.id ");
                stringBuffer.append("where interval_event.id in (" + stringBuffer2.toString() + ") ");
                stringBuffer.append("group by interval_event.id, name ");
            }
            stringBuffer.append("order by 3 desc");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            resultSet = preparedStatement.executeQuery();
            int n3 = 0;
            int[] nArray = new int[4];
            String[] stringArray = new String[4];
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            while (resultSet.next() && n3 < 4) {
                nArray[n3] = resultSet.getInt(1);
                stringArray[n3] = resultSet.getString(2);
                hashMap.put(stringArray[n3], new Integer(n3));
                if (resultSet.getString(3) == null || resultSet.getString(3).trim().equalsIgnoreCase("NaN") || resultSet.getString(3).trim().equals("")) continue;
                ++n3;
            }
            resultSet.close();
            preparedStatement.close();
            if (dB.getDBType().compareTo("db2") == 0) {
                preparedStatement = dB.prepareStatement("drop table SESSION.working_table");
                preparedStatement.execute();
                preparedStatement.close();
            }
            rMICubeData = new RMICubeData(n3);
            rMICubeData.setNames(stringArray);
            stringBuffer = new StringBuffer();
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuffer.append("select node, context, thread, name, excl ");
            } else if (dB.getDBType().compareTo("db2") == 0) {
                stringBuffer.append("select node, context, thread, cast (name as varchar(256)), exclusive ");
            } else {
                stringBuffer.append("select node, context, thread, name, exclusive ");
            }
            stringBuffer.append("from interval_location_profile ");
            stringBuffer.append("inner join interval_event ");
            stringBuffer.append("on interval_event = interval_event.id ");
            stringBuffer.append("where interval_event in (");
            stringBuffer.append(nArray[0]);
            for (n = 1; n < n3; ++n) {
                stringBuffer.append(", ");
                stringBuffer.append(nArray[n]);
            }
            stringBuffer.append(") and metric = ? ");
            stringBuffer.append("order by 1, 2, 3, 4");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, metric.getID());
            resultSet = preparedStatement.executeQuery();
            n = 0;
            int n4 = 0;
            int n5 = 0;
            float[] fArray = new float[n3];
            while (resultSet.next()) {
                if (n != resultSet.getInt(1) || n4 != resultSet.getInt(2) || n5 != resultSet.getInt(3)) {
                    rMICubeData.addValues(fArray);
                    fArray = new float[n3];
                    n = resultSet.getInt(1);
                    n4 = resultSet.getInt(2);
                    n5 = resultSet.getInt(3);
                }
                fArray[((Integer)hashMap.get((Object)resultSet.getString((int)4))).intValue()] = resultSet.getFloat(5);
            }
            rMICubeData.addValues(fArray);
            resultSet.close();
            preparedStatement.close();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't get variation from the database!";
            System.err.println(string);
            exception.printStackTrace();
        }
        return rMICubeData;
    }

    public String getConnectionString() {
        return this.session.db().getConnectString();
    }

    public List getConnectionStrings() {
        return this.sessionStrings;
    }

    public List getEventList(int n, int n2) {
        try {
            this.session.setTrial(n);
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        List list = this.session.getIntervalEvents();
        ArrayList<RMISortableIntervalEvent> arrayList = new ArrayList<RMISortableIntervalEvent>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IntervalEvent intervalEvent = (IntervalEvent)iterator.next();
            arrayList.add(new RMISortableIntervalEvent(intervalEvent, this.session, n2));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List getTrialList(String string) {
        return QueryManager.getTrialList(string);
    }

    public List getChartFieldNames() {
        DB dB = this.getDB();
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = Application.getFieldNames((DB)dB);
        arrayList.add("application.id");
        arrayList.add("application.name");
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add("application." + stringArray[i]);
        }
        arrayList.add("experiment.id");
        arrayList.add("experiment.name");
        arrayList.add("experiment.applciation");
        String[] stringArray2 = Experiment.getFieldNames((DB)dB);
        for (int i = 0; i < stringArray2.length; ++i) {
            arrayList.add("experiment." + stringArray2[i]);
        }
        arrayList.add("trial.id");
        arrayList.add("trial.name");
        arrayList.add("trial.experiment");
        String[] stringArray3 = Trial.getFieldNames((DB)dB);
        for (int i = 0; i < stringArray3.length; ++i) {
            if (stringArray3[i].equalsIgnoreCase("XML_METADATA_GZ") || stringArray3[i].equalsIgnoreCase("node_count") || stringArray3[i].equalsIgnoreCase("contexts_per_node")) continue;
            if (stringArray3[i].equalsIgnoreCase("threads_per_context")) {
                arrayList.add("trial.threads_of_execution");
                continue;
            }
            arrayList.add("trial." + stringArray3[i]);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addBooleanOption('h', "help");
        CmdLineParser.Option option2 = cmdLineParser.addStringOption('c', "configfile");
        CmdLineParser.Option option3 = cmdLineParser.addStringOption('e', "engine");
        CmdLineParser.Option option4 = cmdLineParser.addIntegerOption('p', "port");
        CmdLineParser.Option option5 = cmdLineParser.addBooleanOption('q', "quiet");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println(optionException.getMessage());
            System.err.println(USAGE);
            System.exit(-1);
        }
        Boolean bl = (Boolean)cmdLineParser.getOptionValue(option);
        String string = (String)cmdLineParser.getOptionValue(option2);
        String string2 = (String)cmdLineParser.getOptionValue(option3);
        Integer n = (Integer)cmdLineParser.getOptionValue(option4);
        Boolean bl2 = (Boolean)cmdLineParser.getOptionValue(option5);
        EngineType engineType = EngineType.WEKA;
        if (bl != null && bl.booleanValue()) {
            System.err.println(USAGE);
            System.exit(-1);
        }
        if (bl2 == null) {
            bl2 = new Boolean(false);
        }
        if (string == null) {
            System.err.println("Please enter a valid config file.");
            System.err.println(USAGE);
            System.exit(-1);
        }
        if (string2 == null) {
            System.err.println("Please enter a valid engine type.");
            System.err.println(USAGE);
            System.exit(-1);
        } else if (string2.equalsIgnoreCase("R")) {
            engineType = EngineType.RPROJECT;
        } else if (string2.equalsIgnoreCase("weka")) {
            engineType = EngineType.WEKA;
        } else {
            System.err.println(USAGE);
            System.exit(-1);
        }
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            PerfExplorerServer perfExplorerServer = new PerfExplorerServer(string, engineType, n, bl2);
            Naming.rebind("PerfExplorerServer", perfExplorerServer);
            PerfExplorerOutput.println("PerfExplorerServer bound.");
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        Naming.unbind("PerfExplorerServer");
                        PerfExplorerOutput.println("Server has shut down successfully.");
                    }
                    catch (Exception exception) {
                        System.err.println("Server could not unbind from registry - giving up.");
                    }
                }
            });
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Could not add a shutdown hook: " + runtimeException.getMessage());
        }
        catch (StubNotFoundException stubNotFoundException) {
            System.err.println("You forgot to generate the stubs with RMIC.");
        }
        catch (ConnectException connectException) {
            System.err.println("Could not connect to registry. Is it running and on the right port?");
            System.err.println("Try running rmiregistry in the background.");
            System.exit(-1);
        }
        catch (ServerException serverException) {
            System.err.println("Registry reports a problem: ");
            System.err.println("Maybe the registry cannot find the stub.  Did you set the classpath?  ");
            System.err.println("You can avoid this if you start the registry in the same folder ");
            System.err.println("as the server's stub, or copy the stub to the folder the registry ");
            System.err.println("was started in.");
            System.exit(-1);
        }
        catch (ServerError serverError) {
            System.err.println("Registry reports an error: ");
            System.err.println("Maybe the registry cannot find the DayTime interface.  Did you set the classpath?");
            System.err.println("You can avoid this if you start the registry in the same folder");
            System.err.println("as the server's files, or copy the interface to the folder the registry");
            System.err.println("was started in.");
            System.exit(-1);
        }
        catch (Exception exception) {
            System.err.println("Unhandled PerfExplorerServer exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void setConnectionIndex(int n) throws RemoteException {
        this.session = (DatabaseAPI)this.sessions.get(n);
    }
}

